<div>
    <!-- Desktop/Tablet Version -->
    <div class="hidden md:flex min-h-screen w-full bg-white p-4 sm:p-6 md:p-8">
        <!-- Subtle floating background shapes -->
        <div class="fixed inset-0 overflow-hidden pointer-events-none">
            <div class="absolute w-96 h-96 rounded-full bg-gradient-to-r from-blue-50 to-blue-100 -top-48 -left-48 opacity-70 animate-float-slow"></div>
            <div class="absolute w-96 h-96 rounded-full bg-gradient-to-l from-blue-50 to-blue-100 -bottom-48 -right-48 opacity-70 animate-float-slow-reverse"></div>
            <div class="absolute top-1/4 right-20 w-72 h-72 rounded-full bg-gradient-to-t from-blue-50 to-blue-100 opacity-70 animate-float-medium"></div>
        </div>

        <div class="w-full max-w-md mx-auto flex items-center justify-center z-10">
            <!-- Card Container -->
            <div class="relative w-full bg-white rounded-xl shadow-soft p-8 transition-all duration-300">
                <!-- Content -->
                <div class="relative">
                    <!-- Header with icon -->
                    <div class="text-center mb-8 animate-fadeIn">
                        <div class="inline-flex items-center justify-center w-20 h-20 mb-6 rounded-full bg-gradient-to-br from-blue-400 to-blue-500 shadow-soft-md">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-10 h-10 text-blue-600" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0110 0v4"></path>
                            </svg>
                        </div>
                        <h1 class="text-2xl font-bold text-gray-800 mb-2">Security Check</h1>
                        <p class="text-gray-600">Enter your 6-digit passcode</p>
                    </div>

                    <form wire:submit.prevent="verify" class="space-y-10">
                        <!-- Passcode Input Visualization -->
                        <div class="animate-fadeIn">
                            <!-- Passcode dots -->
                            <div class="flex justify-center space-x-6 mb-12">
                                <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= 6; $i++): ?>
                                    <div class="w-4 h-4 rounded-full border-2 border-gray-200 transition-all duration-300 transform <?php echo e(strlen($passcode) >= $i ? 'scale-110 bg-blue-500 border-blue-500 shadow-soft-blue' : 'bg-white'); ?>"></div>
                                <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            
                            <div class="relative group">
                                <input 
                                    type="password"
                                    wire:model="passcode"
                                    maxlength="6"
                                    class="sr-only"
                                />
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if($error): ?>
                                <div class="mt-3 text-center text-red-500 text-sm animate-shake">
                                    <?php echo e($error); ?>

                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        
                        <!-- Number Pad -->
                        <div class="grid grid-cols-3 gap-6">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = range(1, 9); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button 
                                    type="button"
                                    wire:click="addNumber(<?php echo e($number); ?>)"
                                    class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 text-xl font-medium shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 focus:outline-none active:scale-95">
                                    <span class="relative z-10"><?php echo e($number); ?></span>
                                    <div class="absolute inset-0 bg-gradient-to-br from-blue-400 to-blue-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                                    <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!-- Bottom Row -->
                            <button 
                                type="button"
                                wire:click="clearPasscode"
                                class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 focus:outline-none active:scale-95">
                                <span class="relative z-10">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 mx-auto" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <line x1="18" y1="6" x2="6" y2="18"></line>
                                        <line x1="6" y1="6" x2="18" y2="18"></line>
                                    </svg>
                                </span>
                                <div class="absolute inset-0 bg-gradient-to-br from-red-400 to-red-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                                <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                            </button>
                            <button 
                                type="button"
                                wire:click="addNumber(0)"
                                class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 text-xl font-medium shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 focus:outline-none active:scale-95">
                                <span class="relative z-10">0</span>
                                <div class="absolute inset-0 bg-gradient-to-br from-blue-400 to-blue-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                                <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                            </button>
                            <button 
                                type="button"
                                wire:click="deleteNumber"
                                class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 focus:outline-none active:scale-95">
                                <span class="relative z-10">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 mx-auto" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M21 4H8l-7 8 7 8h13a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"></path>
                                        <line x1="18" y1="9" x2="12" y2="15"></line>
                                        <line x1="12" y1="9" x2="18" y2="15"></line>
                                    </svg>
                                </span>
                                <div class="absolute inset-0 bg-gradient-to-br from-blue-400 to-blue-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                                <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                            </button>
                        </div>
                        
                        <!-- Hidden submit button -->
                        <button type="submit" class="hidden">Verify</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Version -->
    <div class="md:hidden min-h-screen bg-white">
        <!-- Subtle background shapes -->
        <div class="fixed inset-0 overflow-hidden pointer-events-none">
            <div class="absolute w-72 h-72 rounded-full bg-gradient-to-r from-blue-50 to-blue-100 -top-36 -left-36 opacity-70 animate-float-slow"></div>
            <div class="absolute w-72 h-72 rounded-full bg-gradient-to-l from-blue-50 to-blue-100 -bottom-36 -right-36 opacity-70 animate-float-slow-reverse"></div>
        </div>
        
        <!-- Back Button -->
        <div class="p-6 relative z-10">
            <a href="/" class="group inline-flex items-center justify-center w-10 h-10 rounded-full bg-white shadow-soft text-gray-700 transition-all duration-300 hover:scale-105 active:scale-95">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 transition-transform duration-200 group-hover:-translate-x-0.5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="15 18 9 12 15 6"></polyline>
                </svg>
            </a>
        </div>

        <div class="flex flex-col items-center px-6 pt-6 relative z-10">
            <!-- Header -->
            <div class="text-center mb-12 animate-fadeIn">
                <div class="inline-flex items-center justify-center w-20 h-20 mb-6 rounded-full bg-gradient-to-br from-blue-400 to-blue-500 shadow-soft-md">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-10 h-10 text-blue-600" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                        <path d="M7 11V7a5 5 0 0110 0v4"></path>
                    </svg>
                </div>
                <h1 class="text-2xl font-bold text-gray-800 mb-2">Enter Passcode</h1>
                <p class="text-sm text-gray-600">Please enter your secure passcode</p>
            </div>

            <!-- Passcode Dots -->
            <div class="flex space-x-6 mb-12 animate-fadeIn">
                <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= 6; $i++): ?>
                    <div class="w-4 h-4 rounded-full border-2 border-gray-200 transition-all duration-300 transform <?php echo e(strlen($passcode) >= $i ? 'scale-110 bg-blue-500 border-blue-500 shadow-soft-blue' : 'bg-white'); ?>"></div>
                <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!--[if BLOCK]><![endif]--><?php if($error): ?>
                <div class="mb-8 text-center text-red-500 text-sm animate-shake">
                    <?php echo e($error); ?>

                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            
            <form wire:submit.prevent="verify" class="w-full max-w-xs">
                <input 
                    type="password"
                    wire:model="passcode"
                    maxlength="6"
                    class="sr-only"
                />
                
                <!-- Number Pad -->
                <div class="grid grid-cols-3 gap-6">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = range(1, 9); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button 
                            type="button"
                            wire:click="addNumber(<?php echo e($number); ?>)"
                            class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 text-xl font-medium shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 active:scale-95 active:shadow-inner focus:outline-none">
                            <span class="relative z-10"><?php echo e($number); ?></span>
                            <div class="absolute inset-0 bg-gradient-to-br from-blue-400 to-blue-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                            <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                        </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    
                    <!-- Bottom Row -->
                    <button 
                        type="button"
                        wire:click="clearPasscode"
                        class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 active:scale-95 active:shadow-inner focus:outline-none">
                        <span class="relative z-10">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 mx-auto" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                <line x1="6" y1="6" x2="18" y2="18"></line>
                            </svg>
                        </span>
                        <div class="absolute inset-0 bg-gradient-to-br from-red-400 to-red-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                        <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                    </button>
                    <button 
                        type="button"
                        wire:click="addNumber(0)"
                        class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 text-xl font-medium shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 active:scale-95 active:shadow-inner focus:outline-none">
                        <span class="relative z-10">0</span>
                        <div class="absolute inset-0 bg-gradient-to-br from-blue-400 to-blue-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                        <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                    </button>
                    <button 
                        type="button"
                        wire:click="deleteNumber"
                        class="group relative flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-white text-gray-700 shadow-soft overflow-hidden transition-all duration-300 transform hover:scale-105 active:scale-95 active:shadow-inner focus:outline-none">
                        <span class="relative z-10">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 mx-auto" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 4H8l-7 8 7 8h13a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"></path>
                                <line x1="18" y1="9" x2="12" y2="15"></line>
                                <line x1="12" y1="9" x2="18" y2="15"></line>
                            </svg>
                        </span>
                        <div class="absolute inset-0 bg-gradient-to-br from-blue-400 to-blue-500 opacity-0 group-hover:opacity-10 group-active:opacity-20 transition-opacity duration-300 rounded-full"></div>
                        <div class="absolute inset-0 rounded-full group-active:bg-gray-100 transition-colors duration-150"></div>
                    </button>
                </div>
                
                <!-- Hidden submit button -->
                <button type="submit" class="hidden">Verify</button>
            </form>
        </div>
    </div>

    <style>
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideUp {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        @keyframes slideDown {
            from { transform: translateY(-20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }
        @keyframes float-slow {
            0%, 100% { transform: translate(0, 0); }
            50% { transform: translate(20px, 20px); }
        }
        @keyframes float-slow-reverse {
            0%, 100% { transform: translate(0, 0); }
            50% { transform: translate(-20px, -20px); }
        }
        @keyframes float-medium {
            0%, 100% { transform: translate(0, 0); }
            50% { transform: translate(-15px, 15px); }
        }
        .animate-fadeIn {
            animation: fadeIn 0.6s ease-out;
        }
        .animate-slideUp {
            opacity: 0;
            animation: slideUp 0.5s ease-out forwards;
        }
        .animate-slideDown {
            opacity: 0;
            animation: slideDown 0.5s ease-out forwards;
        }
        .animate-shake {
            animation: shake 0.5s ease-in-out;
        }
        .animate-float-slow {
            animation: float-slow 10s ease-in-out infinite;
        }
        .animate-float-slow-reverse {
            animation: float-slow-reverse 10s ease-in-out infinite;
        }
        .animate-float-medium {
            animation: float-medium 7s ease-in-out infinite;
        }
        .shadow-soft {
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        .shadow-soft-md {
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.07);
        }
        .shadow-soft-blue {
            box-shadow: 0 0 8px rgba(59, 130, 246, 0.3);
        }
        .shadow-inner {
            box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.06);
        }
        .w-18 {
            width: 4.5rem;
        }
        .h-18 {
            height: 4.5rem;
        }
    </style>
</div><?php /**PATH /home2/gczzqaya/truthxwallet.com/resources/views/livewire/auth/passcode-page.blade.php ENDPATH**/ ?>