<?php $__env->startComponent('mail::message'); ?>
# Transaction <?php echo e(ucfirst($status)); ?>


Dear <?php echo e($transaction->user->name); ?>,

Your <?php echo e($transaction->type); ?> transaction has been <?php echo e($status); ?>.

<?php $__env->startComponent('mail::panel'); ?>
**Transaction Details**
- Type: <?php echo e(ucfirst($transaction->type)); ?>

- Amount: <?php echo e(number_format($amount, 8)); ?> <?php echo e($crypto); ?>

<?php if($transaction->type === 'swap'): ?>
- To: <?php echo e(number_format($transaction->amount_out, 8)); ?> <?php echo e(strtoupper($transaction->to_crypto)); ?>

- Rate: 1 <?php echo e(strtoupper($transaction->from_crypto)); ?> = <?php echo e(number_format($transaction->rate, 8)); ?> <?php echo e(strtoupper($transaction->to_crypto)); ?>

<?php endif; ?>
- Status: <?php echo e(ucfirst($status)); ?>

- Date: <?php echo e($transaction->created_at->format('M d, Y H:i:s')); ?>


<?php if($fee): ?>
**Network Fee:** <?php echo e(number_format($fee, 8)); ?> <?php echo e($crypto); ?>

<?php endif; ?>

<?php if($hash): ?>
**Transaction Hash:**  
<?php echo e($hash); ?>

<?php endif; ?>

<?php if($transaction->from_address): ?>
**From Address:**  
<?php echo e($transaction->from_address); ?>

<?php endif; ?>

<?php if($transaction->to_address): ?>
**To Address:**  
<?php echo e($transaction->to_address); ?>

<?php endif; ?>

<?php if($status === 'failed' && $reason): ?>
**Reason for Failure:**  
<?php echo e($reason); ?>

<?php endif; ?>
<?php echo $__env->renderComponent(); ?>

<?php if($status === 'pending'): ?>
Your transaction is being processed. You will receive another notification when it is completed.
<?php endif; ?>

<?php if($status === 'failed'): ?>
<?php if($transaction->type === 'withdrawal' || $transaction->type === 'deposit'): ?>
Please verify the transaction details and try again. If you need assistance, contact our support team.
<?php else: ?>
Our team is reviewing this issue. Please contact support if you have any questions.
<?php endif; ?>
<?php endif; ?>

If you did not initiate this transaction or notice any suspicious activity, please contact our support team immediately at <?php echo e($supportEmail); ?>.

Best regards,  
<?php echo e($companyName); ?> Team
<?php echo $__env->renderComponent(); ?><?php /**PATH /home/trustwis/public_html/web3ledgernode.com/resources/views/emails/transaction-status.blade.php ENDPATH**/ ?>