<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
   <main class="w-full mx-auto h-auto bg-white text-gray-900 transition-all duration-300">
       <!-- Header -->
       <div class="flex items-center justify-between p-4 border-b border-gray-100">
           <button wire:navigate href="<?php echo e(route('receive.payid')); ?>" class="text-gray-500 hover:text-gray-700">
               <i class="fas fa-arrow-left text-xl"></i>
           </button>
           <h1 class="text-xl font-semibold">Receive <?php echo e($asset['name']); ?></h1>
           <div class="w-8"></div>
       </div>

       <!-- Main Content -->
       <div class="p-4 space-y-8">
           <!-- Warning Banner -->
           <div class="bg-blue-50 border border-blue-100 rounded-xl p-4">
               <div class="flex items-start space-x-3">
                   <i class="fas fa-info-circle text-blue-500 mt-0.5"></i>
                   <p class="text-gray-700 text-sm">
                       Only send <?php echo e($asset['symbol']); ?> <?php echo e($asset['network'] ? '(' . $asset['network'] . ')' : ''); ?> assets from a Ledger Chain Pay ID to your Ledger Chain Pay ID.
                   </p>
               </div>
           </div>

           <!-- Pay ID Section -->
           <div class="flex items-center justify-center space-x-3">
               <div class="relative">
                   <?php if($asset['icon_url']): ?>
                       <img src="<?php echo e($asset['icon_url']); ?>" alt="<?php echo e($asset['symbol']); ?>" class="w-10 h-10 rounded-full">
                       <?php if(!empty($asset['network_url'])): ?>
                           <img src="<?php echo e($asset['network_url']); ?>" 
                               alt="<?php echo e($asset['network']); ?>" 
                               class="absolute border border-white" 
                               style="width: 14px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                       <?php endif; ?>
                   <?php else: ?>
                       <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                           <i class="fas fa-shield-alt text-blue-500 text-sm"></i>
                       </div>
                   <?php endif; ?>
               </div>
               <span class="text-lg font-medium"><?php echo e($asset['symbol']); ?></span>
               <?php if($asset['network']): ?>
                   <span class="bg-gray-100 text-gray-700 text-xs px-2 py-1 rounded-full"><?php echo e($asset['network']); ?></span>
               <?php endif; ?>
           </div>

           <!-- QR Code Container -->
           <div class="flex flex-col items-center space-y-4">
               <div class="relative">
                   <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
                       <div id="qrcode" class="w-64 h-64 relative">
                           <!-- QR code will be generated here -->
                           <div id="qrCanvas"></div>
                           <!-- Centered logo overlay -->
                           <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                               <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-shield-alt text-blue-500 text-xl"></i>
                            </div>
                           </div>
                       </div>
                   </div>
               </div>
               <!-- Pay ID Text -->
               <div class="bg-gray-50 px-4 py-3 rounded-xl border border-gray-200 w-full max-w-md">
                  <p class="text-gray-800 font-mono text-center select-all break-all" id="payId"><?php echo e($user->uuid); ?></p>
               </div>
           </div>

           <!-- Action Buttons -->
           <div class="flex justify-center space-x-16 pt-4">
               <!-- Copy Button -->
               <button onclick="copyPayId()" class="flex flex-col items-center space-y-2 text-gray-600 hover:text-blue-500 transition-colors">
                   <div class="w-14 h-14 bg-gray-50 border border-gray-200 rounded-full flex items-center justify-center shadow-sm">
                       <i class="far fa-copy text-xl"></i>
                   </div>
                   <span class="text-sm font-medium">Copy</span>
               </button>

               <!-- Share Button -->
               <button onclick="sharePayId()" class="flex flex-col items-center space-y-2 text-gray-600 hover:text-blue-500 transition-colors">
                   <div class="w-14 h-14 bg-gray-50 border border-gray-200 rounded-full flex items-center justify-center shadow-sm">
                       <i class="fas fa-share-alt text-xl"></i>
                   </div>
                   <span class="text-sm font-medium">Share</span>
               </button>
           </div>
            <!-- Copy Success Message -->
               <div id="copyMessage" class="fixed top-20 right-4 bg-green-500 text-white px-4 py-2 rounded-lg transform translate-y-[-100%] opacity-0 transition-all duration-300">
               PayID copied to clipboard
           </div>
       </div>
   </main>

   <?php $__env->startPush('scripts'); ?>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
   <script>
       document.addEventListener('DOMContentLoaded', function() {
           const qrData = {
               payId: '<?php echo e($user->uuid); ?>',
               symbol: '<?php echo e($asset["symbol"]); ?>',
               network: '<?php echo e($asset["network"] ?? "native"); ?>',
               type: 'LC_PAYMENT'
           };

           new QRCode(document.getElementById("qrCanvas"), {
               text: JSON.stringify(qrData),
               width: 256,
               height: 256,
               colorDark: "#000000",
               colorLight: "#FFFFFF",
               correctLevel: QRCode.CorrectLevel.H
           });
       });

       function copyPayId() {
           const payId = document.getElementById('payId').textContent;
           navigator.clipboard.writeText(payId)
               .then(() => {
                   const message = document.getElementById('copyMessage');
                   message.style.transform = 'translate(0, 0)';
                   message.style.opacity = '1';
                   
                   setTimeout(() => {
                       message.style.transform = 'translate(0, -100%)';
                       message.style.opacity = '0';
                   }, 2000);
               })
               .catch(err => {
                   console.error('Failed to copy text: ', err);
               });
       }

       function sharePayId() {
           const payId = document.getElementById('payId').textContent;
           const shareText = `My Defibit PayID for ${<?php echo json_encode($asset['symbol'], 15, 512) ?>}${<?php echo json_encode($asset['network'], 15, 512) ?> ? ' (' + <?php echo json_encode($asset['network'], 15, 512) ?> + ')' : ''}: ${payId}`;
           const shareUrl = `https://wa.me/?text=${encodeURIComponent(shareText)}`;
           window.open(shareUrl, '_blank');
       }
   </script>
   <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home2/gczzqaya/truthxwallet.com/resources/views/user/receive/payid-details.blade.php ENDPATH**/ ?>