<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Wallet Addresses')]); ?>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-white text-gray-900 transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <a href="<?php echo e(url()->previous()); ?>" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Your Wallet Addresses</h1>
            <a href="<?php echo e(route('crypto.manage')); ?>" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-plus text-xl"></i>
            </a>
        </div>
    
        <!-- Search Bar -->
        <div class="relative mb-5">
            <div class="absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400">
                <i class="fas fa-search"></i>
            </div>
            <input 
                type="text" 
                placeholder="Search coin name" 
                id="search-input"
                class="w-full bg-gray-50 border border-gray-100 rounded-xl py-3 pl-12 pr-4 text-gray-900 focus:outline-none focus:ring-2 focus:ring-blue-100 focus:border-blue-300"
                onkeyup="filterCryptos()"
            >
        </div>
    
        <!-- Network Filter -->
        <div class="mb-6 flex flex-wrap gap-2">
            <button 
                class="filter-btn inline-block px-4 py-2 rounded-full text-sm bg-blue-500 text-white font-medium"
                data-network="all"
            >
                All Networks
            </button>
            <?php $__currentLoopData = ['TRC20', 'ERC20', 'BNB']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $network): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button 
                    class="filter-btn inline-block px-4 py-2 rounded-full text-sm bg-gray-100 text-gray-700 font-medium hover:bg-gray-200 transition-colors"
                    data-network="<?php echo e($network); ?>"
                >
                    <?php echo e($network); ?>

                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    
        <!-- Crypto Address List -->
        <div class="space-y-3" id="crypto-list">
            <?php $__empty_1 = true; $__currentLoopData = $activeCryptos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="flex items-center justify-between p-4 crypto-item bg-white rounded-xl shadow-sm border border-gray-100" data-network="<?php echo e($crypto['network'] ?? 'native'); ?>">
                    <div class="flex items-center flex-1">
                        <div class="w-10 h-10 rounded-full bg-blue-50 flex items-center justify-center mr-3">
                            <?php if(strtolower($crypto['symbol']) === 'usdt'): ?>
                                <!-- USDT Icon as Text -->
                                <span class="text-blue-500 font-bold text-xl">₮</span>
                            <?php else: ?>
                                <!-- Cryptocurrency Icon as Image -->
                                <img 
                                    src="<?php echo e(asset('images/' . strtolower($crypto['symbol']) . '-icon.png')); ?>" 
                                    alt="<?php echo e($crypto['name']); ?> Icon" 
                                    class="w-8 h-8 object-contain"
                                >
                            <?php endif; ?>
                        </div>
                        <div class="flex-1">
                            <div class="flex items-center gap-2">
                                <h3 class="font-medium text-gray-900"><?php echo e($crypto['name']); ?></h3>
                                <?php if($crypto['network']): ?>
                                    <span class="text-xs bg-gray-100 px-2 py-0.5 rounded-full text-gray-600"><?php echo e(strtoupper($crypto['network'])); ?></span>
                                <?php endif; ?>
                            </div>
                            <p class="text-sm text-gray-500 font-mono"><?php echo e(\Illuminate\Support\Str::limit($crypto['address'], 15, '...')); ?></p>
                        </div>
                    </div>
                    <button 
                        class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-500 hover:bg-blue-100 transition-colors copy-btn" 
                        data-address="<?php echo e($crypto['address']); ?>"
                        aria-label="Copy <?php echo e($crypto['name']); ?> Address"
                    >
                        <i class="far fa-copy"></i>
                    </button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-10 bg-white rounded-xl shadow-sm border border-gray-100">
                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-wallet text-gray-400 text-2xl"></i>
                    </div>
                    <p class="text-gray-600 font-medium">No active cryptocurrency addresses found</p>
                    <p class="text-sm text-gray-500 mt-1 mb-6">Enable cryptocurrencies in Manage Crypto</p>
                    <a href="<?php echo e(route('crypto.manage')); ?>" class="inline-flex items-center px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-xl font-medium transition-colors">
                        <i class="fas fa-plus mr-2"></i>
                        Add Cryptocurrencies
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </main>

<!-- Success Toast for Copying Address -->
<div id="copy-success" class="fixed top-4 right-4 bg-blue-500 text-white px-4 py-3 rounded-xl shadow-lg z-50 flex items-center opacity-0 pointer-events-none transition-all duration-300">
    <i class="fas fa-check-circle mr-2"></i>
    <span>Address copied to clipboard!</span>
</div>

<!-- JavaScript for Search, Filter, and Copy Functionality -->
<script>
    // Initialize toast position on page load
    document.addEventListener('DOMContentLoaded', function() {
        const successMsg = document.getElementById('copy-success');
        successMsg.style.transform = 'translateX(calc(100% + 1rem))';
    });
    
    // Function to filter cryptocurrencies based on search input and network filter
    function filterCryptos() {
        const searchInput = document.getElementById('search-input').value.toLowerCase();
        const filterButtons = document.querySelectorAll('.filter-btn');
        let activeNetwork = 'all';

        // Determine the active network filter
        filterButtons.forEach(btn => {
            if(btn.classList.contains('bg-blue-500')) {
                activeNetwork = btn.getAttribute('data-network');
            }
        });

        const cryptoItems = document.querySelectorAll('.crypto-item');

        cryptoItems.forEach(item => {
            const name = item.querySelector('h3').innerText.toLowerCase();
            const network = item.getAttribute('data-network').toLowerCase();

            const matchesSearch = name.includes(searchInput);
            const matchesNetwork = activeNetwork === 'all' || network === activeNetwork.toLowerCase();

            if(matchesSearch && matchesNetwork) {
                item.style.display = 'flex';
            } else {
                item.style.display = 'none';
            }
        });
    }

    // Add event listeners to filter buttons
    document.querySelectorAll('.filter-btn').forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.filter-btn').forEach(btn => {
                btn.classList.remove('bg-blue-500', 'text-white');
                btn.classList.add('bg-gray-100', 'text-gray-700');
            });
            
            // Add active class to the clicked button
            this.classList.remove('bg-gray-100', 'text-gray-700');
            this.classList.add('bg-blue-500', 'text-white');
            
            // Trigger the filter function
            filterCryptos();
        });
    });

    // Initialize the first filter button as active
    document.addEventListener('DOMContentLoaded', () => {
        const firstFilterBtn = document.querySelector('.filter-btn[data-network="all"]');
        if(firstFilterBtn) {
            firstFilterBtn.classList.add('bg-blue-500', 'text-white');
            firstFilterBtn.classList.remove('bg-gray-100', 'text-gray-700');
        }
    });

    // Copy to clipboard functionality
    document.querySelectorAll('.copy-btn').forEach(button => {
        button.addEventListener('click', function() {
            const address = this.getAttribute('data-address');
            navigator.clipboard.writeText(address).then(() => {
                // Visual feedback on button
                this.innerHTML = '<i class="fas fa-check"></i>';
                this.classList.add('bg-green-100');
                this.classList.add('text-green-500');
                
                // Show toast notification
                const successMsg = document.getElementById('copy-success');
                successMsg.style.transform = 'translateX(0)';
                successMsg.classList.remove('opacity-0');
                successMsg.classList.add('opacity-90');
                successMsg.classList.remove('pointer-events-none');
                
                // Reset button after 2 seconds
                setTimeout(() => {
                    this.innerHTML = '<i class="far fa-copy"></i>';
                    this.classList.remove('bg-green-100');
                    this.classList.remove('text-green-500');
                }, 2000);
                
                // Hide toast after 3 seconds
                setTimeout(() => {
                    successMsg.style.transform = 'translateX(calc(100% + 1rem))';
                    successMsg.classList.remove('opacity-90');
                    successMsg.classList.add('opacity-0');
                    successMsg.classList.add('pointer-events-none');
                }, 3000);
            }).catch(err => {
                console.error('Failed to copy: ', err);
            });
        });
    });
</script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH /home/neosafewallet/public_html/resources/views/user/crypto/address.blade.php ENDPATH**/ ?>