<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($subject); ?></title>
    <style type="text/css">
        /* Base Styles - Simple CSS that Gmail supports */
        body, html {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            font-size: 16px;
            line-height: 1.6;
            color: #333333;
            background-color: #f7f7f7;
        }
        
        table {
            border-spacing: 0;
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        
        td {
            padding: 0;
            vertical-align: top;
        }
        
        img {
            border: 0;
            display: block;
            -ms-interpolation-mode: bicubic;
        }
        
        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        
        .header {
            background-color: #6b21a8;
            color: white;
            text-align: center;
            padding: 20px;
        }
        
        .content {
            padding: 30px 20px;
        }
        
        .greeting {
            font-weight: bold;
            margin-bottom: 20px;
            color: #111111;
        }
        
        .main-content {
            color: #444444;
        }
        
        .cta-button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #6b21a8;
            color: white;
            text-decoration: none;
            font-weight: bold;
            border-radius: 4px;
        }
        
        .footer {
            padding: 20px;
            text-align: center;
            background-color: #f1f1f1;
            color: #666666;
            font-size: 14px;
            border-top: 1px solid #e5e5e5;
        }
        
        .footer p {
            margin: 5px 0;
        }
        
        .social-links {
            margin: 15px 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 5px;
            color: #6b21a8;
            text-decoration: none;
        }
        
        .unsubscribe {
            color: #999999;
            font-size: 12px;
        }
    </style>
</head>
<body style="margin: 0; padding: 0; background-color: #f7f7f7; font-family: Arial, sans-serif;">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#f7f7f7">
        <tr>
            <td align="center" valign="top" style="padding: 20px 0;">
                <!-- Container Table -->
                <table class="container" width="600" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
                    <!-- Header -->
                    <tr>
                        <td class="header" align="center" bgcolor="#6b21a8" style="padding: 20px;">
                            <?php if($companyLogo): ?>
                                <img src="<?php echo e(asset($companyLogo)); ?>" alt="<?php echo e($companyName); ?> Logo" style="max-height: 60px; margin: 0 auto 10px;">
                            <?php endif; ?>
                            <h1 style="margin: 0; font-size: 24px; font-weight: bold; color: #ffffff;"><?php echo e($companyName); ?></h1>
                        </td>
                    </tr>
                    
                    <!-- Content -->
                    <tr>
                        <td class="content" style="padding: 30px 20px;">
                            <div class="greeting" style="font-weight: bold; margin-bottom: 20px; color: #111111;">
                                Hello <?php echo e($user->name); ?>,
                            </div>
                            
                            <div class="main-content" style="color: #444444;">
                                <?php echo $content; ?>

                            </div>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td class="footer" align="center" bgcolor="#f1f1f1" style="padding: 20px; border-top: 1px solid #e5e5e5;">
                            <div class="social-links" style="margin: 15px 0;">
                                <a href="#" style="display: inline-block; margin: 0 5px; color: #6b21a8; text-decoration: none; font-weight: 500;">Twitter</a> |
                                <a href="#" style="display: inline-block; margin: 0 5px; color: #6b21a8; text-decoration: none; font-weight: 500;">Facebook</a> |
                                <a href="#" style="display: inline-block; margin: 0 5px; color: #6b21a8; text-decoration: none; font-weight: 500;">Instagram</a>
                            </div>
                            
                            <p style="margin: 5px 0; font-size: 14px; color: #666666;">© <?php echo e(date('Y')); ?> <?php echo e($companyName); ?>. All rights reserved.</p>
                            <p style="margin: 5px 0; font-size: 14px; color: #666666;">For support, contact us at <?php echo e($companyEmail); ?></p>
                            
                            <p class="unsubscribe" style="color: #999999; font-size: 12px; margin-top: 15px;">
                                If you no longer wish to receive these emails, you can <a href="#" style="color: #6b21a8; text-decoration: none;">unsubscribe</a>.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html> <?php /**PATH /home2/gczzqaya/truthxwallet.com/resources/views/emails/newsletter/standard.blade.php ENDPATH**/ ?>