<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="w-full mx-auto h-auto bg-white text-gray-900 transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-100">
            <a href="<?php echo e(route('send.external')); ?>" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold">Send <?php echo e($asset['name']); ?></h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>

        <!-- Main Content -->
        <div class="p-4 space-y-6">
            <!-- Sending Method -->
            <div class="bg-blue-50 p-3 rounded-xl text-center">
                <p class="text-sm">
                    <span class="text-gray-700">Sending via - </span>
                    <span class="text-blue-500 font-medium">Cryptocurrency</span>
                </p>
            </div>

            <!-- Error Message -->
            <?php if(session('error')): ?>
            <div class="bg-red-50 border border-red-100 text-red-600 px-4 py-3 rounded-xl relative" role="alert">
                <p class="text-sm"><?php echo e(session('error')); ?></p>
            </div>
            <?php endif; ?>
            
             <?php echo $__env->make('user.status.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- External Send Form -->
            <form id="sendForm" class="space-y-6" action="<?php echo e(route('send.external.process', ['symbol' => $asset['symbol'], 'network' => $asset['network'] ?? 'native'])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <!-- Address Input -->
                <div class="space-y-2">
                    <label for="address" class="block text-sm font-medium text-gray-700">
                        <?php echo e($asset['symbol']); ?> Address <?php echo e($asset['network'] ? '(' . $asset['network'] . ')' : ''); ?>

                    </label>
                    <div class="relative">
                        <input 
                            type="text" 
                            id="address"
                            name="address"
                            value="<?php echo e(old('address')); ?>"
                            placeholder="Enter <?php echo e($asset['symbol']); ?> address"
                            class="w-full bg-gray-50 border border-gray-200 rounded-xl py-3.5 px-4 text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-100 focus:border-blue-300"
                            required
                        >
                        <div class="absolute right-2 top-1/2 -translate-y-1/2 flex items-center space-x-2">
                            <button type="button" id="pasteButton" class="text-blue-500 hover:text-blue-600 px-2" title="Paste from clipboard">
                                <i class="fas fa-paste"></i>
                            </button>
                            <button type="button" id="scanButton" class="text-gray-500 hover:text-gray-600" title="Scan QR Code">
                                <i class="fas fa-qrcode"></i>
                            </button>
                        </div>
                    </div>
                    <p id="addressError" class="hidden text-red-500 text-sm"></p>
                </div>

                <!-- Amount Input -->
                <div class="space-y-2">
                    <label for="amount" class="block text-sm font-medium text-gray-700">
                        Amount
                    </label>
                    <div class="relative">
                        <input 
                            type="number" 
                            id="amount"
                            name="amount"
                            value="<?php echo e(old('amount', session('amount'))); ?>"
                            step="0.00000001"
                            min="0"
                            max="<?php echo e($asset['balance']); ?>"
                            placeholder="0.0000"
                            class="w-full bg-gray-50 border border-gray-200 rounded-xl py-3.5 px-4 text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-100 focus:border-blue-300"
                            required
                        >
                        <div class="absolute right-2 top-1/2 -translate-y-1/2 flex items-center space-x-2">
                            <span class="text-gray-500"><?php echo e($asset['symbol']); ?></span>
                            <button type="button" id="maxButton" class="text-blue-500 hover:text-blue-600 px-2" title="Set to Max">
                                Max
                            </button>
                        </div>
                    </div>
                    <p id="amountError" class="hidden text-red-500 text-sm"></p>
                </div>

                <!-- Percentage Buttons -->
                <div class="grid grid-cols-4 gap-4">
                    <button type="button" class="percentButton px-4 py-2 bg-gray-50 hover:bg-gray-100 border border-gray-200 rounded-xl text-sm transition-colors" data-percentage="25">
                        25%
                    </button>
                    <button type="button" class="percentButton px-4 py-2 bg-gray-50 hover:bg-gray-100 border border-gray-200 rounded-xl text-sm transition-colors" data-percentage="50">
                        50%
                    </button>
                    <button type="button" class="percentButton px-4 py-2 bg-gray-50 hover:bg-gray-100 border border-gray-200 rounded-xl text-sm transition-colors" data-percentage="75">
                        75%
                    </button>
                    <button type="button" class="percentButton px-4 py-2 bg-gray-50 hover:bg-gray-100 border border-gray-200 rounded-xl text-sm transition-colors" data-percentage="100">
                        100%
                    </button>
                </div>

                <!-- Network Fee -->
                <div class="bg-gray-50 p-4 rounded-xl border border-gray-200 space-y-2">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Network Fee</span>
                        <span id="networkFee"><?php echo e(number_format($asset['fee'], 4)); ?> <?php echo e($asset['symbol']); ?></span>
                    </div>
                </div>

                <!-- Balance Info -->
                <div class="flex justify-between text-sm text-gray-600">
                    <span id="usdValue">≈ $ 0.0000</span>
                    <span>Available: <?php echo e(number_format($asset['balance'], 8)); ?> <?php echo e($asset['symbol']); ?></span>
                </div>

                <!-- Preview Section -->
                <div id="previewSection" class="space-y-4 bg-blue-50 p-4 rounded-xl border border-blue-100">
                    <h3 class="font-semibold text-lg">Transaction Preview</h3>
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Address:</span>
                            <span id="previewAddress">Not provided</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Amount:</span>
                            <span id="previewAmount">0 <?php echo e($asset['symbol']); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Network Fee:</span>
                            <span id="previewFee"><?php echo e(number_format($asset['fee'], 4)); ?> <?php echo e($asset['symbol']); ?></span>
                        </div>
                        <div class="flex justify-between font-semibold">
                            <span>Total:</span>
                            <span id="previewTotal">0 <?php echo e($asset['symbol']); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <button type="submit" id="submitButton" disabled
                        class="w-full bg-blue-500 hover:bg-blue-600 text-white font-semibold py-3.5 px-4 rounded-xl transition-colors disabled:opacity-50 disabled:cursor-not-allowed shadow-sm">
                    Send
                </button>
            </form>
        </div>
    </div>
    
    <?php echo $__env->make('user.status.progress', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- Include HTML5 QR Code Library -->
    <script src="https://unpkg.com/html5-qrcode"></script>
    
    <script>
      document.addEventListener('DOMContentLoaded', () => {
   // Elements
   
   const form = document.getElementById('sendForm');
   const addressInput = document.getElementById('address');
   const amountInput = document.getElementById('amount');
   const addressError = document.getElementById('addressError');
   const amountError = document.getElementById('amountError');
   const previewSection = document.getElementById('previewSection');
   const submitButton = document.getElementById('submitButton');
   const qrModal = document.getElementById('qrModal');
   const qrReader = document.getElementById('qr-reader');

   // Constants
   const maxAmount = parseFloat("<?php echo e($asset['balance']); ?>");
   const price = parseFloat("<?php echo e($asset['price']); ?>");
   const networkFeeAmount = parseFloat("<?php echo e($asset['fee']); ?>");

   // Initialize QR Code Scanner
   let html5QrcodeScanner = null;

   function initializeQRScanner() {
       html5QrcodeScanner = new Html5Qrcode("qr-reader");
   }

   function startQRScanner() {
       qrModal.classList.remove('hidden');
       if (!html5QrcodeScanner) {
           initializeQRScanner();
       }

       html5QrcodeScanner.start(
           { facingMode: "environment" },
           {
               fps: 10,
               qrbox: { width: 250, height: 250 }
           },
           (decodedText) => {
               addressInput.value = decodedText;
               validateAddress();
               updatePreview();
               closeQRScanner();
           },
           (errorMessage) => {
               console.warn(`QR Code scan error: ${errorMessage}`);
           }
       ).catch(err => {
           console.error('Unable to start QR scanner:', err);
       });
   }

   function closeQRScanner() {
       qrModal.classList.add('hidden');
       if (html5QrcodeScanner) {
           html5QrcodeScanner.stop().then(ignore => {
               // QR Code scanning is stopped.
           }).catch(err => {
               console.error('Failed to stop QR scanner:', err);
           });
       }
   }

   // Handle paste functionality
   document.getElementById('pasteButton').addEventListener('click', () => {
       navigator.clipboard.readText()
           .then(text => {
               addressInput.value = text.trim();
               validateAddress();
               updatePreview();
           })
           .catch(err => {
               console.error('Failed to read clipboard: ', err);
               alert('Failed to paste from clipboard.');
           });
   });

   // Handle QR scanner button
   document.getElementById('scanButton').addEventListener('click', startQRScanner);

   // Handle percentage buttons
   document.querySelectorAll('.percentButton').forEach(button => {
       button.addEventListener('click', () => {
           const percentage = parseInt(button.dataset.percentage);
           setPercentage(percentage);
       });
   });

   // Handle Max button
   document.getElementById('maxButton').addEventListener('click', setMaxAmount);

   function setPercentage(percentage) {
    const maxWithFee = maxAmount - networkFeeAmount;
    const amount = (maxWithFee * (percentage / 100)).toFixed(8);
    amountInput.value = amount > 0 ? amount : '0.00000000';
    validateAmount();
    updatePreview();
}

// Update setMaxAmount function
function setMaxAmount() {
    const maxWithFee = maxAmount - networkFeeAmount;
    const amount = maxWithFee.toFixed(8);
    amountInput.value = amount > 0 ? amount : '0.00000000';
    validateAmount();
    updatePreview();
}

// Update updatePreview function
function updatePreview() {
    const currentAmount = parseFloat(amountInput.value) || 0;
    const recipient = addressInput.value.trim() || 'Not provided';
    const shortenedRecipient = shortenString(recipient, 20);
    const total = (currentAmount + networkFeeAmount).toFixed(8);

    if (!previewSection.classList.contains('hidden')) {
        document.getElementById('previewAddress').textContent = shortenedRecipient;
        document.getElementById('previewAmount').textContent = `${currentAmount.toFixed(8)} <?php echo e($asset['symbol']); ?>`;
        document.getElementById('previewFee').textContent = `${networkFeeAmount.toFixed(4)} <?php echo e($asset['symbol']); ?>`;
        document.getElementById('previewTotal').textContent = `${total} <?php echo e($asset['symbol']); ?>`;
    }

    // Update USD value (including fee in calculation)
    const totalUsdValue = (currentAmount + networkFeeAmount) * price;
    document.getElementById('usdValue').textContent = '≈ $ ' + totalUsdValue.toFixed(4);
    toggleSubmitButton();
}

// Update validateAmount function
function validateAmount() {
    const amount = parseFloat(amountInput.value);
    const total = amount + networkFeeAmount;

    if (isNaN(amount) || amount <= 0) {
        amountError.textContent = 'Amount must be greater than 0';
        amountError.classList.remove('hidden');
        toggleSubmitButton();
        return false;
    }

    if (total > maxAmount) {
        amountError.textContent = `Insufficient balance (including ${networkFeeAmount} <?php echo e($asset['symbol']); ?> fee)`;
        amountError.classList.remove('hidden');
        toggleSubmitButton();
        return false;
    }

    amountError.classList.add('hidden');
    toggleSubmitButton();
    return true;
}

   function shortenString(str, maxLength = 10) {
       if (typeof str !== 'string') return '';
       if (str.length <= maxLength) return str;

       const ellipsis = '...';
       const charsToShow = maxLength - ellipsis.length;
       const frontChars = Math.ceil(charsToShow / 2);
       const backChars = Math.floor(charsToShow / 2);

       const front = str.substring(0, frontChars);
       const back = str.substring(str.length - backChars);

       return front + ellipsis + back;
   }


   // Validate Address via AJAX
   function validateAddress() {
       const address = addressInput.value.trim();
       const symbol = "<?php echo e(strtoupper($asset['symbol'])); ?>";
       const network = "<?php echo e(strtoupper($asset['network'] ?? 'native')); ?>";

       if (!address) {
           addressError.textContent = 'Address is required.';
           addressError.classList.remove('hidden');
           toggleSubmitButton();
           return false;
       }

       fetch('<?php echo e(route("send.external.verify")); ?>', {
           method: 'POST',
           headers: {
               'Content-Type': 'application/json',
               'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
           },
           body: JSON.stringify({ address, symbol, network }),
       })
       .then(response => response.json())
       .then(data => {
           if (data.success) {
               addressError.classList.add('hidden');
           } else {
               addressError.textContent = data.message;
               addressError.classList.remove('hidden');
           }
           toggleSubmitButton();
       })
       .catch(error => {
           console.error('Error:', error);
           addressError.textContent = 'An error occurred during address verification.';
           addressError.classList.remove('hidden');
           toggleSubmitButton();
       });

       return true;
   }


   // Toggle Submit Button
   function toggleSubmitButton() {
       const isAddressValid = addressError.classList.contains('hidden');
       const amountValid = amountError.classList.contains('hidden') && (parseFloat(amountInput.value) + networkFeeAmount) <= maxAmount;
       submitButton.disabled = !(isAddressValid && amountValid);
   }

   // Handle form submission
   form.addEventListener('submit', function(e) {
       e.preventDefault();

       const isAddressValid = validateAddress();
       const isAmountValid = validateAmount();

       if (!isAddressValid || !isAmountValid) {
           return;
       }

       // Show progress modal
       const progressModal = document.getElementById('progressModal');
       const progressBar = document.getElementById('progressBar');
       const progressText = document.getElementById('progressText');
       const progressStatus = document.getElementById('progressStatus');
       progressModal.classList.remove('hidden');

       let progress = 0;
       const statusMessages = [
           { percent: 20, message: 'Validating address...' },
           { percent: 40, message: 'Checking balance...' },
           { percent: 60, message: 'Calculating network fees...' },
           { percent: 80, message: 'Preparing transaction...' },
           { percent: 90, message: 'Almost done...' }
       ];

       const interval = setInterval(() => {
           if (progress >= 90) {
               clearInterval(interval);
               previewSection.classList.remove('hidden');
               updatePreview();

               submitButton.textContent = 'Confirm';
               submitButton.classList.remove('bg-blue-500', 'hover:bg-blue-600');
               submitButton.classList.add('bg-green-500', 'hover:bg-green-600');

               progressModal.classList.add('hidden');
               submitButton.addEventListener('click', handleConfirm, { once: true });
               submitButton.disabled = false;
           } else {
               progress += 2;
               progressBar.style.width = `${progress}%`;
               progressText.textContent = `${progress}%`;

               for (const status of statusMessages) {
                   if (progress <= status.percent) {
                       progressStatus.textContent = status.message;
                       break;
                   }
               }
           }
       }, 50);
   });

   function handleConfirm(e) {
       const progressModal = document.getElementById('progressModal');
       const progressBar = document.getElementById('progressBar');
       const progressText = document.getElementById('progressText');
       const progressStatus = document.getElementById('progressStatus');

       progressModal.classList.remove('hidden');
       progressBar.style.width = '90%';
       progressText.textContent = '90%';
       progressStatus.textContent = 'Finalizing transaction...';

       setTimeout(() => {
           form.submit();
       }, 1000);
   }

   // Initialize form
   amountInput.addEventListener('input', () => {
       validateAmount();
       updatePreview();
   });

   addressInput.addEventListener('input', () => {
       validateAddress();
       updatePreview();
   });

   updatePreview();
});
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH /home2/gczzqaya/truthxwallet.com/resources/views/user/send/external-details.blade.php ENDPATH**/ ?>