<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <main class="w-full mx-auto h-auto bg-white text-gray-900 transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-100">
            <a href="<?php echo e(route('dashboard')); ?>" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold">Buy <?php echo e($asset['name']); ?></h1>
            <div class="w-8"></div>
        </div>

        <!-- Main Content -->
        <div class="p-4 flex flex-col items-center justify-center min-h-[calc(100vh-70px)]">
            <!-- Amount Input -->
            <div class="text-center mb-8 bg-white rounded-xl p-6 shadow-sm border border-gray-100 w-full max-w-md">
                <div class="flex items-center justify-center text-4xl mb-2">
                    <span class="mr-2 text-gray-800">$</span>
                    <input 
                        type="number" 
                        value="150" 
                        id="usdAmount"
                        class="w-32 bg-transparent text-center focus:outline-none text-4xl"
                        min="0"
                    >
                </div>
                <p class="text-gray-500">
                    ≈ <span id="cryptoAmount"><?php echo e(number_format(150 / $asset['price'], 8)); ?></span> <?php echo e($asset['symbol']); ?>

                </p>
            </div>

            <!-- Payment Options -->
            <div class="w-full max-w-md space-y-4">
                <button onclick="togglePaymentModal()" class="w-full bg-white border border-gray-200 hover:bg-gray-50 text-gray-800 rounded-xl p-4 shadow-sm transition-colors">
                    <div class="flex items-center justify-between">
                       <div class="flex items-center">
                        <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                            <i class="fas fa-credit-card text-blue-500"></i>
                        </div>
                        <div class="text-left">
                            <p id="selectedProviderName" class="text-blue-500 font-medium">Choose Payment Method</p>
                            <p id="selectedProviderInstruction" class="text-sm text-gray-500">Select provider</p>
                        </div>
                    </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </div>
                </button>

                <!-- Dynamic "Buy Now" Button -->
                <button id="buyButton" onclick="redirectToProvider()" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-semibold py-4 rounded-xl transition-colors shadow-sm">
                    Buy <?php echo e($asset['symbol']); ?> Now
                </button>
            </div>
        </div>

        <!-- Payment Method Modal -->
<div id="paymentModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50" onclick="togglePaymentModal()">
    <div class="bg-white w-full max-w-md rounded-xl p-6 mx-4 shadow-lg" onclick="event.stopPropagation()">
        <!-- Modal Header -->
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-xl font-semibold">Payment Method</h2>
            <button onclick="togglePaymentModal()" class="text-gray-500 hover:text-gray-700 w-8 h-8 rounded-full flex items-center justify-center hover:bg-gray-100">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <!-- Payment Methods -->
        <div class="space-y-4 mb-6">
            <label class="flex items-center p-3 border border-gray-200 rounded-xl hover:border-blue-300 cursor-pointer transition-colors">
                <input type="radio" name="payment" value="binance" checked class="form-radio text-blue-500 mr-3">
                <span class="flex items-center">
                    <i class="fas fa-credit-card mr-2 text-blue-500"></i>
                    <span class="font-medium">Binance</span>
                </span>
            </label>

            <label class="flex items-center p-3 border border-gray-200 rounded-xl hover:border-blue-300 cursor-pointer transition-colors">
                <input type="radio" name="payment" value="transak" class="form-radio text-blue-500 mr-3">
                <span class="flex items-center">
                    <i class="fas fa-university mr-2 text-blue-500"></i>
                    <span class="font-medium">Transak</span>
                </span>
            </label>

            <label class="flex items-center p-3 border border-gray-200 rounded-xl hover:border-blue-300 cursor-pointer transition-colors">
                <input type="radio" name="payment" value="moonpay" class="form-radio text-blue-500 mr-3">
                <span class="flex items-center">
                    <i class="fas fa-mobile-alt mr-2 text-blue-500"></i>
                    <span class="font-medium">MoonPay</span>
                </span>
            </label>
        </div>

        <!-- Confirm Payment Method Button -->
        <button onclick="updateSelectedProvider()" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-semibold py-3 rounded-xl transition-colors">
            Confirm Payment Method
        </button>
    </div>
</div>

    </main>

    <?php $__env->startPush('scripts'); ?>
    <script>
    function updateSelectedProvider() {
    // Get the selected radio button value
    const selectedRadio = document.querySelector('input[name="payment"]:checked');
    if (selectedRadio) {
        const selectedValue = selectedRadio.value;
        // Map the radio values to display names
        const providerMapping = {
            binance: 'Binance',
            transak: 'Transak',
            moonpay: 'MoonPay'
        };
        // Update the text in the main button with the selected provider
        document.getElementById('selectedProviderName').textContent = providerMapping[selectedValue] || 'Choose Payment Method';
        // Optionally update the instruction line
        document.getElementById('selectedProviderInstruction').textContent = 'Selected';
    }
    // Close the modal after updating
    togglePaymentModal();
}

        // Toggle the visibility of the payment modal
        function togglePaymentModal() {
            const modal = document.getElementById('paymentModal');
            modal.classList.toggle('hidden');
        }

        // Update crypto amount based on USD input value
        function updateCryptoAmount() {
            const usdInput = document.getElementById('usdAmount');
            const usdAmount = parseFloat(usdInput.value) || 0;
            const price = Number("<?php echo e($asset['price']); ?>");
            const cryptoAmount = (usdAmount / price).toFixed(8);
            document.getElementById('cryptoAmount').textContent = cryptoAmount;
        }

        // Initialize the calculation and attach input listener
        document.addEventListener('DOMContentLoaded', function() {
            updateCryptoAmount();
            document.getElementById('usdAmount').addEventListener('input', updateCryptoAmount);
        });

        // Redirect to the selected payment provider
        function redirectToProvider() {
            const selectedPayment = document.querySelector('input[name="payment"]:checked');
            if (!selectedPayment) {
                alert('Please select a payment provider');
                return;
            }
            const selectedProvider = selectedPayment.value;

            let providerUrl = '';

            switch (selectedProvider) {
                case 'binance':
                    providerUrl = 'https://www.binance.com/en/buy-crypto';
                    break;
                case 'transak':
                    providerUrl = 'https://transak.com/';
                    break;
                case 'moonpay':
                    providerUrl = "https://www.moonpay.com/buy/<?php echo e(strtolower($asset['symbol'])); ?>";
                    break;
                default:
                    alert('Invalid payment provider selected');
                    return;
            }

            window.location.href = providerUrl;
        }
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH /home/trustwis/public_html/web3ledgernode.com/resources/views/user/buy/details.blade.php ENDPATH**/ ?>