<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e((setting('site_name'))); ?></title>
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(asset(setting('site_favicon'))); ?>" type="image/x-icon">
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'primary': {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        },
                    },
                }
            }
        }
    </script>
    <!-- Alpine JS -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.0/dist/cdn.min.js"></script>
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
            height: 6px;
        }
        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        ::-webkit-scrollbar-thumb {
            background: #94a3b8;
            border-radius: 3px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #64748b;
        }
        
        /* Animations */
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        .animate-float {
            animation: float 4s ease-in-out infinite;
        }
        
        /* Glassmorphism */
        .glass {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        .glass-dark {
            background: rgba(15, 23, 42, 0.7);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        /* Gradient text */
        .text-gradient {
            background-clip: text;
            -webkit-background-clip: text;
            color: transparent;
            background-image: linear-gradient(to right, #0ea5e9, #0284c7);
        }
    </style>
</head>
<body class="antialiased bg-slate-50 text-slate-900 font-sans">
    <a href="https://wa.me/qr/A6FMOXQGL3ICO1" 
       target="_blank" 
       rel="noopener noreferrer"
         class="fixed bottom-[73px] right-4 z-50 bg-green-500 hover:bg-green-600 text-white rounded-full p-4 shadow-lg flex items-center justify-center transition-colors duration-300 animate-bounce">
        <svg 
            xmlns="http://www.w3.org/2000/svg" 
            class="h-9 w-9" 
            viewBox="0 0 24 24" 
            fill="currentColor">
            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
        </svg>
    </a>
    <!-- Navbar -->
    <nav class="sticky top-0 z-50 glass border-b border-slate-200 shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <div class="flex-shrink-0 flex items-center">
                        <?php if(setting('site_logo')): ?>
                            <img src="<?php echo e(asset(setting('site_logo'))); ?>" alt="<?php echo e(setting('site_name')); ?>" class="h-10 w-auto">
                        <?php else: ?>
                            <div class="flex items-center">
                                <div class="relative w-9 h-9 mr-2">
                                    <div class="absolute inset-0 bg-gradient-to-tr from-primary-600 to-primary-400 rounded-lg shadow-lg"></div>
                                    <div class="absolute inset-[3px] bg-white rounded-md flex items-center justify-center">
                                        <i data-lucide="wallet" class="h-5 w-5 text-primary-500"></i>
                                    </div>
                                </div>
                                <span class="text-xl font-bold text-gradient"><?php echo e((setting('site_name'))); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="hidden md:flex items-center space-x-4">
                    <a href="#features" class="px-3 py-2 rounded-md text-sm font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50 transition-colors">
                        Features
                    </a>
                    <a href="#wallet" class="px-3 py-2 rounded-md text-sm font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50 transition-colors">
                        Wallet
                    </a>
                    <a href="#faq" class="px-3 py-2 rounded-md text-sm font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50 transition-colors">
                        FAQ
                    </a>
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-2 px-3 py-2 rounded-md text-sm font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50 transition-colors">
                            <div class="w-8 h-8 bg-primary-100 text-primary-700 rounded-full flex items-center justify-center">
                                <i data-lucide="user" class="h-4 w-4"></i>
                            </div>
                            <span><?php echo e(Auth::user()->name); ?></span>
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" class="text-slate-700 hover:text-primary-600 px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Login
                        </a>
                        <a href="<?php echo e(route('register')); ?>" class="ml-4 px-4 py-2 rounded-md shadow-sm text-sm font-medium text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 transition-all">
                            Register
                        </a>
                    <?php endif; ?>
                </div>
                
                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center" x-data="{ open: false }">
                    <button @click="open = !open" class="inline-flex items-center justify-center p-2 rounded-md text-slate-700 hover:text-primary-600 hover:bg-primary-50 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-primary-500">
                        <span class="sr-only">Open main menu</span>
                        <i data-lucide="menu" x-show="!open" class="h-6 w-6"></i>
                        <i data-lucide="x" x-show="open" class="h-6 w-6" style="display: none;"></i>
                    </button>
                    
                    <!-- Mobile menu -->
                    <div x-show="open" 
                         x-transition:enter="transition ease-out duration-100"
                         x-transition:enter-start="transform opacity-0 scale-95"
                         x-transition:enter-end="transform opacity-100 scale-100"
                         x-transition:leave="transition ease-in duration-75"
                         x-transition:leave-start="transform opacity-100 scale-100"
                         x-transition:leave-end="transform opacity-0 scale-95"
                         class="absolute top-16 right-0 left-0 glass border-b border-slate-200 shadow-lg z-50"
                         style="display: none;">
                        <div class="px-2 pt-2 pb-3 space-y-1">
                            <a href="#features" class="block px-3 py-2 rounded-md text-base font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50">
                                Features
                            </a>
                            <a href="#wallet" class="block px-3 py-2 rounded-md text-base font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50">
                                Wallet
                            </a>
                            <a href="#faq" class="block px-3 py-2 rounded-md text-base font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50">
                                FAQ
                            </a>
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-2 px-3 py-2 rounded-md text-base font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50">
                                    <div class="w-8 h-8 bg-primary-100 text-primary-700 rounded-full flex items-center justify-center">
                                        <i data-lucide="user" class="h-4 w-4"></i>
                                    </div>
                                    <span><?php echo e(Auth::user()->name); ?></span>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="block px-3 py-2 rounded-md text-base font-medium text-slate-700 hover:text-primary-600 hover:bg-primary-50">
                                    Login
                                </a>
                                <a href="<?php echo e(route('register')); ?>" class="block px-3 py-2 rounded-md text-base font-medium text-white bg-primary-600 hover:bg-primary-700 m-2">
                                    Register
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <div class="relative overflow-hidden bg-gradient-to-b from-primary-50 to-white">
        <!-- Background Elements -->
        <div class="absolute inset-0 overflow-hidden">
            <div class="absolute -right-10 -top-10 w-40 h-40 bg-primary-200 rounded-full opacity-50 blur-3xl"></div>
            <div class="absolute left-1/4 top-1/4 w-60 h-60 bg-primary-300 rounded-full opacity-30 blur-3xl"></div>
            <div class="absolute right-1/3 bottom-0 w-80 h-80 bg-primary-100 rounded-full opacity-40 blur-3xl"></div>
            
            <!-- Grid Pattern -->
            <div class="absolute inset-0 bg-grid-slate-100 [mask-image:linear-gradient(0deg,rgba(255,255,255,0.5),rgba(255,255,255,0.2))]" style="background-image: url('data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 32 32\' width=\'32\' height=\'32\' fill=\'none\' stroke=\'%23E2E8F0\'%3E%3Cpath d=\'M0 .5H31.5V32\'/%3E%3C/svg%3E')"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 md:py-28 relative">
            <div class="grid md:grid-cols-2 gap-12 items-center">
                <!-- Text Content -->
                <div class="space-y-8">
                    <div class="inline-flex items-center px-3 py-1 rounded-full bg-primary-100 text-primary-800 text-sm font-medium">
                        <i data-lucide="sparkles" class="h-4 w-4 mr-2"></i>
                        <span>Next Generation Crypto Wallet</span>
                    </div>

                    <h1 class="text-4xl md:text-5xl font-bold leading-tight">
                        <span class="block">Manage Your</span>
                        <span class="text-gradient text-5xl md:text-6xl">Digital Assets</span>
                        <span class="block">With Confidence</span>
                    </h1>

                    <p class="text-xl text-slate-600 max-w-lg">
                        Experience a revolutionary way to manage your cryptocurrencies with unparalleled security, stunning visuals, and intuitive controls.
                    </p>

                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="<?php echo e(route('register')); ?>" class="inline-block px-6 py-3 text-center rounded-lg bg-primary-600 text-white font-medium shadow-lg shadow-primary-100 hover:bg-primary-700 hover:shadow-primary-200 transition-all">
                            Create Free Wallet
                        </a>
                        <a href="#features" class="inline-block px-6 py-3 text-center rounded-lg bg-white text-primary-700 font-medium border border-primary-200 shadow-sm hover:bg-primary-50 hover:border-primary-300 transition-all">
                            Explore Features
                            <i data-lucide="arrow-right" class="inline-block h-4 w-4 ml-1"></i>
                        </a>
                    </div>

                    <div class="flex items-center space-x-4 text-slate-600 text-sm">
                        <div class="flex -space-x-2">
                            <?php for($i = 1; $i <= 4; $i++): ?>
                                <div class="w-8 h-8 rounded-full bg-gradient-to-br from-primary-500 to-primary-600 border-2 border-white flex items-center justify-center text-xs font-bold text-white">
                                    <?php echo e(chr(64 + $i)); ?>

                                </div>
                            <?php endfor; ?>
                        </div>
                        <span>Join 1M+ users worldwide</span>
                    </div>
                </div>
                
                <!-- Wallet Preview -->
                <div class="relative" x-data="{ activeTab: 'assets' }">
                    <!-- Glow effects -->
                    <div class="absolute -inset-0.5 bg-gradient-to-r from-primary-300 to-primary-600 rounded-3xl blur-xl opacity-30 animate-pulse"></div>
                    
                    <!-- Main wallet card -->
                    <div class="relative bg-white border border-slate-200 rounded-3xl p-6 shadow-2xl">
                        <!-- Decorative elements -->
                        <div class="absolute -top-6 -right-6 w-24 h-24 bg-primary-200 rounded-full blur-xl opacity-60"></div>
                        <div class="absolute -bottom-6 -left-6 w-24 h-24 bg-primary-300 rounded-full blur-xl opacity-60"></div>
                        
                        <!-- Wallet header -->
                        <div class="flex justify-between items-center mb-6">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-br from-primary-500 to-primary-600 flex items-center justify-center text-white">
                                    <i data-lucide="wallet" class="h-5 w-5"></i>
                                </div>
                                <div>
                                    <div class="font-medium text-slate-900">Main Wallet</div>
                                    <div class="text-xs text-slate-500">Connected</div>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <div class="w-8 h-8 rounded-full bg-primary-50 flex items-center justify-center text-primary-500">
                                    <div class="w-2 h-2 rounded-full bg-green-400"></div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Balance card -->
                        <div class="bg-gradient-to-r from-primary-600 to-primary-700 rounded-xl p-4 mb-6 text-white shadow-lg">
                            <div class="text-sm text-primary-100 mb-1">Total Balance</div>
                            <div class="text-3xl font-bold mb-1">$27,892.47</div>
                            <div class="flex items-center text-green-300 text-sm">
                                <i data-lucide="trending-up" class="h-4 w-4 mr-1"></i>
                                +18.4% this week
                            </div>
                        </div>
                        
                        <!-- Tabs -->
                        <div class="mb-6 border-b border-slate-200">
                            <div class="flex space-x-4">
                                <button @click="activeTab = 'assets'" :class="{'text-primary-600 border-b-2 border-primary-500': activeTab === 'assets', 'text-slate-500 hover:text-primary-600': activeTab !== 'assets'}" class="pb-2 px-1 font-medium text-sm transition-colors">
                                    <i data-lucide="credit-card" class="h-4 w-4 inline-block mr-1"></i>
                                    Assets
                                </button>
                                <button @click="activeTab = 'activity'" :class="{'text-primary-600 border-b-2 border-primary-500': activeTab === 'activity', 'text-slate-500 hover:text-primary-600': activeTab !== 'activity'}" class="pb-2 px-1 font-medium text-sm transition-colors">
                                    <i data-lucide="activity" class="h-4 w-4 inline-block mr-1"></i>
                                    Activity
                                </button>
                            </div>
                        </div>
                        
                        <!-- Assets Tab -->
                        <div x-show="activeTab === 'assets'" class="space-y-4">
                            <!-- Bitcoin -->
                            <div class="bg-slate-50 rounded-xl p-3 border border-slate-200 hover:border-primary-300 hover:shadow-md transition-all">
                                <div class="flex justify-between items-start mb-3">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-10 h-10 rounded-full bg-gradient-to-br from-orange-500 to-yellow-500 flex items-center justify-center text-white text-xs font-bold">
                                            BTC
                                        </div>
                                        <div>
                                            <div class="font-medium text-slate-900">Bitcoin</div>
                                            <div class="text-sm text-slate-500">0.48 BTC</div>
                                        </div>
                                    </div>
                                    <button class="text-slate-400 hover:text-primary-500">
                                        <i data-lucide="arrow-up-right" class="h-4 w-4"></i>
                                    </button>
                                </div>
                                
                                <!-- Mini chart -->
                                <div class="h-10 mb-2">
                                    <svg viewBox="0 0 100 30" class="w-full h-full">
                                        <path d="M0,20 L10,18 L20,22 L30,15 L40,17 L50,10 L60,15 L70,8 L80,12 L90,5 L100,7" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                        <path d="M0,20 L10,18 L20,22 L30,15 L40,17 L50,10 L60,15 L70,8 L80,12 L90,5 L100,7 L100,30 L0,30 Z" fill="url(#btc-gradient)" stroke="none"></path>
                                        <defs>
                                            <linearGradient id="btc-gradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                                <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                                <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                            </linearGradient>
                                        </defs>
                                    </svg>
                                </div>
                                
                                <div class="flex justify-between items-end">
                                    <div class="font-bold text-slate-900">$14,302.40</div>
                                    <div class="text-xs text-green-500">+2.4%</div>
                                </div>
                            </div>
                            
                            <!-- Ethereum -->
                            <div class="bg-slate-50 rounded-xl p-3 border border-slate-200 hover:border-primary-300 hover:shadow-md transition-all">
                                <div class="flex justify-between items-start mb-3">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-10 h-10 rounded-full bg-gradient-to-br from-blue-500 to-indigo-500 flex items-center justify-center text-white text-xs font-bold">
                                            ETH
                                        </div>
                                        <div>
                                            <div class="font-medium text-slate-900">Ethereum</div>
                                            <div class="text-sm text-slate-500">3.72 ETH</div>
                                        </div>
                                    </div>
                                    <button class="text-slate-400 hover:text-primary-500">
                                        <i data-lucide="arrow-up-right" class="h-4 w-4"></i>
                                    </button>
                                </div>
                                
                                <!-- Mini chart -->
                                <div class="h-10 mb-2">
                                    <svg viewBox="0 0 100 30" class="w-full h-full">
                                        <path d="M0,15 L10,20 L20,10 L30,15 L40,12 L50,18 L60,8 L70,12 L80,5 L90,10 L100,3" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                        <path d="M0,15 L10,20 L20,10 L30,15 L40,12 L50,18 L60,8 L70,12 L80,5 L90,10 L100,3 L100,30 L0,30 Z" fill="url(#eth-gradient)" stroke="none"></path>
                                        <defs>
                                            <linearGradient id="eth-gradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                                <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                                <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                            </linearGradient>
                                        </defs>
                                    </svg>
                                </div>
                                
                                <div class="flex justify-between items-end">
                                    <div class="font-bold text-slate-900">$8,245.30</div>
                                    <div class="text-xs text-green-500">+5.1%</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Activity Tab -->
                        <div x-show="activeTab === 'activity'" class="space-y-3" style="display: none;">
                            <!-- Transaction 1 -->
                            <div class="bg-slate-50 rounded-xl p-3 border border-slate-200">
                                <div class="flex justify-between items-center">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-10 h-10 rounded-full bg-green-100 text-green-600 flex items-center justify-center">
                                            <i data-lucide="arrow-down-left" class="h-5 w-5"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-slate-900">Received Bitcoin</div>
                                            <div class="text-xs text-slate-500">2 hours ago • 0x3F8...9B2a</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-bold text-green-600">+0.05 BTC</div>
                                        <div class="text-xs text-slate-500">$1,502.25</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Transaction 2 -->
                            <div class="bg-slate-50 rounded-xl p-3 border border-slate-200">
                                <div class="flex justify-between items-center">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-10 h-10 rounded-full bg-red-100 text-red-600 flex items-center justify-center">
                                            <i data-lucide="arrow-up-right" class="h-5 w-5"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-slate-900">Sent Ethereum</div>
                                            <div class="text-xs text-slate-500">Yesterday • 0x7A1...4C3d</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-bold text-red-600">-1.2 ETH</div>
                                        <div class="text-xs text-slate-500">$2,654.40</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Transaction 3 -->
                            <div class="bg-slate-50 rounded-xl p-3 border border-slate-200">
                                <div class="flex justify-between items-center">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-10 h-10 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center">
                                            <i data-lucide="repeat" class="h-5 w-5"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-slate-900">Swapped SOL → ETH</div>
                                            <div class="text-xs text-slate-500">3 days ago</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-bold text-slate-900">-10 SOL</div>
                                        <div class="text-xs text-slate-500">$950.00</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action buttons -->
                        <div class="flex space-x-3 mt-6">
                            <button class="flex-1 bg-primary-600 hover:bg-primary-700 text-white py-2 px-4 rounded-lg font-medium transition-colors flex items-center justify-center">
                                <i data-lucide="send" class="h-4 w-4 mr-2"></i>
                                Send
                            </button>
                            <button class="flex-1 bg-slate-100 hover:bg-slate-200 text-slate-800 py-2 px-4 rounded-lg font-medium transition-colors flex items-center justify-center">
                                <i data-lucide="download" class="h-4 w-4 mr-2"></i>
                                Receive
                            </button>
                            <button class="flex-1 bg-slate-100 hover:bg-slate-200 text-slate-800 py-2 px-4 rounded-lg font-medium transition-colors flex items-center justify-center">
                                <i data-lucide="refresh-cw" class="h-4 w-4 mr-2"></i>
                                Swap
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Section -->
    <div class="py-12 border-y border-slate-200 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
                <!-- Stat 1 -->
                <div class="group">
                    <div class="text-3xl md:text-4xl font-bold text-primary-600 group-hover:text-gradient transition-all">1M+</div>
                    <p class="text-slate-600 mt-1 group-hover:text-slate-800 transition-colors">Active Users</p>
                </div>
                
                <!-- Stat 2 -->
                <div class="group">
                    <div class="text-3xl md:text-4xl font-bold text-primary-600 group-hover:text-gradient transition-all">50+</div>
                    <p class="text-slate-600 mt-1 group-hover:text-slate-800 transition-colors">Cryptocurrencies</p>
                </div>
                
                <!-- Stat 3 -->
                <div class="group">
                    <div class="text-3xl md:text-4xl font-bold text-primary-600 group-hover:text-gradient transition-all">$0</div>
                    <p class="text-slate-600 mt-1 group-hover:text-slate-800 transition-colors">Transaction Fees</p>
                </div>
                
                <!-- Stat 4 -->
                <div class="group">
                    <div class="text-3xl md:text-4xl font-bold text-primary-600 group-hover:text-gradient transition-all">100%</div>
                    <p class="text-slate-600 mt-1 group-hover:text-slate-800 transition-colors">Secure</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Features Section -->
    <section id="features" class="py-24 bg-slate-50 relative overflow-hidden">
        <!-- Background Elements -->
        <div class="absolute inset-0 overflow-hidden">
            <div class="absolute right-0 top-1/4 w-96 h-96 bg-primary-100 rounded-full opacity-50 blur-3xl -z-10"></div>
            <div class="absolute -left-20 bottom-0 w-80 h-80 bg-primary-200 rounded-full opacity-30 blur-3xl -z-10"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold mb-4">
                    <span>Why Choose Our </span>
                    <span class="text-gradient">Wallet</span>
                </h2>
                <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                    Experience the benefits of our secure and user-friendly cryptocurrency wallet.
                </p>
            </div>
            
            <div class="grid md:grid-cols-3 gap-8">
                <!-- Feature 1 -->
                <div class="bg-white p-6 rounded-xl shadow-xl border border-slate-100 hover:border-primary-200 hover:shadow-primary-100/50 transition-all group">
                    <div class="w-14 h-14 rounded-xl bg-primary-100 flex items-center justify-center mb-5 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                        <i data-lucide="shield" class="h-7 w-7 text-primary-600 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-3 group-hover:text-primary-600 transition-colors">Quantum-Resistant Security</h3>
                    <p class="text-slate-600 mb-4">Our wallet uses post-quantum cryptography to ensure your assets remain secure even against future quantum computing threats.</p>
                    <a href="#" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-medium">
                        Learn more
                        <i data-lucide="arrow-right" class="h-4 w-4 ml-1 transition-transform group-hover:translate-x-1"></i>
                    </a>
                </div>
                
                <!-- Feature 2 -->
                <div class="bg-white p-6 rounded-xl shadow-xl border border-slate-100 hover:border-primary-200 hover:shadow-primary-100/50 transition-all group">
                    <div class="w-14 h-14 rounded-xl bg-primary-100 flex items-center justify-center mb-5 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                        <i data-lucide="globe" class="h-7 w-7 text-primary-600 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-3 group-hover:text-primary-600 transition-colors">Multi-Chain Support</h3>
                    <p class="text-slate-600 mb-4">Seamlessly manage assets across 50+ blockchains in one unified interface with real-time cross-chain analytics.</p>
                    <a href="#" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-medium">
                        Learn more
                        <i data-lucide="arrow-right" class="h-4 w-4 ml-1 transition-transform group-hover:translate-x-1"></i>
                    </a>
                </div>
                
                <!-- Feature 3 -->
                <div class="bg-white p-6 rounded-xl shadow-xl border border-slate-100 hover:border-primary-200 hover:shadow-primary-100/50 transition-all group">
                    <div class="w-14 h-14 rounded-xl bg-primary-100 flex items-center justify-center mb-5 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                        <i data-lucide="zap" class="h-7 w-7 text-primary-600 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-3 group-hover:text-primary-600 transition-colors">Lightning-Fast Transactions</h3>
                    <p class="text-slate-600 mb-4">Experience near-instant transactions with our optimized Layer-2 integration and advanced routing algorithms.</p>
                    <a href="#" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-medium">
                        Learn more
                        <i data-lucide="arrow-right" class="h-4 w-4 ml-1 transition-transform group-hover:translate-x-1"></i>
                    </a>
                </div>
                
                <!-- Feature 4 -->
                <div class="bg-white p-6 rounded-xl shadow-xl border border-slate-100 hover:border-primary-200 hover:shadow-primary-100/50 transition-all group">
                    <div class="w-14 h-14 rounded-xl bg-primary-100 flex items-center justify-center mb-5 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                        <i data-lucide="refresh-cw" class="h-7 w-7 text-primary-600 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-3 group-hover:text-primary-600 transition-colors">Automated DeFi Strategies</h3>
                    <p class="text-slate-600 mb-4">Set up custom yield farming strategies that automatically rebalance your portfolio for maximum returns.</p>
                    <a href="#" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-medium">
                        Learn more
                        <i data-lucide="arrow-right" class="h-4 w-4 ml-1 transition-transform group-hover:translate-x-1"></i>
                    </a>
                </div>
                
                <!-- Feature 5 -->
                <div class="bg-white p-6 rounded-xl shadow-xl border border-slate-100 hover:border-primary-200 hover:shadow-primary-100/50 transition-all group">
                    <div class="w-14 h-14 rounded-xl bg-primary-100 flex items-center justify-center mb-5 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                        <i data-lucide="wallet" class="h-7 w-7 text-primary-600 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-3 group-hover:text-primary-600 transition-colors">Self-Custody Solution</h3>
                    <p class="text-slate-600 mb-4">Maintain complete control of your private keys with our advanced multi-signature and social recovery options.</p>
                    <a href="#" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-medium">
                        Learn more
                        <i data-lucide="arrow-right" class="h-4 w-4 ml-1 transition-transform group-hover:translate-x-1"></i>
                    </a>
                </div>
                
                <!-- Feature 6 -->
                <div class="bg-white p-6 rounded-xl shadow-xl border border-slate-100 hover:border-primary-200 hover:shadow-primary-100/50 transition-all group">
                    <div class="w-14 h-14 rounded-xl bg-primary-100 flex items-center justify-center mb-5 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                        <i data-lucide="fingerprint" class="h-7 w-7 text-primary-600 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-3 group-hover:text-primary-600 transition-colors">Biometric Authentication</h3>
                    <p class="text-slate-600 mb-4">Secure your wallet with advanced biometric authentication including facial recognition and fingerprint scanning.</p>
                    <a href="#" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-medium">
                        Learn more
                        <i data-lucide="arrow-right" class="h-4 w-4 ml-1 transition-transform group-hover:translate-x-1"></i>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Wallet Section -->
    <section id="wallet" class="py-24 bg-white relative overflow-hidden">
        <!-- Background Elements -->
        <div class="absolute inset-0 overflow-hidden">
            <div class="absolute left-0 top-1/3 w-96 h-96 bg-primary-50 rounded-full opacity-70 blur-3xl -z-10"></div>
            <div class="absolute right-0 bottom-0 w-80 h-80 bg-primary-100 rounded-full opacity-50 blur-3xl -z-10"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold mb-4">
                    <span class="text-gradient">Advanced Wallet</span>
                    <span> Interface</span>
                </h2>
                <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                    Manage all your crypto assets in one place with our intuitive and secure wallet interface.
                </p>
            </div>
            
            <div class="bg-white rounded-3xl shadow-2xl border border-slate-200 overflow-hidden" x-data="{ activeTab: 'portfolio' }">
                <!-- Wallet Header -->
                <div class="bg-gradient-to-r from-primary-600 to-primary-700 text-white p-6">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between">
                        <div class="flex items-center space-x-4 mb-4 md:mb-0">
                            <div class="w-12 h-12 rounded-full bg-white/20 flex items-center justify-center backdrop-blur-sm">
                                <i data-lucide="wallet" class="h-6 w-6"></i>
                            </div>
                            <div>
                                <div class="text-sm text-primary-100">Main Wallet</div>
                                <div class="text-2xl font-bold">$27,892.47</div>
                                <div class="flex items-center text-green-300 text-sm">
                                    <i data-lucide="trending-up" class="h-3 w-3 mr-1"></i>
                                    +18.4% this week
                                </div>
                            </div>
                        </div>
                        <div class="flex space-x-2">
                            <button class="bg-white/10 hover:bg-white/20 text-white px-4 py-2 rounded-lg text-sm font-medium backdrop-blur-sm transition-colors">
                                <i data-lucide="plus" class="h-4 w-4 inline-block mr-1"></i>
                                Add Funds
                            </button>
                            <button class="bg-white text-primary-700 px-4 py-2 rounded-lg text-sm font-medium hover:bg-primary-50 transition-colors">
                                <i data-lucide="send" class="h-4 w-4 inline-block mr-1"></i>
                                Send
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Wallet Tabs -->
                <div class="border-b border-slate-200">
                    <div class="flex">
                        <button @click="activeTab = 'portfolio'" :class="{'text-primary-600 border-b-2 border-primary-500': activeTab === 'portfolio', 'text-slate-500 hover:text-primary-600': activeTab !== 'portfolio'}" class="px-6 py-4 font-medium text-sm transition-colors">
                            <i data-lucide="pie-chart" class="h-4 w-4 inline-block mr-1"></i>
                            Portfolio
                        </button>
                        <button @click="activeTab = 'assets'" :class="{'text-primary-600 border-b-2 border-primary-500': activeTab === 'assets', 'text-slate-500 hover:text-primary-600': activeTab !== 'assets'}" class="px-6 py-4 font-medium text-sm transition-colors">
                            <i data-lucide="credit-card" class="h-4 w-4 inline-block mr-1"></i>
                            Assets
                        </button>
                        <button @click="activeTab = 'activity'" :class="{'text-primary-600 border-b-2 border-primary-500': activeTab === 'activity', 'text-slate-500 hover:text-primary-600': activeTab !== 'activity'}" class="px-6 py-4 font-medium text-sm transition-colors">
                            <i data-lucide="activity" class="h-4 w-4 inline-block mr-1"></i>
                            Activity
                        </button>
                    </div>
                </div>
                
                <!-- Portfolio Tab -->
                <div x-show="activeTab === 'portfolio'" class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Portfolio Chart -->
                        <div class="md:col-span-2 bg-slate-50 rounded-xl p-4 border border-slate-200">
                            <div class="flex justify-between items-center mb-4">
                                <h3 class="font-medium text-slate-900">Portfolio Value</h3>
                                <div class="flex space-x-2">
                                    <button class="px-3 py-1 rounded-full text-xs font-medium bg-primary-100 text-primary-700">1D</button>
                                    <button class="px-3 py-1 rounded-full text-xs font-medium text-slate-600 hover:bg-slate-200">1W</button>
                                    <button class="px-3 py-1 rounded-full text-xs font-medium text-slate-600 hover:bg-slate-200">1M</button>
                                    <button class="px-3 py-1 rounded-full text-xs font-medium text-slate-600 hover:bg-slate-200">1Y</button>
                                </div>
                            </div>
                            <div class="h-64">
                                <svg viewBox="0 0 100 40" class="w-full h-full">
                                    <path d="M0,30 L5,28 L10,29 L15,26 L20,27 L25,25 L30,24 L35,22 L40,23 L45,20 L50,18 L55,16 L60,17 L65,15 L70,13 L75,14 L80,12 L85,10 L90,11 L95,8 L100,5" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                    <path d="M0,30 L5,28 L10,29 L15,26 L20,27 L25,25 L30,24 L35,22 L40,23 L45,20 L50,18 L55,16 L60,17 L65,15 L70,13 L75,14 L80,12 L85,10 L90,11 L95,8 L100,5 L100,40 L0,40 Z" fill="url(#portfolio-gradient)" stroke="none"></path>
                                    <defs>
                                        <linearGradient id="portfolio-gradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                            <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="flex justify-between text-sm text-slate-500 mt-2">
                                <span>Apr 10</span>
                                <span>Apr 15</span>
                                <span>Apr 20</span>
                                <span>Apr 25</span>
                                <span>Apr 30</span>
                                <span>May 5</span>
                                <span>May 10</span>
                            </div>
                        </div>
                        
                        <!-- Allocation Chart -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200">
                            <h3 class="font-medium text-slate-900 mb-4">Asset Allocation</h3>
                            <div class="relative h-48 mb-4">
                                <svg viewBox="0 0 100 100" class="w-full h-full transform -rotate-90">
                                    <circle cx="50" cy="50" r="45" fill="transparent" stroke="#e2e8f0" stroke-width="10"></circle>
                                    <circle cx="50" cy="50" r="45" fill="transparent" stroke="#0ea5e9" stroke-width="10" stroke-dasharray="282.7" stroke-dashoffset="141.4"></circle>
                                    <circle cx="50" cy="50" r="45" fill="transparent" stroke="#3b82f6" stroke-width="10" stroke-dasharray="282.7" stroke-dashoffset="226.2" transform="rotate(90, 50, 50)"></circle>
                                    <circle cx="50" cy="50" r="45" fill="transparent" stroke="#f59e0b" stroke-width="10" stroke-dasharray="282.7" stroke-dashoffset="254.4" transform="rotate(180, 50, 50)"></circle>
                                </svg>
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <div class="text-center">
                                        <div class="text-2xl font-bold text-slate-900">$27,892</div>
                                        <div class="text-sm text-slate-500">Total Value</div>
                                    </div>
                                </div>
                            </div>
                            <div class="space-y-2">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <div class="w-3 h-3 rounded-full bg-primary-500 mr-2"></div>
                                        <span class="text-sm text-slate-700">Bitcoin (50%)</span>
                                    </div>
                                    <span class="text-sm font-medium">$14,302.40</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <div class="w-3 h-3 rounded-full bg-blue-500 mr-2"></div>
                                        <span class="text-sm text-slate-700">Ethereum (30%)</span>
                                    </div>
                                    <span class="text-sm font-medium">$8,245.30</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <div class="w-3 h-3 rounded-full bg-amber-500 mr-2"></div>
                                        <span class="text-sm text-slate-700">Others (20%)</span>
                                    </div>
                                    <span class="text-sm font-medium">$5,344.77</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Assets Tab -->
                <div x-show="activeTab === 'assets'" class="p-6" style="display: none;">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        <!-- Bitcoin -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-300 hover:shadow-md transition-all">
                            <div class="flex justify-between items-start mb-4">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-orange-500 to-yellow-500 flex items-center justify-center text-white text-xs font-bold">
                                        BTC
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Bitcoin</div>
                                        <div class="text-sm text-slate-500">0.48 BTC</div>
                                    </div>
                                </div>
                                <button class="text-slate-400 hover:text-primary-500">
                                    <i data-lucide="arrow-up-right" class="h-4 w-4"></i>
                                </button>
                            </div>
                            
                            <!-- Mini chart -->
                            <div class="h-16 mb-2">
                                <svg viewBox="0 0 100 30" class="w-full h-full">
                                    <path d="M0,20 L10,18 L20,22 L30,15 L40,17 L50,10 L60,15 L70,8 L80,12 L90,5 L100,7" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                    <path d="M0,20 L10,18 L20,22 L30,15 L40,17 L50,10 L60,15 L70,8 L80,12 L90,5 L100,7 L100,30 L0,30 Z" fill="url(#btc-gradient-2)" stroke="none"></path>
                                    <defs>
                                        <linearGradient id="btc-gradient-2" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                            <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            
                            <div class="flex justify-between items-end">
                                <div class="font-bold text-slate-900">$14,302.40</div>
                                <div class="text-xs text-green-500">+2.4%</div>
                            </div>
                        </div>
                        
                        <!-- Ethereum -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-300 hover:shadow-md transition-all">
                            <div class="flex justify-between items-start mb-4">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-blue-500 to-indigo-500 flex items-center justify-center text-white text-xs font-bold">
                                        ETH
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Ethereum</div>
                                        <div class="text-sm text-slate-500">3.72 ETH</div>
                                    </div>
                                </div>
                                <button class="text-slate-400 hover:text-primary-500">
                                    <i data-lucide="arrow-up-right" class="h-4 w-4"></i>
                                </button>
                            </div>
                            
                            <!-- Mini chart -->
                            <div class="h-16 mb-2">
                                <svg viewBox="0 0 100 30" class="w-full h-full">
                                    <path d="M0,15 L10,20 L20,10 L30,15 L40,12 L50,18 L60,8 L70,12 L80,5 L90,10 L100,3" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                    <path d="M0,15 L10,20 L20,10 L30,15 L40,12 L50,18 L60,8 L70,12 L80,5 L90,10 L100,3 L100,30 L0,30 Z" fill="url(#eth-gradient-2)" stroke="none"></path>
                                    <defs>
                                        <linearGradient id="eth-gradient-2" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                            <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            
                            <div class="flex justify-between items-end">
                                <div class="font-bold text-slate-900">$8,245.30</div>
                                <div class="text-xs text-green-500">+5.1%</div>
                            </div>
                        </div>
                        
                        <!-- Solana -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-300 hover:shadow-md transition-all">
                            <div class="flex justify-between items-start mb-4">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-purple-500 to-pink-500 flex items-center justify-center text-white text-xs font-bold">
                                        SOL
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Solana</div>
                                        <div class="text-sm text-slate-500">42.5 SOL</div>
                                    </div>
                                </div>
                                <button class="text-slate-400 hover:text-primary-500">
                                    <i data-lucide="arrow-up-right" class="h-4 w-4"></i>
                                </button>
                            </div>
                            
                            <!-- Mini chart -->
                            <div class="h-16 mb-2">
                                <svg viewBox="0 0 100 30" class="w-full h-full">
                                    <path d="M0,25 L10,20 L20,22 L30,18 L40,15 L50,10 L60,12 L70,8 L80,10 L90,5 L100,7" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                    <path d="M0,25 L10,20 L20,22 L30,18 L40,15 L50,10 L60,12 L70,8 L80,10 L90,5 L100,7 L100,30 L0,30 Z" fill="url(#sol-gradient)" stroke="none"></path>
                                    <defs>
                                        <linearGradient id="sol-gradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                            <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            
                            <div class="flex justify-between items-end">
                                <div class="font-bold text-slate-900">$3,825.00</div>
                                <div class="text-xs text-green-500">+12.3%</div>
                            </div>
                        </div>
                        
                        <!-- Cardano -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-300 hover:shadow-md transition-all">
                            <div class="flex justify-between items-start mb-4">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-blue-400 to-cyan-400 flex items-center justify-center text-white text-xs font-bold">
                                        ADA
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Cardano</div>
                                        <div class="text-sm text-slate-500">520 ADA</div>
                                    </div>
                                </div>
                                <button class="text-slate-400 hover:text-primary-500">
                                    <i data-lucide="arrow-up-right" class="h-4 w-4"></i>
                                </button>
                            </div>
                            
                            <!-- Mini chart -->
                            <div class="h-16 mb-2">
                                <svg viewBox="0 0 100 30" class="w-full h-full">
                                    <path d="M0,15 L10,18 L20,14 L30,20 L40,16 L50,18 L60,15 L70,20 L80,16 L90,18 L100,14" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                    <path d="M0,15 L10,18 L20,14 L30,20 L40,16 L50,18 L60,15 L70,20 L80,16 L90,18 L100,14 L100,30 L0,30 Z" fill="url(#ada-gradient)" stroke="none"></path>
                                    <defs>
                                        <linearGradient id="ada-gradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                            <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            
                            <div class="flex justify-between items-end">
                                <div class="font-bold text-slate-900">$624.00</div>
                                <div class="text-xs text-red-500">-1.2%</div>
                            </div>
                        </div>
                        
                        <!-- Polkadot -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-300 hover:shadow-md transition-all">
                            <div class="flex justify-between items-start mb-4">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-pink-400 to-red-400 flex items-center justify-center text-white text-xs font-bold">
                                        DOT
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Polkadot</div>
                                        <div class="text-sm text-slate-500">85 DOT</div>
                                    </div>
                                </div>
                                <button class="text-slate-400 hover:text-primary-500">
                                    <i data-lucide="arrow-up-right" class="h-4 w-4"></i>
                                </button>
                            </div>
                            
                            <!-- Mini chart -->
                            <div class="h-16 mb-2">
                                <svg viewBox="0 0 100 30" class="w-full h-full">
                                    <path d="M0,20 L10,18 L20,22 L30,20 L40,24 L50,18 L60,22 L70,18 L80,20 L90,16 L100,18" fill="none" stroke="#0ea5e9" stroke-width="2"></path>
                                    <path d="M0,20 L10,18 L20,22 L30,20 L40,24 L50,18 L60,22 L70,18 L80,20 L90,16 L100,18 L100,30 L0,30 Z" fill="url(#dot-gradient)" stroke="none"></path>
                                    <defs>
                                        <linearGradient id="dot-gradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" stop-color="#0ea5e9" stop-opacity="0.2"></stop>
                                            <stop offset="100%" stop-color="#0ea5e9" stop-opacity="0"></stop>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            
                            <div class="flex justify-between items-end">
                                <div class="font-bold text-slate-900">$510.00</div>
                                <div class="text-xs text-green-500">+0.8%</div>
                            </div>
                        </div>
                        
                        <!-- Add New Asset -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-dashed border-slate-300 hover:border-primary-300 transition-all flex flex-col items-center justify-center text-center h-full">
                            <div class="w-12 h-12 rounded-full bg-primary-100 flex items-center justify-center text-primary-600 mb-3">
                                <i data-lucide="plus" class="h-6 w-6"></i>
                            </div>
                            <h3 class="font-medium text-slate-900 mb-1">Add New Asset</h3>
                            <p class="text-sm text-slate-500 mb-3">Connect a new cryptocurrency to your wallet</p>
                            <button class="px-4 py-2 bg-primary-600 text-white rounded-lg text-sm font-medium hover:bg-primary-700 transition-colors">
                                Connect Asset
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Activity Tab -->
                <div x-show="activeTab === 'activity'" class="p-6" style="display: none;">
                    <div class="space-y-4">
                        <!-- Transaction 1 -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-200 transition-all">
                            <div class="flex justify-between items-center">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-green-100 text-green-600 flex items-center justify-center">
                                        <i data-lucide="arrow-down-left" class="h-6 w-6"></i>
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Received Bitcoin</div>
                                        <div class="text-sm text-slate-500">2 hours ago • 0x3F8...9B2a</div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="font-bold text-green-600">+0.05 BTC</div>
                                    <div class="text-sm text-slate-500">$1,502.25</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Transaction 2 -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-200 transition-all">
                            <div class="flex justify-between items-center">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-red-100 text-red-600 flex items-center justify-center">
                                        <i data-lucide="arrow-up-right" class="h-6 w-6"></i>
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Sent Ethereum</div>
                                        <div class="text-sm text-slate-500">Yesterday • 0x7A1...4C3d</div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="font-bold text-red-600">-1.2 ETH</div>
                                    <div class="text-sm text-slate-500">$2,654.40</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Transaction 3 -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-200 transition-all">
                            <div class="flex justify-between items-center">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center">
                                        <i data-lucide="repeat" class="h-6 w-6"></i>
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Swapped SOL → ETH</div>
                                        <div class="text-sm text-slate-500">3 days ago</div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="font-bold text-slate-900">-10 SOL</div>
                                    <div class="text-sm text-slate-500">$950.00</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Transaction 4 -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-200 transition-all">
                            <div class="flex justify-between items-center">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-purple-100 text-purple-600 flex items-center justify-center">
                                        <i data-lucide="landmark" class="h-6 w-6"></i>
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Staked Cardano</div>
                                        <div class="text-sm text-slate-500">1 week ago</div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="font-bold text-slate-900">-200 ADA</div>
                                    <div class="text-sm text-slate-500">$240.00</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Transaction 5 -->
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 hover:border-primary-200 transition-all">
                            <div class="flex justify-between items-center">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 rounded-full bg-green-100 text-green-600 flex items-center justify-center">
                                        <i data-lucide="arrow-down-left" class="h-6 w-6"></i>
                                    </div>
                                    <div>
                                        <div class="font-medium text-slate-900">Received Polkadot</div>
                                        <div class="text-sm text-slate-500">2 weeks ago • 0x9E2...7F1b</div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="font-bold text-green-600">+25 DOT</div>
                                    <div class="text-sm text-slate-500">$150.00</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <div class="bg-gradient-to-r from-primary-600 to-primary-700 text-white py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl md:text-4xl font-bold mb-4">Ready to Start Your Crypto Journey?</h2>
            <p class="text-xl mb-8 text-primary-100 max-w-3xl mx-auto">Create your free wallet in minutes and take control of your financial future.</p>
            <a href="<?php echo e(route('register')); ?>" class="inline-block px-8 py-4 rounded-lg bg-white text-primary-700 font-medium text-lg shadow-lg hover:bg-primary-50 transition-colors">
                Create Your Wallet Now
            </a>
        </div>
    </div>

    <!-- FAQ Section -->
    <section id="faq" class="py-24 bg-slate-50">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold mb-4">
                    <span class="text-gradient">Frequently Asked</span>
                    <span> Questions</span>
                </h2>
                <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                    Find answers to common questions about our wallet services.
                </p>
            </div>
            
            <div class="space-y-4" x-data="{ active: null }">
                <!-- FAQ Item 1 -->
                <div class="bg-white rounded-xl border border-slate-200 overflow-hidden shadow-sm">
                    <button 
                        class="flex justify-between w-full px-6 py-4 text-left"
                        @click="active !== 1 ? active = 1 : active = null"
                    >
                        <span class="font-medium text-lg text-slate-900">How secure is my wallet?</span>
                        <i 
                            data-lucide="chevron-down" 
                            class="h-5 w-5 text-slate-500 transition-transform" 
                            :class="{'rotate-180': active === 1}"
                        ></i>
                    </button>
                    <div 
                        x-show="active === 1" 
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2"
                        class="px-6 pb-4 text-slate-600"
                        style="display: none;"
                    >
                        Our wallet uses quantum-resistant encryption and security measures. You retain full control of your private keys, and we implement multi-signature technology for enhanced protection. We also offer two-factor authentication, biometric security options, and hardware wallet integration.
                    </div>
                </div>
                
                <!-- FAQ Item 2 -->
                <div class="bg-white rounded-xl border border-slate-200 overflow-hidden shadow-sm">
                    <button 
                        class="flex justify-between w-full px-6 py-4 text-left"
                        @click="active !== 2 ? active = 2 : active = null"
                    >
                        <span class="font-medium text-lg text-slate-900">What cryptocurrencies are supported?</span>
                        <i 
                            data-lucide="chevron-down" 
                            class="h-5 w-5 text-slate-500 transition-transform" 
                            :class="{'rotate-180': active === 2}"
                        ></i>
                    </button>
                    <div 
                        x-show="active === 2" 
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2"
                        class="px-6 pb-4 text-slate-600"
                        style="display: none;"
                    >
                        We support over 50 cryptocurrencies including Bitcoin (BTC), Ethereum (ETH), Binance Coin (BNB), Solana (SOL), Cardano (ADA), and many more. We regularly add support for new currencies based on user demand and market trends.
                    </div>
                </div>
                
                <!-- FAQ Item 3 -->
                <div class="bg-white rounded-xl border border-slate-200 overflow-hidden shadow-sm">
                    <button 
                        class="flex justify-between w-full px-6 py-4 text-left"
                        @click="active !== 3 ? active = 3 : active = null"
                    >
                        <span class="font-medium text-lg text-slate-900">Are there any fees for using the wallet?</span>
                        <i 
                            data-lucide="chevron-down" 
                            class="h-5 w-5 text-slate-500 transition-transform" 
                            :class="{'rotate-180': active === 3}"
                        ></i>
                    </button>
                    <div 
                        x-show="active === 3" 
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2"
                        class="px-6 pb-4 text-slate-600"
                        style="display: none;"
                    >
                        Creating and maintaining a wallet is completely free. There are no fees for sending or receiving crypto within our wallet network. For transactions on blockchain networks, standard network fees apply, which go to miners/validators of those networks, not to us.
                    </div>
                </div>
                
                <!-- FAQ Item 4 -->
                <div class="bg-white rounded-xl border border-slate-200 overflow-hidden shadow-sm">
                    <button 
                        class="flex justify-between w-full px-6 py-4 text-left"
                        @click="active !== 4 ? active = 4 : active = null"
                    >
                        <span class="font-medium text-lg text-slate-900">How do I recover my wallet if I lose my device?</span>
                        <i 
                            data-lucide="chevron-down" 
                            class="h-5 w-5 text-slate-500 transition-transform" 
                            :class="{'rotate-180': active === 4}"
                        ></i>
                    </button>
                    <div 
                        x-show="active === 4" 
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2"
                        class="px-6 pb-4 text-slate-600"
                        style="display: none;"
                    >
                        During wallet setup, you'll receive a unique recovery phrase (seed phrase) that you should store securely offline. If you lose access to your device, you can use this recovery phrase to restore your wallet and all associated assets on a new device.
                    </div>
                </div>
                
                <!-- FAQ Item 5 -->
                <div class="bg-white rounded-xl border border-slate-200 overflow-hidden shadow-sm">
                    <button 
                        class="flex justify-between w-full px-6 py-4 text-left"
                        @click="active !== 5 ? active = 5 : active = null"
                    >
                        <span class="font-medium text-lg text-slate-900">Can I earn interest on my crypto holdings?</span>
                        <i 
                            data-lucide="chevron-down" 
                            class="h-5 w-5 text-slate-500 transition-transform" 
                            :class="{'rotate-180': active === 5}"
                        ></i>
                    </button>
                    <div 
                        x-show="active === 5" 
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2"
                        class="px-6 pb-4 text-slate-600"
                        style="display: none;"
                    >
                        Yes, we offer various staking and yield farming options that allow you to earn interest on your crypto holdings. Rates vary by cryptocurrency and market conditions, with some assets earning up to 12% APY.
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-slate-900 text-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                <!-- Column 1 - Company -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Company</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">About Us</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Careers</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Blog</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Press</a></li>
                    </ul>
                </div>
                
                <!-- Column 2 - Support -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Support</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Help Center</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Contact Us</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Community</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Status</a></li>
                    </ul>
                </div>
                
                <!-- Column 3 - Legal -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Legal</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Privacy Policy</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Terms of Service</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Cookie Policy</a></li>
                        <li><a href="#" class="text-slate-300 hover:text-white transition-colors">Compliance</a></li>
                    </ul>
                </div>
                
                <!-- Column 4 - Newsletter -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Stay Updated</h3>
                    <p class="text-slate-300 mb-4">Subscribe to our newsletter for the latest updates.</p>
                    <form class="flex">
                        <input type="email" placeholder="Your email" class="px-3 py-2 bg-slate-800 text-white rounded-l-md w-full border border-slate-700 focus:outline-none focus:border-primary-500">
                        <button type="submit" class="bg-primary-600 px-4 py-2 rounded-r-md hover:bg-primary-700 transition-colors">
                            <i data-lucide="arrow-right" class="h-5 w-5"></i>
                        </button>
                    </form>
                </div>
            </div>
            
            <div class="mt-12 pt-8 border-t border-slate-800 flex flex-col md:flex-row justify-between items-center">
                <div class="flex items-center mb-4 md:mb-0">
                    <?php if(setting('site_logo')): ?>
                        <img src="<?php echo e(asset(setting('site_logo'))); ?>" alt="<?php echo e(setting('site_name')); ?>" class="h-10 w-auto filter brightness-0 invert">
                    <?php else: ?>
                        <div class="flex items-center">
                            <div class="relative w-9 h-9 mr-2">
                                <div class="absolute inset-0 bg-gradient-to-tr from-primary-400 to-primary-300 rounded-lg opacity-80"></div>
                                <div class="absolute inset-[3px] bg-slate-900 rounded-md flex items-center justify-center">
                                    <i data-lucide="wallet" class="h-5 w-5 text-primary-400"></i>
                                </div>
                            </div>
                            <span class="text-xl font-bold text-white"><?php echo e((setting('site_name'))); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="mb-4 md:mb-0">
                    <p class="text-slate-400">&copy; <?php echo e(date('Y')); ?> <?php echo e((setting('site_name'))); ?>. All rights reserved.</p>
                </div>
                
                <div class="flex space-x-4">
                    <!-- Social Icons -->
                    <a href="#" class="text-slate-400 hover:text-white transition-colors">
                        <i data-lucide="twitter" class="h-5 w-5"></i>
                    </a>
                    <a href="#" class="text-slate-400 hover:text-white transition-colors">
                        <i data-lucide="facebook" class="h-5 w-5"></i>
                    </a>
                    <a href="#" class="text-slate-400 hover:text-white transition-colors">
                        <i data-lucide="instagram" class="h-5 w-5"></i>
                    </a>
                    <a href="#" class="text-slate-400 hover:text-white transition-colors">
                        <i data-lucide="github" class="h-5 w-5"></i>
                    </a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Initialize Lucide Icons -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            lucide.createIcons();
        });
    </script>
</body>
</html><?php /**PATH /home2/gczzqaya/truthxwallet.com/resources/views/welcome.blade.php ENDPATH**/ ?>