<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <main class="w-full mx-auto min-h-screen bg-white text-gray-900 transition-all duration-300 flex flex-col">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-100">
            <a href="<?php echo e(route('dashboard')); ?>" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-times text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold">Transaction Details</h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>

        <!-- Main Content -->
        <div class="flex-grow flex flex-col items-center justify-center p-4 space-y-6">
            <!-- Status Icon and Message -->
            <?php if($transaction->status === App\Models\Transaction::STATUS_PENDING): ?>
                <!-- Pending Icon -->
                <div class="w-24 h-24 bg-yellow-500 rounded-full flex items-center justify-center shadow-md">
                    <i class="fas fa-hourglass-half text-4xl text-white"></i>
                </div>

                <!-- Pending Message -->
                <h2 class="text-2xl font-bold text-center">Transaction Pending</h2>
                <p class="text-gray-500 text-center">Your transaction is being processed.</p>
            <?php elseif($transaction->status === App\Models\Transaction::STATUS_COMPLETED): ?>
                <!-- Success Icon -->
                <div class="w-24 h-24 bg-green-500 rounded-full flex items-center justify-center shadow-md">
                    <i class="fas fa-check text-4xl text-white"></i>
                </div>

                <!-- Success Message -->
                <h2 class="text-2xl font-bold text-center">Transaction Successful!</h2>
                <p class="text-gray-500 text-center">Your funds have been sent successfully.</p>
            <?php elseif($transaction->status === App\Models\Transaction::STATUS_FAILED): ?>
                <!-- Failed Icon -->
                <div class="w-24 h-24 bg-red-500 rounded-full flex items-center justify-center shadow-md">
                    <i class="fas fa-times text-4xl text-white"></i>
                </div>

                <!-- Failed Message -->
                <h2 class="text-2xl font-bold text-center">Transaction Failed</h2>
                <p class="text-gray-500 text-center">There was an issue processing your transaction.</p>
            <?php else: ?>
                <!-- Default Icon -->
                <div class="w-24 h-24 bg-gray-400 rounded-full flex items-center justify-center shadow-md">
                    <i class="fas fa-question text-4xl text-white"></i>
                </div>

                <!-- Default Message -->
                <h2 class="text-2xl font-bold text-center">Transaction Status Unknown</h2>
                <p class="text-gray-500 text-center">Please contact support for more information.</p>
            <?php endif; ?>

            <!-- Transaction Details -->
            <div class="w-full max-w-md bg-white rounded-xl p-6 space-y-4 shadow-sm border border-gray-200">
                <div class="flex justify-between">
                    <span class="text-gray-500">Amount Sent</span>
                    <span class="font-semibold">
                        <?php echo e(rtrim(sprintf('%.8f', $transaction->amount_out), '0')); ?> 
                        <?php echo e(strtoupper(explode('_', $transaction->which_crypto)[0])); ?>

                    </span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Recipient Address</span>
                    <span class="font-semibold"><?php echo e(shorten_string($transaction->metadata['external_address'] ?? 'N/A')); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Network Fee</span>
                    <span class="font-semibold">
                        <?php echo e($transaction->metadata['network_fee'] > 0 
                            ? shorten_string(rtrim(sprintf('%.8f', $transaction->metadata['network_fee']), '0') . ' ' . strtoupper(explode('_', $transaction->which_crypto)[0])) 
                            : 'Free'); ?>

                    </span>
                </div>
                <div class="flex justify-between font-semibold">
                    <span>Total Amount</span>
                    <span>
                        <?php echo e(shorten_string(rtrim(sprintf('%.8f', $transaction->amount_out + $transaction->metadata['network_fee']), '0') . ' ' . strtoupper(explode('_', $transaction->which_crypto)[0]))); ?>

                    </span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Date</span>
                    <span class="font-semibold"><?php echo e($transaction->created_at->format('M d, Y H:i:s')); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Transaction Hash</span>
                    <span class="font-semibold">
                        <?php echo e(shorten_string($transaction->metadata['transaction_hash'] ?? 'N/A')); ?>

                    </span>
                </div>
            </div>

        <!-- Done Button -->
        <div class="p-4">
            <a href="<?php echo e(route('dashboard')); ?>" 
               class="block w-full bg-blue-500 hover:bg-blue-600 text-white font-semibold py-3.5 px-4 rounded-xl transition-colors text-center shadow-sm">
                Done
            </a>
        </div>
    </main>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                // Show success message
                const message = document.createElement('div');
                message.className = 'fixed bottom-4 right-4 bg-green-500 text-white px-4 py-2 rounded-xl shadow-lg';
                message.textContent = 'Copied to clipboard!';
                document.body.appendChild(message);
                
                // Remove message after 2 seconds
                setTimeout(() => {
                    message.remove();
                }, 2000);
            }).catch(() => {
                // Show error message
                const message = document.createElement('div');
                message.className = 'fixed bottom-4 right-4 bg-red-500 text-white px-4 py-2 rounded-xl shadow-lg';
                message.textContent = 'Failed to copy to clipboard';
                document.body.appendChild(message);
                
                // Remove message after 2 seconds
                setTimeout(() => {
                    message.remove();
                }, 2000);
            });
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH /home/elitemaxpro/wallet.elitemaxpro.click/resources/views/user/send/external-success.blade.php ENDPATH**/ ?>