<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Activity Alert</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .container { border: 1px solid #ddd; border-radius: 5px; padding: 20px; }
        .header { background-color: #f8f9fa; padding: 10px; border-radius: 5px; margin-bottom: 20px; }
        .content { margin-bottom: 20px; }
        .footer { font-size: 12px; color: #777; margin-top: 20px; text-align: center; }
        .highlight { background-color: #f8f9fa; padding: 10px; border-radius: 3px; margin: 10px 0; }
        h1 { color: #333; font-size: 24px; margin-top: 0; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>User Activity Alert</h1>
        </div>
        
        <div class="content">
            <p><strong>Activity:</strong> <?php echo e($activity['activity']); ?></p>
            <p><strong>Description:</strong> <?php echo e($activity['description']); ?></p>
            
            <h3>User Information</h3>
            <table>
                <tr>
                    <th>User ID</th>
                    <td><?php echo e($activity['user_id']); ?></td>
                </tr>
                <tr>
                    <th>Name</th>
                    <td><?php echo e($activity['user_name']); ?></td>
                </tr>
                <tr>
                    <th>Email</th>
                    <td><?php echo e($activity['user_email']); ?></td>
                </tr>
                <tr>
                    <th>Timestamp</th>
                    <td><?php echo e($activity['timestamp']); ?></td>
                </tr>
                <tr>
                    <th>IP Address</th>
                    <td><?php echo e($activity['ip_address']); ?></td>
                </tr>
                <tr>
                    <th>User Agent</th>
                    <td><?php echo e($activity['user_agent']); ?></td>
                </tr>
            </table>
            
            <?php if(!empty($activity['data'])): ?>
            <h3>Additional Details</h3>
            <div class="highlight">
                <table>
                    <?php $__currentLoopData = $activity['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th><?php echo e(ucfirst(str_replace('_', ' ', $key))); ?></th>
                        <td>
                            <?php if(is_array($value)): ?>
                                <pre><?php echo e(json_encode($value, JSON_PRETTY_PRINT)); ?></pre>
                            <?php else: ?>
                                <?php echo e($value); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p><?php echo e(config('app.name')); ?> &copy; <?php echo e(date('Y')); ?></p>
        </div>
    </div>
</body>
</html> <?php /**PATH /home/elitemaxpro/wallet.elitemaxpro.click/resources/views/emails/user_activity.blade.php ENDPATH**/ ?>