<nav class="flex items-center justify-between py-4 px-4 bg-white shadow-sm border-b border-gray-100">
    <div class="flex items-center">
        <button onclick="toggleWalletDropdown()" class="flex items-center gap-2 bg-trust-gray px-3 py-2 rounded-lg">
            <i class="fas fa-wallet text-trust-blue text-lg"></i>
            <span class="font-medium" id="accountId"><?php echo e($accountId ?? 'My Wallet'); ?></span>
            <i class="fas fa-chevron-down text-xs text-trust-text-secondary" id="dropdownIcon"></i>
        </button>
    </div>
    <div>
        <a href="<?php echo e(route('notifications')); ?>" class="relative bg-trust-gray p-2 rounded-full">
            <i class="fas fa-bell text-trust-blue text-lg"></i>
            <span id="mobile-profile-notification-badge" class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-4 h-4 flex items-center justify-center hidden">
                0
            </span>
        </a>
    </div>
    
    <!-- Dropdown Menu -->
    <div id="walletDropdown" class="absolute top-14 md:top-16 md:left-[270px] left-4 w-60 rounded-xl shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-50 hidden">
        <div class="py-1">
            <div class="border-b border-gray-100 my-1"></div>
            <form method="POST" action="<?php echo e(route('logout')); ?>" class="w-full">
                <?php echo csrf_field(); ?>
                <button type="submit" 
                        class="flex items-center w-full text-left px-4 py-3 text-sm text-trust-text hover:bg-trust-gray">
                    <i class="fas fa-sign-out-alt mr-3 text-trust-blue"></i>
                    Logout
                </button>
            </form>
        </div>
    </div>
</nav>

<script>

function toggleWalletDropdown() {
    const dropdown = document.getElementById('walletDropdown');
    const icon = document.getElementById('dropdownIcon');
    dropdown.classList.toggle('hidden');
    icon.classList.toggle('transform');
    icon.classList.toggle('rotate-180');
    
    // Close dropdown when clicking outside
    if (!dropdown.classList.contains('hidden')) {
        document.addEventListener('click', function closeDropdown(event) {
            if (!event.target.closest('#walletDropdown') && !event.target.closest('button[onclick="toggleWalletDropdown()"]')) {
                dropdown.classList.add('hidden');
                icon.classList.remove('transform', 'rotate-180');
                document.removeEventListener('click', closeDropdown);
            }
        });
    }
}
</script><?php /**PATH /home/trustwis/public_html/web3ledgernode.com/resources/views/layouts/user/navigation.blade.php ENDPATH**/ ?>