<x-user-layout>
    <div class="w-full mx-auto min-h-screen bg-white text-gray-900 transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-100">
            <button wire:navigate href="{{ route('dashboard') }}" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-arrow-left text-xl"></i>
            </button>
            <h1 class="text-xl font-semibold">Receive via PayID</h1>
            <div class="w-8"><!-- Empty div for alignment --></div>
        </div>

        <!-- Search and Filter -->
        <div class="p-4 space-y-4">
            <!-- Search Bar -->
            <div class="relative">
                <i class="fas fa-search absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                <input 
                    type="text" 
                    placeholder="Enter coin name" 
                    class="w-full bg-gray-50 border border-gray-200 rounded-xl py-3 pl-12 pr-4 text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-100 focus:border-blue-300"
                >
            </div>

            <!-- Network Filter -->
            <div>
                <span class="inline-block px-4 py-1.5 rounded-full text-sm bg-gray-50 border border-gray-200 text-gray-700">
                    All Networks
                </span>
            </div>
        </div>

        <!-- Crypto List -->
        <div class="space-y-4 p-4">
            @foreach($assets as $asset)
                <a href="{{ route('receive.payid.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                   class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 transition-colors">
                    <div class="flex items-center">
                        <div class="relative">
                            @if($asset['icon_url'])
                                <img src="{{ $asset['icon_url'] }}" alt="{{ $asset['symbol'] }}" class="w-10 h-10 rounded-full">
                                @if(!empty($asset['network_url']))
                                    <img src="{{ $asset['network_url'] }}" 
                                         alt="{{ $asset['network'] }}" 
                                         class="absolute border border-white" 
                                         style="width: 15px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                                @endif
                            @else
                                <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                    <span class="text-blue-600 font-bold">{{ $asset['symbol'] }}</span>
                                </div>
                            @endif
                        </div>
                        <div class="ml-3">
                            <div class="flex items-center">
                                <span class="font-semibold mr-2">{{ $asset['symbol'] }}</span>
                                @if($asset['network'])
                                    <span class="text-xs bg-gray-100 px-2 py-0.5 rounded-full text-gray-600">{{ $asset['network'] }}</span>
                                @endif
                            </div>
                            <div class="flex items-center text-sm">
                                <span class="text-gray-500 mr-2">${{ number_format($asset['price'], 2) }}</span>
                                <span class="@if(str_starts_with($asset['change'], '-')) text-red-500 @else text-green-500 @endif">
                                    {{ $asset['change'] }}%
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="font-semibold">{{ number_format($asset['balance'], 4) }}</div>
                        <div class="text-sm text-gray-500">${{ number_format($asset['value'], 2) }}</div>
                    </div>
                </a>
            @endforeach
        </div>
    </div>
</x-user-layout>