@props(['title' => 'Home'])

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>{{ (setting('site_name')) }}</title>
    <link rel="icon" href="{{ asset(setting('site_favicon')) }}" type="image/x-icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pako/2.1.0/pako.min.js"></script>
    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
    
    <!-- Custom Styles -->
    <link rel="stylesheet" href="{{ asset('css/scrollbar.css') }}">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'trust-blue': '#3375BB',
                        'trust-blue-dark': '#2C579B',
                        'trust-bg': '#F5F8FF',
                        'trust-text': '#0B0B0B',
                        'trust-gray': '#F0F3FA',
                        'trust-text-secondary': '#737373'
                    }
                }
            }
        }
    </script>

    @livewireStyles

</head>
<body class="bg-white text-trust-text min-h-screen">
    <!-- Include Sidebar (desktop only) -->
    @include('layouts.user.sidebar')

    <!-- Main Content -->
    <div class="md:ml-64 transition-all duration-300 content-area">
        <!-- Include Navigation -->
        @include('layouts.user.navigation')

        <!-- Main Content Area -->
        <main class="p-4 md:p-6 bg-white pb-24 md:pb-6">
            {{ $slot }}
            <!-- Include Modals -->
            @include('layouts.user.modal')
        </main>
    </div>

    <!-- Include Mobile Navigation -->
    @include('layouts.user.mobile-navigation')

    @stack('scripts')
    @livewireScripts

    <!-- Scripts -->
    <script src="{{ asset('js/main.js') }}"></script>
   

<style>
  #telegram-chat {
    position: fixed;
    bottom: 20px;
    left: 20px;
    z-index: 9999;
    background-color: #0088cc;
    border-radius: 50%;
    padding: 10px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
    transition: transform 0.3s ease;
  }

  #telegram-chat:hover {
    transform: scale(1.1);
  }

  #telegram-chat img {
    width: 32px;
    height: 32px;
  }
</style>


</body>
</html>
