<aside id="sidebar" class="bg-gray-800 text-white w-64 min-h-screen p-4 fixed inset-y-0 left-0 transform -translate-x-full md:relative md:translate-x-0 transition duration-200 ease-in-out z-10">
    <div class="flex items-center justify-center space-x-2 py-5 border-b border-gray-700">
        <a href="{{ route('admin.dashboard') }}" class="flex items-center space-x-2">
            {{-- If you have an SVG logo --}}
            <svg class="w-8 h-8 text-purple-600" viewBox="0 0 24 24" fill="currentColor">
                <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"></path>
            </svg>
            <span class="text-xl font-bold text-white">Admin<span class="text-purple-500">Panel</span></span>
        </a>
    </div>
    <nav>
        <ul class="space-y-4">
            {{-- Dashboard --}}
            <li>
                <a href="{{ route('admin.dashboard') }}" 
                   class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.dashboard') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                    <i class="ri-dashboard-line text-xl"></i>
                    <span>Dashboard</span>
                </a>
            </li>

            {{-- Users Management --}}
            <li>
                <a href="{{ route('admin.users') }}" 
                   class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.users*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                    <i class="ri-user-line text-xl"></i>
                    <span>Users</span>
                </a>
            </li>

            {{-- KYC Submissions --}}
            <li>
                <a href="{{ route('admin.kyc') }}" 
                   class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.kyc*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                    <i class="ri-shield-check-line text-xl"></i>
                    <span>KYC Verification</span>
                </a>
            </li>
            <li class="space-y-2">
 <!--  <div class="px-2 text-xs text-gray-400 uppercase tracking-wider">Trading Bots</div>
   <ul class="space-y-1">
       <li>
           <a href="{{ route('admin.bots.index') }}" 
              class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.bots.*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
               <i class="ri-robot-line text-xl"></i>
               <span>Bots</span>
           </a>
       </li>
       <li>
           <a href="{{ route('admin.subscriptions.index') }}" 
              class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.subscriptions.*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
               <i class="ri-funds-box-line text-xl"></i>
               <span>Subscriptions</span>
           </a>
       </li>
       <li>
           <a href="{{ route('admin.trades.index') }}" 
              class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.trades.*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
               <i class="ri-exchange-line text-xl"></i>
               <span>Trades</span>
           </a>
       </li>
   </ul>
</li> -->

            {{-- Transactions --}}
            <li class="space-y-2">
                <div class="px-2 text-xs text-gray-400 uppercase tracking-wider">Transactions</div>
                <ul class="space-y-1">
                    <li>
                        <a href="{{ route('admin.transactions') }}" 
                           class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.transactions*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                            <i class="ri-exchange-dollar-line text-xl"></i>
                            <span>Transactions</span>
                        </a>
                    </li>
                </ul>
            </li>

            {{-- Newsletter --}}
            <li class="space-y-2">
                <div class="px-2 text-xs text-gray-400 uppercase tracking-wider">Communication</div>
                <ul class="space-y-1">
                    <li>
                        <a href="{{ route('admin.newsletter') }}" 
                           class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.newsletter*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                            <i class="ri-mail-send-line text-xl"></i>
                            <span>Send Email</span>
                        </a>
                    </li>
                </ul>
            </li>

            {{-- Settings --}}
            <li class="space-y-2">
                <div class="px-2 text-xs text-gray-400 uppercase tracking-wider">Settings</div>
                <ul class="space-y-1">
                    <li>
                        <a href="{{ route('admin.settings.general') }}" 
                           class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.settings.general*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                            <i class="ri-settings-line text-xl"></i>
                            <span>General Settings</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('admin.settings.email') }}" 
                           class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.settings.email*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                            <i class="ri-mail-settings-line text-xl"></i>
                            <span>Email Settings</span>
                        </a>
                    </li>
            <li>
            <a href="{{ route('admin.settings.wallets') }}" 
               class="flex items-center space-x-2 p-2 rounded-lg {{ request()->routeIs('admin.settings.wallets*') ? 'bg-purple-600 text-white' : 'hover:bg-gray-700' }}">
                <i class="ri-wallet-3-line text-xl"></i>
                <span>Wallet Settings</span>
            </a>
        </li>
                </ul>
            </li>
        </ul>
    </nav>
</aside>