@component('mail::message')
# Transaction {{ ucfirst($status) }}

Dear {{ $transaction->user->name }},

Your {{ $transaction->type }} transaction has been {{ $status }}.

@component('mail::panel')
**Transaction Details**
- Type: {{ ucfirst($transaction->type) }}
- Amount: {{ number_format($amount, 8) }} {{ $crypto }}
@if($transaction->type === 'swap')
- To: {{ number_format($transaction->amount_out, 8) }} {{ strtoupper($transaction->to_crypto) }}
- Rate: 1 {{ strtoupper($transaction->from_crypto) }} = {{ number_format($transaction->rate, 8) }} {{ strtoupper($transaction->to_crypto) }}
@endif
- Status: {{ ucfirst($status) }}
- Date: {{ $transaction->created_at->format('M d, Y H:i:s') }}

@if($fee)
**Network Fee:** {{ number_format($fee, 8) }} {{ $crypto }}
@endif

@if($hash)
**Transaction Hash:**  
{{ $hash }}
@endif

@if($transaction->from_address)
**From Address:**  
{{ $transaction->from_address }}
@endif

@if($transaction->to_address)
**To Address:**  
{{ $transaction->to_address }}
@endif

@if($status === 'failed' && $reason)
**Reason for Failure:**  
{{ $reason }}
@endif
@endcomponent

@if($status === 'pending')
Your transaction is being processed. You will receive another notification when it is completed.
@endif

@if($status === 'failed')
@if($transaction->type === 'withdrawal' || $transaction->type === 'deposit')
Please verify the transaction details and try again. If you need assistance, contact our support team.
@else
Our team is reviewing this issue. Please contact support if you have any questions.
@endif
@endif

If you did not initiate this transaction or notice any suspicious activity, please contact our support team immediately at {{ $supportEmail }}.

Best regards,  
{{ $companyName }} Team
@endcomponent