<?php
// reset-password.php
require 'config.php';

$token = $_GET['token'] ?? '';
$stmt = $conn->prepare("SELECT * FROM user WHERE reset_token = ? AND reset_token_expires > NOW()");
$stmt->execute([$token]);
$user = $stmt->fetch();

if (!$user) {
    die("Invalid or expired token.");
}
?>

<!DOCTYPE html>
<html>
<head><title>Set New Password</title></head>
<body>
  <h2>Set a new password</h2>
  <form method="POST" action="update-password.php">
    <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
    <label>New Password:</label><br>
    <input type="password" name="password" required><br><br>
    <button type="submit">Update Password</button>
  </form>
</body>
</html>
