<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
require 'secure/connect.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require 'PHPMailer/src/Exception.php';

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["submit"])) {
    $fullname = trim($_POST['fullname'] . ' ' . $_POST['last_name']);
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    $ref = $_SESSION['referer'] ?? 'N/A';
    $datereg = date("M-d-Y");

    if (empty($fullname) || empty($email) || empty($password)) {
        $_SESSION['reg_error'] = "Please fill in all fields.";
        header("Location: register.html");
        exit;
    }

    // Check for duplicate email
    $check = $conn->prepare("SELECT id FROM user WHERE email = ?");
    $check->bind_param("s", $email);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $_SESSION['reg_error'] = "This email is already registered.";
        header("Location: register.html");
        exit;
    }

    // Directly use plain password (no hashing)
    $stmt = $conn->prepare("INSERT INTO user(fullname, email, password, ref, datereg) VALUES (?, ?, ?, ?, ?)");
    if (!$stmt) {
        $_SESSION['reg_error'] = "Database error: " . $conn->error;
        header("Location: register.html");
        exit;
    }

    $stmt->bind_param("sssss", $fullname, $email, $password, $ref, $datereg);
    if ($stmt->execute()) {
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'www.W3ciphering.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'support@W3ciphering.com';
            $mail->Password = 'Vondasaint2025$!@@';
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom('support@W3ciphering.com', 'W3ciphering.com');
            $mail->addAddress($email, $fullname);
            $mail->isHTML(true);
            $mail->Subject = '[W3ciphering.com] Account Details';
            $mail->Body = "
                <center>
                    <img src='https://W3ciphering.com/en/logo.png'><br>
                    <h3 style='color:#000000;'>Congratulations, $fullname</h3>
                    <h5 style='color:#8B0815;'>Your account has been created successfully!</h5>
                    <h5 style='color:#8B0815;'>Welcome to W3ciphering.com. Gateway to Encrypt, back up, and secure your assets.</h5>
                </center>";

            $mail->send();
        } catch (Exception $e) {
            $_SESSION['reg_success'] = "Account created, but email failed to send.";
            header("Location: login.php");
            exit;
        }

        $_SESSION['reg_success'] = "Registration successful. Please log in.";
        header("Location: login.php");
        exit;
    } else {
        $_SESSION['reg_error'] = "Account creation failed.";
        header("Location: register.html");
        exit;
    }
}
?>
