<?php
session_start();

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (empty($email) || empty($password)) {
        $_SESSION['login_error'] = "Please enter both email and password.";
        header("Location: login.php");
        exit;
    }

    require 'connect.php';

    $stmt = $conn->prepare("SELECT * FROM user WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user_data = $result->fetch_assoc();

        // Check both plain text and hashed passwords
        if ($password === $user_data['password'] || password_verify($password, $user_data['password'])) {
            $_SESSION['email'] = $user_data['email'];
            $_SESSION['fullname'] = $user_data['fullname'];
            $_SESSION['activebal'] = $user_data['activebal'] ?? 0;
            $_SESSION['wallet'] = $user_data['wallet'] ?? '';
            $_SESSION['wallet_address'] = $user_data['wallet_address'] ?? '';
            $_SESSION['otp'] = bin2hex(openssl_random_pseudo_bytes(4));
            $_SESSION['username'] = $user_data['fullname'];
            $_SESSION['secret'] = uniqid();

            session_regenerate_id(true);
            header('Location: dashboard/index.php');
            exit;
        } else {
            $_SESSION['login_error'] = "Incorrect password.";
            header("Location: login.php");
            exit;
        }
    } else {
        $_SESSION['login_error'] = "No account found with that email.";
        header("Location: login.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html dir="ltr">


<!-- Mirrored from Quantumfinsystemss.com/login by HTTrack Website Copier/3.x [XR&CO'2014], Wed, 18 Jun 2025 10:45:29 GMT -->
<!-- Added by HTTrack --><meta http-equiv="content-type" content="text/html;charset=UTF-8" /><!-- /Added by HTTrack -->
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <meta name="author" content="Hypeople">
    <meta name="description" content="Responsive, Highly Customizable Dashboard Template" />

    <!-- Favicon -->
    <link rel="apple-touch-icon" sizes="180x180" href="app-assets/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="app-assets/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="app-assets/favicon/favicon-16x16.png">
    <link rel="manifest" href="https://yoda.hypeople.studio/yoda-admin-template/app-assets/favicon/site.webmanifest">
    <link rel="mask-icon" href="https://yoda.hypeople.studio/yoda-admin-template/app-assets/favicon/safari-pinned-tab.svg" color="#0010f7">
    <meta name="msapplication-TileColor" content="#0010f7">
    <meta name="theme-color" content="#ffffff">

    <!-- Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet" />

    <!-- Plugin -->
    <link rel="stylesheet" type="text/css" href="app-assets/css/plugin/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="app-assets/icons/iconly/index.min.css">
    <link rel="stylesheet" type="text/css" href="app-assets/icons/remix-icon/index.min.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/colors.css">

    <!-- Base -->
    <link rel="stylesheet" type="text/css" href="app-assets/css/base/typography.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/base/base.css">

    <!-- Theme -->
    <link rel="stylesheet" type="text/css" href="app-assets/css/theme/colors-dark.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/theme/theme-dark.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/custom-rtl.css">

    <!-- Layouts -->
    <link rel="stylesheet" type="text/css" href="app-assets/css/layouts/sider.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/layouts/header.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/layouts/page-content.css">
    <link rel="stylesheet" type="text/css" href="app-assets/css/components.css">

    <!-- Pages -->
    <link rel="stylesheet" type="text/css" href="app-assets/css/pages/authentication.css">

    <!-- Custom -->
    <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <title> Login</title>


    <!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet"/>

<!-- jQuery (required by Toastr) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

</head>

<body class="dark">
    <div class="row hp-authentication-page d-flex flex-column">
        <div class="position-absolute w-100 h-100" style="top: 0px; left: 0px; z-index: -1;">
            
        </div>



    <div class="px-32 flex-shrink-1 col d-flex">
        <div class="row h-100 m-auto w-100 align-items-center" style="max-width: 390px;">
            <div class="col-12">
                <h1 class="mb-0 mb-sm-24">Login</h1>
                
            <!-- Display Errors -->
            
                <form class="mt-16 mt-sm-32 mb-8" id="" action="login.php" method="post">
                    <div class="mb-16">
                        <label for="loginEmail" class="form-label">Email</label>
                        <input type="text" name="email" class="form-control" id="emailusername"
                            placeholder="Enter your email address" required>

                    </div>

                    <div class="d-none mb-16" data-step="login-step-1">
                        <label for="loginPassword" class="form-label">Password</label>
                        <input type="password" class="form-control" id="password" name="password" required
                            placeholder="Enter your password">

                    </div>

                    <div class="d-none row align-items-center justify-content-between mb-16" data-step="login-step-1">


                        <div class="col hp-flex-none w-auto">
                            <a class="hp-button text-black-80 hp-text-color-dark-40" href="auth-modern-recover.html">Forgot
                                Password?</a>
                        </div>
                    </div>

                    <button type="button" data-button-step="login-step-1" class="btn btn-primary w-100">
                        Continue
                    </button>

                    <button type="submit" name ="submit" id="submitButton" data-step="login-step-1" class="d-none btn btn-primary w-100">
                        Sign in
                    </button>
                    
                </form>

                <div class="col-12 hp-form-info text-center">
                    <span class="text-black-80 hp-text-color-dark-40 hp-caption me-4">
                        Don’t you have an account?
                    </span>
                    <a class="text-primary-1 hp-text-color-dark-primary-2 hp-caption" href="register.html">
                        Create an account
                    </a>
                    <div class="mt-3">
                        <a class="text-primary-1 hp-text-color-dark-primary-2 hp-caption" href="forget-password.php">
                            Forgot your password?
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>


    

<div class="my-48 px-24 col-12">
    <p class="hp-p1-body text-center hp-text-color-black-60 mb-8"> @Copyright 2024 Web3 </p>

    <div class="row align-items-center justify-content-center mx-n8">
        <div class="w-auto hp-flex-none px-8 col">
            <a href="javascript:;" class="hp-text-color-black-80 hp-text-color-dark-40"> Privacy Policy </a>
        </div>

        <div class="w-auto hp-flex-none px-8 col">
            <a href="javascript:;" class="hp-text-color-black-80 hp-text-color-dark-40"> Term of use </a>
        </div>
    </div>
</div>
</div>

<!-- Plugin -->
<script src="app-assets/js/plugin/jquery.min.js"></script>
<script src="app-assets/js/plugin/bootstrap.bundle.min.js"></script>
<script src="app-assets/js/plugin/swiper-bundle.min.js"></script>
<script src="app-assets/js/plugin/jquery.mask.min.js"></script>
<script src="app-assets/js/plugin/autocomplete.min.js"></script>
<script src="app-assets/js/plugin/moment.min.js"></script>

<!-- Layouts -->
<script src="app-assets/js/layouts/header-search.js"></script>
<script src="app-assets/js/layouts/sider.js"></script>
<script src="app-assets/js/components/input-number.js"></script>

<!-- Base -->
<script src="app-assets/js/base/index.js"></script>

<!-- Pages -->
<script src="app-assets/js/pages/auth.js"></script>

<!-- Custom -->
<script src="assets/js/main.js"></script>

<!-- Smartsupp Live Chat script -->



<!-- Mirrored from Quantumfinsystemss.com/login by HTTrack Website Copier/3.x [XR&CO'2014], Wed, 18 Jun 2025 10:45:35 GMT -->
</html>
