<?php
session_start();
require '../secure/connect.php';

$data = json_decode(file_get_contents('php://input'), true);
$from = $data['fromCoin'];
$to = $data['toCoin'];
$amount = (float)$data['amount'];
$user = $_SESSION['email'];

// Fetch wallets
$stmt = $conn->prepare("SELECT * FROM wallets WHERE email=? AND label=?");
$stmt->execute([$user, $from]);
$fromWallet = $stmt->fetch(PDO::FETCH_ASSOC);

$stmt = $conn->prepare("SELECT * FROM wallets WHERE email=? AND id=?");
$stmt->execute([$user, $to]);
$toWallet = $stmt->fetch(PDO::FETCH_ASSOC);

// Validate
if(!$fromWallet || $fromWallet['value'] < $amount){
    echo json_encode(['success'=>false, 'error'=>'Insufficient balance']);
    exit;
}

// Swap calculation
$fromRate = safeRate($fromWallet['id'], $rates);
$toRate = safeRate($toWallet['id'], $rates);
$toAmount = ($amount * $fromRate)/$toRate;

// Update balances
$conn->beginTransaction();
$conn->prepare("UPDATE wallets SET value=value-? WHERE id=?")->execute([$amount, $fromWallet['id']]);
$conn->prepare("UPDATE wallets SET value=value+? WHERE id=?")->execute([$toAmount, $toWallet['id']]);
$conn->commit();

echo json_encode(['success'=>true]);
?>
