<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require '../connect.php';

if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit;
}

$message = "";
$email = $_SESSION['email'];

/* ---------------------------------------------------
   FETCH CURRENT PROFILE PHOTO FOR DISPLAY
-----------------------------------------------------*/
$stmt = $conn->prepare("SELECT profile_photo FROM user WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($profilePhoto);
$stmt->fetch();
$stmt->close();

// Default profile image
$photoPath = "public/dist/images/default-avatar.png";

// If user has uploaded a photo, show it
if (!empty($profilePhoto)) {
    $photoPath = "../uploads/profile/" . $profilePhoto;
}

/* ---------------------------------------------------
   PROFILE PHOTO UPLOAD HANDLER
-----------------------------------------------------*/
if (isset($_POST['upload_profile'])) {

    if (isset($_FILES['profile_photo']) && $_FILES['profile_photo']['error'] === 0) {

        $fileTmpPath = $_FILES['profile_photo']['tmp_name'];
        $fileName = $_FILES['profile_photo']['name'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));

        $allowedExtensions = ['jpeg','jpg','png','bmp','gif','svg'];

        if (in_array($fileExtension, $allowedExtensions)) {

            // Create unique file name
            $newFileName = $email . "_profile_" . time() . "." . $fileExtension;

            // Upload folder
            $uploadDir = "../uploads/profile/";
            if (!file_exists($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $dest_path = $uploadDir . $newFileName;

            if (move_uploaded_file($fileTmpPath, $dest_path)) {

                // Save new file in DB
                $stmt = $conn->prepare("UPDATE user SET profile_photo = ? WHERE email = ?");
                $stmt->bind_param("ss", $newFileName, $email);
                $stmt->execute();
                $stmt->close();

                // For immediate display
                $_SESSION['profile_photo'] = $newFileName;

                // Update displayed path
                $photoPath = "../uploads/profile/" . $newFileName;

                $message = "Profile image updated successfully!";
            } else {
                $message = "Error uploading file. Try again.";
            }
        } else {
            $message = "Only jpeg, jpg, png, bmp, gif, svg formats are allowed.";
        }
    } else {
        $message = "No file selected or upload error.";
    }
}

/* ---------------------------------------------------
   PASSWORD CHANGE HANDLER  (UNCHANGED)
-----------------------------------------------------*/
if (isset($_POST['change_password'])) {

    $old_password = $_POST['old_password'];
    $new_password = $_POST['password'];
    $confirm_password = $_POST['password_confirmation'];

    if ($new_password !== $confirm_password) {
        $message = "New password and confirmation do not match.";

    } elseif (strlen($new_password) < 6) {
        $message = "Password must be at least 6 characters long.";

    } else {
        $stmt = $conn->prepare("SELECT password FROM user WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->bind_result($current_password);
        $stmt->fetch();
        $stmt->close();

        if (!$current_password) {
            $message = "User not found.";

        } elseif ($old_password !== $current_password) {
            $message = "Old password is incorrect.";

        } else {
            $update = $conn->prepare("UPDATE user SET password = ? WHERE email = ?");
            $update->bind_param("ss", $new_password, $email);

            if ($update->execute()) {
                $message = "Password changed successfully.";
            } else {
                $message = "Failed to update password. Try again.";
            }

            $update->close();
        }
    }
}
?>




<html lang="en"><head><style type="text/css">.swal-icon--error{border-color:#f27474;-webkit-animation:animateErrorIcon .5s;animation:animateErrorIcon .5s}.swal-icon--error__x-mark{position:relative;display:block;-webkit-animation:animateXMark .5s;animation:animateXMark .5s}.swal-icon--error__line{position:absolute;height:5px;width:47px;background-color:#f27474;display:block;top:37px;border-radius:2px}.swal-icon--error__line--left{-webkit-transform:rotate(45deg);transform:rotate(45deg);left:17px}.swal-icon--error__line--right{-webkit-transform:rotate(-45deg);transform:rotate(-45deg);right:16px}@-webkit-keyframes animateErrorIcon{0%{-webkit-transform:rotateX(100deg);transform:rotateX(100deg);opacity:0}to{-webkit-transform:rotateX(0deg);transform:rotateX(0deg);opacity:1}}@keyframes animateErrorIcon{0%{-webkit-transform:rotateX(100deg);transform:rotateX(100deg);opacity:0}to{-webkit-transform:rotateX(0deg);transform:rotateX(0deg);opacity:1}}@-webkit-keyframes animateXMark{0%{-webkit-transform:scale(.4);transform:scale(.4);margin-top:26px;opacity:0}50%{-webkit-transform:scale(.4);transform:scale(.4);margin-top:26px;opacity:0}80%{-webkit-transform:scale(1.15);transform:scale(1.15);margin-top:-6px}to{-webkit-transform:scale(1);transform:scale(1);margin-top:0;opacity:1}}@keyframes animateXMark{0%{-webkit-transform:scale(.4);transform:scale(.4);margin-top:26px;opacity:0}50%{-webkit-transform:scale(.4);transform:scale(.4);margin-top:26px;opacity:0}80%{-webkit-transform:scale(1.15);transform:scale(1.15);margin-top:-6px}to{-webkit-transform:scale(1);transform:scale(1);margin-top:0;opacity:1}}.swal-icon--warning{border-color:#f8bb86;-webkit-animation:pulseWarning .75s infinite alternate;animation:pulseWarning .75s infinite alternate}.swal-icon--warning__body{width:5px;height:47px;top:10px;border-radius:2px;margin-left:-2px}.swal-icon--warning__body,.swal-icon--warning__dot{position:absolute;left:50%;background-color:#f8bb86}.swal-icon--warning__dot{width:7px;height:7px;border-radius:50%;margin-left:-4px;bottom:-11px}@-webkit-keyframes pulseWarning{0%{border-color:#f8d486}to{border-color:#f8bb86}}@keyframes pulseWarning{0%{border-color:#f8d486}to{border-color:#f8bb86}}.swal-icon--success{border-color:#a5dc86}.swal-icon--success:after,.swal-icon--success:before{content:"";border-radius:50%;position:absolute;width:60px;height:120px;background:#fff;-webkit-transform:rotate(45deg);transform:rotate(45deg)}.swal-icon--success:before{border-radius:120px 0 0 120px;top:-7px;left:-33px;-webkit-transform:rotate(-45deg);transform:rotate(-45deg);-webkit-transform-origin:60px 60px;transform-origin:60px 60px}.swal-icon--success:after{border-radius:0 120px 120px 0;top:-11px;left:30px;-webkit-transform:rotate(-45deg);transform:rotate(-45deg);-webkit-transform-origin:0 60px;transform-origin:0 60px;-webkit-animation:rotatePlaceholder 4.25s ease-in;animation:rotatePlaceholder 4.25s ease-in}.swal-icon--success__ring{width:80px;height:80px;border:4px solid hsla(98,55%,69%,.2);border-radius:50%;box-sizing:content-box;position:absolute;left:-4px;top:-4px;z-index:2}.swal-icon--success__hide-corners{width:5px;height:90px;background-color:#fff;padding:1px;position:absolute;left:28px;top:8px;z-index:1;-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}.swal-icon--success__line{height:5px;background-color:#a5dc86;display:block;border-radius:2px;position:absolute;z-index:2}.swal-icon--success__line--tip{width:25px;left:14px;top:46px;-webkit-transform:rotate(45deg);transform:rotate(45deg);-webkit-animation:animateSuccessTip .75s;animation:animateSuccessTip .75s}.swal-icon--success__line--long{width:47px;right:8px;top:38px;-webkit-transform:rotate(-45deg);transform:rotate(-45deg);-webkit-animation:animateSuccessLong .75s;animation:animateSuccessLong .75s}@-webkit-keyframes rotatePlaceholder{0%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}5%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}12%{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}to{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}}@keyframes rotatePlaceholder{0%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}5%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}12%{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}to{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}}@-webkit-keyframes animateSuccessTip{0%{width:0;left:1px;top:19px}54%{width:0;left:1px;top:19px}70%{width:50px;left:-8px;top:37px}84%{width:17px;left:21px;top:48px}to{width:25px;left:14px;top:45px}}@keyframes animateSuccessTip{0%{width:0;left:1px;top:19px}54%{width:0;left:1px;top:19px}70%{width:50px;left:-8px;top:37px}84%{width:17px;left:21px;top:48px}to{width:25px;left:14px;top:45px}}@-webkit-keyframes animateSuccessLong{0%{width:0;right:46px;top:54px}65%{width:0;right:46px;top:54px}84%{width:55px;right:0;top:35px}to{width:47px;right:8px;top:38px}}@keyframes animateSuccessLong{0%{width:0;right:46px;top:54px}65%{width:0;right:46px;top:54px}84%{width:55px;right:0;top:35px}to{width:47px;right:8px;top:38px}}.swal-icon--info{border-color:#c9dae1}.swal-icon--info:before{width:5px;height:29px;bottom:17px;border-radius:2px;margin-left:-2px}.swal-icon--info:after,.swal-icon--info:before{content:"";position:absolute;left:50%;background-color:#c9dae1}.swal-icon--info:after{width:7px;height:7px;border-radius:50%;margin-left:-3px;top:19px}.swal-icon{width:80px;height:80px;border-width:4px;border-style:solid;border-radius:50%;padding:0;position:relative;box-sizing:content-box;margin:20px auto}.swal-icon:first-child{margin-top:32px}.swal-icon--custom{width:auto;height:auto;max-width:100%;border:none;border-radius:0}.swal-icon img{max-width:100%;max-height:100%}.swal-title{color:rgba(0,0,0,.65);font-weight:600;text-transform:none;position:relative;display:block;padding:13px 16px;font-size:27px;line-height:normal;text-align:center;margin-bottom:0}.swal-title:first-child{margin-top:26px}.swal-title:not(:first-child){padding-bottom:0}.swal-title:not(:last-child){margin-bottom:13px}.swal-text{font-size:16px;position:relative;float:none;line-height:normal;vertical-align:top;text-align:left;display:inline-block;margin:0;padding:0 10px;font-weight:400;color:rgba(0,0,0,.64);max-width:calc(100% - 20px);overflow-wrap:break-word;box-sizing:border-box}.swal-text:first-child{margin-top:45px}.swal-text:last-child{margin-bottom:45px}.swal-footer{text-align:right;padding-top:13px;margin-top:13px;padding:13px 16px;border-radius:inherit;border-top-left-radius:0;border-top-right-radius:0}.swal-button-container{margin:5px;display:inline-block;position:relative}.swal-button{background-color:#7cd1f9;color:#fff;border:none;box-shadow:none;border-radius:5px;font-weight:600;font-size:14px;padding:10px 24px;margin:0;cursor:pointer}.swal-button:not([disabled]):hover{background-color:#78cbf2}.swal-button:active{background-color:#70bce0}.swal-button:focus{outline:none;box-shadow:0 0 0 1px #fff,0 0 0 3px rgba(43,114,165,.29)}.swal-button[disabled]{opacity:.5;cursor:default}.swal-button::-moz-focus-inner{border:0}.swal-button--cancel{color:#555;background-color:#efefef}.swal-button--cancel:not([disabled]):hover{background-color:#e8e8e8}.swal-button--cancel:active{background-color:#d7d7d7}.swal-button--cancel:focus{box-shadow:0 0 0 1px #fff,0 0 0 3px rgba(116,136,150,.29)}.swal-button--danger{background-color:#e64942}.swal-button--danger:not([disabled]):hover{background-color:#df4740}.swal-button--danger:active{background-color:#cf423b}.swal-button--danger:focus{box-shadow:0 0 0 1px #fff,0 0 0 3px rgba(165,43,43,.29)}.swal-content{padding:0 20px;margin-top:20px;font-size:medium}.swal-content:last-child{margin-bottom:20px}.swal-content__input,.swal-content__textarea{-webkit-appearance:none;background-color:#fff;border:none;font-size:14px;display:block;box-sizing:border-box;width:100%;border:1px solid rgba(0,0,0,.14);padding:10px 13px;border-radius:2px;transition:border-color .2s}.swal-content__input:focus,.swal-content__textarea:focus{outline:none;border-color:#6db8ff}.swal-content__textarea{resize:vertical}.swal-button--loading{color:transparent}.swal-button--loading~.swal-button__loader{opacity:1}.swal-button__loader{position:absolute;height:auto;width:43px;z-index:2;left:50%;top:50%;-webkit-transform:translateX(-50%) translateY(-50%);transform:translateX(-50%) translateY(-50%);text-align:center;pointer-events:none;opacity:0}.swal-button__loader div{display:inline-block;float:none;vertical-align:baseline;width:9px;height:9px;padding:0;border:none;margin:2px;opacity:.4;border-radius:7px;background-color:hsla(0,0%,100%,.9);transition:background .2s;-webkit-animation:swal-loading-anim 1s infinite;animation:swal-loading-anim 1s infinite}.swal-button__loader div:nth-child(3n+2){-webkit-animation-delay:.15s;animation-delay:.15s}.swal-button__loader div:nth-child(3n+3){-webkit-animation-delay:.3s;animation-delay:.3s}@-webkit-keyframes swal-loading-anim{0%{opacity:.4}20%{opacity:.4}50%{opacity:1}to{opacity:.4}}@keyframes swal-loading-anim{0%{opacity:.4}20%{opacity:.4}50%{opacity:1}to{opacity:.4}}.swal-overlay{position:fixed;top:0;bottom:0;left:0;right:0;text-align:center;font-size:0;overflow-y:auto;background-color:rgba(0,0,0,.4);z-index:10000;pointer-events:none;opacity:0;transition:opacity .3s}.swal-overlay:before{content:" ";display:inline-block;vertical-align:middle;height:100%}.swal-overlay--show-modal{opacity:1;pointer-events:auto}.swal-overlay--show-modal .swal-modal{opacity:1;pointer-events:auto;box-sizing:border-box;-webkit-animation:showSweetAlert .3s;animation:showSweetAlert .3s;will-change:transform}.swal-modal{width:478px;opacity:0;pointer-events:none;background-color:#fff;text-align:center;border-radius:5px;position:static;margin:20px auto;display:inline-block;vertical-align:middle;-webkit-transform:scale(1);transform:scale(1);-webkit-transform-origin:50% 50%;transform-origin:50% 50%;z-index:10001;transition:opacity .2s,-webkit-transform .3s;transition:transform .3s,opacity .2s;transition:transform .3s,opacity .2s,-webkit-transform .3s}@media (max-width:500px){.swal-modal{width:calc(100% - 20px)}}@-webkit-keyframes showSweetAlert{0%{-webkit-transform:scale(1);transform:scale(1)}1%{-webkit-transform:scale(.5);transform:scale(.5)}45%{-webkit-transform:scale(1.05);transform:scale(1.05)}80%{-webkit-transform:scale(.95);transform:scale(.95)}to{-webkit-transform:scale(1);transform:scale(1)}}@keyframes showSweetAlert{0%{-webkit-transform:scale(1);transform:scale(1)}1%{-webkit-transform:scale(.5);transform:scale(.5)}45%{-webkit-transform:scale(1.05);transform:scale(1.05)}80%{-webkit-transform:scale(.95);transform:scale(.95)}to{-webkit-transform:scale(1);transform:scale(1)}}</style>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="twoone.tech">
    <meta name="csrf-token" content="AWO37hEyyaFjyNu7gt4uBj6e66n0lDGYYU2YPoWc">

    <title>User Profile |  Web3</title>

    <!-- css -->
    <link rel="stylesheet" href="public/dist/libraries/bootstrap-5.0.2/css/bootstrap.min.css">
<link rel="stylesheet" href="public/dist/plugins/select2-4.1.0-rc.0/css/select2.min.css">
    <link rel="stylesheet" href="public/dist/plugins/intl-tel-input-17.0.19/css/intlTelInput.min.css">
<link rel="stylesheet" href="public/user/templates/css/style.min.css">
    <!-- end css -->
    
    <!-- favicon -->
    <link rel="shortcut icon" href="public/uploads/logos/1698017319_favicon.PNG">

    <script>
      'use strict';
      var SITE_URL = "https://Quantumsecurenova.com";
      var FIATDP = "0.00";
      var CRYPTODP = "0.00000000";

      if (localStorage.getItem('dark') === '1') {
        document.documentElement.classList.add('dark');
      }

      if (localStorage.getItem('lang') == 'ar') {
        document.getElementsByTagName("html")[0].setAttribute("dir", "rtl");
        document.querySelector("html").setAttribute("dir", "rtl");
      } else {
        document.querySelector("html").removeAttribute("dir", "rtl");
      }
    </script>
  </head>
  <body>

    <!-- sidebar section -->
    <!-- Sidebar Start -->
<div class="side-navbar active-nav d-flex justify-content-between flex-wrap flex-column" id="sidebar">
    <div class="bg-secondary vh-100 position-fixed d-flex flex-column w-inherit drop-parent">
        <div>
            <a href="https://Quantumsecurenova.com"><img class="ml-40 mt-20 pay-logo img-fluid" src="public/uploads/logos/1698017319_logo.png" alt="Web3"></a>
        </div>
        <div class="flex-grow-1 px-4 px-res mt-43 bg-secondary position-relative overflow-auto hide-thin-scrollbar thin-scrollbar">
            <ul class="list-unstyled ps-0 accordion accordion-flush position-absolute w-268" id="accordion-menu">

                <!-- Dashboard -->
                <li>
                    <a href="index.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.8611 13.8016H4.98016C4.7202 13.8016 4.4709 13.9049 4.28708 14.0887C4.10327 14.2725 4 14.5218 4 14.7817V20.6627C4 20.9227 4.10327 21.172 4.28708 21.3558C4.4709 21.5396 4.7202 21.6429 4.98016 21.6429H10.8611C11.1211 21.6429 11.3704 21.5396 11.5542 21.3558C11.738 21.172 11.8413 20.9227 11.8413 20.6627V14.7817C11.8413 14.5218 11.738 14.2725 11.5542 14.0887C11.3704 13.9049 11.1211 13.8016 10.8611 13.8016ZM9.88095 19.6825H5.96032V15.7619H9.88095V19.6825ZM20.6627 4H14.7817C14.5218 4 14.2725 4.10327 14.0887 4.28708C13.9049 4.4709 13.8016 4.7202 13.8016 4.98016V10.8611C13.8016 11.1211 13.9049 11.3704 14.0887 11.5542C14.2725 11.738 14.5218 11.8413 14.7817 11.8413H20.6627C20.9227 11.8413 21.172 11.738 21.3558 11.5542C21.5396 11.3704 21.6429 11.1211 21.6429 10.8611V4.98016C21.6429 4.7202 21.5396 4.4709 21.3558 4.28708C21.172 4.10327 20.9227 4 20.6627 4ZM19.6825 9.88095H15.7619V5.96032H19.6825V9.88095ZM20.6627 16.7421H18.7024V14.7817C18.7024 14.5218 18.5991 14.2725 18.4153 14.0887C18.2315 13.9049 17.9822 13.8016 17.7222 13.8016C17.4623 13.8016 17.213 13.9049 17.0291 14.0887C16.8453 14.2725 16.7421 14.5218 16.7421 14.7817V16.7421H14.7817C14.5218 16.7421 14.2725 16.8453 14.0887 17.0291C13.9049 17.213 13.8016 17.4623 13.8016 17.7222C13.8016 17.9822 13.9049 18.2315 14.0887 18.4153C14.2725 18.5991 14.5218 18.7024 14.7817 18.7024H16.7421V20.6627C16.7421 20.9227 16.8453 21.172 17.0291 21.3558C17.213 21.5396 17.4623 21.6429 17.7222 21.6429C17.9822 21.6429 18.2315 21.5396 18.4153 21.3558C18.5991 21.172 18.7024 20.9227 18.7024 20.6627V18.7024H20.6627C20.9227 18.7024 21.172 18.5991 21.3558 18.4153C21.5396 18.2315 21.6429 17.9822 21.6429 17.7222C21.6429 17.4623 21.5396 17.213 21.3558 17.0291C21.172 16.8453 20.9227 16.7421 20.6627 16.7421ZM10.8611 4H4.98016C4.7202 4 4.4709 4.10327 4.28708 4.28708C4.10327 4.4709 4 4.7202 4 4.98016V10.8611C4 11.1211 4.10327 11.3704 4.28708 11.5542C4.4709 11.738 4.7202 11.8413 4.98016 11.8413H10.8611C11.1211 11.8413 11.3704 11.738 11.5542 11.5542C11.738 11.3704 11.8413 11.1211 11.8413 10.8611V4.98016C11.8413 4.7202 11.738 4.4709 11.5542 4.28708C11.3704 4.10327 11.1211 4 10.8611 4ZM9.88095 9.88095H5.96032V5.96032H9.88095V9.88095Z" fill="#C1BFDF"></path>
                            </svg></span>
                        <span>Dashboard</span>
                    </a>
                </li>

                <!-- Wallets -->
                <li>
                    <a href="wallet.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.44369 5.6875L16.9313 5.6875C17.3596 5.68749 17.7291 5.68748 18.0335 5.71234C18.3547 5.73859 18.6742 5.79653 18.9816 5.95317C19.4402 6.18687 19.8131 6.55976 20.0468 7.0184C20.2035 7.32583 20.2614 7.64532 20.2877 7.96654C20.3125 8.27088 20.3125 8.64037 20.3125 9.06867V10.2956C21.1151 10.5791 21.7213 11.2668 21.8907 12.1182C21.938 12.3562 21.9378 12.6225 21.9375 12.9319C21.9375 12.9543 21.9375 12.9771 21.9375 13C21.9375 13.023 21.9375 13.0457 21.9375 13.0682C21.9378 13.3775 21.938 13.6438 21.8907 13.8818C21.7213 14.7332 21.1151 15.4209 20.3125 15.7044V16.9313C20.3125 17.3596 20.3125 17.7291 20.2877 18.0335C20.2614 18.3547 20.2035 18.6742 20.0468 18.9816C19.8131 19.4402 19.4402 19.8131 18.9816 20.0468C18.6742 20.2035 18.3547 20.2614 18.0335 20.2877C17.7291 20.3125 17.3596 20.3125 16.9313 20.3125L7.44367 20.3125C7.01537 20.3125 6.64588 20.3125 6.34154 20.2877C6.02032 20.2614 5.70083 20.2035 5.3934 20.0468C4.93475 19.8131 4.56186 19.4402 4.32817 18.9816C4.17153 18.6742 4.11358 18.3547 4.08734 18.0335C4.06247 17.7291 4.06249 17.3596 4.0625 16.9313V9.06868C4.06249 8.64038 4.06247 8.27088 4.08734 7.96654C4.11358 7.64532 4.17153 7.32583 4.32817 7.0184C4.56186 6.55975 4.93475 6.18686 5.3934 5.95317C5.70083 5.79653 6.02032 5.73858 6.34154 5.71234C6.64588 5.68747 7.01538 5.68749 7.44369 5.6875ZM18.6875 15.8438H17.4688C17.4458 15.8438 17.4231 15.8438 17.4006 15.8438C17.0913 15.844 16.8249 15.8442 16.587 15.7969C15.62 15.6046 14.8642 14.8487 14.6718 13.8818C14.6245 13.6438 14.6247 13.3775 14.625 13.0682C14.625 13.0457 14.625 13.023 14.625 13C14.625 12.9771 14.625 12.9543 14.625 12.9318C14.6247 12.6225 14.6245 12.3562 14.6718 12.1182C14.8642 11.1513 15.62 10.3954 16.587 10.2031C16.8249 10.1558 17.0913 10.156 17.4006 10.1562C17.4231 10.1562 17.4458 10.1563 17.4688 10.1563H18.6875V9.1C18.6875 8.63155 18.6869 8.32908 18.6681 8.09887C18.65 7.87814 18.6194 7.79631 18.5989 7.75613C18.521 7.60325 18.3968 7.47896 18.2439 7.40106C18.2037 7.38059 18.1219 7.34998 17.9011 7.33194C17.6709 7.31313 17.3684 7.3125 16.9 7.3125H7.475C7.00655 7.3125 6.70408 7.31313 6.47387 7.33194C6.25314 7.34998 6.17131 7.38059 6.13113 7.40106C5.97825 7.47896 5.85396 7.60325 5.77606 7.75613C5.75559 7.79631 5.72498 7.87814 5.70694 8.09887C5.68813 8.32908 5.6875 8.63155 5.6875 9.1V16.9C5.6875 17.3685 5.68813 17.6709 5.70694 17.9011C5.72498 18.1219 5.75559 18.2037 5.77606 18.2439C5.85396 18.3967 5.97825 18.521 6.13113 18.5989C6.17131 18.6194 6.25314 18.65 6.47387 18.6681C6.70408 18.6869 7.00655 18.6875 7.475 18.6875L16.9 18.6875C17.3685 18.6875 17.6709 18.6869 17.9011 18.6681C18.1219 18.65 18.2037 18.6194 18.2439 18.5989C18.3968 18.521 18.521 18.3967 18.5989 18.2439C18.6194 18.2037 18.65 18.1219 18.6681 17.9011C18.6869 17.6709 18.6875 17.3685 18.6875 16.9V15.8438ZM17.4688 11.7813C17.0523 11.7813 16.9627 11.7852 16.904 11.7969C16.5817 11.861 16.3297 12.1129 16.2656 12.4352C16.2539 12.4939 16.25 12.5835 16.25 13C16.25 13.4165 16.2539 13.5061 16.2656 13.5648C16.3297 13.8871 16.5817 14.139 16.904 14.2031C16.9627 14.2148 17.0523 14.2188 17.4688 14.2188H19.0938C19.5102 14.2188 19.5998 14.2148 19.6585 14.2031C19.9808 14.139 20.2328 13.8871 20.2969 13.5648C20.3086 13.5061 20.3125 13.4165 20.3125 13C20.3125 12.5835 20.3086 12.4939 20.2969 12.4352C20.2328 12.1129 19.9808 11.861 19.6585 11.7969C19.5998 11.7852 19.5102 11.7813 19.0938 11.7813H17.4688Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Wallets</span>
                    </a>
                </li>
                <!-- Cards -->
               
                <li class="mb-21 d-flex align-items-center res-trans text-warning f-13 ml-20 mt-39 gilroy-Semibold text-uppercase">Transactions</li>

                <!-- Transactions -->
                <li>
                    <a href="transactions.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M19.5 4.875H11.375C10.7285 4.875 10.1085 5.13181 9.65143 5.58893C9.19431 6.04605 8.9375 6.66603 8.9375 7.3125V13C8.9375 13.6465 9.19431 14.2665 9.65143 14.7236C10.1085 15.1807 10.7285 15.4375 11.375 15.4375H19.5C20.1465 15.4375 20.7665 15.1807 21.2236 14.7236C21.6807 14.2665 21.9375 13.6465 21.9375 13V7.3125C21.9375 6.66603 21.6807 6.04605 21.2236 5.58893C20.7665 5.13181 20.1465 4.875 19.5 4.875ZM20.3125 13C20.3125 13.2155 20.2269 13.4222 20.0745 13.5745C19.9222 13.7269 19.7155 13.8125 19.5 13.8125H11.375C11.1595 13.8125 10.9528 13.7269 10.8005 13.5745C10.6481 13.4222 10.5625 13.2155 10.5625 13V7.3125C10.5625 7.09701 10.6481 6.89035 10.8005 6.73798C10.9528 6.5856 11.1595 6.5 11.375 6.5H19.5C19.7155 6.5 19.9222 6.5856 20.0745 6.73798C20.2269 6.89035 20.3125 7.09701 20.3125 7.3125V13ZM17.4688 9.75C17.168 9.75102 16.8783 9.86398 16.6562 10.0669C16.4815 9.90807 16.2645 9.80344 16.0314 9.76568C15.7983 9.72793 15.5593 9.75868 15.3434 9.85421C15.1275 9.94973 14.944 10.1059 14.8152 10.3038C14.6863 10.5016 14.6178 10.7327 14.6178 10.9688C14.6178 11.2048 14.6863 11.4359 14.8152 11.6337C14.944 11.8316 15.1275 11.9878 15.3434 12.0833C15.5593 12.1788 15.7983 12.2096 16.0314 12.1718C16.2645 12.1341 16.4815 12.0294 16.6562 11.8706C16.803 12.004 16.98 12.0995 17.172 12.149C17.364 12.1984 17.5652 12.2003 17.7581 12.1544C17.951 12.1085 18.1297 12.0162 18.2789 11.8856C18.4281 11.755 18.5431 11.5899 18.614 11.4048C18.685 11.2196 18.7097 11.02 18.686 10.8231C18.6623 10.6263 18.5909 10.4382 18.4781 10.2751C18.3653 10.1121 18.2144 9.97906 18.0385 9.88755C17.8626 9.79604 17.667 9.74883 17.4688 9.75ZM16.25 17.0625C16.0345 17.0625 15.8278 17.1481 15.6755 17.3005C15.5231 17.4528 15.4375 17.6595 15.4375 17.875V18.6875C15.4375 18.903 15.3519 19.1097 15.1995 19.262C15.0472 19.4144 14.8405 19.5 14.625 19.5H6.5C6.28451 19.5 6.07785 19.4144 5.92548 19.262C5.7731 19.1097 5.6875 18.903 5.6875 18.6875V15.4375H6.5C6.71549 15.4375 6.92215 15.3519 7.07452 15.1995C7.2269 15.0472 7.3125 14.8405 7.3125 14.625C7.3125 14.4095 7.2269 14.2028 7.07452 14.0505C6.92215 13.8981 6.71549 13.8125 6.5 13.8125H5.6875V13C5.6875 12.7845 5.7731 12.5778 5.92548 12.4255C6.07785 12.2731 6.28451 12.1875 6.5 12.1875C6.71549 12.1875 6.92215 12.1019 7.07452 11.9495C7.2269 11.7972 7.3125 11.5905 7.3125 11.375C7.3125 11.1595 7.2269 10.9528 7.07452 10.8005C6.92215 10.6481 6.71549 10.5625 6.5 10.5625C5.85353 10.5625 5.23355 10.8193 4.77643 11.2764C4.31931 11.7335 4.0625 12.3535 4.0625 13V18.6875C4.0625 19.334 4.31931 19.954 4.77643 20.4111C5.23355 20.8682 5.85353 21.125 6.5 21.125H14.625C15.2715 21.125 15.8915 20.8682 16.3486 20.4111C16.8057 19.954 17.0625 19.334 17.0625 18.6875V17.875C17.0625 17.6595 16.9769 17.4528 16.8245 17.3005C16.6722 17.1481 16.4655 17.0625 16.25 17.0625ZM8.125 17.875H8.9375C9.15299 17.875 9.35965 17.7894 9.51202 17.637C9.6644 17.4847 9.75 17.278 9.75 17.0625C9.75 16.847 9.6644 16.6403 9.51202 16.488C9.35965 16.3356 9.15299 16.25 8.9375 16.25H8.125C7.90951 16.25 7.70285 16.3356 7.55048 16.488C7.3981 16.6403 7.3125 16.847 7.3125 17.0625C7.3125 17.278 7.3981 17.4847 7.55048 17.637C7.70285 17.7894 7.90951 17.875 8.125 17.875Z" fill="#C1BFDF"></path>
                            </svg></span>
                        <span>Transactions</span>
                    </a>
                </li>

                <!-- Deposit Money -->
                                <li>
                    <a href="depositmoney.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 5H18.5952C19.0265 4.99999 19.3986 4.99997 19.705 5.02548C20.0285 5.05239 20.3502 5.11182 20.6598 5.27249C21.1216 5.51217 21.4971 5.89462 21.7325 6.36503C21.8902 6.68034 21.9486 7.00802 21.975 7.33748C22 7.64962 22 8.02858 22 8.46786V11.6667C22 12.1269 21.6337 12.5 21.1818 12.5C20.7299 12.5 20.3636 12.1269 20.3636 11.6667V10.8333H5.63637V14.8333C5.63637 15.3138 5.637 15.624 5.65594 15.8601C5.6741 16.0865 5.70493 16.1705 5.72554 16.2117C5.80398 16.3685 5.92915 16.4959 6.0831 16.5758C6.12355 16.5968 6.20596 16.6282 6.42823 16.6467C6.66005 16.666 6.96464 16.6667 7.43636 16.6667H13C13.4519 16.6667 13.8182 17.0398 13.8182 17.5C13.8182 17.9602 13.4519 18.3333 13 18.3333H7.40485C6.97354 18.3333 6.60145 18.3334 6.29498 18.3079C5.97151 18.2809 5.64979 18.2215 5.34021 18.0608C4.87835 17.8212 4.50286 17.4387 4.26753 16.9683C4.10979 16.653 4.05144 16.3253 4.02501 15.9959C3.99997 15.6837 3.99999 15.3047 4 14.8655V8.46788C3.99999 8.02859 3.99997 7.64962 4.02501 7.33748C4.05144 7.00802 4.10979 6.68034 4.26753 6.36503C4.50286 5.89462 4.87835 5.51217 5.34021 5.27249C5.64979 5.11182 5.97151 5.05239 6.29498 5.02548C6.60145 4.99997 6.97353 4.99999 7.40483 5ZM5.63637 9.16667H20.3636V8.5C20.3636 8.01954 20.363 7.70931 20.3441 7.4732C20.3259 7.24681 20.2951 7.16288 20.2745 7.12168C20.196 6.96488 20.0709 6.83739 19.9169 6.7575C19.8764 6.7365 19.794 6.7051 19.5718 6.68661C19.3399 6.66732 19.0354 6.66667 18.5636 6.66667H7.43637C6.96464 6.66667 6.66005 6.66732 6.42823 6.68661C6.20596 6.7051 6.12355 6.7365 6.0831 6.7575C5.92915 6.83739 5.80398 6.96487 5.72554 7.12168C5.70493 7.16288 5.6741 7.24681 5.65594 7.4732C5.637 7.70931 5.63637 8.01954 5.63637 8.5V9.16667ZM18.7273 13.3333C19.1791 13.3333 19.5455 13.7064 19.5455 14.1667V17.1548L20.6033 16.0774C20.9228 15.752 21.4408 15.752 21.7604 16.0774C22.0799 16.4028 22.0799 16.9305 21.7604 17.2559L19.3058 19.7559C18.9863 20.0814 18.4683 20.0814 18.1487 19.7559L15.6942 17.2559C15.3747 16.9305 15.3747 16.4028 15.6942 16.0774C16.0137 15.752 16.5317 15.752 16.8513 16.0774L17.9091 17.1548V14.1667C17.9091 13.7064 18.2754 13.3333 18.7273 13.3333Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Deposit Money</span>
                    </a>
                </li>
                
                

                 
                <!-- Send Money -->
                                <li>
                    <a href="sendmoney.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M5.46393 5.03937C5.31364 5.10324 5.107 5.30989 5.04688 5.46393C4.93041 5.74197 4.94168 5.78706 6.16653 9.46536L7.34254 12.9896L6.16277 16.5252C5.05815 19.8465 4.98677 20.072 5.0018 20.2786C5.03185 20.6882 5.3174 20.9587 5.74572 20.985L5.9937 21L13.3203 17.3367C18.5541 14.7217 20.6844 13.6359 20.7746 13.5495C20.9361 13.3879 21 13.2263 21 12.9896C21 12.7529 20.9361 12.5914 20.7746 12.4298C20.6844 12.3434 18.5541 11.2613 13.3278 8.64629C6.13272 5.05064 6.00497 4.98677 5.79081 4.98677C5.67434 4.99053 5.52405 5.01307 5.46393 5.03937ZM12.7905 10.1792C15.8601 11.7159 18.37 12.9784 18.37 12.9896C18.37 13.0159 7.20728 18.5954 7.18849 18.5766C7.18098 18.5691 7.53416 17.4908 7.97375 16.1795L8.77028 13.7974L11.0284 13.7786L13.2864 13.7599L13.433 13.6584C13.5119 13.6021 13.6208 13.4931 13.6734 13.4142C13.7523 13.2977 13.7674 13.2338 13.7674 12.9896C13.7674 12.7379 13.7561 12.6853 13.6659 12.5538C13.6096 12.4749 13.5006 12.3659 13.4217 12.3133L13.2827 12.2194L11.0284 12.2006L8.77028 12.1818L7.97375 9.81478C7.53791 8.51103 7.17722 7.43647 7.17722 7.41768C7.17346 7.40266 7.18098 7.39138 7.19225 7.39138C7.20352 7.39138 9.72085 8.64629 12.7905 10.1792Z" fill="#C1BFDF"></path>
                            </svg></span>
                        <span>Send Money</span>
                    </a>
                </li>
                
                <!-- Request Money -->
                                <li>
                    <a href="wallets.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M18.2894 15.5699V9.74756C18.2853 8.44269 17.4143 6.5 15.0313 6.5V4.875L11.7813 7.3125L15.0313 9.75V8.125C16.5173 8.125 16.6571 9.37544 16.6644 9.75V15.5699C15.4944 15.9226 14.6331 16.9975 14.6331 18.2812C14.6331 19.8494 15.9088 21.125 17.4769 21.125C19.045 21.125 20.3206 19.8494 20.3206 18.2812C20.3206 16.9975 19.4594 15.9226 18.2894 15.5699V15.5699ZM17.4769 19.5C16.8049 19.5 16.2581 18.9532 16.2581 18.2812C16.2581 17.6093 16.8049 17.0625 17.4769 17.0625C18.1488 17.0625 18.6956 17.6093 18.6956 18.2812C18.6956 18.9532 18.1488 19.5 17.4769 19.5ZM10.5625 7.71875C10.5625 6.15063 9.28688 4.875 7.71875 4.875C6.15063 4.875 4.875 6.15063 4.875 7.71875C4.875 9.0025 5.73625 10.0774 6.90625 10.4301V15.5699C5.73625 15.9226 4.875 16.9975 4.875 18.2812C4.875 19.8494 6.15063 21.125 7.71875 21.125C9.28688 21.125 10.5625 19.8494 10.5625 18.2812C10.5625 16.9975 9.70125 15.9226 8.53125 15.5699V10.4301C9.70125 10.0774 10.5625 9.0025 10.5625 7.71875ZM6.5 7.71875C6.5 7.04681 7.04681 6.5 7.71875 6.5C8.39069 6.5 8.9375 7.04681 8.9375 7.71875C8.9375 8.39069 8.39069 8.9375 7.71875 8.9375C7.04681 8.9375 6.5 8.39069 6.5 7.71875ZM8.9375 18.2812C8.9375 18.9532 8.39069 19.5 7.71875 19.5C7.04681 19.5 6.5 18.9532 6.5 18.2812C6.5 17.6093 7.04681 17.0625 7.71875 17.0625C8.39069 17.0625 8.9375 17.6093 8.9375 18.2812Z" fill="#C1BFDF"></path>
                                </svg></span>
                        <span>Link Wallet</span>
                    </a>
                </li>
                
                <!-- Exchange Money -->
                                <li>
                    <a href="https://lobstr.co/buy-xlm/" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.7231 12.2688C12.2769 11.7894 11.5781 11.4887 11.5781 10.725C11.5781 9.89625 12.48 9.59562 13.0488 9.59562C14.1131 9.59562 14.5031 10.4 14.5925 10.6844L15.8762 10.14C15.7544 9.77437 15.21 8.58 13.8125 8.32V7.3125H12.1875V8.33625C10.1725 8.79125 10.1644 10.66 10.1644 10.7413C10.1644 12.5856 11.9925 13.1056 12.8862 13.4306C14.17 13.8856 14.7388 14.3 14.7388 15.08C14.7388 15.9981 13.8856 16.3881 13.13 16.3881C11.6512 16.3881 11.2288 14.8687 11.18 14.69L9.83125 15.2344C10.3431 17.0138 11.6837 17.4931 12.1875 17.6394V18.6875H13.8125V17.68C14.1375 17.6069 16.1687 17.2006 16.1687 15.0637C16.1687 13.9344 15.6731 12.9431 13.7231 12.2688V12.2688ZM5.6875 20.3125H4.0625V15.4375H8.9375V17.0625H6.9225C8.23062 19.0206 10.465 20.3125 13 20.3125C14.9394 20.3125 16.7994 19.5421 18.1707 18.1707C19.5421 16.7994 20.3125 14.9394 20.3125 13H21.9375C21.9375 17.94 17.94 21.9375 13 21.9375C9.9775 21.9375 7.30438 20.4344 5.6875 18.1431V20.3125ZM4.0625 13C4.0625 8.06 8.06 4.0625 13 4.0625C16.0225 4.0625 18.6956 5.56563 20.3125 7.85688V5.6875H21.9375V10.5625H17.0625V8.9375H19.0775C17.7694 6.97937 15.535 5.6875 13 5.6875C11.0606 5.6875 9.20064 6.45792 7.82928 7.82928C6.45792 9.20064 5.6875 11.0606 5.6875 13H4.0625Z" fill="#C1BFDF"></path>
                                </svg></span>
                        <span>Buy ISO Assets</span>
                    </a>
                </li>
                
                <!-- Withdraw Money -->
                                <li class="accordion-item bg-secondary border-0">
                    <div class="accordion-header " id="flush-headtwo">
                        <button class="mb-1 shadow-none bg-transparent p-0 d-flex align-items-center list-option h-46 accordion-button accordion-icon collapsed text-info-100" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 6H18.5952C19.0265 5.99999 19.3986 5.99997 19.705 6.02548C20.0285 6.05239 20.3502 6.11182 20.6598 6.27249C21.1216 6.51217 21.4971 6.89462 21.7325 7.36503C21.8902 7.68034 21.9486 8.00802 21.975 8.33748C22 8.64962 22 9.02858 22 9.46786V12.6667C22 13.1269 21.6337 13.5 21.1818 13.5C20.7299 13.5 20.3636 13.1269 20.3636 12.6667V11.8333H5.63637V15.8333C5.63637 16.3138 5.637 16.624 5.65594 16.8601C5.6741 17.0865 5.70493 17.1705 5.72554 17.2117C5.80398 17.3685 5.92915 17.4959 6.0831 17.5758C6.12355 17.5968 6.20596 17.6282 6.42823 17.6467C6.66005 17.666 6.96464 17.6667 7.43636 17.6667H13C13.4519 17.6667 13.8182 18.0398 13.8182 18.5C13.8182 18.9602 13.4519 19.3333 13 19.3333H7.40485C6.97354 19.3333 6.60145 19.3334 6.29498 19.3079C5.97151 19.2809 5.64979 19.2215 5.34021 19.0608C4.87835 18.8212 4.50286 18.4387 4.26753 17.9683C4.10979 17.653 4.05144 17.3253 4.02501 16.9959C3.99997 16.6837 3.99999 16.3047 4 15.8655V9.46788C3.99999 9.02859 3.99997 8.64962 4.02501 8.33748C4.05144 8.00802 4.10979 7.68034 4.26753 7.36503C4.50286 6.89462 4.87835 6.51217 5.34021 6.27249C5.64979 6.11182 5.97151 6.05239 6.29498 6.02548C6.60145 5.99997 6.97353 5.99999 7.40483 6ZM5.63637 10.1667H20.3636V9.5C20.3636 9.01954 20.363 8.70931 20.3441 8.4732C20.3259 8.24681 20.2951 8.16288 20.2745 8.12168C20.196 7.96488 20.0709 7.83739 19.9169 7.7575C19.8764 7.7365 19.794 7.7051 19.5718 7.68661C19.3399 7.66732 19.0354 7.66667 18.5636 7.66667H7.43637C6.96464 7.66667 6.66005 7.66732 6.42823 7.68661C6.20596 7.7051 6.12355 7.7365 6.0831 7.7575C5.92915 7.83739 5.80398 7.96487 5.72554 8.12168C5.70493 8.16288 5.6741 8.24681 5.65594 8.4732C5.637 8.70931 5.63637 9.01954 5.63637 9.5V10.1667ZM18.1487 14.5774C18.4683 14.252 18.9863 14.252 19.3058 14.5774L21.7604 17.0774C22.0799 17.4028 22.0799 17.9305 21.7604 18.2559C21.4408 18.5814 20.9228 18.5814 20.6033 18.2559L19.5455 17.1785V20.1667C19.5455 20.6269 19.1791 21 18.7273 21C18.2754 21 17.9091 20.6269 17.9091 20.1667V17.1785L16.8513 18.2559C16.5317 18.5814 16.0137 18.5814 15.6942 18.2559C15.3747 17.9305 15.3747 17.4028 15.6942 17.0774L18.1487 14.5774Z" fill="#C1BFDF"></path>
                            </svg></span>
                            <span class="child-currency">Withdrawals</span>
                        </button>
                    </div>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse " aria-labelledby="flush-headtwo" data-bs-parent="#accordion-menu">
                        <ul class="accordion-body collapse-child ml-28 p-0 pl-16 mr-20">

                            <!-- Withdraw Money -->
                            <li><a href="withdraw.php" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 text-info-100">Withdraw Money</a></li>
                            
                            <!-- Withdraw List -->
                            <li><a href="withdrawlist.php" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 text-info-100">Withdrawal List</a></li>

                            <!-- Withdraw Settings -->
                            <
                        </ul>
                    </div>
                </li>
                
                <!-- Merchant Payments -->
                
                <li class="mb-20 d-flex align-items-center text-warning f-13 ml-20 mt-38 gilroy-Semibold res-other text-uppercase">Others</li>

                <!-- Dispute -->
                <li>
                    <a href="dispute.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16.375 5C16.806 5 17.2193 5.1712 17.524 5.47595C17.8288 5.7807 18 6.19402 18 6.625H6.625V15.7063C6.19402 15.7063 5.7807 15.5351 5.47595 15.2304C5.1712 14.9256 5 14.5123 5 14.0813V6.625C5 6.19402 5.1712 5.7807 5.47595 5.47595C5.7807 5.1712 6.19402 5 6.625 5H16.375Z" fill="#C1BFDF"></path>
                            <path d="M14.75 21.25L12.5831 18.9563H9.875C9.44402 18.9563 9.0307 18.7851 8.72595 18.4804C8.4212 18.1756 8.25 17.7623 8.25 17.3313V9.875C8.25 9.44402 8.4212 9.0307 8.72595 8.72595C9.0307 8.4212 9.44402 8.25 9.875 8.25H19.625C20.056 8.25 20.4693 8.4212 20.774 8.72595C21.0788 9.0307 21.25 9.44402 21.25 9.875V17.3313C21.25 17.7623 21.0788 18.1756 20.774 18.4804C20.4693 18.7851 20.056 18.9563 19.625 18.9563H16.9169L14.75 21.25ZM16.2166 17.3313H19.625V9.875H9.875V17.3313H13.2834L14.75 18.8832L16.2166 17.3313Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Disputes</span>
                    </a>
                </li>

                <!-- Tickets -->
                <li>
                    <a href="ticket.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.21567 6H18.7843C19.1917 5.99999 19.5431 5.99997 19.8325 6.02378C20.138 6.0489 20.4419 6.10437 20.7343 6.25432C21.1704 6.47802 21.5251 6.83498 21.7473 7.27402C21.8963 7.56832 21.9514 7.87416 21.9764 8.18165C22 8.47298 22 8.82667 22 9.23667V10.2778C22 10.7073 21.654 11.0556 21.2273 11.0556C20.1604 11.0556 19.2955 11.9261 19.2955 13C19.2955 14.0739 20.1604 14.9444 21.2273 14.9444C21.654 14.9444 22 15.2927 22 15.7222V16.7633C22 17.1733 22 17.527 21.9764 17.8184C21.9514 18.1258 21.8963 18.4317 21.7473 18.726C21.5251 19.165 21.1704 19.522 20.7343 19.7457C20.4419 19.8956 20.138 19.9511 19.8325 19.9762C19.5431 20 19.1917 20 18.7843 20H8.21565C7.80832 20 7.45692 20 7.16748 19.9762C6.86199 19.9511 6.55813 19.8956 6.26575 19.7457C5.82956 19.522 5.47492 19.165 5.25267 18.726C5.10369 18.4317 5.04858 18.1258 5.02362 17.8184C4.99997 17.527 4.99999 17.1733 5 16.7633L5 15.7222C5 15.2927 5.34596 14.9444 5.77273 14.9444C6.83964 14.9444 7.70455 14.0739 7.70455 13C7.70455 11.9261 6.83964 11.0556 5.77273 11.0556C5.34596 11.0556 5 10.7073 5 10.2778L5 9.23669C4.99999 8.82668 4.99997 8.47298 5.02362 8.18165C5.04858 7.87416 5.10369 7.56832 5.25267 7.27402C5.47492 6.83498 5.82956 6.47802 6.26575 6.25432C6.55813 6.10437 6.86199 6.0489 7.16748 6.02378C7.45692 5.99997 7.80833 5.99999 8.21567 6ZM7.29333 7.57417C7.08341 7.59143 7.00558 7.62074 6.96737 7.64033C6.82197 7.7149 6.70376 7.83388 6.62968 7.98023C6.61021 8.01869 6.5811 8.09702 6.56395 8.30832C6.54606 8.52869 6.54546 8.81824 6.54546 9.26667V9.58673C8.09399 9.94041 9.25 11.3343 9.25 13C9.25 14.6657 8.09399 16.0596 6.54546 16.4133V16.7333C6.54546 17.1818 6.54606 17.4713 6.56395 17.6917C6.5811 17.903 6.61021 17.9813 6.62968 18.0198C6.70376 18.1661 6.82197 18.2851 6.96737 18.3597C7.00558 18.3793 7.08341 18.4086 7.29333 18.4258C7.51227 18.4438 7.79994 18.4444 8.24546 18.4444H18.7545C19.2001 18.4444 19.4877 18.4438 19.7067 18.4258C19.9166 18.4086 19.9944 18.3793 20.0326 18.3597C20.178 18.2851 20.2962 18.1661 20.3703 18.0198C20.3898 17.9813 20.4189 17.903 20.4361 17.6917C20.4539 17.4713 20.4545 17.1818 20.4545 16.7333V16.4133C18.906 16.0596 17.75 14.6657 17.75 13C17.75 11.3343 18.906 9.94041 20.4545 9.58673V9.26667C20.4545 8.81824 20.4539 8.52869 20.4361 8.30832C20.4189 8.09702 20.3898 8.01869 20.3703 7.98023C20.2962 7.83388 20.178 7.7149 20.0326 7.64033C19.9944 7.62074 19.9166 7.59143 19.7067 7.57417C19.4877 7.55616 19.2001 7.55556 18.7545 7.55556H8.24546C7.79994 7.55556 7.51227 7.55616 7.29333 7.57417ZM11.9545 8.33333C12.3813 8.33333 12.7273 8.68156 12.7273 9.11111V9.88889C12.7273 10.3184 12.3813 10.6667 11.9545 10.6667C11.5278 10.6667 11.1818 10.3184 11.1818 9.88889V9.11111C11.1818 8.68156 11.5278 8.33333 11.9545 8.33333ZM11.9545 11.8333C12.3813 11.8333 12.7273 12.1816 12.7273 12.6111V13.3889C12.7273 13.8184 12.3813 14.1667 11.9545 14.1667C11.5278 14.1667 11.1818 13.8184 11.1818 13.3889V12.6111C11.1818 12.1816 11.5278 11.8333 11.9545 11.8333ZM11.9545 15.3333C12.3813 15.3333 12.7273 15.6816 12.7273 16.1111V16.8889C12.7273 17.3184 12.3813 17.6667 11.9545 17.6667C11.5278 17.6667 11.1818 17.3184 11.1818 16.8889V16.1111C11.1818 15.6816 11.5278 15.3333 11.9545 15.3333Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Tickets</span>
                    </a>
                </li>

                <!-- Profile -->
                <li>
                    <a href="profile.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-white bg-info">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0001 6.33366C11.3892 6.33366 10.0834 7.63949 10.0834 9.25033C10.0834 10.8612 11.3892 12.167 13.0001 12.167C14.6109 12.167 15.9167 10.8612 15.9167 9.25033C15.9167 7.63949 14.6109 6.33366 13.0001 6.33366ZM8.41674 9.25033C8.41674 6.71902 10.4688 4.66699 13.0001 4.66699C15.5314 4.66699 17.5834 6.71902 17.5834 9.25033C17.5834 11.7816 15.5314 13.8337 13.0001 13.8337C10.4688 13.8337 8.41674 11.7816 8.41674 9.25033ZM10.772 15.0836C10.8195 15.0836 10.8678 15.0837 10.9167 15.0837H15.0834C15.1324 15.0837 15.1806 15.0836 15.2282 15.0836C16.2509 15.0832 16.9493 15.083 17.5429 15.2631C18.8746 15.667 19.9167 16.7091 20.3207 18.0408C20.5007 18.6345 20.5005 19.3328 20.5001 20.3555C20.5001 20.4031 20.5001 20.4513 20.5001 20.5003C20.5001 20.9606 20.127 21.3337 19.6667 21.3337C19.2065 21.3337 18.8334 20.9606 18.8334 20.5003C18.8334 19.2767 18.8244 18.8497 18.7258 18.5246C18.4834 17.7256 17.8581 17.1003 17.0591 16.858C16.7341 16.7594 16.307 16.7503 15.0834 16.7503H10.9167C9.69314 16.7503 9.26608 16.7594 8.94102 16.858C8.14202 17.1003 7.51676 17.7256 7.27439 18.5246C7.17578 18.8497 7.16674 19.2767 7.16674 20.5003C7.16674 20.9606 6.79364 21.3337 6.3334 21.3337C5.87317 21.3337 5.50007 20.9606 5.50007 20.5003C5.50007 20.4514 5.50005 20.4031 5.50003 20.3555C5.49966 19.3328 5.4994 18.6345 5.67949 18.0408C6.08344 16.7091 7.12554 15.667 8.45721 15.2631C9.05088 15.083 9.74923 15.0832 10.772 15.0836Z" fill="#FFAF30"></path>
                        </svg></span>
                        <span>Profile</span>
                    </a>
                </li>

                <!-- Verifications -->
                  <!-- kyc -->
                <li>
                    <a href="kyc.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0001 6.33366C11.3892 6.33366 10.0834 7.63949 10.0834 9.25033C10.0834 10.8612 11.3892 12.167 13.0001 12.167C14.6109 12.167 15.9167 10.8612 15.9167 9.25033C15.9167 7.63949 14.6109 6.33366 13.0001 6.33366ZM8.41674 9.25033C8.41674 6.71902 10.4688 4.66699 13.0001 4.66699C15.5314 4.66699 17.5834 6.71902 17.5834 9.25033C17.5834 11.7816 15.5314 13.8337 13.0001 13.8337C10.4688 13.8337 8.41674 11.7816 8.41674 9.25033ZM10.772 15.0836C10.8195 15.0836 10.8678 15.0837 10.9167 15.0837H15.0834C15.1324 15.0837 15.1806 15.0836 15.2282 15.0836C16.2509 15.0832 16.9493 15.083 17.5429 15.2631C18.8746 15.667 19.9167 16.7091 20.3207 18.0408C20.5007 18.6345 20.5005 19.3328 20.5001 20.3555C20.5001 20.4031 20.5001 20.4513 20.5001 20.5003C20.5001 20.9606 20.127 21.3337 19.6667 21.3337C19.2065 21.3337 18.8334 20.9606 18.8334 20.5003C18.8334 19.2767 18.8244 18.8497 18.7258 18.5246C18.4834 17.7256 17.8581 17.1003 17.0591 16.858C16.7341 16.7594 16.307 16.7503 15.0834 16.7503H10.9167C9.69314 16.7503 9.26608 16.7594 8.94102 16.858C8.14202 17.1003 7.51676 17.7256 7.27439 18.5246C7.17578 18.8497 7.16674 19.2767 7.16674 20.5003C7.16674 20.9606 6.79364 21.3337 6.3334 21.3337C5.87317 21.3337 5.50007 20.9606 5.50007 20.5003C5.50007 20.4514 5.50005 20.4031 5.50003 20.3555C5.49966 19.3328 5.4994 18.6345 5.67949 18.0408C6.08344 16.7091 7.12554 15.667 8.45721 15.2631C9.05088 15.083 9.74923 15.0832 10.772 15.0836Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>KYC Verrification</span>
                    </a>
                    
                </li>


                <!-- Custom Addons Header Menu -->
                        
                                                                                                                                            <!-- Custom Addons Header Menu End-->
            </ul>
        </div>
    </div>
</div>

<!-- Sidebar End -->
    <!-- end sidebar section -->

    <div class="my-container active-cont bg-white-50">

        <!-- header section -->
        <nav class="navbar navbar sticky-top top-navbar bg-white p-0">
    <a class="btn border-0 menu-svg" id="menu-btn">
        <svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M1 7H19M1 1H19M1 13H13" stroke="" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
        </svg>
    </a>
    
    <div class="border-b-DF d-flex align-items-center w-100 h-70">
        <div class="input-group flex-nowrap search-fill">
            
        </div>

        <div class="color-parent form-check form-switch d-flex mr-33">
            <div class="switch d-flex align-items-center justify-content-center">
                
                <span class="moon-rtl">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"></path>
                </svg>
                </span>
                <div class="mx-10" id="switch">
                    <input class="form-check-input theme-check m-0" type="checkbox" id="flexSwitchCheckDefault">
                </div>
                <span class="moon-ltr">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"></path>
                </svg>
                </span>
            </div>
        </div>

        <div class="notification-drop p-0 d-flex align-items-center">
            <div class="item">
                <div class="d-flex align-items-center">
                    <div class="d-flex align-items-center justify-content-center user-dp">
    <img src="<?php echo $photoPath; ?>" alt="Profile" class="img-fluid" style="width:50px; height:40px; object-fit:cover; border-radius:50%;">
</div>

                    <div class="ml-12 d-flex align-items-center h-78 w-134">
                        <p class="mb-0 f-14 text-dark gilroy-Semibold"><?php echo $_SESSION['username']; ?></p>
                        <span class="ml-13">
                            <svg width="9" height="5" viewBox="0 0 9 5" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M0.401158 0.234532C0.639812 -0.00412146 1.02675 -0.00412146 1.2654 0.234532L4.49995 3.46908L7.73449 0.234532C7.97315 -0.00412146 8.36008 -0.00412146 8.59873 0.234532C8.83739 0.473186 8.83739 0.86012 8.59873 1.09877L4.93207 4.76544C4.69341 5.00409 4.30648 5.00409 4.06783 4.76544L0.401158 1.09877C0.162505 0.86012 0.162505 0.473186 0.401158 0.234532Z" fill="#3F405B"></path>
                            </svg>
                        </span>
                    </div>
                </div>
                <ul class="open-notify open-drop bg-white">
                    <li class="d-flex align-items-center bg-secondary h-78 px-3">
                      <div class="d-flex align-items-center justify-content-center user-dp">
    <img src="<?php echo $photoPath; ?>" alt="Profile" class="img-fluid" style="width:50px; height:40px; object-fit:cover; border-radius:50%;">
</div>

                        <div class="ms-3 text-white">
                            <p class="mb-0 f-15 gilroy-medium text-white"><?php echo $_SESSION['username']; ?></p>
                            <p class="mb-0 f-13 mt-3p gilroy-regular text-info-100"><?php echo $_SESSION['email']; ?></p>
                        </div>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="profile.php" class="f-13 gilroy-medium">
                            <svg width="15" height="17" viewBox="0 0 15 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 1.7C5.88918 1.7 4.58336 3.03195 4.58336 4.675C4.58336 6.31805 5.88918 7.65 7.5 7.65C9.11082 7.65 10.4166 6.31805 10.4166 4.675C10.4166 3.03195 9.11082 1.7 7.5 1.7ZM2.91671 4.675C2.91671 2.09307 4.96872 0 7.5 0C10.0313 0 12.0833 2.09307 12.0833 4.675C12.0833 7.25693 10.0313 9.35 7.5 9.35C4.96872 9.35 2.91671 7.25693 2.91671 4.675ZM5.27191 10.625C5.31946 10.625 5.36771 10.625 5.41669 10.625H9.58331C9.63229 10.625 9.68054 10.625 9.72809 10.625C10.7508 10.6246 11.4491 10.6243 12.0428 10.808C13.3745 11.22 14.4166 12.283 14.8205 13.6413C15.0006 14.2468 15.0003 14.9591 15 16.0023C14.9999 16.0508 14.9999 16.1 14.9999 16.15C14.9999 16.6194 14.6268 17 14.1666 17C13.7064 17 13.3333 16.6194 13.3333 16.15C13.3333 14.9019 13.3242 14.4663 13.2256 14.1348C12.9833 13.3198 12.358 12.682 11.559 12.4348C11.234 12.3342 10.8069 12.325 9.58331 12.325H5.41669C4.1931 12.325 3.76604 12.3342 3.44099 12.4348C2.642 12.682 2.01674 13.3198 1.77437 14.1348C1.67577 14.4663 1.66672 14.9019 1.66672 16.15C1.66672 16.6194 1.29363 17 0.833395 17C0.373162 17 6.93952e-05 16.6194 6.93952e-05 16.15C6.93952e-05 16.1 5.1514e-05 16.0508 3.39308e-05 16.0023C-0.000344456 14.9591 -0.000602846 14.2468 0.179484 13.6413C0.583439 12.283 1.62553 11.22 2.95719 10.808C3.55085 10.6243 4.24919 10.6246 5.27191 10.625Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">View Profile</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="wallet.php" class="f-13 gilroy-medium">
                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.21566 6.68974e-07L12.2388 8.54411e-07C12.6462 -1.2497e-05 12.9976 -2.3901e-05 13.287 0.0237793C13.5925 0.0489025 13.8964 0.10437 14.1887 0.254321C14.6249 0.478026 14.9796 0.83498 15.2018 1.27403C15.3508 1.56832 15.4059 1.87416 15.4309 2.18165C15.4545 2.47298 15.4545 2.82668 15.4545 3.23667V4.41114C16.2177 4.68253 16.7943 5.34089 16.9554 6.1559C17.0004 6.38368 17.0002 6.63866 17 6.93477C17 6.95629 16.9999 6.97803 16.9999 7C16.9999 7.02197 17 7.04372 17 7.06526C17.0002 7.36135 17.0004 7.61633 16.9554 7.8441C16.7943 8.65911 16.2177 9.31748 15.4545 9.58886V10.7633C15.4545 11.1733 15.4545 11.527 15.4309 11.8184C15.4059 12.1258 15.3508 12.4317 15.2018 12.726C14.9796 13.165 14.6249 13.522 14.1887 13.7457C13.8964 13.8956 13.5925 13.9511 13.287 13.9762C12.9976 14 12.6462 14 12.2388 14L3.21564 14C2.80831 14 2.45691 14 2.16747 13.9762C1.86198 13.9511 1.55813 13.8956 1.26575 13.7457C0.829554 13.522 0.474918 13.165 0.252667 12.726C0.10369 12.4317 0.0485829 12.1258 0.0236231 11.8184C-2.51275e-05 11.527 -1.31528e-05 11.1733 6.64628e-07 10.7633V3.23669C-1.31528e-05 2.82668 -2.51275e-05 2.47298 0.0236232 2.18165C0.048583 1.87416 0.103691 1.56832 0.252667 1.27402C0.474918 0.834979 0.829554 0.478024 1.26575 0.25432C1.55813 0.104369 1.86198 0.0489007 2.16747 0.0237777C2.45691 -2.52918e-05 2.80832 -1.32388e-05 3.21566 6.68974e-07ZM13.909 9.72222H12.7499C12.7281 9.72222 12.7065 9.72224 12.6851 9.72226C12.391 9.72249 12.1376 9.7227 11.9113 9.67739C10.9917 9.49327 10.2729 8.76971 10.09 7.8441C10.0449 7.61632 10.0451 7.36134 10.0454 7.06525C10.0454 7.04372 10.0454 7.02197 10.0454 7C10.0454 6.97803 10.0454 6.95628 10.0454 6.93476C10.0451 6.63866 10.0449 6.38368 10.09 6.1559C10.2729 5.23029 10.9917 4.50673 11.9113 4.32261C12.1376 4.27731 12.391 4.27751 12.6851 4.27774C12.7065 4.27776 12.7281 4.27778 12.75 4.27778H13.909V3.26667C13.909 2.81824 13.9084 2.52869 13.8905 2.30832C13.8734 2.09703 13.8443 2.01869 13.8248 1.98023C13.7507 1.83388 13.6325 1.7149 13.4871 1.64033C13.4489 1.62074 13.3711 1.59143 13.1612 1.57417C12.9422 1.55616 12.6546 1.55556 12.209 1.55556H3.24544C2.79993 1.55556 2.51226 1.55616 2.29332 1.57417C2.0834 1.59143 2.00557 1.62074 1.96736 1.64033C1.82197 1.7149 1.70376 1.83388 1.62967 1.98023C1.6102 2.01869 1.58109 2.09702 1.56394 2.30832C1.54605 2.52869 1.54545 2.81824 1.54545 3.26667V10.7333C1.54545 11.1818 1.54605 11.4713 1.56394 11.6917C1.58109 11.903 1.6102 11.9813 1.62967 12.0198C1.70376 12.1661 1.82197 12.2851 1.96736 12.3597C2.00557 12.3793 2.0834 12.4086 2.29332 12.4258C2.51226 12.4438 2.79993 12.4444 3.24544 12.4444L12.209 12.4444C12.6546 12.4444 12.9422 12.4438 13.1612 12.4258C13.3711 12.4086 13.4489 12.3793 13.4871 12.3597C13.6325 12.2851 13.7507 12.1661 13.8248 12.0198C13.8443 11.9813 13.8734 11.903 13.8905 11.6917C13.9084 11.4713 13.909 11.1818 13.909 10.7333V9.72222ZM12.75 5.83333C12.3539 5.83333 12.2687 5.8371 12.2128 5.84828C11.9063 5.90965 11.6667 6.15084 11.6057 6.45937C11.5946 6.51557 11.5909 6.60132 11.5909 7C11.5909 7.39868 11.5946 7.48443 11.6057 7.54063C11.6667 7.84916 11.9063 8.09035 12.2128 8.15172C12.2687 8.1629 12.3539 8.16667 12.7499 8.16667H14.2954C14.6915 8.16667 14.7767 8.1629 14.8325 8.15172C15.139 8.09035 15.3787 7.84916 15.4396 7.54063C15.4507 7.48443 15.4545 7.39868 15.4545 7C15.4545 6.60132 15.4507 6.51557 15.4396 6.45937C15.3787 6.15084 15.139 5.90965 14.8325 5.84828C14.7767 5.8371 14.6915 5.83333 14.2954 5.83333H12.75Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Check Wallet</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="profile.php" class="f-13 gilroy-medium">
                            <svg width="17" height="15" viewBox="0 0 17 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.03788 0H1.82273V6.25H3.03788V0ZM10.4503 6.25H6.56183L6.07577 5.5625V4.3125L6.56183 3.75H10.4503L10.9364 4.375V5.625L10.4503 6.25ZM4.37455 10H0.486061L0 9.375V8.125L0.486061 7.5H4.37455L4.86061 8.125V9.375L4.37455 10ZM9.11365 0H7.8985V2.5H9.11365V0ZM7.8985 7.5H9.11365V15H7.8985V7.5ZM3.03788 11.25H1.82273V15H3.03788V11.25ZM12.6376 11.25H16.5139L17 10.625V9.4375L16.5139 8.8125H12.6376L12.1515 9.4375V10.625L12.6376 11.25ZM15.1894 0H13.9743V7.5H15.1894V0ZM13.9743 12.5H15.1894V15H13.9743V12.5Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Settings</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center border-top h-63">
                        <a href="logout.php" class="f-13 gilroy-medium">
                            <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.03109 3.01904e-07L4.9 6.3569e-07C5.2866 6.3569e-07 5.6 0.313401 5.6 0.700001C5.6 1.0866 5.2866 1.4 4.9 1.4H4.06C3.4604 1.4 3.05279 1.40054 2.73773 1.42629C2.43084 1.45136 2.27389 1.49681 2.16441 1.55259C1.90099 1.68681 1.68681 1.90099 1.55259 2.16441C1.49681 2.27389 1.45136 2.43084 1.42629 2.73773C1.40054 3.05279 1.4 3.46039 1.4 4.06V9.94C1.4 10.5396 1.40054 10.9472 1.42629 11.2623C1.45136 11.5692 1.49681 11.7261 1.55259 11.8356C1.68681 12.099 1.90099 12.3132 2.16441 12.4474C2.27389 12.5032 2.43084 12.5486 2.73773 12.5737C3.05279 12.5995 3.46039 12.6 4.06 12.6H4.9C5.2866 12.6 5.6 12.9134 5.6 13.3C5.6 13.6866 5.2866 14 4.9 14H4.03107C3.4676 14 3.00256 14 2.62372 13.9691C2.23025 13.9369 1.86856 13.8679 1.52883 13.6948C1.00197 13.4264 0.573628 12.998 0.305183 12.4712C0.132079 12.1314 0.0630838 11.7697 0.0309362 11.3763C-1.59696e-05 10.9974 -8.62687e-06 10.5324 3.01904e-07 9.96891V4.03109C-8.62687e-06 3.46761 -1.59696e-05 3.00256 0.0309363 2.62372C0.063084 2.23025 0.132079 1.86856 0.305183 1.52883C0.573629 1.00197 1.00197 0.573628 1.52883 0.305182C1.86856 0.132079 2.23025 0.0630838 2.62372 0.0309362C3.00256 -1.59696e-05 3.46761 -8.62687e-06 4.03109 3.01904e-07ZM9.30503 3.00503C9.57839 2.73166 10.0216 2.73166 10.295 3.00503L13.795 6.50503C14.0683 6.77839 14.0683 7.22161 13.795 7.49497L10.295 10.995C10.0216 11.2683 9.57839 11.2683 9.30503 10.995C9.03166 10.7216 9.03166 10.2784 9.30503 10.005L11.61 7.7H4.9C4.5134 7.7 4.2 7.3866 4.2 7C4.2 6.6134 4.5134 6.3 4.9 6.3H11.61L9.30503 3.99497C9.03166 3.72161 9.03166 3.27839 9.30503 3.00503Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Logout</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>        <!-- end header section -->

      <div class="position-relative">
        <div class="containt-parent">
          <div class="main-containt">
            
            <!-- main-containt -->
            <div class="text-center">
    <p class="mb-0 gilroy-Semibold f-26 text-dark theme-tran r-f-20 text-uppercase">Your Profile</p>
    <p class="mb-0 gilroy-medium text-gray-100 f-16 r-f-12 profile-header mt-2 tran-title">You have full control to manage your own account setting</p>
</div>
<div class="row" id="profileUpdate">
   <!-- PROFILE PHOTO UPLOAD SECTION -->
<form method="post" enctype="multipart/form-data">
    <div class="avatar-left-div <div class="modal-body modal-body-pxy">
                                    
                                </div>
        <div class="d-flex justify-content-between">

            <div class="left-avatar-desc">
                <p class="mb-0 f-20 leading-25 gilroy-Semibold text-dark">
                    <?php echo $_SESSION['username']; ?>
                </p>

                <p class="mb-0 f-14 leading-22 gilroy-medium text-gray-100 mt-8">
                    Please set your profile image.
                </p>

                <p class="mb-0 f-12 leading-18 gilroy-medium fst-italic text-gray mt-3p">
                    Supported format: jpeg, png, bmp, gif, svg
                </p>

                <div class="d-flex mt-26 align-items-center justify-content-between">

                    <div class="camera">
                        <!-- FILE INPUT -->
                        <input accept="image/jpeg,image/jpg,image/png,image/bmp,image/gif,image/svg"
                               class="form-control" 
                               name="profile_photo" 
                               type="file" 
                               id="uploadPhotoInput"
                               required>

                        <!-- SUBMIT BUTTON -->
                        <button type="submit" name="upload_profile" class="bg-primary green-btn" id="changeProfile">
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                 <path fill-rule="evenodd" clip-rule="evenodd"
                                       d="M7.1683 0.750003C7.1741 0.750004 7.17995 0.750006 7.18586 0.750006L10.8317 0.750003C10.9144 0.749983 10.9863 0.749965 11.0549 0.754121C11.9225 0.806667 12.6823 1.35427 13.0065 2.16076C13.0321 2.22455 13.0549 2.29277 13.081 2.3712L13.0865 2.38783C13.1213 2.49221 13.1289 2.5138 13.1353 2.52975C13.2433 2.79858 13.4966 2.98112 13.7858 2.99863C13.8028 2.99966 13.8282 3.00001 13.9458 3.00001C13.96 3.00001 13.974 3 13.9877 3C14.2239 2.99995 14.3974 2.99992 14.5458 3.01462C15.9687 3.15561 17.0944 4.28127 17.2354 5.70422C17.2501 5.85261 17.2501 6.01915 17.25 6.24402C17.25 6.25679 17.25 6.26976 17.25 6.28292V12.181C17.25 12.7847 17.25 13.283 17.2169 13.6889C17.1824 14.1104 17.1085 14.498 16.923 14.862C16.6354 15.4265 16.1765 15.8854 15.612 16.173C15.248 16.3585 14.8605 16.4324 14.4389 16.4669C14.033 16.5 13.5347 16.5 12.931 16.5H5.06902C4.4653 16.5 3.96703 16.5 3.56114 16.4669C3.13957 16.4324 2.75204 16.3585 2.38804 16.173C1.82355 15.8854 1.36461 15.4265 1.07699 14.862C0.891523 14.498 0.817599 14.1104 0.783156 13.6889C0.749993 13.283 0.75 12.7847 0.75001 12.181L0.75001 6.28292C0.75001 6.26976 0.750008 6.25679 0.750005 6.24402C0.749959 6.01915 0.749925 5.85261 0.764628 5.70422C0.905612 4.28127 2.03128 3.15561 3.45422 3.01462C3.60266 2.99992 3.77616 2.99995 4.01231 3C4.02606 3 4.04002 3.00001 4.0542 3.00001C4.1718 3.00001 4.19725 2.99966 4.21421 2.99863C4.50342 2.98112 4.75667 2.79858 4.86475 2.52975C4.87116 2.5138 4.8787 2.49222 4.9135 2.38783C4.91537 2.38222 4.91722 2.37666 4.91906 2.37115C4.94517 2.29275 4.96789 2.22453 4.99353 2.16076C5.31775 1.35427 6.0775 0.806667 6.94513 0.754121C7.01375 0.749965 7.08565 0.749983 7.1683 0.750003ZM9.00001 7.12501C7.75737 7.12501 6.75001 8.13236 6.75001 9.37501C6.75001 10.6176 7.75737 11.625 9.00001 11.625C10.2427 11.625 11.25 10.6176 11.25 9.37501C11.25 8.13236 10.2427 7.12501 9.00001 7.12501ZM5.25001 9.37501C5.25001 7.30394 6.92894 5.62501 9.00001 5.62501C11.0711 5.62501 12.75 7.30394 12.75 9.37501C12.75 11.4461 11.0711 13.125 9.00001 13.125C6.92894 13.125 5.25001 11.4461 5.25001 9.37501Z"
                                       fill="currentColor"></path>
                            </svg>
                            <span class="f-14 leading-20 text-white mx-2 gilroy-medium">
                                Change Photo
                            </span>
                        </button>

                        <span id="file-error"></span>
                    </div>
                </div>
            </div>

            <div class="right-avatar-img">
                <img src="<?php echo isset($_SESSION['profile_photo'])
                    ? '../uploads/profile/' . $_SESSION['profile_photo']
                    : 'public/dist/images/default-avatar.png'; ?>"
                     alt="Profile"
                     id="profileImage"
                     style="width: 120px; height: 120px; border-radius: 50%; object-fit: cover;">
            </div>

        </div>
    </div>
</form>
<script>
document.getElementById('uploadPhotoInput').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        document.getElementById('profileImage').src = URL.createObjectURL(file);
    }
});
</script>

   
    <div class="col-xl-12 col-xxl-6">
        <div class="bg-white profile-qr-code mt-32">
            <!-- Qr Code Div -->
            <div class="d-flex flex-wrap justify-content-between gap-26">
                <div class="left-qr-desc">
                    <input type="hidden" value="6160" name="user_id" id="user_id">
                    <div class="peofile-qr-text d-flex">
                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.11084 1.83301L7.33203 1.83301C7.83829 1.83301 8.2487 2.24341 8.2487 2.74968C8.2487 3.25594 7.83829 3.66634 7.33203 3.66634H7.1487C6.3635 3.66634 5.82973 3.66706 5.41715 3.70076C5.01527 3.7336 4.80975 3.79311 4.66638 3.86616C4.32142 4.04193 4.04095 4.3224 3.86519 4.66736C3.79214 4.81073 3.73262 5.01625 3.69979 5.41813C3.66608 5.83071 3.66537 6.36448 3.66537 7.14968V7.33301C3.66537 7.83927 3.25496 8.24968 2.7487 8.24968C2.24244 8.24968 1.83203 7.83927 1.83203 7.33301L1.83203 7.11182C1.83202 6.37393 1.83201 5.76493 1.87254 5.26884C1.91464 4.75358 2.00499 4.27993 2.23167 3.83504C2.58321 3.14512 3.14414 2.58419 3.83407 2.23265C4.27896 2.00597 4.7526 1.91562 5.26786 1.87352C5.76395 1.83299 6.37295 1.833 7.11084 1.83301ZM16.5802 3.70076C16.1677 3.66706 15.6339 3.66634 14.8487 3.66634H14.6654C14.1591 3.66634 13.7487 3.25594 13.7487 2.74968C13.7487 2.24341 14.1591 1.83301 14.6654 1.83301L14.8866 1.83301C15.6244 1.833 16.2334 1.83299 16.7295 1.87352C17.2448 1.91562 17.7184 2.00597 18.1633 2.23265C18.8533 2.58419 19.4142 3.14512 19.7657 3.83504C19.9924 4.27993 20.0828 4.75358 20.1249 5.26884C20.1654 5.76493 20.1654 6.37392 20.1654 7.1118V7.33301C20.1654 7.83927 19.755 8.24968 19.2487 8.24968C18.7424 8.24968 18.332 7.83927 18.332 7.33301V7.14968C18.332 6.36448 18.3313 5.83071 18.2976 5.41813C18.2648 5.01625 18.2053 4.81073 18.1322 4.66736C17.9564 4.3224 17.676 4.04193 17.331 3.86616C17.1876 3.79311 16.9821 3.7336 16.5802 3.70076ZM1.83203 10.9997C1.83203 10.4934 2.24244 10.083 2.7487 10.083H2.75787C3.26413 10.083 3.67453 10.4934 3.67453 10.9997C3.67453 11.5059 3.26413 11.9163 2.75787 11.9163H2.7487C2.24244 11.9163 1.83203 11.5059 1.83203 10.9997ZM5.95703 10.9997C5.95703 10.4934 6.36744 10.083 6.8737 10.083H6.88287C7.38913 10.083 7.79953 10.4934 7.79953 10.9997C7.79953 11.5059 7.38913 11.9163 6.88287 11.9163H6.8737C6.36744 11.9163 5.95703 11.5059 5.95703 10.9997ZM10.082 10.9997C10.082 10.4934 10.4924 10.083 10.9987 10.083H11.0079C11.5141 10.083 11.9245 10.4934 11.9245 10.9997C11.9245 11.5059 11.5141 11.9163 11.0079 11.9163H10.9987C10.4924 11.9163 10.082 11.5059 10.082 10.9997ZM14.207 10.9997C14.207 10.4934 14.6174 10.083 15.1237 10.083H15.1329C15.6391 10.083 16.0495 10.4934 16.0495 10.9997C16.0495 11.5059 15.6391 11.9163 15.1329 11.9163H15.1237C14.6174 11.9163 14.207 11.5059 14.207 10.9997ZM18.332 10.9997C18.332 10.4934 18.7424 10.083 19.2487 10.083H19.2579C19.7641 10.083 20.1745 10.4934 20.1745 10.9997C20.1745 11.5059 19.7641 11.9163 19.2579 11.9163H19.2487C18.7424 11.9163 18.332 11.5059 18.332 10.9997ZM2.7487 13.7497C3.25496 13.7497 3.66537 14.1601 3.66537 14.6663V14.8497C3.66537 15.6349 3.66608 16.1686 3.69979 16.5812C3.73262 16.9831 3.79214 17.1886 3.86519 17.332C4.04096 17.677 4.32142 17.9574 4.66638 18.1332C4.80975 18.2062 5.01527 18.2658 5.41715 18.2986C5.82973 18.3323 6.3635 18.333 7.1487 18.333H7.33203C7.83829 18.333 8.2487 18.7434 8.2487 19.2497C8.2487 19.7559 7.83829 20.1663 7.33203 20.1663H7.11082C6.37294 20.1664 5.76395 20.1664 5.26786 20.1258C4.7526 20.0837 4.27896 19.9934 3.83407 19.7667C3.14414 19.4152 2.58321 18.8542 2.23167 18.1643C2.00499 17.7194 1.91464 17.2458 1.87254 16.7305C1.83201 16.2344 1.83202 15.6254 1.83203 14.8875L1.83203 14.6663C1.83203 14.1601 2.24244 13.7497 2.7487 13.7497ZM19.2487 13.7497C19.755 13.7497 20.1654 14.1601 20.1654 14.6663V14.8876C20.1654 15.6254 20.1654 16.2344 20.1249 16.7305C20.0828 17.2458 19.9924 17.7194 19.7657 18.1643C19.4142 18.8542 18.8533 19.4152 18.1633 19.7667C17.7184 19.9934 17.2448 20.0837 16.7295 20.1258C16.2334 20.1664 15.6245 20.1664 14.8866 20.1663H14.6654C14.1591 20.1663 13.7487 19.7559 13.7487 19.2497C13.7487 18.7434 14.1591 18.333 14.6654 18.333H14.8487C15.6339 18.333 16.1677 18.3323 16.5802 18.2986C16.9821 18.2658 17.1876 18.2062 17.331 18.1332C17.676 17.9574 17.9564 17.677 18.1322 17.332C18.2053 17.1886 18.2648 16.9831 18.2976 16.5812C18.3313 16.1686 18.332 15.6349 18.332 14.8497V14.6663C18.332 14.1601 18.7424 13.7497 19.2487 13.7497Z" fill="currentColor"></path>
                            </svg>
                   
            <!-- Password Div -->
            <div class="profile-qr-bootom d-flex justify-content-between align-items-center mt-26">
                <div class="d-flex align-items-center">
                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 7.33301C5.5 4.29544 7.96244 1.83301 11 1.83301C13.2568 1.83301 15.1941 3.19209 16.042 5.13267C16.2446 5.59658 16.0329 6.13697 15.569 6.33967C15.1051 6.54236 14.5647 6.3306 14.362 5.86668C13.7953 4.56977 12.5021 3.66634 11 3.66634C8.97496 3.66634 7.33333 5.30796 7.33333 7.33301V8.25117C7.55123 8.24967 7.78286 8.24967 8.02881 8.24968H13.9712C14.7091 8.24966 15.3181 8.24965 15.8142 8.29019C16.3294 8.33228 16.8031 8.42264 17.248 8.64932C17.9379 9.00085 18.4988 9.56178 18.8504 10.2517C19.077 10.6966 19.1674 11.1702 19.2095 11.6855C19.25 12.1816 19.25 12.7906 19.25 13.5285V14.8876C19.25 15.6254 19.25 16.2344 19.2095 16.7305C19.1674 17.2458 19.077 17.7194 18.8504 18.1643C18.4988 18.8542 17.9379 19.4152 17.248 19.7667C16.8031 19.9934 16.3294 20.0837 15.8142 20.1258C15.3181 20.1664 14.7091 20.1664 13.9712 20.1663H8.02879C7.29091 20.1664 6.68192 20.1664 6.18583 20.1258C5.67057 20.0837 5.19693 19.9934 4.75204 19.7667C4.06211 19.4152 3.50118 18.8542 3.14964 18.1643C2.92296 17.7194 2.83261 17.2458 2.79051 16.7305C2.74998 16.2344 2.74999 15.6254 2.75 14.8875V13.5285C2.74999 12.7906 2.74998 12.1816 2.79051 11.6855C2.83261 11.1702 2.92296 10.6966 3.14964 10.2517C3.50118 9.56178 4.06211 9.00085 4.75204 8.64932C4.9923 8.5269 5.24094 8.44424 5.5 8.38747V7.33301ZM6.33512 10.1174C5.93324 10.1503 5.72772 10.2098 5.58435 10.2828C5.23939 10.4586 4.95892 10.7391 4.78316 11.084C4.71011 11.2274 4.65059 11.4329 4.61776 11.8348C4.58405 12.2474 4.58333 12.7811 4.58333 13.5663V14.8497C4.58333 15.6349 4.58405 16.1686 4.61776 16.5812C4.65059 16.9831 4.71011 17.1886 4.78316 17.332C4.95892 17.677 5.23939 17.9574 5.58435 18.1332C5.72772 18.2062 5.93324 18.2658 6.33512 18.2986C6.7477 18.3323 7.28147 18.333 8.06667 18.333H13.9333C14.7185 18.333 15.2523 18.3323 15.6649 18.2986C16.0668 18.2658 16.2723 18.2062 16.4157 18.1332C16.7606 17.9574 17.0411 17.677 17.2168 17.332C17.2899 17.1886 17.3494 16.9831 17.3822 16.5812C17.416 16.1686 17.4167 15.6349 17.4167 14.8497V13.5663C17.4167 12.7811 17.416 12.2474 17.3822 11.8348C17.3494 11.4329 17.2899 11.2274 17.2168 11.084C17.0411 10.7391 16.7606 10.4586 16.4157 10.2828C16.2723 10.2098 16.0668 10.1503 15.6649 10.1174C15.2523 10.0837 14.7185 10.083 13.9333 10.083H8.06667C7.28147 10.083 6.7477 10.0837 6.33512 10.1174ZM11 12.3747C11.5063 12.3747 11.9167 12.7851 11.9167 13.2913V15.1247C11.9167 15.6309 11.5063 16.0413 11 16.0413C10.4937 16.0413 10.0833 15.6309 10.0833 15.1247V13.2913C10.0833 12.7851 10.4937 12.3747 11 12.3747Z" fill="currentColor"></path>
                    </svg>
                    <p class="ml-12 mb-0 f-16 leading-20 gilroy-medium text-dark">Change Password</p>
                </div>
                <div class="d-flex align-items-center">
                    <div class="mb-0 f-16 leading-20 gilroy-medium d-flex align-items-center text-gray-100 password-text pass-height">*************</div>
                    <div class="cursor-pointer" data-bs-toggle="modal" data-bs-target="#exampleModal-2">
                        <svg class="ml-14" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect width="24" height="24" rx="4" fill="#635BFE"></rect>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.2139 6.62899C14.925 5.91794 16.0778 5.91794 16.7889 6.62899C17.4999 7.34005 17.4999 8.4929 16.7889 9.20395L9.46059 16.5322C9.44904 16.5438 9.4376 16.5552 9.42624 16.5666C9.25857 16.7346 9.11073 16.8827 8.9325 16.9919C8.77592 17.0879 8.60522 17.1586 8.42666 17.2015C8.2234 17.2503 8.01413 17.2501 7.77678 17.2498C7.76071 17.2498 7.74451 17.2498 7.72818 17.2498H6.75136C6.4292 17.2498 6.16803 16.9886 6.16803 16.6665V15.6897C6.16803 15.6733 6.16801 15.6571 6.168 15.6411C6.16778 15.4037 6.16758 15.1945 6.21638 14.9912C6.25925 14.8126 6.32996 14.6419 6.42591 14.4853C6.53513 14.3071 6.68324 14.1593 6.85123 13.9916C6.8626 13.9803 6.87407 13.9688 6.88562 13.9573L14.2139 6.62899ZM15.9639 7.45395C15.7085 7.19851 15.2943 7.19851 15.0389 7.45395L7.71058 14.7822C7.48916 15.0036 7.44834 15.0498 7.42065 15.0949C7.38867 15.1471 7.3651 15.204 7.35081 15.2635C7.33844 15.3151 7.33469 15.3765 7.33469 15.6897V16.0831H7.72818C8.0413 16.0831 8.10279 16.0794 8.1543 16.067C8.21382 16.0527 8.27073 16.0292 8.32292 15.9972C8.36809 15.9695 8.41422 15.9287 8.63563 15.7073L15.9639 8.37899C16.2193 8.12355 16.2193 7.7094 15.9639 7.45395ZM11.418 16.6665C11.418 16.3443 11.6792 16.0831 12.0013 16.0831H17.2513C17.5735 16.0831 17.8347 16.3443 17.8347 16.6665C17.8347 16.9886 17.5735 17.2498 17.2513 17.2498H12.0013C11.6792 17.2498 11.418 16.9886 11.418 16.6665Z" fill="white"></path>
                    </svg>
                    </div>
                    <div class="modal fade modal-overly" id="exampleModal-2" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg res-dialog">
                            <div class="modal-content">
                                <div class="modal-header w-modal-header">
                                    <p class="modal-title gilroy-Semibold text-dark">Change Password</p>
                                    <button type="button" class="cursor-pointer close-btn" data-bs-dismiss="modal" aria-label="Close">
                                        <span class="close-div position-absolute modal-close-btn rtl-wrap-four text-gray-100 d-flex align-items-center justify-content-center">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.24408 5.24408C5.56951 4.91864 6.09715 4.91864 6.42259 5.24408L10 8.82149L13.5774 5.24408C13.9028 4.91864 14.4305 4.91864 14.7559 5.24408C15.0814 5.56951 15.0814 6.09715 14.7559 6.42259L11.1785 10L14.7559 13.5774C15.0814 13.9028 15.0814 14.4305 14.7559 14.7559C14.4305 15.0814 13.9028 15.0814 13.5774 14.7559L10 11.1785L6.42259 14.7559C6.09715 15.0814 5.56951 15.0814 5.24408 14.7559C4.91864 14.4305 4.91864 13.9028 5.24408 13.5774L8.82149 10L5.24408 6.42259C4.91864 6.09715 4.91864 5.56951 5.24408 5.24408Z" fill="currentColor"></path>
                            </svg>
                                        </span>
                                    </button>
                                </div>
                             <!-- SUCCESS/ERROR MESSAGE -->
<?php if (!empty($message)): ?>
    <div class="alert alert-info" style="margin: 20px; padding: 10px; background: #eef; border-radius: 5px;">
        <?= $message ?>
    </div>
<?php endif; ?>

<!-- PASSWORD RESET MODAL CONTENT -->
<div class="modal-body modal-body-pxy">
    <form action="" method="post" id="profileResetPasswordForm">
        <div>

            <!-- OLD PASSWORD -->
            <div class="row">
                <div class="col-md-12">
                    <div class="label-top mt-withdraw">
                        <label class="gilroy-medium text-gray-100 mb-2 f-14">Old Password</label>
                        <input type="password" class="form-control input-form-control input-form-control-withdraw apply-bg"
                               name="old_password" id="old_password" placeholder="Old Password" required>
                    </div>
                </div>
            </div>

            <!-- NEW PASSWORD -->
            <div class="row">
                <div class="col-md-12">
                    <div class="label-top mt-withdraw position-r">
                        <label class="gilroy-medium text-gray-100 mb-2 f-14">New Password</label>
                        <div id="show_hide_password">
                            <input type="password" class="form-control input-form-control input-form-control-withdraw apply-bg"
                                   name="password" id="password" placeholder="New Password" required>
                        </div>

                        <!-- EYE ICONS -->
                        <span class="eye-icon-hide d-none cursor-pointer" id="eye-icon-show">
                            <!-- Visible Eye SVG -->
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                                <path d="..."></path>
                            </svg>
                        </span>

                        <span class="eye-icon cursor-pointer" id="eye-icon-hide">
                            <!-- Hidden Eye SVG -->
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none">
                                <path d="..."></path>
                            </svg>
                        </span>

                        <p class="mb-0 text-gray-100 dark-B87 gilroy-regular f-12 mt-2">
                            <em>*Password should contain minimum 6 characters</em>
                        </p>
                    </div>
                </div>
            </div>

            <!-- CONFIRM PASSWORD -->
            <div class="row">
                <div class="col-md-12">
                    <div class="label-top mt-withdraw">
                        <label class="gilroy-medium text-gray-100 mb-2 f-14">Confirm Password</label>
                        <input type="password" class="form-control input-form-control input-form-control-withdraw apply-bg"
                               name="password_confirmation" id="password_confirmation"
                               placeholder="Confirm Password" required>
                    </div>
                </div>
            </div>

        </div>

        <!-- SUBMIT BUTTON -->
        <div class="row mt-20">
            <div class="col-md-12 pb-2">
                <button type="submit" class="btn bg-primary add-option-btn w-100 setting-btn f-16"
                        id="profileResetPasswordSubmitBtn">
                    <div class="spinner spinner-border text-white spinner-border-sm mx-2 d-none" role="status">
                        <span class="visually-hidden"></span>
                    </div>
                    <span id="profileResetPasswordSubmitBtnText">Save Changes</span>
                </button>
            </div>
        </div>
    </form>
</div>

<!-- PASSWORD SHOW/HIDE SCRIPT -->
<script>
document.getElementById("eye-icon-hide").addEventListener("click", function() {
    document.getElementById("password").type = "text";
    this.classList.add("d-none");
    document.getElementById("eye-icon-show").classList.remove("d-none");
});

document.getElementById("eye-icon-show").addEventListener("click", function() {
    document.getElementById("password").type = "password";
    this.classList.add("d-none");
    document.getElementById("eye-icon-hide").classList.remove("d-none");
});
</script>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <br>
            <!-- Email Div -->
            <div class="profile-qr-bootom d-flex justify-content-between align-items-center mt-27">
                <div class="d-flex align-items-center">
                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M10.4274 1.89848C10.8032 1.81118 11.1942 1.81118 11.57 1.89848C11.9992 1.99821 12.3807 2.24442 12.8148 2.52455C12.8449 2.54402 12.8754 2.56367 12.9061 2.58343L18.9475 6.47054C18.962 6.47985 18.9766 6.48927 18.9914 6.49877L19.1793 6.61966C19.1944 6.62938 19.2099 6.63932 19.2259 6.6495C19.3974 6.75901 19.6131 6.89677 19.7774 7.09139C19.9195 7.2598 20.0263 7.45459 20.0915 7.66435C20.1668 7.90677 20.1659 8.16088 20.1652 8.36287C20.1652 8.38166 20.1651 8.39999 20.1651 8.41782V14.4996C20.1651 15.1635 20.1651 15.7115 20.1283 16.1579C20.09 16.6216 20.0079 17.0478 19.8018 17.4481C19.4822 18.069 18.9723 18.5737 18.3451 18.8901C17.9407 19.094 17.5101 19.1753 17.0417 19.2132C16.5907 19.2497 16.0371 19.2497 15.3663 19.2497H6.63105C5.96027 19.2497 5.40666 19.2497 4.95568 19.2132C4.48728 19.1753 4.05671 19.094 3.65228 18.8901C3.02509 18.5737 2.51517 18.069 2.1956 17.4481C1.98953 17.0478 1.90739 16.6216 1.86912 16.1579C1.83228 15.7115 1.83228 15.1635 1.8323 14.4995L1.8323 8.41782C1.8323 8.39999 1.83223 8.38166 1.83217 8.36287C1.83147 8.16088 1.8306 7.90677 1.90591 7.66435C1.97108 7.45458 2.07787 7.2598 2.22003 7.09139C2.38433 6.89677 2.60004 6.75901 2.77151 6.6495C2.78746 6.63932 2.80302 6.62938 2.81813 6.61966L3.00603 6.49876C3.02077 6.48926 3.03542 6.47984 3.0499 6.47053C3.0571 6.4659 3.06426 6.46129 3.07138 6.45672L9.09129 2.58344C9.12202 2.56367 9.15245 2.54403 9.18263 2.52455C9.61671 2.24442 9.99822 1.99821 10.4274 1.89848ZM9.99958 3.96664L4.19465 7.7016L9.99958 11.4366C10.579 11.8094 10.7006 11.8736 10.8083 11.8986C10.9335 11.9277 11.0639 11.9277 11.1891 11.8986C11.2968 11.8736 11.4184 11.8094 11.9978 11.4366L17.8027 7.7016L11.9978 3.96664C11.4184 3.59381 11.2968 3.52959 11.1891 3.50456C11.0639 3.47546 10.9335 3.47546 10.8083 3.50456C10.7006 3.52959 10.579 3.59381 9.99958 3.96664ZM18.4985 9.22156L12.9061 12.8198C12.8754 12.8395 12.845 12.8592 12.8148 12.8786C12.3807 13.1588 11.9992 13.405 11.57 13.5047C11.1942 13.592 10.8032 13.592 10.4274 13.5047C9.99822 13.405 9.6167 13.1588 9.18263 12.8786C9.15245 12.8592 9.12201 12.8395 9.09129 12.8198L3.49891 9.22156V14.4655C3.49891 15.172 3.49956 15.6523 3.53021 16.0236C3.56006 16.3852 3.61416 16.5702 3.68056 16.6992C3.84035 17.0096 4.09531 17.262 4.4089 17.4201C4.53923 17.4859 4.72606 17.5394 5.0914 17.569C5.46646 17.5993 5.95169 17.5999 6.66549 17.5999H15.3319C16.0457 17.5999 16.5309 17.5993 16.906 17.569C17.2713 17.5394 17.4582 17.4859 17.5885 17.4201C17.9021 17.262 18.157 17.0096 18.3168 16.6992C18.3832 16.5702 18.4373 16.3852 18.4672 16.0236C18.4978 15.6523 18.4985 15.172 18.4985 14.4655V9.22156Z" fill="currentColor"></path>
                        </svg>
                    <p class="ml-12 mb-0 f-16 leading-20 gilroy-medium text-dark">Email Address</p>
                </div>
                <p class="mb-0 f-15 leading-18 gilroy-medium d-flex align-items-center text-gray-100 responsive-mail-text"><?php echo $_SESSION['email']; ?></p>
            </div>
        </div>
    </div>
</div>
<!-- Personal Information Div -->
<div class="profile-personal-information bg-white mt-18">
    <div class="d-flex align-items-center">
        <p class="mb-0 f-24 leading-30 gilroy-Semibold text-dark">Personal Information</p>
        <div class="hover-qr-code cursor-pointer wallet-svg  position-r">
            <a href="" data-bs-toggle="modal" data-bs-target="#exampleModal-3">
                <svg class="ml-12" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M11.8448 2.09484C12.759 1.18063 14.2412 1.18063 15.1554 2.09484C16.0696 3.00905 16.0696 4.49129 15.1554 5.4055L5.73337 14.8276C5.71852 14.8424 5.70381 14.8571 5.68921 14.8718C5.47363 15.0878 5.28355 15.2782 5.0544 15.4186C4.85309 15.542 4.63361 15.6329 4.40403 15.688C4.1427 15.7507 3.87364 15.7505 3.56847 15.7502C3.54781 15.7502 3.52698 15.7502 3.50598 15.7502H2.25008C1.83586 15.7502 1.50008 15.4144 1.50008 15.0002V13.7443C1.50008 13.7233 1.50006 13.7025 1.50004 13.6818C1.49975 13.3766 1.4995 13.1076 1.56224 12.8462C1.61736 12.6167 1.70827 12.3972 1.83164 12.1959C1.97206 11.9667 2.16249 11.7766 2.37848 11.5611C2.3931 11.5465 2.40784 11.5317 2.42269 11.5169L11.8448 2.09484ZM14.0948 3.1555C13.7663 2.82707 13.2339 2.82707 12.9054 3.1555L3.48335 12.5776C3.19868 12.8622 3.14619 12.9215 3.1106 12.9796C3.06948 13.0467 3.03917 13.1199 3.0208 13.1964C3.0049 13.2626 3.00008 13.3417 3.00008 13.7443V14.2502H3.50598C3.90857 14.2502 3.98762 14.2453 4.05386 14.2294C4.13039 14.2111 4.20354 14.1808 4.27065 14.1396C4.32873 14.1041 4.38804 14.0516 4.67271 13.7669L14.0948 4.34484C14.4232 4.01641 14.4232 3.48393 14.0948 3.1555ZM8.25006 15.0002C8.25006 14.586 8.58584 14.2502 9.00006 14.2502H15.7501C16.1643 14.2502 16.5001 14.586 16.5001 15.0002C16.5001 15.4144 16.1643 15.7502 15.7501 15.7502H9.00006C8.58584 15.7502 8.25006 15.4144 8.25006 15.0002Z" fill="currentColor"></path>
                </svg>
            </a>
        </div>

        <div class="modal fade modal-overly" id="exampleModal-3" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg res-dialog">
                <div class="modal-content">
                    <div class="modal-header w-modal-header">
                        <p class="modal-title gilroy-Semibold text-dark">Profile Information</p>
                        <button type="button" class="cursor-pointer close-btn" data-bs-dismiss="modal" aria-label="Close">
                            <span class="close-div position-absolute modal-close-btn rtl-wrap-four text-gray-100 d-flex align-items-center justify-content-center">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.24408 5.24408C5.56951 4.91864 6.09715 4.91864 6.42259 5.24408L10 8.82149L13.5774 5.24408C13.9028 4.91864 14.4305 4.91864 14.7559 5.24408C15.0814 5.56951 15.0814 6.09715 14.7559 6.42259L11.1785 10L14.7559 13.5774C15.0814 13.9028 15.0814 14.4305 14.7559 14.7559C14.4305 15.0814 13.9028 15.0814 13.5774 14.7559L10 11.1785L6.42259 14.7559C6.09715 15.0814 5.56951 15.0814 5.24408 14.7559C4.91864 14.4305 4.91864 13.9028 5.24408 13.5774L8.82149 10L5.24408 6.42259C4.91864 6.09715 4.91864 5.56951 5.24408 5.24408Z" fill="currentColor"></path>
                            </svg>
                            </span>
                        </button>
                    </div>
                    <div class="modal-body modal-body-pxy">
                        <form method="post" action="https://Quantumsecurenova.com/prifile/update" id="profileUpdateForm">
                            <input type="hidden" name="_token" value="AWO37hEyyaFjyNu7gt4uBj6e66n0lDGYYU2YPoWc">                            <input type="hidden" value="6160" name="id" id="id">
                            <input type="hidden" name="defaultCountry" id="defaultCountry" value="ng">
                            <input type="hidden" name="carrierCode" id="carrierCode" value="234">
                            <input type="hidden" name="formattedPhone" id="formattedPhone" value="+2348145166452">
                            <div class="row">
                                <!-- First Name -->
                                <div class="col-6 column-pr-unset2">
                                    <div class="label-top mt-withdraw">
                                        <label class="gilroy-medium text-gray-100 mb-2 f-14 leading-17 r-mt-amount r-mt-6">Full Name <span class="f-16 text-F30">*</span></label>
                                        <input type="text" class="form-control input-form-control input-form-control-withdraw apply-bg" name="first_name" id="first_name" value="<?php echo $_SESSION['fullname']; ?>" required="" data-value-missing="This field is required.">
                                                                            </div>
                                </div>
                                <!-- Last Name -->
                                <div class="col-6 column-pl-unset2">
                                    <div class="label-top mt-withdraw position-r">
                                        <label class="gilroy-medium text-gray-100 mb-2 f-14 leading-17 r-mt-amount r-mt-6">User Name <span class="f-16 text-F30">*</span></label>
                                        <input type="text" class="form-control input-form-control input-form-control-withdraw apply-bg" name="last_name" id="last_name" value="<?php echo $_SESSION['username']; ?>" required="" data-value-missing="This field is required.">
                                                                            </div>
                                </div>
                            </div>
                            <!-- Phone -->
                           
                                <!-- Timezone -->
                                <div class="col-6 column-pl-unset2">  
                                    <div class="param-ref param-ref-withdraw param-ref-withdraw-modal money-ref-2">
                                        <label class="gilroy-medium text-gray-100 mb-2 f-14 leading-17 mt-20 r-mt-0">Time Zone</label>
                                        <select class="select2 select2-hidden-accessible" name="timezone" id="timezone" data-select2-id="select2-data-timezone" tabindex="-1" aria-hidden="true">
                                                                                            <option value="Africa/Abidjan">UTC/GMT +00:00 - Africa/Abidjan</option>
                                                                                            <option value="Africa/Accra">UTC/GMT +00:00 - Africa/Accra</option>
                                                                                            <option value="Africa/Addis_Ababa">UTC/GMT +03:00 - Africa/Addis_Ababa</option>
                                                                                            <option value="Africa/Algiers">UTC/GMT +01:00 - Africa/Algiers</option>
                                                                                            <option value="Africa/Asmara">UTC/GMT +03:00 - Africa/Asmara</option>
                                                                                            <option value="Africa/Bamako">UTC/GMT +00:00 - Africa/Bamako</option>
                                                                                            <option value="Africa/Bangui">UTC/GMT +01:00 - Africa/Bangui</option>
                                                                                            <option value="Africa/Banjul">UTC/GMT +00:00 - Africa/Banjul</option>
                                                                                            <option value="Africa/Bissau">UTC/GMT +00:00 - Africa/Bissau</option>
                                                                                            <option value="Africa/Blantyre">UTC/GMT +02:00 - Africa/Blantyre</option>
                                                                                            <option value="Africa/Brazzaville">UTC/GMT +01:00 - Africa/Brazzaville</option>
                                                                                            <option value="Africa/Bujumbura">UTC/GMT +02:00 - Africa/Bujumbura</option>
                                                                                            <option value="Africa/Cairo">UTC/GMT +03:00 - Africa/Cairo</option>
                                                                                            <option value="Africa/Casablanca">UTC/GMT +01:00 - Africa/Casablanca</option>
                                                                                            <option value="Africa/Ceuta">UTC/GMT +01:00 - Africa/Ceuta</option>
                                                                                            <option value="Africa/Conakry">UTC/GMT +00:00 - Africa/Conakry</option>
                                                                                            <option value="Africa/Dakar">UTC/GMT +00:00 - Africa/Dakar</option>
                                                                                            <option value="Africa/Dar_es_Salaam">UTC/GMT +03:00 - Africa/Dar_es_Salaam</option>
                                                                                            <option value="Africa/Djibouti">UTC/GMT +03:00 - Africa/Djibouti</option>
                                                                                            <option value="Africa/Douala">UTC/GMT +01:00 - Africa/Douala</option>
                                                                                            <option value="Africa/El_Aaiun">UTC/GMT +01:00 - Africa/El_Aaiun</option>
                                                                                            <option value="Africa/Freetown">UTC/GMT +00:00 - Africa/Freetown</option>
                                                                                            <option value="Africa/Gaborone">UTC/GMT +02:00 - Africa/Gaborone</option>
                                                                                            <option value="Africa/Harare">UTC/GMT +02:00 - Africa/Harare</option>
                                                                                            <option value="Africa/Johannesburg">UTC/GMT +02:00 - Africa/Johannesburg</option>
                                                                                            <option value="Africa/Juba">UTC/GMT +02:00 - Africa/Juba</option>
                                                                                            <option value="Africa/Kampala">UTC/GMT +03:00 - Africa/Kampala</option>
                                                                                            <option value="Africa/Khartoum">UTC/GMT +02:00 - Africa/Khartoum</option>
                                                                                            <option value="Africa/Kigali">UTC/GMT +02:00 - Africa/Kigali</option>
                                                                                            <option value="Africa/Kinshasa">UTC/GMT +01:00 - Africa/Kinshasa</option>
                                                                                            <option value="Africa/Lagos">UTC/GMT +01:00 - Africa/Lagos</option>
                                                                                            <option value="Africa/Libreville">UTC/GMT +01:00 - Africa/Libreville</option>
                                                                                            <option value="Africa/Lome">UTC/GMT +00:00 - Africa/Lome</option>
                                                                                            <option value="Africa/Luanda">UTC/GMT +01:00 - Africa/Luanda</option>
                                                                                            <option value="Africa/Lubumbashi">UTC/GMT +02:00 - Africa/Lubumbashi</option>
                                                                                            <option value="Africa/Lusaka">UTC/GMT +02:00 - Africa/Lusaka</option>
                                                                                            <option value="Africa/Malabo">UTC/GMT +01:00 - Africa/Malabo</option>
                                                                                            <option value="Africa/Maputo">UTC/GMT +02:00 - Africa/Maputo</option>
                                                                                            <option value="Africa/Maseru">UTC/GMT +02:00 - Africa/Maseru</option>
                                                                                            <option value="Africa/Mbabane">UTC/GMT +02:00 - Africa/Mbabane</option>
                                                                                            <option value="Africa/Mogadishu">UTC/GMT +03:00 - Africa/Mogadishu</option>
                                                                                            <option value="Africa/Monrovia">UTC/GMT +00:00 - Africa/Monrovia</option>
                                                                                            <option value="Africa/Nairobi">UTC/GMT +03:00 - Africa/Nairobi</option>
                                                                                            <option value="Africa/Ndjamena">UTC/GMT +01:00 - Africa/Ndjamena</option>
                                                                                            <option value="Africa/Niamey">UTC/GMT +01:00 - Africa/Niamey</option>
                                                                                            <option value="Africa/Nouakchott">UTC/GMT +00:00 - Africa/Nouakchott</option>
                                                                                            <option value="Africa/Ouagadougou">UTC/GMT +00:00 - Africa/Ouagadougou</option>
                                                                                            <option value="Africa/Porto-Novo">UTC/GMT +01:00 - Africa/Porto-Novo</option>
                                                                                            <option value="Africa/Sao_Tome">UTC/GMT +00:00 - Africa/Sao_Tome</option>
                                                                                            <option value="Africa/Tripoli">UTC/GMT +02:00 - Africa/Tripoli</option>
                                                                                            <option value="Africa/Tunis">UTC/GMT +01:00 - Africa/Tunis</option>
                                                                                            <option value="Africa/Windhoek">UTC/GMT +02:00 - Africa/Windhoek</option>
                                                                                            <option value="America/Adak">UTC/GMT -09:00 - America/Adak</option>
                                                                                            <option value="America/Anchorage">UTC/GMT -08:00 - America/Anchorage</option>
                                                                                            <option value="America/Anguilla">UTC/GMT -04:00 - America/Anguilla</option>
                                                                                            <option value="America/Antigua">UTC/GMT -04:00 - America/Antigua</option>
                                                                                            <option value="America/Araguaina">UTC/GMT -03:00 - America/Araguaina</option>
                                                                                            <option value="America/Argentina/Buenos_Aires">UTC/GMT -03:00 - America/Argentina/Buenos_Aires</option>
                                                                                            <option value="America/Argentina/Catamarca">UTC/GMT -03:00 - America/Argentina/Catamarca</option>
                                                                                            <option value="America/Argentina/Cordoba">UTC/GMT -03:00 - America/Argentina/Cordoba</option>
                                                                                            <option value="America/Argentina/Jujuy">UTC/GMT -03:00 - America/Argentina/Jujuy</option>
                                                                                            <option value="America/Argentina/La_Rioja">UTC/GMT -03:00 - America/Argentina/La_Rioja</option>
                                                                                            <option value="America/Argentina/Mendoza">UTC/GMT -03:00 - America/Argentina/Mendoza</option>
                                                                                            <option value="America/Argentina/Rio_Gallegos">UTC/GMT -03:00 - America/Argentina/Rio_Gallegos</option>
                                                                                            <option value="America/Argentina/Salta">UTC/GMT -03:00 - America/Argentina/Salta</option>
                                                                                            <option value="America/Argentina/San_Juan">UTC/GMT -03:00 - America/Argentina/San_Juan</option>
                                                                                            <option value="America/Argentina/San_Luis">UTC/GMT -03:00 - America/Argentina/San_Luis</option>
                                                                                            <option value="America/Argentina/Tucuman">UTC/GMT -03:00 - America/Argentina/Tucuman</option>
                                                                                            <option value="America/Argentina/Ushuaia">UTC/GMT -03:00 - America/Argentina/Ushuaia</option>
                                                                                            <option value="America/Aruba">UTC/GMT -04:00 - America/Aruba</option>
                                                                                            <option value="America/Asuncion">UTC/GMT -03:00 - America/Asuncion</option>
                                                                                            <option value="America/Atikokan">UTC/GMT -05:00 - America/Atikokan</option>
                                                                                            <option value="America/Bahia">UTC/GMT -03:00 - America/Bahia</option>
                                                                                            <option value="America/Bahia_Banderas">UTC/GMT -06:00 - America/Bahia_Banderas</option>
                                                                                            <option value="America/Barbados">UTC/GMT -04:00 - America/Barbados</option>
                                                                                            <option value="America/Belem">UTC/GMT -03:00 - America/Belem</option>
                                                                                            <option value="America/Belize">UTC/GMT -06:00 - America/Belize</option>
                                                                                            <option value="America/Blanc-Sablon">UTC/GMT -04:00 - America/Blanc-Sablon</option>
                                                                                            <option value="America/Boa_Vista">UTC/GMT -04:00 - America/Boa_Vista</option>
                                                                                            <option value="America/Bogota">UTC/GMT -05:00 - America/Bogota</option>
                                                                                            <option value="America/Boise">UTC/GMT -06:00 - America/Boise</option>
                                                                                            <option value="America/Cambridge_Bay">UTC/GMT -06:00 - America/Cambridge_Bay</option>
                                                                                            <option value="America/Campo_Grande">UTC/GMT -04:00 - America/Campo_Grande</option>
                                                                                            <option value="America/Cancun">UTC/GMT -05:00 - America/Cancun</option>
                                                                                            <option value="America/Caracas">UTC/GMT -04:00 - America/Caracas</option>
                                                                                            <option value="America/Cayenne">UTC/GMT -03:00 - America/Cayenne</option>
                                                                                            <option value="America/Cayman">UTC/GMT -05:00 - America/Cayman</option>
                                                                                            <option value="America/Chicago">UTC/GMT -05:00 - America/Chicago</option>
                                                                                            <option value="America/Chihuahua">UTC/GMT -06:00 - America/Chihuahua</option>
                                                                                            <option value="America/Ciudad_Juarez">UTC/GMT -06:00 - America/Ciudad_Juarez</option>
                                                                                            <option value="America/Costa_Rica">UTC/GMT -06:00 - America/Costa_Rica</option>
                                                                                            <option value="America/Creston">UTC/GMT -07:00 - America/Creston</option>
                                                                                            <option value="America/Cuiaba">UTC/GMT -04:00 - America/Cuiaba</option>
                                                                                            <option value="America/Curacao">UTC/GMT -04:00 - America/Curacao</option>
                                                                                            <option value="America/Danmarkshavn">UTC/GMT +00:00 - America/Danmarkshavn</option>
                                                                                            <option value="America/Dawson">UTC/GMT -07:00 - America/Dawson</option>
                                                                                            <option value="America/Dawson_Creek">UTC/GMT -07:00 - America/Dawson_Creek</option>
                                                                                            <option value="America/Denver">UTC/GMT -06:00 - America/Denver</option>
                                                                                            <option value="America/Detroit">UTC/GMT -04:00 - America/Detroit</option>
                                                                                            <option value="America/Dominica">UTC/GMT -04:00 - America/Dominica</option>
                                                                                            <option value="America/Edmonton">UTC/GMT -06:00 - America/Edmonton</option>
                                                                                            <option value="America/Eirunepe">UTC/GMT -05:00 - America/Eirunepe</option>
                                                                                            <option value="America/El_Salvador">UTC/GMT -06:00 - America/El_Salvador</option>
                                                                                            <option value="America/Fort_Nelson">UTC/GMT -07:00 - America/Fort_Nelson</option>
                                                                                            <option value="America/Fortaleza">UTC/GMT -03:00 - America/Fortaleza</option>
                                                                                            <option value="America/Glace_Bay">UTC/GMT -03:00 - America/Glace_Bay</option>
                                                                                            <option value="America/Goose_Bay">UTC/GMT -03:00 - America/Goose_Bay</option>
                                                                                            <option value="America/Grand_Turk">UTC/GMT -04:00 - America/Grand_Turk</option>
                                                                                            <option value="America/Grenada">UTC/GMT -04:00 - America/Grenada</option>
                                                                                            <option value="America/Guadeloupe">UTC/GMT -04:00 - America/Guadeloupe</option>
                                                                                            <option value="America/Guatemala">UTC/GMT -06:00 - America/Guatemala</option>
                                                                                            <option value="America/Guayaquil">UTC/GMT -05:00 - America/Guayaquil</option>
                                                                                            <option value="America/Guyana">UTC/GMT -04:00 - America/Guyana</option>
                                                                                            <option value="America/Halifax">UTC/GMT -03:00 - America/Halifax</option>
                                                                                            <option value="America/Havana">UTC/GMT -04:00 - America/Havana</option>
                                                                                            <option value="America/Hermosillo">UTC/GMT -07:00 - America/Hermosillo</option>
                                                                                            <option value="America/Indiana/Indianapolis">UTC/GMT -04:00 - America/Indiana/Indianapolis</option>
                                                                                            <option value="America/Indiana/Knox">UTC/GMT -05:00 - America/Indiana/Knox</option>
                                                                                            <option value="America/Indiana/Marengo">UTC/GMT -04:00 - America/Indiana/Marengo</option>
                                                                                            <option value="America/Indiana/Petersburg">UTC/GMT -04:00 - America/Indiana/Petersburg</option>
                                                                                            <option value="America/Indiana/Tell_City">UTC/GMT -05:00 - America/Indiana/Tell_City</option>
                                                                                            <option value="America/Indiana/Vevay">UTC/GMT -04:00 - America/Indiana/Vevay</option>
                                                                                            <option value="America/Indiana/Vincennes">UTC/GMT -04:00 - America/Indiana/Vincennes</option>
                                                                                            <option value="America/Indiana/Winamac">UTC/GMT -04:00 - America/Indiana/Winamac</option>
                                                                                            <option value="America/Inuvik">UTC/GMT -06:00 - America/Inuvik</option>
                                                                                            <option value="America/Iqaluit">UTC/GMT -04:00 - America/Iqaluit</option>
                                                                                            <option value="America/Jamaica">UTC/GMT -05:00 - America/Jamaica</option>
                                                                                            <option value="America/Juneau">UTC/GMT -08:00 - America/Juneau</option>
                                                                                            <option value="America/Kentucky/Louisville">UTC/GMT -04:00 - America/Kentucky/Louisville</option>
                                                                                            <option value="America/Kentucky/Monticello">UTC/GMT -04:00 - America/Kentucky/Monticello</option>
                                                                                            <option value="America/Kralendijk">UTC/GMT -04:00 - America/Kralendijk</option>
                                                                                            <option value="America/La_Paz">UTC/GMT -04:00 - America/La_Paz</option>
                                                                                            <option value="America/Lima">UTC/GMT -05:00 - America/Lima</option>
                                                                                            <option value="America/Los_Angeles">UTC/GMT -07:00 - America/Los_Angeles</option>
                                                                                            <option value="America/Lower_Princes">UTC/GMT -04:00 - America/Lower_Princes</option>
                                                                                            <option value="America/Maceio">UTC/GMT -03:00 - America/Maceio</option>
                                                                                            <option value="America/Managua">UTC/GMT -06:00 - America/Managua</option>
                                                                                            <option value="America/Manaus">UTC/GMT -04:00 - America/Manaus</option>
                                                                                            <option value="America/Marigot">UTC/GMT -04:00 - America/Marigot</option>
                                                                                            <option value="America/Martinique">UTC/GMT -04:00 - America/Martinique</option>
                                                                                            <option value="America/Matamoros">UTC/GMT -05:00 - America/Matamoros</option>
                                                                                            <option value="America/Mazatlan">UTC/GMT -07:00 - America/Mazatlan</option>
                                                                                            <option value="America/Menominee">UTC/GMT -05:00 - America/Menominee</option>
                                                                                            <option value="America/Merida">UTC/GMT -06:00 - America/Merida</option>
                                                                                            <option value="America/Metlakatla">UTC/GMT -08:00 - America/Metlakatla</option>
                                                                                            <option value="America/Mexico_City">UTC/GMT -06:00 - America/Mexico_City</option>
                                                                                            <option value="America/Miquelon">UTC/GMT -02:00 - America/Miquelon</option>
                                                                                            <option value="America/Moncton">UTC/GMT -03:00 - America/Moncton</option>
                                                                                            <option value="America/Monterrey">UTC/GMT -06:00 - America/Monterrey</option>
                                                                                            <option value="America/Montevideo">UTC/GMT -03:00 - America/Montevideo</option>
                                                                                            <option value="America/Montserrat">UTC/GMT -04:00 - America/Montserrat</option>
                                                                                            <option value="America/Nassau">UTC/GMT -04:00 - America/Nassau</option>
                                                                                            <option value="America/New_York">UTC/GMT -04:00 - America/New_York</option>
                                                                                            <option value="America/Nome">UTC/GMT -08:00 - America/Nome</option>
                                                                                            <option value="America/Noronha">UTC/GMT -02:00 - America/Noronha</option>
                                                                                            <option value="America/North_Dakota/Beulah">UTC/GMT -05:00 - America/North_Dakota/Beulah</option>
                                                                                            <option value="America/North_Dakota/Center">UTC/GMT -05:00 - America/North_Dakota/Center</option>
                                                                                            <option value="America/North_Dakota/New_Salem">UTC/GMT -05:00 - America/North_Dakota/New_Salem</option>
                                                                                            <option value="America/Nuuk">UTC/GMT -02:00 - America/Nuuk</option>
                                                                                            <option value="America/Ojinaga">UTC/GMT -05:00 - America/Ojinaga</option>
                                                                                            <option value="America/Panama">UTC/GMT -05:00 - America/Panama</option>
                                                                                            <option value="America/Paramaribo">UTC/GMT -03:00 - America/Paramaribo</option>
                                                                                            <option value="America/Phoenix">UTC/GMT -07:00 - America/Phoenix</option>
                                                                                            <option value="America/Port-au-Prince">UTC/GMT -04:00 - America/Port-au-Prince</option>
                                                                                            <option value="America/Port_of_Spain">UTC/GMT -04:00 - America/Port_of_Spain</option>
                                                                                            <option value="America/Porto_Velho">UTC/GMT -04:00 - America/Porto_Velho</option>
                                                                                            <option value="America/Puerto_Rico">UTC/GMT -04:00 - America/Puerto_Rico</option>
                                                                                            <option value="America/Punta_Arenas">UTC/GMT -03:00 - America/Punta_Arenas</option>
                                                                                            <option value="America/Rankin_Inlet">UTC/GMT -05:00 - America/Rankin_Inlet</option>
                                                                                            <option value="America/Recife">UTC/GMT -03:00 - America/Recife</option>
                                                                                            <option value="America/Regina">UTC/GMT -06:00 - America/Regina</option>
                                                                                            <option value="America/Resolute">UTC/GMT -05:00 - America/Resolute</option>
                                                                                            <option value="America/Rio_Branco">UTC/GMT -05:00 - America/Rio_Branco</option>
                                                                                            <option value="America/Santarem">UTC/GMT -03:00 - America/Santarem</option>
                                                                                            <option value="America/Santiago">UTC/GMT -03:00 - America/Santiago</option>
                                                                                            <option value="America/Santo_Domingo">UTC/GMT -04:00 - America/Santo_Domingo</option>
                                                                                            <option value="America/Sao_Paulo">UTC/GMT -03:00 - America/Sao_Paulo</option>
                                                                                            <option value="America/Scoresbysund">UTC/GMT -02:00 - America/Scoresbysund</option>
                                                                                            <option value="America/Sitka">UTC/GMT -08:00 - America/Sitka</option>
                                                                                            <option value="America/St_Barthelemy">UTC/GMT -04:00 - America/St_Barthelemy</option>
                                                                                            <option value="America/St_Johns">UTC/GMT -02:30 - America/St_Johns</option>
                                                                                            <option value="America/St_Kitts">UTC/GMT -04:00 - America/St_Kitts</option>
                                                                                            <option value="America/St_Lucia">UTC/GMT -04:00 - America/St_Lucia</option>
                                                                                            <option value="America/St_Thomas">UTC/GMT -04:00 - America/St_Thomas</option>
                                                                                            <option value="America/St_Vincent">UTC/GMT -04:00 - America/St_Vincent</option>
                                                                                            <option value="America/Swift_Current">UTC/GMT -06:00 - America/Swift_Current</option>
                                                                                            <option value="America/Tegucigalpa">UTC/GMT -06:00 - America/Tegucigalpa</option>
                                                                                            <option value="America/Thule">UTC/GMT -03:00 - America/Thule</option>
                                                                                            <option value="America/Tijuana">UTC/GMT -07:00 - America/Tijuana</option>
                                                                                            <option value="America/Toronto">UTC/GMT -04:00 - America/Toronto</option>
                                                                                            <option value="America/Tortola">UTC/GMT -04:00 - America/Tortola</option>
                                                                                            <option value="America/Vancouver">UTC/GMT -07:00 - America/Vancouver</option>
                                                                                            <option value="America/Whitehorse">UTC/GMT -07:00 - America/Whitehorse</option>
                                                                                            <option value="America/Winnipeg">UTC/GMT -05:00 - America/Winnipeg</option>
                                                                                            <option value="America/Yakutat">UTC/GMT -08:00 - America/Yakutat</option>
                                                                                            <option value="Antarctica/Casey">UTC/GMT +08:00 - Antarctica/Casey</option>
                                                                                            <option value="Antarctica/Davis">UTC/GMT +07:00 - Antarctica/Davis</option>
                                                                                            <option value="Antarctica/DumontDUrville">UTC/GMT +10:00 - Antarctica/DumontDUrville</option>
                                                                                            <option value="Antarctica/Macquarie">UTC/GMT +11:00 - Antarctica/Macquarie</option>
                                                                                            <option value="Antarctica/Mawson">UTC/GMT +05:00 - Antarctica/Mawson</option>
                                                                                            <option value="Antarctica/McMurdo">UTC/GMT +13:00 - Antarctica/McMurdo</option>
                                                                                            <option value="Antarctica/Palmer">UTC/GMT -03:00 - Antarctica/Palmer</option>
                                                                                            <option value="Antarctica/Rothera">UTC/GMT -03:00 - Antarctica/Rothera</option>
                                                                                            <option value="Antarctica/Syowa">UTC/GMT +03:00 - Antarctica/Syowa</option>
                                                                                            <option value="Antarctica/Troll">UTC/GMT +00:00 - Antarctica/Troll</option>
                                                                                            <option value="Antarctica/Vostok">UTC/GMT +05:00 - Antarctica/Vostok</option>
                                                                                            <option value="Arctic/Longyearbyen">UTC/GMT +01:00 - Arctic/Longyearbyen</option>
                                                                                            <option value="Asia/Aden">UTC/GMT +03:00 - Asia/Aden</option>
                                                                                            <option value="Asia/Almaty">UTC/GMT +05:00 - Asia/Almaty</option>
                                                                                            <option value="Asia/Amman">UTC/GMT +03:00 - Asia/Amman</option>
                                                                                            <option value="Asia/Anadyr">UTC/GMT +12:00 - Asia/Anadyr</option>
                                                                                            <option value="Asia/Aqtau">UTC/GMT +05:00 - Asia/Aqtau</option>
                                                                                            <option value="Asia/Aqtobe">UTC/GMT +05:00 - Asia/Aqtobe</option>
                                                                                            <option value="Asia/Ashgabat">UTC/GMT +05:00 - Asia/Ashgabat</option>
                                                                                            <option value="Asia/Atyrau">UTC/GMT +05:00 - Asia/Atyrau</option>
                                                                                            <option value="Asia/Baghdad">UTC/GMT +03:00 - Asia/Baghdad</option>
                                                                                            <option value="Asia/Bahrain">UTC/GMT +03:00 - Asia/Bahrain</option>
                                                                                            <option value="Asia/Baku">UTC/GMT +04:00 - Asia/Baku</option>
                                                                                            <option value="Asia/Bangkok">UTC/GMT +07:00 - Asia/Bangkok</option>
                                                                                            <option value="Asia/Barnaul">UTC/GMT +07:00 - Asia/Barnaul</option>
                                                                                            <option value="Asia/Beirut">UTC/GMT +02:00 - Asia/Beirut</option>
                                                                                            <option value="Asia/Bishkek">UTC/GMT +06:00 - Asia/Bishkek</option>
                                                                                            <option value="Asia/Brunei">UTC/GMT +08:00 - Asia/Brunei</option>
                                                                                            <option value="Asia/Chita">UTC/GMT +09:00 - Asia/Chita</option>
                                                                                            <option value="Asia/Colombo">UTC/GMT +05:30 - Asia/Colombo</option>
                                                                                            <option value="Asia/Damascus">UTC/GMT +03:00 - Asia/Damascus</option>
                                                                                            <option value="Asia/Dhaka" selected="" data-select2-id="select2-data-6-a5a1">UTC/GMT +06:00 - Asia/Dhaka</option>
                                                                                            <option value="Asia/Dili">UTC/GMT +09:00 - Asia/Dili</option>
                                                                                            <option value="Asia/Dubai">UTC/GMT +04:00 - Asia/Dubai</option>
                                                                                            <option value="Asia/Dushanbe">UTC/GMT +05:00 - Asia/Dushanbe</option>
                                                                                            <option value="Asia/Famagusta">UTC/GMT +02:00 - Asia/Famagusta</option>
                                                                                            <option value="Asia/Gaza">UTC/GMT +02:00 - Asia/Gaza</option>
                                                                                            <option value="Asia/Hebron">UTC/GMT +02:00 - Asia/Hebron</option>
                                                                                            <option value="Asia/Ho_Chi_Minh">UTC/GMT +07:00 - Asia/Ho_Chi_Minh</option>
                                                                                            <option value="Asia/Hong_Kong">UTC/GMT +08:00 - Asia/Hong_Kong</option>
                                                                                            <option value="Asia/Hovd">UTC/GMT +07:00 - Asia/Hovd</option>
                                                                                            <option value="Asia/Irkutsk">UTC/GMT +08:00 - Asia/Irkutsk</option>
                                                                                            <option value="Asia/Jakarta">UTC/GMT +07:00 - Asia/Jakarta</option>
                                                                                            <option value="Asia/Jayapura">UTC/GMT +09:00 - Asia/Jayapura</option>
                                                                                            <option value="Asia/Jerusalem">UTC/GMT +02:00 - Asia/Jerusalem</option>
                                                                                            <option value="Asia/Kabul">UTC/GMT +04:30 - Asia/Kabul</option>
                                                                                            <option value="Asia/Kamchatka">UTC/GMT +12:00 - Asia/Kamchatka</option>
                                                                                            <option value="Asia/Karachi">UTC/GMT +05:00 - Asia/Karachi</option>
                                                                                            <option value="Asia/Kathmandu">UTC/GMT +05:45 - Asia/Kathmandu</option>
                                                                                            <option value="Asia/Khandyga">UTC/GMT +09:00 - Asia/Khandyga</option>
                                                                                            <option value="Asia/Kolkata">UTC/GMT +05:30 - Asia/Kolkata</option>
                                                                                            <option value="Asia/Krasnoyarsk">UTC/GMT +07:00 - Asia/Krasnoyarsk</option>
                                                                                            <option value="Asia/Kuala_Lumpur">UTC/GMT +08:00 - Asia/Kuala_Lumpur</option>
                                                                                            <option value="Asia/Kuching">UTC/GMT +08:00 - Asia/Kuching</option>
                                                                                            <option value="Asia/Kuwait">UTC/GMT +03:00 - Asia/Kuwait</option>
                                                                                            <option value="Asia/Macau">UTC/GMT +08:00 - Asia/Macau</option>
                                                                                            <option value="Asia/Magadan">UTC/GMT +11:00 - Asia/Magadan</option>
                                                                                            <option value="Asia/Makassar">UTC/GMT +08:00 - Asia/Makassar</option>
                                                                                            <option value="Asia/Manila">UTC/GMT +08:00 - Asia/Manila</option>
                                                                                            <option value="Asia/Muscat">UTC/GMT +04:00 - Asia/Muscat</option>
                                                                                            <option value="Asia/Nicosia">UTC/GMT +02:00 - Asia/Nicosia</option>
                                                                                            <option value="Asia/Novokuznetsk">UTC/GMT +07:00 - Asia/Novokuznetsk</option>
                                                                                            <option value="Asia/Novosibirsk">UTC/GMT +07:00 - Asia/Novosibirsk</option>
                                                                                            <option value="Asia/Omsk">UTC/GMT +06:00 - Asia/Omsk</option>
                                                                                            <option value="Asia/Oral">UTC/GMT +05:00 - Asia/Oral</option>
                                                                                            <option value="Asia/Phnom_Penh">UTC/GMT +07:00 - Asia/Phnom_Penh</option>
                                                                                            <option value="Asia/Pontianak">UTC/GMT +07:00 - Asia/Pontianak</option>
                                                                                            <option value="Asia/Pyongyang">UTC/GMT +09:00 - Asia/Pyongyang</option>
                                                                                            <option value="Asia/Qatar">UTC/GMT +03:00 - Asia/Qatar</option>
                                                                                            <option value="Asia/Qostanay">UTC/GMT +05:00 - Asia/Qostanay</option>
                                                                                            <option value="Asia/Qyzylorda">UTC/GMT +05:00 - Asia/Qyzylorda</option>
                                                                                            <option value="Asia/Riyadh">UTC/GMT +03:00 - Asia/Riyadh</option>
                                                                                            <option value="Asia/Sakhalin">UTC/GMT +11:00 - Asia/Sakhalin</option>
                                                                                            <option value="Asia/Samarkand">UTC/GMT +05:00 - Asia/Samarkand</option>
                                                                                            <option value="Asia/Seoul">UTC/GMT +09:00 - Asia/Seoul</option>
                                                                                            <option value="Asia/Shanghai">UTC/GMT +08:00 - Asia/Shanghai</option>
                                                                                            <option value="Asia/Singapore">UTC/GMT +08:00 - Asia/Singapore</option>
                                                                                            <option value="Asia/Srednekolymsk">UTC/GMT +11:00 - Asia/Srednekolymsk</option>
                                                                                            <option value="Asia/Taipei">UTC/GMT +08:00 - Asia/Taipei</option>
                                                                                            <option value="Asia/Tashkent">UTC/GMT +05:00 - Asia/Tashkent</option>
                                                                                            <option value="Asia/Tbilisi">UTC/GMT +04:00 - Asia/Tbilisi</option>
                                                                                            <option value="Asia/Tehran">UTC/GMT +03:30 - Asia/Tehran</option>
                                                                                            <option value="Asia/Thimphu">UTC/GMT +06:00 - Asia/Thimphu</option>
                                                                                            <option value="Asia/Tokyo">UTC/GMT +09:00 - Asia/Tokyo</option>
                                                                                            <option value="Asia/Tomsk">UTC/GMT +07:00 - Asia/Tomsk</option>
                                                                                            <option value="Asia/Ulaanbaatar">UTC/GMT +08:00 - Asia/Ulaanbaatar</option>
                                                                                            <option value="Asia/Urumqi">UTC/GMT +06:00 - Asia/Urumqi</option>
                                                                                            <option value="Asia/Ust-Nera">UTC/GMT +10:00 - Asia/Ust-Nera</option>
                                                                                            <option value="Asia/Vientiane">UTC/GMT +07:00 - Asia/Vientiane</option>
                                                                                            <option value="Asia/Vladivostok">UTC/GMT +10:00 - Asia/Vladivostok</option>
                                                                                            <option value="Asia/Yakutsk">UTC/GMT +09:00 - Asia/Yakutsk</option>
                                                                                            <option value="Asia/Yangon">UTC/GMT +06:30 - Asia/Yangon</option>
                                                                                            <option value="Asia/Yekaterinburg">UTC/GMT +05:00 - Asia/Yekaterinburg</option>
                                                                                            <option value="Asia/Yerevan">UTC/GMT +04:00 - Asia/Yerevan</option>
                                                                                            <option value="Atlantic/Azores">UTC/GMT -01:00 - Atlantic/Azores</option>
                                                                                            <option value="Atlantic/Bermuda">UTC/GMT -03:00 - Atlantic/Bermuda</option>
                                                                                            <option value="Atlantic/Canary">UTC/GMT +00:00 - Atlantic/Canary</option>
                                                                                            <option value="Atlantic/Cape_Verde">UTC/GMT -01:00 - Atlantic/Cape_Verde</option>
                                                                                            <option value="Atlantic/Faroe">UTC/GMT +00:00 - Atlantic/Faroe</option>
                                                                                            <option value="Atlantic/Madeira">UTC/GMT +00:00 - Atlantic/Madeira</option>
                                                                                            <option value="Atlantic/Reykjavik">UTC/GMT +00:00 - Atlantic/Reykjavik</option>
                                                                                            <option value="Atlantic/South_Georgia">UTC/GMT -02:00 - Atlantic/South_Georgia</option>
                                                                                            <option value="Atlantic/St_Helena">UTC/GMT +00:00 - Atlantic/St_Helena</option>
                                                                                            <option value="Atlantic/Stanley">UTC/GMT -03:00 - Atlantic/Stanley</option>
                                                                                            <option value="Australia/Adelaide">UTC/GMT +10:30 - Australia/Adelaide</option>
                                                                                            <option value="Australia/Brisbane">UTC/GMT +10:00 - Australia/Brisbane</option>
                                                                                            <option value="Australia/Broken_Hill">UTC/GMT +10:30 - Australia/Broken_Hill</option>
                                                                                            <option value="Australia/Darwin">UTC/GMT +09:30 - Australia/Darwin</option>
                                                                                            <option value="Australia/Eucla">UTC/GMT +08:45 - Australia/Eucla</option>
                                                                                            <option value="Australia/Hobart">UTC/GMT +11:00 - Australia/Hobart</option>
                                                                                            <option value="Australia/Lindeman">UTC/GMT +10:00 - Australia/Lindeman</option>
                                                                                            <option value="Australia/Lord_Howe">UTC/GMT +11:00 - Australia/Lord_Howe</option>
                                                                                            <option value="Australia/Melbourne">UTC/GMT +11:00 - Australia/Melbourne</option>
                                                                                            <option value="Australia/Perth">UTC/GMT +08:00 - Australia/Perth</option>
                                                                                            <option value="Australia/Sydney">UTC/GMT +11:00 - Australia/Sydney</option>
                                                                                            <option value="Europe/Amsterdam">UTC/GMT +01:00 - Europe/Amsterdam</option>
                                                                                            <option value="Europe/Andorra">UTC/GMT +01:00 - Europe/Andorra</option>
                                                                                            <option value="Europe/Astrakhan">UTC/GMT +04:00 - Europe/Astrakhan</option>
                                                                                            <option value="Europe/Athens">UTC/GMT +02:00 - Europe/Athens</option>
                                                                                            <option value="Europe/Belgrade">UTC/GMT +01:00 - Europe/Belgrade</option>
                                                                                            <option value="Europe/Berlin">UTC/GMT +01:00 - Europe/Berlin</option>
                                                                                            <option value="Europe/Bratislava">UTC/GMT +01:00 - Europe/Bratislava</option>
                                                                                            <option value="Europe/Brussels">UTC/GMT +01:00 - Europe/Brussels</option>
                                                                                            <option value="Europe/Bucharest">UTC/GMT +02:00 - Europe/Bucharest</option>
                                                                                            <option value="Europe/Budapest">UTC/GMT +01:00 - Europe/Budapest</option>
                                                                                            <option value="Europe/Busingen">UTC/GMT +01:00 - Europe/Busingen</option>
                                                                                            <option value="Europe/Chisinau">UTC/GMT +02:00 - Europe/Chisinau</option>
                                                                                            <option value="Europe/Copenhagen">UTC/GMT +01:00 - Europe/Copenhagen</option>
                                                                                            <option value="Europe/Dublin">UTC/GMT +00:00 - Europe/Dublin</option>
                                                                                            <option value="Europe/Gibraltar">UTC/GMT +01:00 - Europe/Gibraltar</option>
                                                                                            <option value="Europe/Guernsey">UTC/GMT +00:00 - Europe/Guernsey</option>
                                                                                            <option value="Europe/Helsinki">UTC/GMT +02:00 - Europe/Helsinki</option>
                                                                                            <option value="Europe/Isle_of_Man">UTC/GMT +00:00 - Europe/Isle_of_Man</option>
                                                                                            <option value="Europe/Istanbul">UTC/GMT +03:00 - Europe/Istanbul</option>
                                                                                            <option value="Europe/Jersey">UTC/GMT +00:00 - Europe/Jersey</option>
                                                                                            <option value="Europe/Kaliningrad">UTC/GMT +02:00 - Europe/Kaliningrad</option>
                                                                                            <option value="Europe/Kirov">UTC/GMT +03:00 - Europe/Kirov</option>
                                                                                            <option value="Europe/Kyiv">UTC/GMT +02:00 - Europe/Kyiv</option>
                                                                                            <option value="Europe/Lisbon">UTC/GMT +00:00 - Europe/Lisbon</option>
                                                                                            <option value="Europe/Ljubljana">UTC/GMT +01:00 - Europe/Ljubljana</option>
                                                                                            <option value="Europe/London">UTC/GMT +00:00 - Europe/London</option>
                                                                                            <option value="Europe/Luxembourg">UTC/GMT +01:00 - Europe/Luxembourg</option>
                                                                                            <option value="Europe/Madrid">UTC/GMT +01:00 - Europe/Madrid</option>
                                                                                            <option value="Europe/Malta">UTC/GMT +01:00 - Europe/Malta</option>
                                                                                            <option value="Europe/Mariehamn">UTC/GMT +02:00 - Europe/Mariehamn</option>
                                                                                            <option value="Europe/Minsk">UTC/GMT +03:00 - Europe/Minsk</option>
                                                                                            <option value="Europe/Monaco">UTC/GMT +01:00 - Europe/Monaco</option>
                                                                                            <option value="Europe/Moscow">UTC/GMT +03:00 - Europe/Moscow</option>
                                                                                            <option value="Europe/Oslo">UTC/GMT +01:00 - Europe/Oslo</option>
                                                                                            <option value="Europe/Paris">UTC/GMT +01:00 - Europe/Paris</option>
                                                                                            <option value="Europe/Podgorica">UTC/GMT +01:00 - Europe/Podgorica</option>
                                                                                            <option value="Europe/Prague">UTC/GMT +01:00 - Europe/Prague</option>
                                                                                            <option value="Europe/Riga">UTC/GMT +02:00 - Europe/Riga</option>
                                                                                            <option value="Europe/Rome">UTC/GMT +01:00 - Europe/Rome</option>
                                                                                            <option value="Europe/Samara">UTC/GMT +04:00 - Europe/Samara</option>
                                                                                            <option value="Europe/San_Marino">UTC/GMT +01:00 - Europe/San_Marino</option>
                                                                                            <option value="Europe/Sarajevo">UTC/GMT +01:00 - Europe/Sarajevo</option>
                                                                                            <option value="Europe/Saratov">UTC/GMT +04:00 - Europe/Saratov</option>
                                                                                            <option value="Europe/Simferopol">UTC/GMT +03:00 - Europe/Simferopol</option>
                                                                                            <option value="Europe/Skopje">UTC/GMT +01:00 - Europe/Skopje</option>
                                                                                            <option value="Europe/Sofia">UTC/GMT +02:00 - Europe/Sofia</option>
                                                                                            <option value="Europe/Stockholm">UTC/GMT +01:00 - Europe/Stockholm</option>
                                                                                            <option value="Europe/Tallinn">UTC/GMT +02:00 - Europe/Tallinn</option>
                                                                                            <option value="Europe/Tirane">UTC/GMT +01:00 - Europe/Tirane</option>
                                                                                            <option value="Europe/Ulyanovsk">UTC/GMT +04:00 - Europe/Ulyanovsk</option>
                                                                                            <option value="Europe/Vaduz">UTC/GMT +01:00 - Europe/Vaduz</option>
                                                                                            <option value="Europe/Vatican">UTC/GMT +01:00 - Europe/Vatican</option>
                                                                                            <option value="Europe/Vienna">UTC/GMT +01:00 - Europe/Vienna</option>
                                                                                            <option value="Europe/Vilnius">UTC/GMT +02:00 - Europe/Vilnius</option>
                                                                                            <option value="Europe/Volgograd">UTC/GMT +03:00 - Europe/Volgograd</option>
                                                                                            <option value="Europe/Warsaw">UTC/GMT +01:00 - Europe/Warsaw</option>
                                                                                            <option value="Europe/Zagreb">UTC/GMT +01:00 - Europe/Zagreb</option>
                                                                                            <option value="Europe/Zurich">UTC/GMT +01:00 - Europe/Zurich</option>
                                                                                            <option value="Indian/Antananarivo">UTC/GMT +03:00 - Indian/Antananarivo</option>
                                                                                            <option value="Indian/Chagos">UTC/GMT +06:00 - Indian/Chagos</option>
                                                                                            <option value="Indian/Christmas">UTC/GMT +07:00 - Indian/Christmas</option>
                                                                                            <option value="Indian/Cocos">UTC/GMT +06:30 - Indian/Cocos</option>
                                                                                            <option value="Indian/Comoro">UTC/GMT +03:00 - Indian/Comoro</option>
                                                                                            <option value="Indian/Kerguelen">UTC/GMT +05:00 - Indian/Kerguelen</option>
                                                                                            <option value="Indian/Mahe">UTC/GMT +04:00 - Indian/Mahe</option>
                                                                                            <option value="Indian/Maldives">UTC/GMT +05:00 - Indian/Maldives</option>
                                                                                            <option value="Indian/Mauritius">UTC/GMT +04:00 - Indian/Mauritius</option>
                                                                                            <option value="Indian/Mayotte">UTC/GMT +03:00 - Indian/Mayotte</option>
                                                                                            <option value="Indian/Reunion">UTC/GMT +04:00 - Indian/Reunion</option>
                                                                                            <option value="Pacific/Apia">UTC/GMT +13:00 - Pacific/Apia</option>
                                                                                            <option value="Pacific/Auckland">UTC/GMT +13:00 - Pacific/Auckland</option>
                                                                                            <option value="Pacific/Bougainville">UTC/GMT +11:00 - Pacific/Bougainville</option>
                                                                                            <option value="Pacific/Chatham">UTC/GMT +13:45 - Pacific/Chatham</option>
                                                                                            <option value="Pacific/Chuuk">UTC/GMT +10:00 - Pacific/Chuuk</option>
                                                                                            <option value="Pacific/Easter">UTC/GMT -05:00 - Pacific/Easter</option>
                                                                                            <option value="Pacific/Efate">UTC/GMT +11:00 - Pacific/Efate</option>
                                                                                            <option value="Pacific/Fakaofo">UTC/GMT +13:00 - Pacific/Fakaofo</option>
                                                                                            <option value="Pacific/Fiji">UTC/GMT +12:00 - Pacific/Fiji</option>
                                                                                            <option value="Pacific/Funafuti">UTC/GMT +12:00 - Pacific/Funafuti</option>
                                                                                            <option value="Pacific/Galapagos">UTC/GMT -06:00 - Pacific/Galapagos</option>
                                                                                            <option value="Pacific/Gambier">UTC/GMT -09:00 - Pacific/Gambier</option>
                                                                                            <option value="Pacific/Guadalcanal">UTC/GMT +11:00 - Pacific/Guadalcanal</option>
                                                                                            <option value="Pacific/Guam">UTC/GMT +10:00 - Pacific/Guam</option>
                                                                                            <option value="Pacific/Honolulu">UTC/GMT -10:00 - Pacific/Honolulu</option>
                                                                                            <option value="Pacific/Kanton">UTC/GMT +13:00 - Pacific/Kanton</option>
                                                                                            <option value="Pacific/Kiritimati">UTC/GMT +14:00 - Pacific/Kiritimati</option>
                                                                                            <option value="Pacific/Kosrae">UTC/GMT +11:00 - Pacific/Kosrae</option>
                                                                                            <option value="Pacific/Kwajalein">UTC/GMT +12:00 - Pacific/Kwajalein</option>
                                                                                            <option value="Pacific/Majuro">UTC/GMT +12:00 - Pacific/Majuro</option>
                                                                                            <option value="Pacific/Marquesas">UTC/GMT -09:30 - Pacific/Marquesas</option>
                                                                                            <option value="Pacific/Midway">UTC/GMT -11:00 - Pacific/Midway</option>
                                                                                            <option value="Pacific/Nauru">UTC/GMT +12:00 - Pacific/Nauru</option>
                                                                                            <option value="Pacific/Niue">UTC/GMT -11:00 - Pacific/Niue</option>
                                                                                            <option value="Pacific/Norfolk">UTC/GMT +12:00 - Pacific/Norfolk</option>
                                                                                            <option value="Pacific/Noumea">UTC/GMT +11:00 - Pacific/Noumea</option>
                                                                                            <option value="Pacific/Pago_Pago">UTC/GMT -11:00 - Pacific/Pago_Pago</option>
                                                                                            <option value="Pacific/Palau">UTC/GMT +09:00 - Pacific/Palau</option>
                                                                                            <option value="Pacific/Pitcairn">UTC/GMT -08:00 - Pacific/Pitcairn</option>
                                                                                            <option value="Pacific/Pohnpei">UTC/GMT +11:00 - Pacific/Pohnpei</option>
                                                                                            <option value="Pacific/Port_Moresby">UTC/GMT +10:00 - Pacific/Port_Moresby</option>
                                                                                            <option value="Pacific/Rarotonga">UTC/GMT -10:00 - Pacific/Rarotonga</option>
                                                                                            <option value="Pacific/Saipan">UTC/GMT +10:00 - Pacific/Saipan</option>
                                                                                            <option value="Pacific/Tahiti">UTC/GMT -10:00 - Pacific/Tahiti</option>
                                                                                            <option value="Pacific/Tarawa">UTC/GMT +12:00 - Pacific/Tarawa</option>
                                                                                            <option value="Pacific/Tongatapu">UTC/GMT +13:00 - Pacific/Tongatapu</option>
                                                                                            <option value="Pacific/Wake">UTC/GMT +12:00 - Pacific/Wake</option>
                                                                                            <option value="Pacific/Wallis">UTC/GMT +12:00 - Pacific/Wallis</option>
                                                                                            <option value="UTC">UTC/GMT +00:00 - UTC</option>
                                                                                    </select><span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="select2-data-5-xhvh" style="width: auto;"><span class="selection"><span class="select2-selection select2-selection--single" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-disabled="false" aria-labelledby="select2-timezone-container" aria-controls="select2-timezone-container"><span class="select2-selection__rendered" id="select2-timezone-container" role="textbox" aria-readonly="true" title="UTC/GMT +06:00 - Asia/Dhaka"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
                                                                            </div>
                                </div>
                            </div>
                            <div class="row mt-20">
                                <div class="col-md-12 pd-bottom pb-2">
                                    <button type="submit" class="btn bg-primary add-option-btn w-100 setting-btn f-16 leading-20 gilroy-medium" id="profileUpdateSubmitBtn">
                                        <div class="spinner spinner-border text-white spinner-border-sm mx-2 d-none" role="status">
                                            <span class="visually-hidden"></span>
                                        </div>
                                        <span id="profileUpdateSubmitBtnText">Save Changes</span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Personal Information View Div  -->
    <div class="profile-info-body d-flex profile-wraps justify-content-between mt-36">
        <div class="left-profile-info w-50">
            <div class="d-flex gap-3 justify-content-between profile-borders-bottom">
                <p class="mb-0 f-15 leading-18 text-dark gilroy-medium text-align-initial">Name</p>
                <p class="mb-0 f-15 leading-18 text-gray-100 gilroy-medium text-align-end"><?php echo $_SESSION['username']; ?></p>
            </div>
          
            
        </div>
    </div>
</div>
            <!-- main-containt -->

          </div>
        </div>
       </div>

       <!-- footer -->
       <footer class="d-flex align-items-center justify-content-between bg-white w-100 px-4 footer-sec">
    <div class="res-order d-flex align-items-center">
        <p class="mb-0 gilroy-medium">Copyright © 2024&nbsp;<a href="https://Quantumsecurenova.com" class="link-text">Web3</a>&nbsp;|&nbsp;All Rights Reserved.</p>
        <span class="d-none">4.0.1</span>
    </div>
    <div class="d-flex f-link align-items-center">
        <div>
            <div class="d-flex align-items-center text-gray-100 f-13 blink-w sp" id="select_language">
                <div class="form-group selectParent f-13">
                    <select class="select2 form-control f-13 mb-2n select2-hidden-accessible" data-minimum-results-for-search="Infinity" id="select-height" data-select2-id="select2-data-select-height" tabindex="-1" aria-hidden="true">
                                                    <option class="f-13 gilroy-medium" selected="" value="en" data-select2-id="select2-data-8-8fwc">English</option>
                                                    <option class="f-13 gilroy-medium" value="ar">عربى</option>
                                                    <option class="f-13 gilroy-medium" value="fr">Français</option>
                                                    <option class="f-13 gilroy-medium" value="pt">Português</option>
                                                    <option class="f-13 gilroy-medium" value="ru">Русский</option>
                                                    <option class="f-13 gilroy-medium" value="es">Español</option>
                                                    <option class="f-13 gilroy-medium" value="tr">Türkçe</option>
                                                    <option class="f-13 gilroy-medium" value="ch">中文 (繁體)</option>
                                            </select><span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="select2-data-7-1s5m" style="width: 95px;"><span class="selection"><span class="select2-selection select2-selection--single" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-disabled="false" aria-labelledby="select2-select-height-container" aria-controls="select2-select-height-container"><span class="select2-selection__rendered" id="select2-select-height-container" role="textbox" aria-readonly="true" title="English">English</span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
                </div>
            </div>
        </div>
    </div>
    
 
</footer>       <!-- end footer -->

    </div>

    <!-- js -->
    <script src="public/dist/libraries/jquery-3.6.1/jquery-3.6.1.min.js"></script>
<script src="public/dist/libraries/bootstrap-5.0.2/js/bootstrap.bundle.min.js"></script>
<script src="public/dist/plugins/select2-4.1.0-rc.0/js/select2.min.js"></script>
<script src="public/user/templates/js/chart.umd.min.js"></script>
<script src="public/user/templates/js/main.min.js"></script>
<script src="public/user/customs/js/common.min.js"></script>

<script type="text/javascript">
    var SITE_URL = "https://Quantumsecurenova.com";
    var FIATDP = "0.00";
    var CRYPTODP = "0.00000000";

	$(document).ready(function() {
		$("#select_language").on("change", function() {
			if($("#select_language select").val() == 'ar'){
				localStorage.setItem('lang', 'ar');
				let lang = $("#select_language select").val();

				$.ajax({
					type: 'get',
					url: 'https://Quantumsecurenova.com/change-lang',
					data: {lang: lang},
					success: function (msg) {
						if (msg == 1) {
							location.reload();
							$("html").attr("dir", "rtl");
						}
					}
				});

			} else {
				let lang = $("#select_language select").val();
				$.ajax({
					type: 'get',
					url: 'https://Quantumsecurenova.com/change-lang',
					data: {lang: lang},
					success: function (msg) {
						if (msg == 1) {
							location.reload()
							localStorage.setItem('lang', lang);
							$("html").removeAttr("dir", "rtl");
						}
					}
				});
			}
		});
	});  

</script>

<script src="public/dist/plugins/html5-validation-1.0.0/validation.min.js" type="text/javascript"></script>
<script src="public/dist/plugins/intl-tel-input-17.0.19/js/intlTelInput-jquery.min.js" type="text/javascript"></script>
<script src="public/dist/js/isValidPhoneNumber.min.js" type="text/javascript"></script>
<script src="public/dist/libraries/sweetalert/sweetalert-unpkg.min.js" type="text/javascript"></script>
<script>
    'use strict';
    var csrfToken = 'AWO37hEyyaFjyNu7gt4uBj6e66n0lDGYYU2YPoWc';
    var userId = $('#id').val();
    var countryShortCode = 'US';
    var utilsScriptLoadingPath = 'public/dist/plugins/intl-tel-input-17.0.19/js/utils.min.js';
    var validPhoneNumberErrorText = 'Please enter a valid international phone number.';
    var formattedPhoneNumber = "+266452";
    var defaultCountry = "ng";
    var carrierCode = "234";
    var printQrCodeUrl = "public/qr-code-print/6160/user";
    var updateQrCodeUrl = "public/qr-code/add-or-update";
    var profileImageUploadUrl = "profile.php-image-upload";
    var duplicatePhoneCheckUrl = "public/duplicate-phone-number-check";
    var pleaseWaitText = "Please Wait";
    var loadingText = 'Loading...';
    var errorText = 'Error!';
    var updateQrCodeText = "Update QR Code";
    var submitButtonText = "Submitting...";
</script>
<script src="public/user/customs/js/phone.min.js" type="text/javascript"></script>
<script src="public/user/customs/js/profile.min.js" type="text/javascript"></script>
    <!-- end js -->
 <!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/6726b15c2480f5b4f597ef78/1ibni9l16';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->

  
</body></html>