<?php
session_start();

// Define upload directory
$uploadDir = __DIR__ . '/uploads/kyc/';
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// Allowed file types and max size (5MB)
$allowedTypes = ['image/jpeg', 'image/png', 'application/pdf'];
$maxFileSize = 5 * 1024 * 1024;

// Helper to validate uploaded file
function validateFile($file, $label) {
    global $allowedTypes, $maxFileSize;

    if ($file['error'] !== UPLOAD_ERR_OK) {
        return "$label upload failed.";
    }
    if (!in_array($file['type'], $allowedTypes)) {
        return "$label must be JPG, PNG, or PDF.";
    }
    if ($file['size'] > $maxFileSize) {
        return "$label exceeds 5MB limit.";
    }
    return null;
}

// Validate form inputs
$errors = [];

$fullName = trim($_POST['full_name'] ?? '');
$documentType = $_POST['document_type'] ?? '';

if ($fullName === '') {
    $errors[] = "Full name is required.";
}
if (!in_array($documentType, ['passport', 'driver_license', 'national_id'])) {
    $errors[] = "Invalid document type.";
}

$idFront = $_FILES['id_front'] ?? null;
$selfie = $_FILES['selfie'] ?? null;

if (!$idFront || !$selfie) {
    $errors[] = "Both ID and Selfie files are required.";
} else {
    $idFrontError = validateFile($idFront, 'ID Front');
    $selfieError = validateFile($selfie, 'Selfie');
    if ($idFrontError) $errors[] = $idFrontError;
    if ($selfieError) $errors[] = $selfieError;
}

// If any errors, redirect back
if (!empty($errors)) {
    $_SESSION['kyc_error'] = implode('<br>', $errors);
    header("Location: kyc.php");
    exit;
}

// Generate safe file names
$idFrontName = uniqid('id_') . '_' . basename($idFront['name']);
$selfieName = uniqid('selfie_') . '_' . basename($selfie['name']);

move_uploaded_file($idFront['tmp_name'], $uploadDir . $idFrontName);
move_uploaded_file($selfie['tmp_name'], $uploadDir . $selfieName);

// Store to DB (example using PDO)
try {
    $pdo = new PDO("mysql:host=localhost;dbname=jcnmouoi_vic", "jcnmouoi_vic", "Jesusis12@1");
    $stmt = $pdo->prepare("INSERT INTO kyc_requests (user_id, full_name, document_type, id_front_path, selfie_path, status, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
    
    $stmt->execute([
        $_SESSION['user_id'],  // assuming user is logged in
        $fullName,
        $documentType,
        'uploads/kyc/' . $idFrontName,
        'uploads/kyc/' . $selfieName,
        'pending'
    ]);

    $_SESSION['kyc_success'] = "KYC submitted successfully. We'll notify you once it's reviewed.";
    header("Location: dashboard.php");
    exit;

} catch (PDOException $e) {
    $_SESSION['kyc_error'] = "Database error: " . $e->getMessage();
    header("Location: kyc.php");
    exit;
}
