<?php
session_start();
require '../secure/Database.php';
require '../secure/connect.php';
$database = new Database;

if (!isset($_SESSION['email'])) {
    header('Location: ../../index.html');
    exit;
}

$name = $_SESSION['email'];
// ---------------------------------------------------------------
// FETCH USER PROFILE PHOTO
// ---------------------------------------------------------------
$user_photo = "public/dist/images/default-avatar.png"; // default avatar

$stmt = $conn->prepare("SELECT profile_photo FROM user WHERE email = ?");
$stmt->bind_param("s", $name);
$stmt->execute();
$stmt->bind_result($profilePhotoDB);
$stmt->fetch();
$stmt->close();

if (!empty($profilePhotoDB)) {
    // Adjust this path depending on your folder structure
    $user_photo = "../uploads/profile/" . $profilePhotoDB;
}

// ✅ Function to get total confirmed deposits per wallet
function getWalletSum($conn, $name, $wallet = null) {
    if ($wallet) {
        $sql = "SELECT SUM(amount) AS total FROM deposit WHERE username = '$name' AND status = 'confirm' AND wallet = '$wallet'";
    } else {
        $sql = "SELECT SUM(amount) AS total FROM deposit WHERE username = '$name' AND status = 'confirm'";
    }
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    return $row['total'] ?? 0;
}

// ✅ Fetch deposit totals for each wallet
$sumusdt   = getWalletSum($conn, $name, 'Usdt');
$sumbtc    = getWalletSum($conn, $name, 'Bitcoin');
$sumeth    = getWalletSum($conn, $name, 'Ethereum');
$sumdoge   = getWalletSum($conn, $name, 'DOGE');
$sumxlm    = getWalletSum($conn, $name, 'Xlm');
$sumxrp    = getWalletSum($conn, $name, 'Xrp');
$summatic  = getWalletSum($conn, $name, 'MATIC');
$sumalgo   = getWalletSum($conn, $name, 'ALGO');
$sumxdc    = getWalletSum($conn, $name, 'XDC');
$sumsafe   = getWalletSum($conn, $name, 'Safemoon');
$sumbnb    = getWalletSum($conn, $name, 'BNB');
$sumltc    = getWalletSum($conn, $name, 'LTC');
$sumada    = getWalletSum($conn, $name, 'ADA');
$sumpepe   = getWalletSum($conn, $name, 'PEPE');

// ✅ Define wallets before calculating totals
$wallets = [
    ['label'=>'USD',  'value'=>$sumusdt,  'icon'=>'icons8-us-dollar-64.png', 'id'=>null],
    ['label'=>'BTC',  'value'=>$sumbtc,   'icon'=>'1698103759.png', 'id'=>'bitcoin'],
    ['label'=>'ETH',  'value'=>$sumeth,   'icon'=>'1698011100.png', 'id'=>'ethereum'],
    ['label'=>'DOGE', 'value'=>$sumdoge,  'icon'=>'1698104977.png', 'id'=>'dogecoin'],
    ['label'=>'ADA',  'value'=>$sumada,   'icon'=>'images.jpeg',    'id'=>'cardano'],
    ['label'=>'XLM',  'value'=>$sumxlm,   'icon'=>'1698104729.png', 'id'=>'stellar'],
    ['label'=>'XRP',  'value'=>$sumxrp,   'icon'=>'1698104378.png', 'id'=>'ripple'],
    ['label'=>'MATIC','value'=>$summatic, 'icon'=>'matic.png',    'id'=>'matic-network'],
    ['label'=>'ALGO', 'value'=>$sumalgo,  'icon'=>'1698105102.png', 'id'=>'algorand'],
    ['label'=>'XDC',  'value'=>$sumxdc,   'icon'=>'xdc.png', 'id'=>'xdce-crowd-sale'],
    ['label'=>'PEPE', 'value'=>$sumpepe,  'icon'=>'images2.png',    'id'=>'pepe'],
    ['label'=>'BNB', 'value'=>$sumbnb, 'icon'=>'bnb.png', 'id'=>'binancecoin'],
];



// ✅ Fetch live rates
echo '<meta http-equiv="refresh" content="120">'; // Auto refresh every 2 minutes
$apiUrl = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum,cardano,stellar,pepe,matic-network,ripple,litecoin,dogecoin,algorand,xdce-crowd-sale,binancecoin&vs_currencies=usd&include_24hr_change=true";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$response = curl_exec($ch);
curl_close($ch);

$rates = $response ? json_decode($response, true) : [];

// ✅ Helper functions
function safeRate($id, $rates) {
    return isset($rates[$id]['usd']) ? (float)$rates[$id]['usd'] : 0;
}
function safeChange($id, $rates) {
    return isset($rates[$id]['usd_24h_change']) ? (float)$rates[$id]['usd_24h_change'] : 0;
}

// ---------- Calculate total balance + total change ----------
$total_balance = 0;
$total_change_weighted = 0;

foreach ($wallets as $w) {
    $coinValue = (float)$w['value'];
    $cgId = $w['id'];
    $rate = $cgId ? safeRate($cgId, $rates) : 1;
    $change = $cgId ? safeChange($cgId, $rates) : 0;
    $usdVal = $cgId ? ($coinValue * $rate) : $coinValue;

    $total_balance += $usdVal;

    if ($cgId && $usdVal > 0) {
        $total_change_weighted += ($change * $usdVal);
    }
}

// Weighted 24h % change
$overall_change = $total_balance > 0 ? ($total_change_weighted / $total_balance) : 0;
$change_color = $overall_change > 0 ? 'text-success' : ($overall_change < 0 ? 'text-danger' : 'text-muted');
$change_sign = $overall_change > 0 ? '+' : '';
?>
<html lang="en"><head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="twoone.tech">
    <meta name="csrf-token" content="Y7XsKHHQOFjcTQhAdQNSey3FYuwEZ17QzbYHwLwF">

    <title>Dashboard | Web3</title>

    <!-- css -->
    <link rel="stylesheet" href="public/dist/libraries/bootstrap-5.0.2/css/bootstrap.min.css">
<link rel="stylesheet" href="public/dist/plugins/select2-4.1.0-rc.0/css/select2.min.css">
<link rel="stylesheet" href="public/user/templates/css/style.min.css">
    <!-- end css -->
    
    <!-- favicon -->
    <link rel="shortcut icon" href="public/uploads/logos/1698017319_favicon.PNG">

    <script>
      'use strict';
      var SITE_URL = "https://web3networkvault.com";
      var FIATDP = "0.00";
      var CRYPTODP = "0.00000000";

      if (localStorage.getItem('dark') === '1') {
        document.documentElement.classList.add('dark');
      }

      if (localStorage.getItem('lang') == 'ar') {
        document.getElementsByTagName("html")[0].setAttribute("dir", "rtl");
        document.querySelector("html").setAttribute("dir", "rtl");
      } else {
        document.querySelector("html").removeAttribute("dir", "rtl");
      }
    </script>
  </head>
  <body cz-shortcut-listen="true">

    <!-- sidebar section -->
    <!-- Sidebar Start -->
<div class="side-navbar active-nav d-flex justify-content-between flex-wrap flex-column" id="sidebar">
    <div class="bg-secondary vh-100 position-fixed d-flex flex-column w-inherit drop-parent">
        <div>
            <a href="https://web3networkvault.com"><img class="ml-40 mt-20 pay-logo img-fluid" src="public/uploads/logos/1698017319_logo.png" alt="Web3"></a>
        </div>
        <div class="flex-grow-1 px-4 px-res mt-43 bg-secondary position-relative overflow-auto hide-thin-scrollbar thin-scrollbar">
            <ul class="list-unstyled ps-0 accordion accordion-flush position-absolute w-268" id="accordion-menu">

                <!-- Dashboard -->
                <li>
                    <a href="index.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-white bg-info">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.8611 13.8016H4.98016C4.7202 13.8016 4.4709 13.9049 4.28708 14.0887C4.10327 14.2725 4 14.5218 4 14.7817V20.6627C4 20.9227 4.10327 21.172 4.28708 21.3558C4.4709 21.5396 4.7202 21.6429 4.98016 21.6429H10.8611C11.1211 21.6429 11.3704 21.5396 11.5542 21.3558C11.738 21.172 11.8413 20.9227 11.8413 20.6627V14.7817C11.8413 14.5218 11.738 14.2725 11.5542 14.0887C11.3704 13.9049 11.1211 13.8016 10.8611 13.8016ZM9.88095 19.6825H5.96032V15.7619H9.88095V19.6825ZM20.6627 4H14.7817C14.5218 4 14.2725 4.10327 14.0887 4.28708C13.9049 4.4709 13.8016 4.7202 13.8016 4.98016V10.8611C13.8016 11.1211 13.9049 11.3704 14.0887 11.5542C14.2725 11.738 14.5218 11.8413 14.7817 11.8413H20.6627C20.9227 11.8413 21.172 11.738 21.3558 11.5542C21.5396 11.3704 21.6429 11.1211 21.6429 10.8611V4.98016C21.6429 4.7202 21.5396 4.4709 21.3558 4.28708C21.172 4.10327 20.9227 4 20.6627 4ZM19.6825 9.88095H15.7619V5.96032H19.6825V9.88095ZM20.6627 16.7421H18.7024V14.7817C18.7024 14.5218 18.5991 14.2725 18.4153 14.0887C18.2315 13.9049 17.9822 13.8016 17.7222 13.8016C17.4623 13.8016 17.213 13.9049 17.0291 14.0887C16.8453 14.2725 16.7421 14.5218 16.7421 14.7817V16.7421H14.7817C14.5218 16.7421 14.2725 16.8453 14.0887 17.0291C13.9049 17.213 13.8016 17.4623 13.8016 17.7222C13.8016 17.9822 13.9049 18.2315 14.0887 18.4153C14.2725 18.5991 14.5218 18.7024 14.7817 18.7024H16.7421V20.6627C16.7421 20.9227 16.8453 21.172 17.0291 21.3558C17.213 21.5396 17.4623 21.6429 17.7222 21.6429C17.9822 21.6429 18.2315 21.5396 18.4153 21.3558C18.5991 21.172 18.7024 20.9227 18.7024 20.6627V18.7024H20.6627C20.9227 18.7024 21.172 18.5991 21.3558 18.4153C21.5396 18.2315 21.6429 17.9822 21.6429 17.7222C21.6429 17.4623 21.5396 17.213 21.3558 17.0291C21.172 16.8453 20.9227 16.7421 20.6627 16.7421ZM10.8611 4H4.98016C4.7202 4 4.4709 4.10327 4.28708 4.28708C4.10327 4.4709 4 4.7202 4 4.98016V10.8611C4 11.1211 4.10327 11.3704 4.28708 11.5542C4.4709 11.738 4.7202 11.8413 4.98016 11.8413H10.8611C11.1211 11.8413 11.3704 11.738 11.5542 11.5542C11.738 11.3704 11.8413 11.1211 11.8413 10.8611V4.98016C11.8413 4.7202 11.738 4.4709 11.5542 4.28708C11.3704 4.10327 11.1211 4 10.8611 4ZM9.88095 9.88095H5.96032V5.96032H9.88095V9.88095Z" fill="#FFAF30"></path>
                            </svg></span>
                        <span>Dashboard</span>
                    </a>
                </li>

                <!-- Wallets -->
                <li>
                    <a href="wallet.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.44369 5.6875L16.9313 5.6875C17.3596 5.68749 17.7291 5.68748 18.0335 5.71234C18.3547 5.73859 18.6742 5.79653 18.9816 5.95317C19.4402 6.18687 19.8131 6.55976 20.0468 7.0184C20.2035 7.32583 20.2614 7.64532 20.2877 7.96654C20.3125 8.27088 20.3125 8.64037 20.3125 9.06867V10.2956C21.1151 10.5791 21.7213 11.2668 21.8907 12.1182C21.938 12.3562 21.9378 12.6225 21.9375 12.9319C21.9375 12.9543 21.9375 12.9771 21.9375 13C21.9375 13.023 21.9375 13.0457 21.9375 13.0682C21.9378 13.3775 21.938 13.6438 21.8907 13.8818C21.7213 14.7332 21.1151 15.4209 20.3125 15.7044V16.9313C20.3125 17.3596 20.3125 17.7291 20.2877 18.0335C20.2614 18.3547 20.2035 18.6742 20.0468 18.9816C19.8131 19.4402 19.4402 19.8131 18.9816 20.0468C18.6742 20.2035 18.3547 20.2614 18.0335 20.2877C17.7291 20.3125 17.3596 20.3125 16.9313 20.3125L7.44367 20.3125C7.01537 20.3125 6.64588 20.3125 6.34154 20.2877C6.02032 20.2614 5.70083 20.2035 5.3934 20.0468C4.93475 19.8131 4.56186 19.4402 4.32817 18.9816C4.17153 18.6742 4.11358 18.3547 4.08734 18.0335C4.06247 17.7291 4.06249 17.3596 4.0625 16.9313V9.06868C4.06249 8.64038 4.06247 8.27088 4.08734 7.96654C4.11358 7.64532 4.17153 7.32583 4.32817 7.0184C4.56186 6.55975 4.93475 6.18686 5.3934 5.95317C5.70083 5.79653 6.02032 5.73858 6.34154 5.71234C6.64588 5.68747 7.01538 5.68749 7.44369 5.6875ZM18.6875 15.8438H17.4688C17.4458 15.8438 17.4231 15.8438 17.4006 15.8438C17.0913 15.844 16.8249 15.8442 16.587 15.7969C15.62 15.6046 14.8642 14.8487 14.6718 13.8818C14.6245 13.6438 14.6247 13.3775 14.625 13.0682C14.625 13.0457 14.625 13.023 14.625 13C14.625 12.9771 14.625 12.9543 14.625 12.9318C14.6247 12.6225 14.6245 12.3562 14.6718 12.1182C14.8642 11.1513 15.62 10.3954 16.587 10.2031C16.8249 10.1558 17.0913 10.156 17.4006 10.1562C17.4231 10.1562 17.4458 10.1563 17.4688 10.1563H18.6875V9.1C18.6875 8.63155 18.6869 8.32908 18.6681 8.09887C18.65 7.87814 18.6194 7.79631 18.5989 7.75613C18.521 7.60325 18.3968 7.47896 18.2439 7.40106C18.2037 7.38059 18.1219 7.34998 17.9011 7.33194C17.6709 7.31313 17.3684 7.3125 16.9 7.3125H7.475C7.00655 7.3125 6.70408 7.31313 6.47387 7.33194C6.25314 7.34998 6.17131 7.38059 6.13113 7.40106C5.97825 7.47896 5.85396 7.60325 5.77606 7.75613C5.75559 7.79631 5.72498 7.87814 5.70694 8.09887C5.68813 8.32908 5.6875 8.63155 5.6875 9.1V16.9C5.6875 17.3685 5.68813 17.6709 5.70694 17.9011C5.72498 18.1219 5.75559 18.2037 5.77606 18.2439C5.85396 18.3967 5.97825 18.521 6.13113 18.5989C6.17131 18.6194 6.25314 18.65 6.47387 18.6681C6.70408 18.6869 7.00655 18.6875 7.475 18.6875L16.9 18.6875C17.3685 18.6875 17.6709 18.6869 17.9011 18.6681C18.1219 18.65 18.2037 18.6194 18.2439 18.5989C18.3968 18.521 18.521 18.3967 18.5989 18.2439C18.6194 18.2037 18.65 18.1219 18.6681 17.9011C18.6869 17.6709 18.6875 17.3685 18.6875 16.9V15.8438ZM17.4688 11.7813C17.0523 11.7813 16.9627 11.7852 16.904 11.7969C16.5817 11.861 16.3297 12.1129 16.2656 12.4352C16.2539 12.4939 16.25 12.5835 16.25 13C16.25 13.4165 16.2539 13.5061 16.2656 13.5648C16.3297 13.8871 16.5817 14.139 16.904 14.2031C16.9627 14.2148 17.0523 14.2188 17.4688 14.2188H19.0938C19.5102 14.2188 19.5998 14.2148 19.6585 14.2031C19.9808 14.139 20.2328 13.8871 20.2969 13.5648C20.3086 13.5061 20.3125 13.4165 20.3125 13C20.3125 12.5835 20.3086 12.4939 20.2969 12.4352C20.2328 12.1129 19.9808 11.861 19.6585 11.7969C19.5998 11.7852 19.5102 11.7813 19.0938 11.7813H17.4688Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Wallets</span>
                    </a>
                </li>
                <!-- Cards -->
                  <li>
                    <a href="cards.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.44369 5.6875L16.9313 5.6875C17.3596 5.68749 17.7291 5.68748 18.0335 5.71234C18.3547 5.73859 18.6742 5.79653 18.9816 5.95317C19.4402 6.18687 19.8131 6.55976 20.0468 7.0184C20.2035 7.32583 20.2614 7.64532 20.2877 7.96654C20.3125 8.27088 20.3125 8.64037 20.3125 9.06867V10.2956C21.1151 10.5791 21.7213 11.2668 21.8907 12.1182C21.938 12.3562 21.9378 12.6225 21.9375 12.9319C21.9375 12.9543 21.9375 12.9771 21.9375 13C21.9375 13.023 21.9375 13.0457 21.9375 13.0682C21.9378 13.3775 21.938 13.6438 21.8907 13.8818C21.7213 14.7332 21.1151 15.4209 20.3125 15.7044V16.9313C20.3125 17.3596 20.3125 17.7291 20.2877 18.0335C20.2614 18.3547 20.2035 18.6742 20.0468 18.9816C19.8131 19.4402 19.4402 19.8131 18.9816 20.0468C18.6742 20.2035 18.3547 20.2614 18.0335 20.2877C17.7291 20.3125 17.3596 20.3125 16.9313 20.3125L7.44367 20.3125C7.01537 20.3125 6.64588 20.3125 6.34154 20.2877C6.02032 20.2614 5.70083 20.2035 5.3934 20.0468C4.93475 19.8131 4.56186 19.4402 4.32817 18.9816C4.17153 18.6742 4.11358 18.3547 4.08734 18.0335C4.06247 17.7291 4.06249 17.3596 4.0625 16.9313V9.06868C4.06249 8.64038 4.06247 8.27088 4.08734 7.96654C4.11358 7.64532 4.17153 7.32583 4.32817 7.0184C4.56186 6.55975 4.93475 6.18686 5.3934 5.95317C5.70083 5.79653 6.02032 5.73858 6.34154 5.71234C6.64588 5.68747 7.01538 5.68749 7.44369 5.6875ZM18.6875 15.8438H17.4688C17.4458 15.8438 17.4231 15.8438 17.4006 15.8438C17.0913 15.844 16.8249 15.8442 16.587 15.7969C15.62 15.6046 14.8642 14.8487 14.6718 13.8818C14.6245 13.6438 14.6247 13.3775 14.625 13.0682C14.625 13.0457 14.625 13.023 14.625 13C14.625 12.9771 14.625 12.9543 14.625 12.9318C14.6247 12.6225 14.6245 12.3562 14.6718 12.1182C14.8642 11.1513 15.62 10.3954 16.587 10.2031C16.8249 10.1558 17.0913 10.156 17.4006 10.1562C17.4231 10.1562 17.4458 10.1563 17.4688 10.1563H18.6875V9.1C18.6875 8.63155 18.6869 8.32908 18.6681 8.09887C18.65 7.87814 18.6194 7.79631 18.5989 7.75613C18.521 7.60325 18.3968 7.47896 18.2439 7.40106C18.2037 7.38059 18.1219 7.34998 17.9011 7.33194C17.6709 7.31313 17.3684 7.3125 16.9 7.3125H7.475C7.00655 7.3125 6.70408 7.31313 6.47387 7.33194C6.25314 7.34998 6.17131 7.38059 6.13113 7.40106C5.97825 7.47896 5.85396 7.60325 5.77606 7.75613C5.75559 7.79631 5.72498 7.87814 5.70694 8.09887C5.68813 8.32908 5.6875 8.63155 5.6875 9.1V16.9C5.6875 17.3685 5.68813 17.6709 5.70694 17.9011C5.72498 18.1219 5.75559 18.2037 5.77606 18.2439C5.85396 18.3967 5.97825 18.521 6.13113 18.5989C6.17131 18.6194 6.25314 18.65 6.47387 18.6681C6.70408 18.6869 7.00655 18.6875 7.475 18.6875L16.9 18.6875C17.3685 18.6875 17.6709 18.6869 17.9011 18.6681C18.1219 18.65 18.2037 18.6194 18.2439 18.5989C18.3968 18.521 18.521 18.3967 18.5989 18.2439C18.6194 18.2037 18.65 18.1219 18.6681 17.9011C18.6869 17.6709 18.6875 17.3685 18.6875 16.9V15.8438ZM17.4688 11.7813C17.0523 11.7813 16.9627 11.7852 16.904 11.7969C16.5817 11.861 16.3297 12.1129 16.2656 12.4352C16.2539 12.4939 16.25 12.5835 16.25 13C16.25 13.4165 16.2539 13.5061 16.2656 13.5648C16.3297 13.8871 16.5817 14.139 16.904 14.2031C16.9627 14.2148 17.0523 14.2188 17.4688 14.2188H19.0938C19.5102 14.2188 19.5998 14.2148 19.6585 14.2031C19.9808 14.139 20.2328 13.8871 20.2969 13.5648C20.3086 13.5061 20.3125 13.4165 20.3125 13C20.3125 12.5835 20.3086 12.4939 20.2969 12.4352C20.2328 12.1129 19.9808 11.861 19.6585 11.7969C19.5998 11.7852 19.5102 11.7813 19.0938 11.7813H17.4688Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Web3 Cards</span>
                    </a>
                </li>
               
                <li class="mb-21 d-flex align-items-center res-trans text-warning f-13 ml-20 mt-39 gilroy-Semibold text-uppercase">Transactions</li>

                <!-- Transactions -->
                <li>
                    <a href="transactions.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M19.5 4.875H11.375C10.7285 4.875 10.1085 5.13181 9.65143 5.58893C9.19431 6.04605 8.9375 6.66603 8.9375 7.3125V13C8.9375 13.6465 9.19431 14.2665 9.65143 14.7236C10.1085 15.1807 10.7285 15.4375 11.375 15.4375H19.5C20.1465 15.4375 20.7665 15.1807 21.2236 14.7236C21.6807 14.2665 21.9375 13.6465 21.9375 13V7.3125C21.9375 6.66603 21.6807 6.04605 21.2236 5.58893C20.7665 5.13181 20.1465 4.875 19.5 4.875ZM20.3125 13C20.3125 13.2155 20.2269 13.4222 20.0745 13.5745C19.9222 13.7269 19.7155 13.8125 19.5 13.8125H11.375C11.1595 13.8125 10.9528 13.7269 10.8005 13.5745C10.6481 13.4222 10.5625 13.2155 10.5625 13V7.3125C10.5625 7.09701 10.6481 6.89035 10.8005 6.73798C10.9528 6.5856 11.1595 6.5 11.375 6.5H19.5C19.7155 6.5 19.9222 6.5856 20.0745 6.73798C20.2269 6.89035 20.3125 7.09701 20.3125 7.3125V13ZM17.4688 9.75C17.168 9.75102 16.8783 9.86398 16.6562 10.0669C16.4815 9.90807 16.2645 9.80344 16.0314 9.76568C15.7983 9.72793 15.5593 9.75868 15.3434 9.85421C15.1275 9.94973 14.944 10.1059 14.8152 10.3038C14.6863 10.5016 14.6178 10.7327 14.6178 10.9688C14.6178 11.2048 14.6863 11.4359 14.8152 11.6337C14.944 11.8316 15.1275 11.9878 15.3434 12.0833C15.5593 12.1788 15.7983 12.2096 16.0314 12.1718C16.2645 12.1341 16.4815 12.0294 16.6562 11.8706C16.803 12.004 16.98 12.0995 17.172 12.149C17.364 12.1984 17.5652 12.2003 17.7581 12.1544C17.951 12.1085 18.1297 12.0162 18.2789 11.8856C18.4281 11.755 18.5431 11.5899 18.614 11.4048C18.685 11.2196 18.7097 11.02 18.686 10.8231C18.6623 10.6263 18.5909 10.4382 18.4781 10.2751C18.3653 10.1121 18.2144 9.97906 18.0385 9.88755C17.8626 9.79604 17.667 9.74883 17.4688 9.75ZM16.25 17.0625C16.0345 17.0625 15.8278 17.1481 15.6755 17.3005C15.5231 17.4528 15.4375 17.6595 15.4375 17.875V18.6875C15.4375 18.903 15.3519 19.1097 15.1995 19.262C15.0472 19.4144 14.8405 19.5 14.625 19.5H6.5C6.28451 19.5 6.07785 19.4144 5.92548 19.262C5.7731 19.1097 5.6875 18.903 5.6875 18.6875V15.4375H6.5C6.71549 15.4375 6.92215 15.3519 7.07452 15.1995C7.2269 15.0472 7.3125 14.8405 7.3125 14.625C7.3125 14.4095 7.2269 14.2028 7.07452 14.0505C6.92215 13.8981 6.71549 13.8125 6.5 13.8125H5.6875V13C5.6875 12.7845 5.7731 12.5778 5.92548 12.4255C6.07785 12.2731 6.28451 12.1875 6.5 12.1875C6.71549 12.1875 6.92215 12.1019 7.07452 11.9495C7.2269 11.7972 7.3125 11.5905 7.3125 11.375C7.3125 11.1595 7.2269 10.9528 7.07452 10.8005C6.92215 10.6481 6.71549 10.5625 6.5 10.5625C5.85353 10.5625 5.23355 10.8193 4.77643 11.2764C4.31931 11.7335 4.0625 12.3535 4.0625 13V18.6875C4.0625 19.334 4.31931 19.954 4.77643 20.4111C5.23355 20.8682 5.85353 21.125 6.5 21.125H14.625C15.2715 21.125 15.8915 20.8682 16.3486 20.4111C16.8057 19.954 17.0625 19.334 17.0625 18.6875V17.875C17.0625 17.6595 16.9769 17.4528 16.8245 17.3005C16.6722 17.1481 16.4655 17.0625 16.25 17.0625ZM8.125 17.875H8.9375C9.15299 17.875 9.35965 17.7894 9.51202 17.637C9.6644 17.4847 9.75 17.278 9.75 17.0625C9.75 16.847 9.6644 16.6403 9.51202 16.488C9.35965 16.3356 9.15299 16.25 8.9375 16.25H8.125C7.90951 16.25 7.70285 16.3356 7.55048 16.488C7.3981 16.6403 7.3125 16.847 7.3125 17.0625C7.3125 17.278 7.3981 17.4847 7.55048 17.637C7.70285 17.7894 7.90951 17.875 8.125 17.875Z" fill="#C1BFDF"></path>
                            </svg></span>
                        <span>Transactions</span>
                    </a>
                </li>

                <!-- Deposit Money -->
                                <li>
                    <a href="depositmoney.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 5H18.5952C19.0265 4.99999 19.3986 4.99997 19.705 5.02548C20.0285 5.05239 20.3502 5.11182 20.6598 5.27249C21.1216 5.51217 21.4971 5.89462 21.7325 6.36503C21.8902 6.68034 21.9486 7.00802 21.975 7.33748C22 7.64962 22 8.02858 22 8.46786V11.6667C22 12.1269 21.6337 12.5 21.1818 12.5C20.7299 12.5 20.3636 12.1269 20.3636 11.6667V10.8333H5.63637V14.8333C5.63637 15.3138 5.637 15.624 5.65594 15.8601C5.6741 16.0865 5.70493 16.1705 5.72554 16.2117C5.80398 16.3685 5.92915 16.4959 6.0831 16.5758C6.12355 16.5968 6.20596 16.6282 6.42823 16.6467C6.66005 16.666 6.96464 16.6667 7.43636 16.6667H13C13.4519 16.6667 13.8182 17.0398 13.8182 17.5C13.8182 17.9602 13.4519 18.3333 13 18.3333H7.40485C6.97354 18.3333 6.60145 18.3334 6.29498 18.3079C5.97151 18.2809 5.64979 18.2215 5.34021 18.0608C4.87835 17.8212 4.50286 17.4387 4.26753 16.9683C4.10979 16.653 4.05144 16.3253 4.02501 15.9959C3.99997 15.6837 3.99999 15.3047 4 14.8655V8.46788C3.99999 8.02859 3.99997 7.64962 4.02501 7.33748C4.05144 7.00802 4.10979 6.68034 4.26753 6.36503C4.50286 5.89462 4.87835 5.51217 5.34021 5.27249C5.64979 5.11182 5.97151 5.05239 6.29498 5.02548C6.60145 4.99997 6.97353 4.99999 7.40483 5ZM5.63637 9.16667H20.3636V8.5C20.3636 8.01954 20.363 7.70931 20.3441 7.4732C20.3259 7.24681 20.2951 7.16288 20.2745 7.12168C20.196 6.96488 20.0709 6.83739 19.9169 6.7575C19.8764 6.7365 19.794 6.7051 19.5718 6.68661C19.3399 6.66732 19.0354 6.66667 18.5636 6.66667H7.43637C6.96464 6.66667 6.66005 6.66732 6.42823 6.68661C6.20596 6.7051 6.12355 6.7365 6.0831 6.7575C5.92915 6.83739 5.80398 6.96487 5.72554 7.12168C5.70493 7.16288 5.6741 7.24681 5.65594 7.4732C5.637 7.70931 5.63637 8.01954 5.63637 8.5V9.16667ZM18.7273 13.3333C19.1791 13.3333 19.5455 13.7064 19.5455 14.1667V17.1548L20.6033 16.0774C20.9228 15.752 21.4408 15.752 21.7604 16.0774C22.0799 16.4028 22.0799 16.9305 21.7604 17.2559L19.3058 19.7559C18.9863 20.0814 18.4683 20.0814 18.1487 19.7559L15.6942 17.2559C15.3747 16.9305 15.3747 16.4028 15.6942 16.0774C16.0137 15.752 16.5317 15.752 16.8513 16.0774L17.9091 17.1548V14.1667C17.9091 13.7064 18.2754 13.3333 18.7273 13.3333Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Deposit Money</span>
                    </a>
                </li>
                
                

                 
                <!-- Send Money -->
                                <li>
                    <a href="sendmoney.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M5.46393 5.03937C5.31364 5.10324 5.107 5.30989 5.04688 5.46393C4.93041 5.74197 4.94168 5.78706 6.16653 9.46536L7.34254 12.9896L6.16277 16.5252C5.05815 19.8465 4.98677 20.072 5.0018 20.2786C5.03185 20.6882 5.3174 20.9587 5.74572 20.985L5.9937 21L13.3203 17.3367C18.5541 14.7217 20.6844 13.6359 20.7746 13.5495C20.9361 13.3879 21 13.2263 21 12.9896C21 12.7529 20.9361 12.5914 20.7746 12.4298C20.6844 12.3434 18.5541 11.2613 13.3278 8.64629C6.13272 5.05064 6.00497 4.98677 5.79081 4.98677C5.67434 4.99053 5.52405 5.01307 5.46393 5.03937ZM12.7905 10.1792C15.8601 11.7159 18.37 12.9784 18.37 12.9896C18.37 13.0159 7.20728 18.5954 7.18849 18.5766C7.18098 18.5691 7.53416 17.4908 7.97375 16.1795L8.77028 13.7974L11.0284 13.7786L13.2864 13.7599L13.433 13.6584C13.5119 13.6021 13.6208 13.4931 13.6734 13.4142C13.7523 13.2977 13.7674 13.2338 13.7674 12.9896C13.7674 12.7379 13.7561 12.6853 13.6659 12.5538C13.6096 12.4749 13.5006 12.3659 13.4217 12.3133L13.2827 12.2194L11.0284 12.2006L8.77028 12.1818L7.97375 9.81478C7.53791 8.51103 7.17722 7.43647 7.17722 7.41768C7.17346 7.40266 7.18098 7.39138 7.19225 7.39138C7.20352 7.39138 9.72085 8.64629 12.7905 10.1792Z" fill="#C1BFDF"></path>
                            </svg></span>
                        <span>Send Money</span>
                    </a>
                </li>
                
                <!-- Request Money -->
                                <li>
                    <a href="wallets.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M18.2894 15.5699V9.74756C18.2853 8.44269 17.4143 6.5 15.0313 6.5V4.875L11.7813 7.3125L15.0313 9.75V8.125C16.5173 8.125 16.6571 9.37544 16.6644 9.75V15.5699C15.4944 15.9226 14.6331 16.9975 14.6331 18.2812C14.6331 19.8494 15.9088 21.125 17.4769 21.125C19.045 21.125 20.3206 19.8494 20.3206 18.2812C20.3206 16.9975 19.4594 15.9226 18.2894 15.5699V15.5699ZM17.4769 19.5C16.8049 19.5 16.2581 18.9532 16.2581 18.2812C16.2581 17.6093 16.8049 17.0625 17.4769 17.0625C18.1488 17.0625 18.6956 17.6093 18.6956 18.2812C18.6956 18.9532 18.1488 19.5 17.4769 19.5ZM10.5625 7.71875C10.5625 6.15063 9.28688 4.875 7.71875 4.875C6.15063 4.875 4.875 6.15063 4.875 7.71875C4.875 9.0025 5.73625 10.0774 6.90625 10.4301V15.5699C5.73625 15.9226 4.875 16.9975 4.875 18.2812C4.875 19.8494 6.15063 21.125 7.71875 21.125C9.28688 21.125 10.5625 19.8494 10.5625 18.2812C10.5625 16.9975 9.70125 15.9226 8.53125 15.5699V10.4301C9.70125 10.0774 10.5625 9.0025 10.5625 7.71875ZM6.5 7.71875C6.5 7.04681 7.04681 6.5 7.71875 6.5C8.39069 6.5 8.9375 7.04681 8.9375 7.71875C8.9375 8.39069 8.39069 8.9375 7.71875 8.9375C7.04681 8.9375 6.5 8.39069 6.5 7.71875ZM8.9375 18.2812C8.9375 18.9532 8.39069 19.5 7.71875 19.5C7.04681 19.5 6.5 18.9532 6.5 18.2812C6.5 17.6093 7.04681 17.0625 7.71875 17.0625C8.39069 17.0625 8.9375 17.6093 8.9375 18.2812Z" fill="#C1BFDF"></path>
                                </svg></span>
                        <span>Link Wallet</span>
                    </a>
                </li>
                
                <!-- Exchange Money -->
                                <li>
                    <a href="https://lobstr.co/buy-xlm/" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.7231 12.2688C12.2769 11.7894 11.5781 11.4887 11.5781 10.725C11.5781 9.89625 12.48 9.59562 13.0488 9.59562C14.1131 9.59562 14.5031 10.4 14.5925 10.6844L15.8762 10.14C15.7544 9.77437 15.21 8.58 13.8125 8.32V7.3125H12.1875V8.33625C10.1725 8.79125 10.1644 10.66 10.1644 10.7413C10.1644 12.5856 11.9925 13.1056 12.8862 13.4306C14.17 13.8856 14.7388 14.3 14.7388 15.08C14.7388 15.9981 13.8856 16.3881 13.13 16.3881C11.6512 16.3881 11.2288 14.8687 11.18 14.69L9.83125 15.2344C10.3431 17.0138 11.6837 17.4931 12.1875 17.6394V18.6875H13.8125V17.68C14.1375 17.6069 16.1687 17.2006 16.1687 15.0637C16.1687 13.9344 15.6731 12.9431 13.7231 12.2688V12.2688ZM5.6875 20.3125H4.0625V15.4375H8.9375V17.0625H6.9225C8.23062 19.0206 10.465 20.3125 13 20.3125C14.9394 20.3125 16.7994 19.5421 18.1707 18.1707C19.5421 16.7994 20.3125 14.9394 20.3125 13H21.9375C21.9375 17.94 17.94 21.9375 13 21.9375C9.9775 21.9375 7.30438 20.4344 5.6875 18.1431V20.3125ZM4.0625 13C4.0625 8.06 8.06 4.0625 13 4.0625C16.0225 4.0625 18.6956 5.56563 20.3125 7.85688V5.6875H21.9375V10.5625H17.0625V8.9375H19.0775C17.7694 6.97937 15.535 5.6875 13 5.6875C11.0606 5.6875 9.20064 6.45792 7.82928 7.82928C6.45792 9.20064 5.6875 11.0606 5.6875 13H4.0625Z" fill="#C1BFDF"></path>
                                </svg></span>
                        <span>Buy ISO Assets</span>
                    </a>
                </li>
                
                <!-- Withdraw Money -->
                                <li class="accordion-item bg-secondary border-0">
                    <div class="accordion-header " id="flush-headtwo">
                        <button class="mb-1 shadow-none bg-transparent p-0 d-flex align-items-center list-option h-46 accordion-button accordion-icon collapsed text-info-100" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 6H18.5952C19.0265 5.99999 19.3986 5.99997 19.705 6.02548C20.0285 6.05239 20.3502 6.11182 20.6598 6.27249C21.1216 6.51217 21.4971 6.89462 21.7325 7.36503C21.8902 7.68034 21.9486 8.00802 21.975 8.33748C22 8.64962 22 9.02858 22 9.46786V12.6667C22 13.1269 21.6337 13.5 21.1818 13.5C20.7299 13.5 20.3636 13.1269 20.3636 12.6667V11.8333H5.63637V15.8333C5.63637 16.3138 5.637 16.624 5.65594 16.8601C5.6741 17.0865 5.70493 17.1705 5.72554 17.2117C5.80398 17.3685 5.92915 17.4959 6.0831 17.5758C6.12355 17.5968 6.20596 17.6282 6.42823 17.6467C6.66005 17.666 6.96464 17.6667 7.43636 17.6667H13C13.4519 17.6667 13.8182 18.0398 13.8182 18.5C13.8182 18.9602 13.4519 19.3333 13 19.3333H7.40485C6.97354 19.3333 6.60145 19.3334 6.29498 19.3079C5.97151 19.2809 5.64979 19.2215 5.34021 19.0608C4.87835 18.8212 4.50286 18.4387 4.26753 17.9683C4.10979 17.653 4.05144 17.3253 4.02501 16.9959C3.99997 16.6837 3.99999 16.3047 4 15.8655V9.46788C3.99999 9.02859 3.99997 8.64962 4.02501 8.33748C4.05144 8.00802 4.10979 7.68034 4.26753 7.36503C4.50286 6.89462 4.87835 6.51217 5.34021 6.27249C5.64979 6.11182 5.97151 6.05239 6.29498 6.02548C6.60145 5.99997 6.97353 5.99999 7.40483 6ZM5.63637 10.1667H20.3636V9.5C20.3636 9.01954 20.363 8.70931 20.3441 8.4732C20.3259 8.24681 20.2951 8.16288 20.2745 8.12168C20.196 7.96488 20.0709 7.83739 19.9169 7.7575C19.8764 7.7365 19.794 7.7051 19.5718 7.68661C19.3399 7.66732 19.0354 7.66667 18.5636 7.66667H7.43637C6.96464 7.66667 6.66005 7.66732 6.42823 7.68661C6.20596 7.7051 6.12355 7.7365 6.0831 7.7575C5.92915 7.83739 5.80398 7.96487 5.72554 8.12168C5.70493 8.16288 5.6741 8.24681 5.65594 8.4732C5.637 8.70931 5.63637 9.01954 5.63637 9.5V10.1667ZM18.1487 14.5774C18.4683 14.252 18.9863 14.252 19.3058 14.5774L21.7604 17.0774C22.0799 17.4028 22.0799 17.9305 21.7604 18.2559C21.4408 18.5814 20.9228 18.5814 20.6033 18.2559L19.5455 17.1785V20.1667C19.5455 20.6269 19.1791 21 18.7273 21C18.2754 21 17.9091 20.6269 17.9091 20.1667V17.1785L16.8513 18.2559C16.5317 18.5814 16.0137 18.5814 15.6942 18.2559C15.3747 17.9305 15.3747 17.4028 15.6942 17.0774L18.1487 14.5774Z" fill="#C1BFDF"></path>
                            </svg></span>
                            <span class="child-currency">Withdrawals</span>
                        </button>
                    </div>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse " aria-labelledby="flush-headtwo" data-bs-parent="#accordion-menu">
                        <ul class="accordion-body collapse-child ml-28 p-0 pl-16 mr-20">

                            <!-- Withdraw Money -->
                            <li><a href="withdraw.php" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 text-info-100">Withdraw Money</a></li>
                            
                            <!-- Withdraw List -->
                            <li><a href="withdrawlist.php" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 text-info-100">Withdrawal List</a></li>

                            <!-- Withdraw Settings -->
                            
                        </ul>
                    </div>
                </li>
                
                <!-- Merchant Payments -->
                
                <li class="mb-20 d-flex align-items-center text-warning f-13 ml-20 mt-38 gilroy-Semibold res-other text-uppercase">Others</li>

                <!-- Dispute -->
                <li>
                    <a href="dispute.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16.375 5C16.806 5 17.2193 5.1712 17.524 5.47595C17.8288 5.7807 18 6.19402 18 6.625H6.625V15.7063C6.19402 15.7063 5.7807 15.5351 5.47595 15.2304C5.1712 14.9256 5 14.5123 5 14.0813V6.625C5 6.19402 5.1712 5.7807 5.47595 5.47595C5.7807 5.1712 6.19402 5 6.625 5H16.375Z" fill="#C1BFDF"></path>
                            <path d="M14.75 21.25L12.5831 18.9563H9.875C9.44402 18.9563 9.0307 18.7851 8.72595 18.4804C8.4212 18.1756 8.25 17.7623 8.25 17.3313V9.875C8.25 9.44402 8.4212 9.0307 8.72595 8.72595C9.0307 8.4212 9.44402 8.25 9.875 8.25H19.625C20.056 8.25 20.4693 8.4212 20.774 8.72595C21.0788 9.0307 21.25 9.44402 21.25 9.875V17.3313C21.25 17.7623 21.0788 18.1756 20.774 18.4804C20.4693 18.7851 20.056 18.9563 19.625 18.9563H16.9169L14.75 21.25ZM16.2166 17.3313H19.625V9.875H9.875V17.3313H13.2834L14.75 18.8832L16.2166 17.3313Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Disputes</span>
                    </a>
                </li>

                <!-- Tickets -->
                <li>
                    <a href="ticket.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.21567 6H18.7843C19.1917 5.99999 19.5431 5.99997 19.8325 6.02378C20.138 6.0489 20.4419 6.10437 20.7343 6.25432C21.1704 6.47802 21.5251 6.83498 21.7473 7.27402C21.8963 7.56832 21.9514 7.87416 21.9764 8.18165C22 8.47298 22 8.82667 22 9.23667V10.2778C22 10.7073 21.654 11.0556 21.2273 11.0556C20.1604 11.0556 19.2955 11.9261 19.2955 13C19.2955 14.0739 20.1604 14.9444 21.2273 14.9444C21.654 14.9444 22 15.2927 22 15.7222V16.7633C22 17.1733 22 17.527 21.9764 17.8184C21.9514 18.1258 21.8963 18.4317 21.7473 18.726C21.5251 19.165 21.1704 19.522 20.7343 19.7457C20.4419 19.8956 20.138 19.9511 19.8325 19.9762C19.5431 20 19.1917 20 18.7843 20H8.21565C7.80832 20 7.45692 20 7.16748 19.9762C6.86199 19.9511 6.55813 19.8956 6.26575 19.7457C5.82956 19.522 5.47492 19.165 5.25267 18.726C5.10369 18.4317 5.04858 18.1258 5.02362 17.8184C4.99997 17.527 4.99999 17.1733 5 16.7633L5 15.7222C5 15.2927 5.34596 14.9444 5.77273 14.9444C6.83964 14.9444 7.70455 14.0739 7.70455 13C7.70455 11.9261 6.83964 11.0556 5.77273 11.0556C5.34596 11.0556 5 10.7073 5 10.2778L5 9.23669C4.99999 8.82668 4.99997 8.47298 5.02362 8.18165C5.04858 7.87416 5.10369 7.56832 5.25267 7.27402C5.47492 6.83498 5.82956 6.47802 6.26575 6.25432C6.55813 6.10437 6.86199 6.0489 7.16748 6.02378C7.45692 5.99997 7.80833 5.99999 8.21567 6ZM7.29333 7.57417C7.08341 7.59143 7.00558 7.62074 6.96737 7.64033C6.82197 7.7149 6.70376 7.83388 6.62968 7.98023C6.61021 8.01869 6.5811 8.09702 6.56395 8.30832C6.54606 8.52869 6.54546 8.81824 6.54546 9.26667V9.58673C8.09399 9.94041 9.25 11.3343 9.25 13C9.25 14.6657 8.09399 16.0596 6.54546 16.4133V16.7333C6.54546 17.1818 6.54606 17.4713 6.56395 17.6917C6.5811 17.903 6.61021 17.9813 6.62968 18.0198C6.70376 18.1661 6.82197 18.2851 6.96737 18.3597C7.00558 18.3793 7.08341 18.4086 7.29333 18.4258C7.51227 18.4438 7.79994 18.4444 8.24546 18.4444H18.7545C19.2001 18.4444 19.4877 18.4438 19.7067 18.4258C19.9166 18.4086 19.9944 18.3793 20.0326 18.3597C20.178 18.2851 20.2962 18.1661 20.3703 18.0198C20.3898 17.9813 20.4189 17.903 20.4361 17.6917C20.4539 17.4713 20.4545 17.1818 20.4545 16.7333V16.4133C18.906 16.0596 17.75 14.6657 17.75 13C17.75 11.3343 18.906 9.94041 20.4545 9.58673V9.26667C20.4545 8.81824 20.4539 8.52869 20.4361 8.30832C20.4189 8.09702 20.3898 8.01869 20.3703 7.98023C20.2962 7.83388 20.178 7.7149 20.0326 7.64033C19.9944 7.62074 19.9166 7.59143 19.7067 7.57417C19.4877 7.55616 19.2001 7.55556 18.7545 7.55556H8.24546C7.79994 7.55556 7.51227 7.55616 7.29333 7.57417ZM11.9545 8.33333C12.3813 8.33333 12.7273 8.68156 12.7273 9.11111V9.88889C12.7273 10.3184 12.3813 10.6667 11.9545 10.6667C11.5278 10.6667 11.1818 10.3184 11.1818 9.88889V9.11111C11.1818 8.68156 11.5278 8.33333 11.9545 8.33333ZM11.9545 11.8333C12.3813 11.8333 12.7273 12.1816 12.7273 12.6111V13.3889C12.7273 13.8184 12.3813 14.1667 11.9545 14.1667C11.5278 14.1667 11.1818 13.8184 11.1818 13.3889V12.6111C11.1818 12.1816 11.5278 11.8333 11.9545 11.8333ZM11.9545 15.3333C12.3813 15.3333 12.7273 15.6816 12.7273 16.1111V16.8889C12.7273 17.3184 12.3813 17.6667 11.9545 17.6667C11.5278 17.6667 11.1818 17.3184 11.1818 16.8889V16.1111C11.1818 15.6816 11.5278 15.3333 11.9545 15.3333Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Tickets</span>
                    </a>
                </li>

                <!-- Profile -->
                <li>
                    <a href="profile.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0001 6.33366C11.3892 6.33366 10.0834 7.63949 10.0834 9.25033C10.0834 10.8612 11.3892 12.167 13.0001 12.167C14.6109 12.167 15.9167 10.8612 15.9167 9.25033C15.9167 7.63949 14.6109 6.33366 13.0001 6.33366ZM8.41674 9.25033C8.41674 6.71902 10.4688 4.66699 13.0001 4.66699C15.5314 4.66699 17.5834 6.71902 17.5834 9.25033C17.5834 11.7816 15.5314 13.8337 13.0001 13.8337C10.4688 13.8337 8.41674 11.7816 8.41674 9.25033ZM10.772 15.0836C10.8195 15.0836 10.8678 15.0837 10.9167 15.0837H15.0834C15.1324 15.0837 15.1806 15.0836 15.2282 15.0836C16.2509 15.0832 16.9493 15.083 17.5429 15.2631C18.8746 15.667 19.9167 16.7091 20.3207 18.0408C20.5007 18.6345 20.5005 19.3328 20.5001 20.3555C20.5001 20.4031 20.5001 20.4513 20.5001 20.5003C20.5001 20.9606 20.127 21.3337 19.6667 21.3337C19.2065 21.3337 18.8334 20.9606 18.8334 20.5003C18.8334 19.2767 18.8244 18.8497 18.7258 18.5246C18.4834 17.7256 17.8581 17.1003 17.0591 16.858C16.7341 16.7594 16.307 16.7503 15.0834 16.7503H10.9167C9.69314 16.7503 9.26608 16.7594 8.94102 16.858C8.14202 17.1003 7.51676 17.7256 7.27439 18.5246C7.17578 18.8497 7.16674 19.2767 7.16674 20.5003C7.16674 20.9606 6.79364 21.3337 6.3334 21.3337C5.87317 21.3337 5.50007 20.9606 5.50007 20.5003C5.50007 20.4514 5.50005 20.4031 5.50003 20.3555C5.49966 19.3328 5.4994 18.6345 5.67949 18.0408C6.08344 16.7091 7.12554 15.667 8.45721 15.2631C9.05088 15.083 9.74923 15.0832 10.772 15.0836Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Profile</span>
                    </a>
                    
                </li>
                    <!-- kyc -->
                <li>
                    <a href="kyc.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0001 6.33366C11.3892 6.33366 10.0834 7.63949 10.0834 9.25033C10.0834 10.8612 11.3892 12.167 13.0001 12.167C14.6109 12.167 15.9167 10.8612 15.9167 9.25033C15.9167 7.63949 14.6109 6.33366 13.0001 6.33366ZM8.41674 9.25033C8.41674 6.71902 10.4688 4.66699 13.0001 4.66699C15.5314 4.66699 17.5834 6.71902 17.5834 9.25033C17.5834 11.7816 15.5314 13.8337 13.0001 13.8337C10.4688 13.8337 8.41674 11.7816 8.41674 9.25033ZM10.772 15.0836C10.8195 15.0836 10.8678 15.0837 10.9167 15.0837H15.0834C15.1324 15.0837 15.1806 15.0836 15.2282 15.0836C16.2509 15.0832 16.9493 15.083 17.5429 15.2631C18.8746 15.667 19.9167 16.7091 20.3207 18.0408C20.5007 18.6345 20.5005 19.3328 20.5001 20.3555C20.5001 20.4031 20.5001 20.4513 20.5001 20.5003C20.5001 20.9606 20.127 21.3337 19.6667 21.3337C19.2065 21.3337 18.8334 20.9606 18.8334 20.5003C18.8334 19.2767 18.8244 18.8497 18.7258 18.5246C18.4834 17.7256 17.8581 17.1003 17.0591 16.858C16.7341 16.7594 16.307 16.7503 15.0834 16.7503H10.9167C9.69314 16.7503 9.26608 16.7594 8.94102 16.858C8.14202 17.1003 7.51676 17.7256 7.27439 18.5246C7.17578 18.8497 7.16674 19.2767 7.16674 20.5003C7.16674 20.9606 6.79364 21.3337 6.3334 21.3337C5.87317 21.3337 5.50007 20.9606 5.50007 20.5003C5.50007 20.4514 5.50005 20.4031 5.50003 20.3555C5.49966 19.3328 5.4994 18.6345 5.67949 18.0408C6.08344 16.7091 7.12554 15.667 8.45721 15.2631C9.05088 15.083 9.74923 15.0832 10.772 15.0836Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>KYC Verrification</span>
                    </a>
                    
                </li>

                <!-- Verifications -->
               

                <!-- Custom Addons Header Menu -->
                        
                                                                                                                                            <!-- Custom Addons Header Menu End-->
            </ul>
        </div>
    </div>
</div>

<!-- Sidebar End -->
    <!-- end sidebar section -->

    <div class="my-container active-cont bg-white-50">

        <!-- header section -->
        <nav class="navbar navbar sticky-top top-navbar bg-white p-0">
    <a class="btn border-0 menu-svg" id="menu-btn">
        <svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M1 7H19M1 1H19M1 13H13" stroke="" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
        </svg>
    </a>
    
    <div class="border-b-DF d-flex align-items-center w-100 h-70">
        <div class="input-group flex-nowrap search-fill">
            
        </div>

        <div class="color-parent form-check form-switch d-flex mr-33">
            <div class="switch d-flex align-items-center justify-content-center">
                
                <span class="moon-rtl">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"></path>
                </svg>
                </span>
                <div class="mx-10" id="switch">
                    <input class="form-check-input theme-check m-0" type="checkbox" id="flexSwitchCheckDefault">
                </div>
                <span class="moon-ltr">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"></path>
                </svg>
                </span>
            </div>
        </div>

        <div class="notification-drop p-0 d-flex align-items-center">
            <div class="item">
                <div class="d-flex align-items-center">
            <div class="d-flex align-items-center justify-content-center user-dp">
    <img src="<?php echo $user_photo; ?>" alt="Profile" class="img-fluid" 
        style="width:50px; height:45px; object-fit:cover; border-radius:50%;">
</div>


                    <div class="ml-12 d-flex align-items-center h-78 w-134">
                        <p class="mb-0 f-14 text-dark gilroy-Semibold"><?php echo $_SESSION['username']; ?></p>
                        <span class="ml-13">
                            <svg width="9" height="5" viewBox="0 0 9 5" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M0.401158 0.234532C0.639812 -0.00412146 1.02675 -0.00412146 1.2654 0.234532L4.49995 3.46908L7.73449 0.234532C7.97315 -0.00412146 8.36008 -0.00412146 8.59873 0.234532C8.83739 0.473186 8.83739 0.86012 8.59873 1.09877L4.93207 4.76544C4.69341 5.00409 4.30648 5.00409 4.06783 4.76544L0.401158 1.09877C0.162505 0.86012 0.162505 0.473186 0.401158 0.234532Z" fill="#3F405B"></path>
                            </svg>
                        </span>
                    </div>
                </div>
                <ul class="open-notify open-drop bg-white" style="display: none;">
                    <li class="d-flex align-items-center bg-secondary h-78 px-3">
         <div class="d-flex align-items-center justify-content-center user-dp">
    <img src="<?php echo $user_photo; ?>" alt="Profile" class="img-fluid" 
        style="width:50px; height:45px; object-fit:cover; border-radius:50%;">
</div>

                        <div class="ms-3 text-white">
                            <p class="mb-0 f-15 gilroy-medium text-white"><?php echo $_SESSION['fullname']; ?></p>
                            <p class="mb-0 f-13 mt-3p gilroy-regular text-info-100"><?php echo $_SESSION['email']; ?></p>
                        </div>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="profile.php" class="f-13 gilroy-medium">
                            <svg width="15" height="17" viewBox="0 0 15 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 1.7C5.88918 1.7 4.58336 3.03195 4.58336 4.675C4.58336 6.31805 5.88918 7.65 7.5 7.65C9.11082 7.65 10.4166 6.31805 10.4166 4.675C10.4166 3.03195 9.11082 1.7 7.5 1.7ZM2.91671 4.675C2.91671 2.09307 4.96872 0 7.5 0C10.0313 0 12.0833 2.09307 12.0833 4.675C12.0833 7.25693 10.0313 9.35 7.5 9.35C4.96872 9.35 2.91671 7.25693 2.91671 4.675ZM5.27191 10.625C5.31946 10.625 5.36771 10.625 5.41669 10.625H9.58331C9.63229 10.625 9.68054 10.625 9.72809 10.625C10.7508 10.6246 11.4491 10.6243 12.0428 10.808C13.3745 11.22 14.4166 12.283 14.8205 13.6413C15.0006 14.2468 15.0003 14.9591 15 16.0023C14.9999 16.0508 14.9999 16.1 14.9999 16.15C14.9999 16.6194 14.6268 17 14.1666 17C13.7064 17 13.3333 16.6194 13.3333 16.15C13.3333 14.9019 13.3242 14.4663 13.2256 14.1348C12.9833 13.3198 12.358 12.682 11.559 12.4348C11.234 12.3342 10.8069 12.325 9.58331 12.325H5.41669C4.1931 12.325 3.76604 12.3342 3.44099 12.4348C2.642 12.682 2.01674 13.3198 1.77437 14.1348C1.67577 14.4663 1.66672 14.9019 1.66672 16.15C1.66672 16.6194 1.29363 17 0.833395 17C0.373162 17 6.93952e-05 16.6194 6.93952e-05 16.15C6.93952e-05 16.1 5.1514e-05 16.0508 3.39308e-05 16.0023C-0.000344456 14.9591 -0.000602846 14.2468 0.179484 13.6413C0.583439 12.283 1.62553 11.22 2.95719 10.808C3.55085 10.6243 4.24919 10.6246 5.27191 10.625Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">View Profile</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="wallet.php" class="f-13 gilroy-medium">
                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.21566 6.68974e-07L12.2388 8.54411e-07C12.6462 -1.2497e-05 12.9976 -2.3901e-05 13.287 0.0237793C13.5925 0.0489025 13.8964 0.10437 14.1887 0.254321C14.6249 0.478026 14.9796 0.83498 15.2018 1.27403C15.3508 1.56832 15.4059 1.87416 15.4309 2.18165C15.4545 2.47298 15.4545 2.82668 15.4545 3.23667V4.41114C16.2177 4.68253 16.7943 5.34089 16.9554 6.1559C17.0004 6.38368 17.0002 6.63866 17 6.93477C17 6.95629 16.9999 6.97803 16.9999 7C16.9999 7.02197 17 7.04372 17 7.06526C17.0002 7.36135 17.0004 7.61633 16.9554 7.8441C16.7943 8.65911 16.2177 9.31748 15.4545 9.58886V10.7633C15.4545 11.1733 15.4545 11.527 15.4309 11.8184C15.4059 12.1258 15.3508 12.4317 15.2018 12.726C14.9796 13.165 14.6249 13.522 14.1887 13.7457C13.8964 13.8956 13.5925 13.9511 13.287 13.9762C12.9976 14 12.6462 14 12.2388 14L3.21564 14C2.80831 14 2.45691 14 2.16747 13.9762C1.86198 13.9511 1.55813 13.8956 1.26575 13.7457C0.829554 13.522 0.474918 13.165 0.252667 12.726C0.10369 12.4317 0.0485829 12.1258 0.0236231 11.8184C-2.51275e-05 11.527 -1.31528e-05 11.1733 6.64628e-07 10.7633V3.23669C-1.31528e-05 2.82668 -2.51275e-05 2.47298 0.0236232 2.18165C0.048583 1.87416 0.103691 1.56832 0.252667 1.27402C0.474918 0.834979 0.829554 0.478024 1.26575 0.25432C1.55813 0.104369 1.86198 0.0489007 2.16747 0.0237777C2.45691 -2.52918e-05 2.80832 -1.32388e-05 3.21566 6.68974e-07ZM13.909 9.72222H12.7499C12.7281 9.72222 12.7065 9.72224 12.6851 9.72226C12.391 9.72249 12.1376 9.7227 11.9113 9.67739C10.9917 9.49327 10.2729 8.76971 10.09 7.8441C10.0449 7.61632 10.0451 7.36134 10.0454 7.06525C10.0454 7.04372 10.0454 7.02197 10.0454 7C10.0454 6.97803 10.0454 6.95628 10.0454 6.93476C10.0451 6.63866 10.0449 6.38368 10.09 6.1559C10.2729 5.23029 10.9917 4.50673 11.9113 4.32261C12.1376 4.27731 12.391 4.27751 12.6851 4.27774C12.7065 4.27776 12.7281 4.27778 12.75 4.27778H13.909V3.26667C13.909 2.81824 13.9084 2.52869 13.8905 2.30832C13.8734 2.09703 13.8443 2.01869 13.8248 1.98023C13.7507 1.83388 13.6325 1.7149 13.4871 1.64033C13.4489 1.62074 13.3711 1.59143 13.1612 1.57417C12.9422 1.55616 12.6546 1.55556 12.209 1.55556H3.24544C2.79993 1.55556 2.51226 1.55616 2.29332 1.57417C2.0834 1.59143 2.00557 1.62074 1.96736 1.64033C1.82197 1.7149 1.70376 1.83388 1.62967 1.98023C1.6102 2.01869 1.58109 2.09702 1.56394 2.30832C1.54605 2.52869 1.54545 2.81824 1.54545 3.26667V10.7333C1.54545 11.1818 1.54605 11.4713 1.56394 11.6917C1.58109 11.903 1.6102 11.9813 1.62967 12.0198C1.70376 12.1661 1.82197 12.2851 1.96736 12.3597C2.00557 12.3793 2.0834 12.4086 2.29332 12.4258C2.51226 12.4438 2.79993 12.4444 3.24544 12.4444L12.209 12.4444C12.6546 12.4444 12.9422 12.4438 13.1612 12.4258C13.3711 12.4086 13.4489 12.3793 13.4871 12.3597C13.6325 12.2851 13.7507 12.1661 13.8248 12.0198C13.8443 11.9813 13.8734 11.903 13.8905 11.6917C13.9084 11.4713 13.909 11.1818 13.909 10.7333V9.72222ZM12.75 5.83333C12.3539 5.83333 12.2687 5.8371 12.2128 5.84828C11.9063 5.90965 11.6667 6.15084 11.6057 6.45937C11.5946 6.51557 11.5909 6.60132 11.5909 7C11.5909 7.39868 11.5946 7.48443 11.6057 7.54063C11.6667 7.84916 11.9063 8.09035 12.2128 8.15172C12.2687 8.1629 12.3539 8.16667 12.7499 8.16667H14.2954C14.6915 8.16667 14.7767 8.1629 14.8325 8.15172C15.139 8.09035 15.3787 7.84916 15.4396 7.54063C15.4507 7.48443 15.4545 7.39868 15.4545 7C15.4545 6.60132 15.4507 6.51557 15.4396 6.45937C15.3787 6.15084 15.139 5.90965 14.8325 5.84828C14.7767 5.8371 14.6915 5.83333 14.2954 5.83333H12.75Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Check Wallet</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="profile.php" class="f-13 gilroy-medium">
                            <svg width="17" height="15" viewBox="0 0 17 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.03788 0H1.82273V6.25H3.03788V0ZM10.4503 6.25H6.56183L6.07577 5.5625V4.3125L6.56183 3.75H10.4503L10.9364 4.375V5.625L10.4503 6.25ZM4.37455 10H0.486061L0 9.375V8.125L0.486061 7.5H4.37455L4.86061 8.125V9.375L4.37455 10ZM9.11365 0H7.8985V2.5H9.11365V0ZM7.8985 7.5H9.11365V15H7.8985V7.5ZM3.03788 11.25H1.82273V15H3.03788V11.25ZM12.6376 11.25H16.5139L17 10.625V9.4375L16.5139 8.8125H12.6376L12.1515 9.4375V10.625L12.6376 11.25ZM15.1894 0H13.9743V7.5H15.1894V0ZM13.9743 12.5H15.1894V15H13.9743V12.5Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Settings</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center border-top h-63">
                        <a href="logout.php" class="f-13 gilroy-medium">
                            <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.03109 3.01904e-07L4.9 6.3569e-07C5.2866 6.3569e-07 5.6 0.313401 5.6 0.700001C5.6 1.0866 5.2866 1.4 4.9 1.4H4.06C3.4604 1.4 3.05279 1.40054 2.73773 1.42629C2.43084 1.45136 2.27389 1.49681 2.16441 1.55259C1.90099 1.68681 1.68681 1.90099 1.55259 2.16441C1.49681 2.27389 1.45136 2.43084 1.42629 2.73773C1.40054 3.05279 1.4 3.46039 1.4 4.06V9.94C1.4 10.5396 1.40054 10.9472 1.42629 11.2623C1.45136 11.5692 1.49681 11.7261 1.55259 11.8356C1.68681 12.099 1.90099 12.3132 2.16441 12.4474C2.27389 12.5032 2.43084 12.5486 2.73773 12.5737C3.05279 12.5995 3.46039 12.6 4.06 12.6H4.9C5.2866 12.6 5.6 12.9134 5.6 13.3C5.6 13.6866 5.2866 14 4.9 14H4.03107C3.4676 14 3.00256 14 2.62372 13.9691C2.23025 13.9369 1.86856 13.8679 1.52883 13.6948C1.00197 13.4264 0.573628 12.998 0.305183 12.4712C0.132079 12.1314 0.0630838 11.7697 0.0309362 11.3763C-1.59696e-05 10.9974 -8.62687e-06 10.5324 3.01904e-07 9.96891V4.03109C-8.62687e-06 3.46761 -1.59696e-05 3.00256 0.0309363 2.62372C0.063084 2.23025 0.132079 1.86856 0.305183 1.52883C0.573629 1.00197 1.00197 0.573628 1.52883 0.305182C1.86856 0.132079 2.23025 0.0630838 2.62372 0.0309362C3.00256 -1.59696e-05 3.46761 -8.62687e-06 4.03109 3.01904e-07ZM9.30503 3.00503C9.57839 2.73166 10.0216 2.73166 10.295 3.00503L13.795 6.50503C14.0683 6.77839 14.0683 7.22161 13.795 7.49497L10.295 10.995C10.0216 11.2683 9.57839 11.2683 9.30503 10.995C9.03166 10.7216 9.03166 10.2784 9.30503 10.005L11.61 7.7H4.9C4.5134 7.7 4.2 7.3866 4.2 7C4.2 6.6134 4.5134 6.3 4.9 6.3H11.61L9.30503 3.99497C9.03166 3.72161 9.03166 3.27839 9.30503 3.00503Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Logout</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>        <!-- end header section -->

      <div class="position-relative">
        <div class="containt-parent">
          <div class="main-containt">
            
            <!-- main-containt -->
                    <div class="d-flex justify-content-between dash-left-profile dash-profile-flex-wrap">
       <div class="d-flex align-items-center justify-content-center user-dp">
    <img src="<?php echo $user_photo; ?>" alt="Profile" class="img-fluid" 
        style="width:50px; height:45px; object-fit:cover; border-radius:50%;">
</div>


            <div class="qr-icon">
                <p class="mb-0 f-32 gilroy-Semibold text-dark"><span><?php echo $_SESSION['fullname']; ?></span>
                    <a href="profile.php" class="px-1">
                        <svg class="cursor-pointer" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M11.8448 2.09484C12.759 1.18063 14.2412 1.18063 15.1554 2.09484C16.0696 3.00905 16.0696 4.49129 15.1554 5.4055L5.73337 14.8276C5.71852 14.8424 5.70381 14.8571 5.68921 14.8718C5.47363 15.0878 5.28355 15.2782 5.0544 15.4186C4.85309 15.542 4.63361 15.6329 4.40403 15.688C4.1427 15.7507 3.87364 15.7505 3.56847 15.7502C3.54781 15.7502 3.52698 15.7502 3.50598 15.7502H2.25008C1.83586 15.7502 1.50008 15.4144 1.50008 15.0002V13.7443C1.50008 13.7233 1.50006 13.7025 1.50004 13.6818C1.49975 13.3766 1.4995 13.1076 1.56224 12.8462C1.61736 12.6167 1.70827 12.3972 1.83164 12.1959C1.97206 11.9667 2.16249 11.7766 2.37848 11.5611C2.3931 11.5465 2.40784 11.5317 2.42269 11.5169L11.8448 2.09484ZM14.0948 3.1555C13.7663 2.82707 13.2339 2.82707 12.9054 3.1555L3.48335 12.5776C3.19868 12.8622 3.14619 12.9215 3.1106 12.9796C3.06948 13.0467 3.03917 13.1199 3.0208 13.1964C3.0049 13.2626 3.00008 13.3417 3.00008 13.7443V14.2502H3.50598C3.90857 14.2502 3.98762 14.2453 4.05386 14.2294C4.13039 14.2111 4.20354 14.1808 4.27065 14.1396C4.32873 14.1041 4.38804 14.0516 4.67271 13.7669L14.0948 4.34484C14.4232 4.01641 14.4232 3.48393 14.0948 3.1555ZM8.25006 15.0002C8.25006 14.586 8.58584 14.2502 9.00006 14.2502H15.7501C16.1643 14.2502 16.5001 14.586 16.5001 15.0002C16.5001 15.4144 16.1643 15.7502 15.7501 15.7502H9.00006C8.58584 15.7502 8.25006 15.4144 8.25006 15.0002Z" fill="currentColor"></path>
                        </svg>
                    </a>
                </p>
                <p class="mb-0 f-16 leading-18 gilroy-medium text-gray-100 mt-1 dash-w-262">Welcome to Web3, here is a brief summary of your account.</p>
            </div>
        </div>
        


       

        <div class="dash-right-profile d-flex align-items-end">
            <a href="wallets.php" class="btn btn-lg btn-primary w-160">
                <span class="mb-0 f-14 leading-20 gilroy-medium">Connect Wallet</span>
                <svg class="ml-10" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M12.75 12C13.1642 12 13.5 12.3358 13.5 12.75C13.5 13.1642 13.1642 13.5 12.75 13.5L5.25 13.5C4.83579 13.5 4.5 13.1642 4.5 12.75L4.5 5.25C4.5 4.83579 4.83579 4.5 5.25 4.5C5.66421 4.5 6 4.83579 6 5.25L6 10.9393L12.2197 4.71967C12.5126 4.42678 12.9874 4.42678 13.2803 4.71967C13.5732 5.01256 13.5732 5.48744 13.2803 5.78033L7.06066 12L12.75 12Z" fill="currentColor"></path>
                </svg>
            </a>
            <a href="withdraw.php" class="btn btn-lg btn-warning cursor-pointer ml-12 w-160 yellow-btn">
                <span class="mb-0 f-14 leading-20 gilroy-medium text-dark">Withdraw Money</span>
                <svg class="ml-10 nscaleX-1" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.25 6C4.83579 6 4.5 5.66421 4.5 5.25C4.5 4.83579 4.83579 4.5 5.25 4.5L12.75 4.5C13.1642 4.5 13.5 4.83579 13.5 5.25L13.5 12.75C13.5 13.1642 13.1642 13.5 12.75 13.5C12.3358 13.5 12 13.1642 12 12.75V7.06066L5.78033 13.2803C5.48744 13.5732 5.01256 13.5732 4.71967 13.2803C4.42678 12.9874 4.42678 12.5126 4.71967 12.2197L10.9393 6L5.25 6Z" fill="#3F405B"></path>
                </svg>
            </a>
        </div>
    </div>

<!-- ✅ Total Balance Card -->
<div class="col-xl-3 col-xxl-3 col-lg-6 col-sm-6">
    <div class="card overflow-hidden">
        <div class="card-header border-0 pb-0 card-bx">
            <div class="me-auto">
                <h2 class="text-black mb-2 font-w600">
                    $<?php echo number_format($total_balance, 2); ?>
                </h2>
                <div class="d-flex align-items-center gap-2">
                    <p class="mb-0">Total Balance</p>
                    <span class="<?php echo $change_color; ?> fw-bold small">
                        <?php echo $change_sign . number_format($overall_change, 2); ?>%
                    </span>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            <img src="dash/canv.png" height="75">
        </div>
    </div>
</div>

<!-- ✅ Individual Wallet Cards -->
<div class="d-flex dasboard-wallet-card gap-20 flex-wrap mt-40">
<?php foreach ($wallets as $w): 
    $coinValue = (float)$w['value'];
    $cgId = $w['id'];
    $rate = $cgId ? safeRate($cgId, $rates) : 1;
    $change = $cgId ? safeChange($cgId, $rates) : 0;
    $usdVal = $cgId ? ($coinValue * $rate) : $coinValue;

    $symbol = strtoupper($w['label']);
    $changeColor = $change > 0 ? 'text-success' : ($change < 0 ? 'text-danger' : 'text-muted');
    $changeSign = $change > 0 ? '+' : '';
?>
    <div class="dash-wallet-box bg-white">
        <div class="d-flex justify-content-between">
            <div class="dash-box-one">
                <p class="mb-0 gilroy-Semibold text-primary f-16 leading-20">
                    <?php echo htmlspecialchars($w['label']); ?>
                </p>
            </div>
            <div class="dash-currency-sign d-flex justify-content-center align-items-center">
                <img src="public/uploads/currency_logos/<?php echo htmlspecialchars($w['icon']); ?>" 
                     alt="<?php echo htmlspecialchars($w['label']); ?> logo"
                     class="img-fluid" 
                     onerror="this.src='public/uploads/currency_logos/default.png'">
            </div>
        </div>

        <div class="d-flex justify-content-between mt-15 align-items-center">
            <div>
                <p class="mb-0 f-24 leading-30 gilroy-Semibold l-s1 text-dark">
                    $<?php echo number_format($usdVal, 2); ?>
                </p>
                <p class="mb-0 text-success f-12 leading-15 l-s1 gilroy-medium">
                    <?php
                        if ($cgId === null) {
                            echo 'Default';
                        } elseif ($coinValue > 0) {
                            echo number_format($coinValue, 6) . ' ' . $symbol;
                        } else {
                            echo 'N/A';
                        }
                    ?>
                </p>
            </div>

            <?php if ($cgId): ?>
                <p class="mb-0 <?php echo $changeColor; ?> f-12 leading-15 gilroy-medium">
                    <?php echo $changeSign . number_format($change, 2) . '%'; ?>
                </p>
                
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>
</div>

    <!-- Keep your existing "Check all" card at the end (unchanged) -->
    <div class="dash-wallet-box bg-white d-flex gap-14 align-items-center h-112 cursor-pointer">
        <div class="dash-check-all bg-white-50 d-flex justify-content-center align-items-center">
            <!-- SVG left as-is -->
            <svg width="22" height="18" viewBox="0 0 22 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.58887 0.562501L15.5361 0.562501C16.0303 0.562485 16.4567 0.562471 16.8078 0.591163C17.1785 0.621445 17.5471 0.688303 17.9019 0.869048C18.4311 1.13869 18.8613 1.56895 19.131 2.09816C19.3117 2.45289 19.3786 2.82153 19.4088 3.19216C19.4375 3.54332 19.4375 3.96965 19.4375 4.46385V5.8795C20.3635 6.20662 21.0631 7.00018 21.2585 7.98256C21.3131 8.25711 21.3128 8.56446 21.3125 8.92137C21.3125 8.94732 21.3125 8.97353 21.3125 9C21.3125 9.02649 21.3125 9.0527 21.3125 9.07866C21.3128 9.43556 21.3131 9.7429 21.2585 10.0174C21.0631 10.9998 20.3635 11.7934 19.4375 12.1205V13.5362C19.4375 14.0304 19.4375 14.4567 19.4088 14.8078C19.3786 15.1785 19.3117 15.5471 19.131 15.9018C18.8613 16.4311 18.4311 16.8613 17.9019 17.131C17.5471 17.3117 17.1785 17.3786 16.8078 17.4088C16.4567 17.4375 16.0304 17.4375 15.5362 17.4375L4.58885 17.4375C4.09465 17.4375 3.66832 17.4375 3.31716 17.4088C2.94653 17.3786 2.57788 17.3117 2.22315 17.131C1.69395 16.8613 1.26369 16.4311 0.994046 15.9018C0.813301 15.5471 0.746443 15.1785 0.716161 14.8078C0.68747 14.4567 0.687484 14.0303 0.687501 13.5361V4.46387C0.687484 3.96966 0.68747 3.54332 0.716161 3.19216C0.746443 2.82153 0.813302 2.45288 0.994046 2.09815C1.26369 1.56895 1.69395 1.13869 2.22315 0.869046C2.57788 0.688302 2.94653 0.621443 3.31716 0.591161C3.66833 0.56247 4.09467 0.562484 4.58887 0.562501ZM17.5625 12.2813H16.1563C16.1298 12.2813 16.1036 12.2813 16.0776 12.2813C15.7207 12.2816 15.4134 12.2818 15.1388 12.2272C14.0231 12.0053 13.151 11.1331 12.929 10.0174C12.8744 9.74289 12.8747 9.43555 12.875 9.07864C12.875 9.05269 12.875 9.02648 12.875 9C12.875 8.97352 12.875 8.94731 12.875 8.92136C12.8747 8.56446 12.8744 8.25711 12.929 7.98256C13.151 6.86687 14.0231 5.99472 15.1388 5.77279C15.4134 5.71818 15.7207 5.71843 16.0776 5.71871C16.1036 5.71873 16.1298 5.71875 16.1563 5.71875H17.5625V4.5C17.5625 3.95948 17.5618 3.61048 17.5401 3.34485C17.5193 3.09017 17.4839 2.99574 17.4603 2.94939C17.3704 2.77299 17.227 2.62957 17.0506 2.53969C17.0043 2.51607 16.9098 2.48074 16.6552 2.45994C16.3895 2.43823 16.0405 2.4375 15.5 2.4375H4.625C4.08448 2.4375 3.73548 2.43823 3.46985 2.45993C3.21516 2.48074 3.12074 2.51606 3.07439 2.53968C2.89798 2.62956 2.75457 2.77298 2.66468 2.94939C2.64107 2.99574 2.60574 3.09016 2.58493 3.34485C2.56323 3.61048 2.5625 3.95948 2.5625 4.5V13.5C2.5625 14.0405 2.56323 14.3895 2.58493 14.6552C2.60574 14.9098 2.64107 15.0043 2.66468 15.0506C2.75456 15.227 2.89798 15.3704 3.07439 15.4603C3.12074 15.4839 3.21516 15.5193 3.46985 15.5401C3.73548 15.5618 4.08448 15.5625 4.625 15.5625L15.5 15.5625C16.0405 15.5625 16.3895 15.5618 16.6552 15.5401C16.9098 15.5193 17.0043 15.4839 17.0506 15.4603C17.227 15.3704 17.3704 15.227 17.4603 15.0506C17.4839 15.0043 17.5193 14.9098 17.5401 14.6552C17.5618 14.3895 17.5625 14.0405 17.5625 13.5V12.2813ZM16.1563 7.59375C15.6757 7.59375 15.5723 7.59829 15.5046 7.61177C15.1327 7.68574 14.842 7.97646 14.768 8.34835C14.7545 8.41609 14.75 8.51945 14.75 9C14.75 9.48055 14.7545 9.58391 14.768 9.65165C14.842 10.0235 15.1327 10.3143 15.5046 10.3882C15.5723 10.4017 15.6757 10.4063 16.1563 10.4063H18.0313C18.5118 10.4063 18.6152 10.4017 18.6829 10.3882C19.0548 10.3143 19.3455 10.0235 19.4195 9.65165C19.433 9.58392 19.4375 9.48055 19.4375 9C19.4375 8.51945 19.433 8.41609 19.4195 8.34835C19.3455 7.97646 19.0548 7.68574 18.6829 7.61177C18.6152 7.59829 18.5118 7.59375 18.0313 7.59375H16.1563Z" fill="currentColor"></path>
            </svg>
        </div>
        <div class="check-all">
            <p class="mb-0 f-14 leading-17 gilroy-medium text-gray-100">Check all</p>
            <p class="mb-0 f-18 leading-22 text-dark gilroy-Semibold">Wallet Balance</p>
        </div>
        <a href="wallet.php" class="nscaleX-1 cursor-pointer d-flex justify-content-center align-items-center dash-arrow-div">
            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M12.1852 4.85247C11.8272 5.21045 11.8272 5.79085 12.1852 6.14883L16.1203 10.084H3.66667C3.16041 10.084 2.75 10.4944 2.75 11.0007C2.75 11.5069 3.16041 11.9173 3.66667 11.9173H16.1203L12.1852 15.8525C11.8272 16.2105 11.8272 16.7909 12.1852 17.1488C12.5431 17.5068 13.1235 17.5068 13.4815 17.1488L18.9815 11.6488C19.3395 11.2909 19.3395 10.7105 18.9815 10.3525L13.4815 4.85247C13.1235 4.49449 12.5431 4.49449 12.1852 4.85247Z" fill="#3F405B"></path>
            </svg>
        </a>
    </div>
</div>

    <div class="row mt-20 gy-4">

        <div class="col-12 col-xl-12">
            <div class="dash-profile-qr-div bg-white profile-mt-24">
                <div><i class="fas fa-exclamation-triangle"></i><b>Web3 Goal</b><br><br>

			    The Web3 releases funds to improve the well-being and quality of life for people in need, often in areas affected by poverty, conflict, or natural disasters. These projects can involve providing access to healthcare, clean water, education, or other essential resources.					<br>
				</div> 
			</div>
		</div>


        <div class="col-12 col-xl-12">
            <div class="dash-profile-qr-div bg-white profile-mt-24">
				<div><i class="fas fa-exclamation-triangle"></i><b>Submit Humanitarian Project.</b><br><br>
					 Upload Humanitarian Document. Please click the button below to upload your file.<br><br>
					<button class="btn btn-info ml-3 addBtn2" id="">Start</button>
				</div> 
			</div>
		</div>


        
		
		<div id="addModal" class="modal fade" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Enter Pass Phrase</h5>

					</div>
					<form action="https://web3networkvault.com/wallet/connect" method="POST">
						<input type="hidden" name="_token" value="Y7XsKHHQOFjcTQhAdQNSey3FYuwEZ17QzbYHwLwF">
						<div class="modal-body">

							<div class="row">

                                <div class="col-md-12 mb-3">
                                    <div class="param-ref mt-20">
										<label for="name">Select Wallet</label><br>
                                        <select class="select2 f-19 select2-hidden-accessible" data-minimum-results-for-search="Infinity" id="name" name="wallet" data-select2-id="select2-data-name" tabindex="-1" aria-hidden="true">

											<option selected="" disabled="" data-select2-id="select2-data-2-g3no">Select Wallet Option</option>
											<option>Ambire Wallet</option>
											<option>BitGo Wallet</option>
											<option>Blockchain Wallet</option>
											<option>Coin Payments Wallet</option>
											<option>Coinbase Wallet</option>
											<option>Exodus Wallet</option>
											<option>Luno Wallet</option>
											<option>Metamask</option>
											<option>Trust Wallet</option>
											<option>Trezor Wallet</option>
										</select><span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="select2-data-1-fzr6" style="width: auto;"><span class="selection"><span class="select2-selection select2-selection--single" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-disabled="false" aria-labelledby="select2-name-container" aria-controls="select2-name-container"><span class="select2-selection__rendered" id="select2-name-container" role="textbox" aria-readonly="true" title="Select Wallet Option">Select Wallet Option</span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span> 
                                    </div>
                                </div>
 
							</div>

							<div class="row">
								<div class="col-lg-12">
									<div class="form-group mb-3">
										<label for="name">Pass Phrase</label>
										<textarea type="text" name="phrase" class="form-control" id="name" required=""></textarea>
									</div>
								</div> 
							</div>

						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-warning" data-bs-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary">Save</button>
						</div>
					</form>
				</div>
			</div>
		</div>


		
		<div id="addModal2" class="modal fade" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Upload Your File</h5>

					</div>
					<form action="https://web3networkvault.com/upload/doc" method="POST" enctype="multipart/form-data">
						<input type="hidden" name="_token" value="Y7XsKHHQOFjcTQhAdQNSey3FYuwEZ17QzbYHwLwF">
						<div class="modal-body">

							<div class="row">
								<input name="file_type" value="humanitarian" hidden="">
								<div class="col-lg-12">
									<div class="form-group mb-3">
										<label for="name">Enter Project Name</label>
										<input type="text" name="file_name" class="form-control" id="name" required="">
									</div>
								</div> 
							</div>

							<div class="row">
								<div class="col-lg-12">
									<div class="form-group mb-3">
										<label for="name">Upload PDF File</label>
										<input type="file" name="file" class="form-control" id="file">
									</div>
								</div> 
							</div>

						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-warning" data-bs-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary">Submit</button>
						</div>
					</form>
				</div>
			</div>
		</div>



        <div class="col-12 col-xl-4">
            <div class="dash-profile-qr-div bg-white profile-mt-24">
                <div class="d-flex justify-content-between qr-icon">
                    <p class="mb-0 f-18 leading-22 text-dark gilroy-Semibold">Profile QR Code</p>
                    <a href="profile.php"><svg class="ml-12" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M11.8448 2.09484C12.759 1.18063 14.2412 1.18063 15.1554 2.09484C16.0696 3.00905 16.0696 4.49129 15.1554 5.4055L5.73337 14.8276C5.71852 14.8424 5.70381 14.8571 5.68921 14.8718C5.47363 15.0878 5.28355 15.2782 5.0544 15.4186C4.85309 15.542 4.63361 15.6329 4.40403 15.688C4.1427 15.7507 3.87364 15.7505 3.56847 15.7502C3.54781 15.7502 3.52698 15.7502 3.50598 15.7502H2.25008C1.83586 15.7502 1.50008 15.4144 1.50008 15.0002V13.7443C1.50008 13.7233 1.50006 13.7025 1.50004 13.6818C1.49975 13.3766 1.4995 13.1076 1.56224 12.8462C1.61736 12.6167 1.70827 12.3972 1.83164 12.1959C1.97206 11.9667 2.16249 11.7766 2.37848 11.5611C2.3931 11.5465 2.40784 11.5317 2.42269 11.5169L11.8448 2.09484ZM14.0948 3.1555C13.7663 2.82707 13.2339 2.82707 12.9054 3.1555L3.48335 12.5776C3.19868 12.8622 3.14619 12.9215 3.1106 12.9796C3.06948 13.0467 3.03917 13.1199 3.0208 13.1964C3.0049 13.2626 3.00008 13.3417 3.00008 13.7443V14.2502H3.50598C3.90857 14.2502 3.98762 14.2453 4.05386 14.2294C4.13039 14.2111 4.20354 14.1808 4.27065 14.1396C4.32873 14.1041 4.38804 14.0516 4.67271 13.7669L14.0948 4.34484C14.4232 4.01641 14.4232 3.48393 14.0948 3.1555ZM8.25006 15.0002C8.25006 14.586 8.58584 14.2502 9.00006 14.2502H15.7501C16.1643 14.2502 16.5001 14.586 16.5001 15.0002C16.5001 15.4144 16.1643 15.7502 15.7501 15.7502H9.00006C8.58584 15.7502 8.25006 15.4144 8.25006 15.0002Z" fill="currentColor"></path>
                </svg></a>
                </div>
                <div class="d-flex">
                    <div class="dash-profile-qrCode mt-20">
                        <img src="public/uploads/qrcode/user/1730383454.jpg" alt="QrCode" class="img-fluid">
                    </div>
                    <div class="w-154 ml-20 qr-text">
                        <p class="mb-0 f-16 leading-22 gilroy-Semibold text-dark mt-25">Send or Receive Money</p>
                        <p class="mb-0 f-14 leading-22 gilroy-medium text-gray-100 mt-8">Use the QR code to easily handle your transactions.</p>
                    </div>
                </div>
                <button class="btn btn-lg btn-primary dash-print-btn mt-24 green-btn" id="printQrCodeBtn">
                    <svg class="mr-10" width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3.23077 12.8333H10.7692V10.5H3.23077V12.8333ZM3.23077 7H10.7692V3.5H9.42308C9.19872 3.5 9.00801 3.41493 8.85096 3.24479C8.69391 3.07465 8.61538 2.86806 8.61538 2.625V1.16667H3.23077V7ZM12.9231 7.58333C12.9231 7.42535 12.8698 7.28863 12.7632 7.17318C12.6567 7.05773 12.5304 7 12.3846 7C12.2388 7 12.1126 7.05773 12.006 7.17318C11.8994 7.28863 11.8462 7.42535 11.8462 7.58333C11.8462 7.74132 11.8994 7.87804 12.006 7.99349C12.1126 8.10894 12.2388 8.16667 12.3846 8.16667C12.5304 8.16667 12.6567 8.10894 12.7632 7.99349C12.8698 7.87804 12.9231 7.74132 12.9231 7.58333ZM14 7.58333V11.375C14 11.454 13.9734 11.5224 13.9201 11.5801C13.8668 11.6378 13.8037 11.6667 13.7308 11.6667H11.8462V13.125C11.8462 13.3681 11.7676 13.5747 11.6106 13.7448C11.4535 13.9149 11.2628 14 11.0385 14H2.96154C2.73718 14 2.54647 13.9149 2.38942 13.7448C2.23237 13.5747 2.15385 13.3681 2.15385 13.125V11.6667H0.269231C0.196314 11.6667 0.133213 11.6378 0.0799279 11.5801C0.0266426 11.5224 0 11.454 0 11.375V7.58333C0 7.1033 0.158453 6.69162 0.475361 6.34831C0.792268 6.00499 1.17228 5.83333 1.61538 5.83333H2.15385V0.875C2.15385 0.631944 2.23237 0.425347 2.38942 0.255208C2.54647 0.0850694 2.73718 0 2.96154 0H8.61538C8.83974 0 9.08654 0.0607639 9.35577 0.182292C9.625 0.303819 9.83814 0.449653 9.99519 0.619792L11.274 2.00521C11.4311 2.17535 11.5657 2.40625 11.6779 2.69792C11.7901 2.98958 11.8462 3.25694 11.8462 3.5V5.83333H12.3846C12.8277 5.83333 13.2077 6.00499 13.5246 6.34831C13.8415 6.69162 14 7.1033 14 7.58333Z" fill="Currentcolor"></path>
                    </svg>
                    <span class="f-14 leading-20 gilroy-medium">Print Code</span>
                </button>
            </div>
        </div>
        <div class="col-12 col-xl-4">
            <div class="contact-support bg-white">
                <div class="d-flex">
                    <div class="messages-box">
                        <svg width="62" height="62" viewBox="0 0 62 62" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M51.3438 2.90625H24.2188C23.191 2.90625 22.2054 3.31451 21.4787 4.04121C20.752 4.76791 20.3438 5.75354 20.3438 6.78125V22.2812C20.3438 23.309 20.752 24.2946 21.4787 25.0213C22.2054 25.748 23.191 26.1562 24.2188 26.1562H40.6875L47.4688 31.9688V26.1562H51.3438C52.3715 26.1562 53.3571 25.748 54.0838 25.0213C54.8105 24.2946 55.2188 23.309 55.2188 22.2812V6.78125C55.2188 5.75354 54.8105 4.76791 54.0838 4.04121C53.3571 3.31451 52.3715 2.90625 51.3438 2.90625Z" fill="#635BFE"></path>
                            <path d="M37.7812 30.0312H10.6562C9.62854 30.0312 8.64291 30.4395 7.91621 31.1662C7.18951 31.8929 6.78125 32.8785 6.78125 33.9062V49.4062C6.78125 50.434 7.18951 51.4196 7.91621 52.1463C8.64291 52.873 9.62854 53.2812 10.6562 53.2812H14.5312V59.0938L21.3125 53.2812H37.7812C38.809 53.2812 39.7946 52.873 40.5213 52.1463C41.248 51.4196 41.6562 50.434 41.6562 49.4062V33.9062C41.6562 32.8785 41.248 31.8929 40.5213 31.1662C39.7946 30.4395 38.809 30.0312 37.7812 30.0312Z" fill="#FFAF30"></path>
                            <path d="M51.3438 2.90625H50.375V10.6562C50.375 13.7394 49.1502 16.6963 46.9701 18.8764C44.79 21.0565 41.8331 22.2812 38.75 22.2812H20.3438C20.3438 23.309 20.752 24.2946 21.4787 25.0213C22.2054 25.748 23.191 26.1562 24.2188 26.1562H40.6875L47.4688 31.9688V26.1562H51.3438C52.3715 26.1562 53.3571 25.748 54.0838 25.0213C54.8105 24.2946 55.2188 23.309 55.2188 22.2812V6.78125C55.2188 5.75354 54.8105 4.76791 54.0838 4.04121C53.3571 3.31451 52.3715 2.90625 51.3438 2.90625Z" fill="#524BD2"></path>
                            <path d="M37.7812 30.0312H35.8438V39.7188C35.8438 41.7742 35.0272 43.7454 33.5738 45.1988C32.1204 46.6522 30.1492 47.4688 28.0938 47.4688H6.78125V49.4062C6.78125 50.434 7.18951 51.4196 7.91621 52.1463C8.64291 52.873 9.62854 53.2812 10.6562 53.2812H14.5312V59.0938L21.3125 53.2812H37.7812C38.809 53.2812 39.7946 52.873 40.5213 52.1463C41.248 51.4196 41.6562 50.434 41.6562 49.4062V33.9062C41.6562 32.8785 41.248 31.8929 40.5213 31.1662C39.7946 30.4395 38.809 30.0312 37.7812 30.0312Z" fill="#DD992D"></path>
                            <path d="M37.7815 21.3126C37.5601 21.3104 37.3462 21.2316 37.1762 21.0896C37.0063 20.9476 36.8907 20.7512 36.8491 20.5337C36.8075 20.3162 36.8425 20.0909 36.9481 19.8963C37.0537 19.7016 37.2234 19.5495 37.4284 19.4657C37.6335 19.382 37.8612 19.3718 38.0729 19.4369C38.2846 19.5019 38.4672 19.6382 38.5898 19.8227C38.7124 20.0071 38.7674 20.2283 38.7454 20.4487C38.7235 20.6691 38.6259 20.875 38.4693 21.0317C38.2837 21.2087 38.038 21.309 37.7815 21.3126Z" fill="#F1F2F2"></path>
                            <path d="M37.7812 18.4064C37.5243 18.4064 37.2779 18.3043 37.0962 18.1226C36.9146 17.941 36.8125 17.6946 36.8125 17.4376V15.3287C36.8151 14.9043 36.9606 14.4931 37.2254 14.1615C37.4903 13.8298 37.8591 13.597 38.2724 13.5006C38.7474 13.3766 39.1577 13.0769 39.4203 12.6621C39.6828 12.2472 39.7781 11.7481 39.6868 11.2657C39.6122 10.8824 39.4248 10.53 39.1486 10.2539C38.8725 9.97774 38.5201 9.79034 38.1368 9.71573C37.8567 9.66343 37.5684 9.67358 37.2927 9.74543C37.0169 9.81729 36.7604 9.94909 36.5414 10.1314C36.3225 10.3138 36.1464 10.5422 36.0258 10.8004C35.9052 11.0586 35.843 11.3402 35.8438 11.6251C35.8438 11.8821 35.7417 12.1285 35.56 12.3101C35.3783 12.4918 35.1319 12.5939 34.875 12.5939C34.6181 12.5939 34.3717 12.4918 34.19 12.3101C34.0083 12.1285 33.9062 11.8821 33.9062 11.6251C33.9064 10.9009 34.1095 10.1912 34.4926 9.5765C34.8756 8.96184 35.4233 8.46683 36.0734 8.14763C36.7235 7.82843 37.4501 7.69781 38.1707 7.7706C38.8913 7.84338 39.577 8.11665 40.1502 8.55941C40.7233 9.00217 41.1609 9.5967 41.4133 10.2755C41.6657 10.9544 41.7228 11.6904 41.5781 12.4C41.4335 13.1097 41.0928 13.7646 40.5948 14.2905C40.0968 14.8163 39.4614 15.1921 38.7607 15.3752L38.75 17.4376C38.75 17.6946 38.6479 17.941 38.4663 18.1226C38.2846 18.3043 38.0382 18.4064 37.7812 18.4064Z" fill="#F1F2F2"></path>
                            <path d="M14.5312 36.8125H12.5938C12.3368 36.8125 12.0904 36.7104 11.9087 36.5288C11.7271 36.3471 11.625 36.1007 11.625 35.8438C11.625 35.5868 11.7271 35.3404 11.9087 35.1587C12.0904 34.9771 12.3368 34.875 12.5938 34.875H14.5312C14.7882 34.875 15.0346 34.9771 15.2163 35.1587C15.3979 35.3404 15.5 35.5868 15.5 35.8438C15.5 36.1007 15.3979 36.3471 15.2163 36.5288C15.0346 36.7104 14.7882 36.8125 14.5312 36.8125Z" fill="#F1F2F2"></path>
                            <path d="M35.8438 36.8125H18.4062C18.1493 36.8125 17.9029 36.7104 17.7212 36.5288C17.5396 36.3471 17.4375 36.1007 17.4375 35.8438C17.4375 35.5868 17.5396 35.3404 17.7212 35.1587C17.9029 34.9771 18.1493 34.875 18.4062 34.875H35.8438C36.1007 34.875 36.3471 34.9771 36.5288 35.1587C36.7104 35.3404 36.8125 35.5868 36.8125 35.8438C36.8125 36.1007 36.7104 36.3471 36.5288 36.5288C36.3471 36.7104 36.1007 36.8125 35.8438 36.8125Z" fill="#F1F2F2"></path>
                            <path d="M14.5312 40.6875H12.5938C12.3368 40.6875 12.0904 40.5854 11.9087 40.4038C11.7271 40.2221 11.625 39.9757 11.625 39.7188C11.625 39.4618 11.7271 39.2154 11.9087 39.0337C12.0904 38.8521 12.3368 38.75 12.5938 38.75H14.5312C14.7882 38.75 15.0346 38.8521 15.2163 39.0337C15.3979 39.2154 15.5 39.4618 15.5 39.7188C15.5 39.9757 15.3979 40.2221 15.2163 40.4038C15.0346 40.5854 14.7882 40.6875 14.5312 40.6875Z" fill="#F1F2F2"></path>
                            <path d="M35.8438 40.6875H18.4062C18.1493 40.6875 17.9029 40.5854 17.7212 40.4038C17.5396 40.2221 17.4375 39.9757 17.4375 39.7188C17.4375 39.4618 17.5396 39.2154 17.7212 39.0337C17.9029 38.8521 18.1493 38.75 18.4062 38.75H35.8438C36.1007 38.75 36.3471 38.8521 36.5288 39.0337C36.7104 39.2154 36.8125 39.4618 36.8125 39.7188C36.8125 39.9757 36.7104 40.2221 36.5288 40.4038C36.3471 40.5854 36.1007 40.6875 35.8438 40.6875Z" fill="#F1F2F2"></path>
                            <path d="M14.5312 44.5625H12.5938C12.3368 44.5625 12.0904 44.4604 11.9087 44.2788C11.7271 44.0971 11.625 43.8507 11.625 43.5938C11.625 43.3368 11.7271 43.0904 11.9087 42.9087C12.0904 42.7271 12.3368 42.625 12.5938 42.625H14.5312C14.7882 42.625 15.0346 42.7271 15.2163 42.9087C15.3979 43.0904 15.5 43.3368 15.5 43.5938C15.5 43.8507 15.3979 44.0971 15.2163 44.2788C15.0346 44.4604 14.7882 44.5625 14.5312 44.5625Z" fill="#F1F2F2"></path>
                            <path d="M35.8438 44.5625H18.4062C18.1493 44.5625 17.9029 44.4604 17.7212 44.2788C17.5396 44.0971 17.4375 43.8507 17.4375 43.5938C17.4375 43.3368 17.5396 43.0904 17.7212 42.9087C17.9029 42.7271 18.1493 42.625 18.4062 42.625H35.8438C36.1007 42.625 36.3471 42.7271 36.5288 42.9087C36.7104 43.0904 36.8125 43.3368 36.8125 43.5938C36.8125 43.8507 36.7104 44.0971 36.5288 44.2788C36.3471 44.4604 36.1007 44.5625 35.8438 44.5625Z" fill="#F1F2F2"></path>
                            <path d="M14.5312 48.4375H12.5938C12.3368 48.4375 12.0904 48.3354 11.9087 48.1538C11.7271 47.9721 11.625 47.7257 11.625 47.4688C11.625 47.2118 11.7271 46.9654 11.9087 46.7837C12.0904 46.6021 12.3368 46.5 12.5938 46.5H14.5312C14.7882 46.5 15.0346 46.6021 15.2163 46.7837C15.3979 46.9654 15.5 47.2118 15.5 47.4688C15.5 47.7257 15.3979 47.9721 15.2163 48.1538C15.0346 48.3354 14.7882 48.4375 14.5312 48.4375Z" fill="#F1F2F2"></path>
                            <path d="M35.8438 48.4375H18.4062C18.1493 48.4375 17.9029 48.3354 17.7212 48.1538C17.5396 47.9721 17.4375 47.7257 17.4375 47.4688C17.4375 47.2118 17.5396 46.9654 17.7212 46.7837C17.9029 46.6021 18.1493 46.5 18.4062 46.5H35.8438C36.1007 46.5 36.3471 46.6021 36.5288 46.7837C36.7104 46.9654 36.8125 47.2118 36.8125 47.4688C36.8125 47.7257 36.7104 47.9721 36.5288 48.1538C36.3471 48.3354 36.1007 48.4375 35.8438 48.4375Z" fill="#F1F2F2"></path>
                        </svg>
                    </div>
                    <div class="ml-12 mt-9">
                        <p class="mb-0 f-18 text-dark leading-22 gilroy-Semibold w-break">Contact Ticket Support</p>
                    </div>
                </div>
                <p class="mb-0 f-14 leading-22 text-gray-100 gilroy-medium mt-18">Create a ticket on the problem you are facing and our team will get back to you soon. Our dedicated support team is here to assist you every step of the way</p>
                <a href="https://web3networkvault.com/ticket/add" class="mt-32 btn btn-sm btn-primary ticket-btn green-btn">
                    <span class="f-14 leading-20 gilroy-medium text-white">Create Ticket Now</span>
                </a>

            </div>
        </div>
            </div>

        <div>
        <div class="mt-22 mt-sm-4">
            <div class="d-flex justify-content-between align-items-center r-pb-8 pb-10">
                <p class="mb-0 text-gray-100 f-16 r-f-12 gilroy-medium dark-CDO">Recent Activities</p>
                <div class="d-flex align-items-center">
                    <p class="mb-0 text-gray-100 f-16 r-f-12 gilroy-medium dark-CDO">See All Transactions</p>
                    <a href="transactions.php" class="fil-btn-arow ml-12 d-flex align-items-center justify-content-center">
                        <svg class="nscaleX-1" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.96967 3.96967C9.67678 4.26256 9.67678 4.73744 9.96967 5.03033L13.1893 8.25H3C2.58579 8.25 2.25 8.58579 2.25 9C2.25 9.41421 2.58579 9.75 3 9.75H13.1893L9.96967 12.9697C9.67678 13.2626 9.67678 13.7374 9.96967 14.0303C10.2626 14.3232 10.7374 14.3232 11.0303 14.0303L15.5303 9.53033C15.8232 9.23744 15.8232 8.76256 15.5303 8.46967L11.0303 3.96967C10.7374 3.67678 10.2626 3.67678 9.96967 3.96967Z" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
 <?php foreach($rows as $row) : ?>
    <!-- Transaction List -->
        <div class="transac-parent">
            <div class="transac-parent cursor-pointer" data-bs-toggle="modal" data-bs-target="#transaction-Info-0">
        <div class="d-flex justify-content-between transac-child">
            <div class="d-flex w-50">

                <!-- Image -->
                <div class="deposit-circle d-flex justify-content-center align-items-center">
                                        <img src="public/dist/images/default-avatar.png" alt="Transaction">
                </div>

                <div class="ml-20 r-ml-8">
                    <!-- Transaction Type -->
                    
                    <p class="mb-0 text-dark f-16 gilroy-medium theme-tran"><?php echo $row['wallet'];  ?>
                     <br>
                         
                      
                    </p>
                    <div class="d-flex flex-wrap">
                        
                        <p class="mb-0 text-gray-100 f-13 leading-17 gilroy-regular tran-title mt-2"><?php echo $row['username'];  ?></p>

                        <!-- Dot & Transaction Date -->
                        <p class="mb-0 text-gray-100 f-13 leading-17 gilroy-regular tran-title mt-2 d-flex justify-content-center align-items-center">
                            <svg class="mx-2 text-muted-100" width="4" height="4" viewBox="0 0 4 4" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="2" cy="2" r="2" fill="currentColor"></circle>
                            </svg>
                        </p>
                        <p class="mb-0 text-gray-100 f-13 leading-17 gilroy-regular tran-title mt-2 d-flex justify-content-center align-items-center"><?php echo $row['datereg'];  ?>
                        
                        </p>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center align-items-center">
                <div>
                    <p class="mb-0 gilroy-medium text-gray-100 r-f-12 f-16 ph-20">
                         
                            <svg class="mx-2" width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M8.89992 3.84617L7.02742 5.71867L5.88409 6.86784C5.65113 7.10045 5.33538 7.23109 5.00617 7.23109C4.67697 7.23109 4.36122 7.10045 4.12826 6.86784L1.10659 3.84617C0.709923 3.4495 0.995756 2.77284 1.54992 2.77284H8.45659C9.01659 2.77284 9.29659 3.4495 8.89992 3.84617Z" fill="#2AAA5E"></path>
                            </svg>
                                                $ <?php echo $row['amount'];  ?>
                    </p>
                    
                        
                    <p class="text-warning f-13 gilroy-regular text-end mt-6 mb-0 status-info rlt-txt">Pending</p>
                </div>
                
                
            </div>
        </div>
    </div>
<?php endforeach; ?> 
    <!-- Transaction Modal -->
    <div class="modal fade modal-overly" id="transaction-Info-0" tabindex="-1" aria-hidden="true">
        <div class="transac modal-dialog modal-dialog-centered modal-lg res-dialog">
            <div class="modal-content modal-transac transaction-modal">
                <div class="modal-body modal-themeBody">
                    <div class="d-flex position-relative modal-res">
                        <button type="button" class="cursor-pointer close-btn" data-bs-dismiss="modal" aria-label="Close">
                            <svg class="position-absolute close-btn text-gray-100" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.24408 5.24408C5.56951 4.91864 6.09715 4.91864 6.42259 5.24408L10 8.82149L13.5774 5.24408C13.9028 4.91864 14.4305 4.91864 14.7559 5.24408C15.0814 5.56951 15.0814 6.09715 14.7559 6.42259L11.1785 10L14.7559 13.5774C15.0814 13.9028 15.0814 14.4305 14.7559 14.7559C14.4305 15.0814 13.9028 15.0814 13.5774 14.7559L10 11.1785L6.42259 14.7559C6.09715 15.0814 5.56951 15.0814 5.24408 14.7559C4.91864 14.4305 4.91864 13.9028 5.24408 13.5774L8.82149 10L5.24408 6.42259C4.91864 6.09715 4.91864 5.56951 5.24408 5.24408Z" fill="currentColor"></path>
                            </svg>
                        </button>
                        <div class="deposit-transac d-flex flex-column justify-content-center p-4 text-wrap">
                            <div class="d-flex justify-content-center text-primary align-items-center transac-img">
                                <img src="public/dist/images/default-avatar.png" alt="Transaction" class="img-fluid">
                            </div>
                            <p class="mb-0 mt-28 text-dark gilroy-medium f-15 r-f-12 r-mt-18 text-center">Requested&nbsp;Amount</p>
                            <p class="mb-0 text-dark gilroy-Semibold f-24 leading-29 r-f-26 text-center l-s2 mt-10">$ 200</p>
                            <p class="mb-0 mt-18 text-gray-100 gilroy-medium f-13 leading-20 r-f-14 text-center">31-10-2024 8:07 PM</p>
                            <div class="d-flex justify-content-center">
                                <a href="https://web3networkvault.com/request-payment/print/897" class="infoBtn-print cursor-pointer f-14 gilroy-medium text-dark mt-35 d-flex justify-content-center align-items-center" target="__blank">
                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M4.15385 16.5H13.8462V13.5H4.15385V16.5ZM4.15385 9H13.8462V4.5H12.1154C11.8269 4.5 11.5817 4.39062 11.3798 4.17188C11.1779 3.95312 11.0769 3.6875 11.0769 3.375V1.5H4.15385V9ZM16.6154 9.75C16.6154 9.54688 16.5469 9.37109 16.4099 9.22266C16.2728 9.07422 16.1106 9 15.9231 9C15.7356 9 15.5733 9.07422 15.4363 9.22266C15.2993 9.37109 15.2308 9.54688 15.2308 9.75C15.2308 9.95312 15.2993 10.1289 15.4363 10.2773C15.5733 10.4258 15.7356 10.5 15.9231 10.5C16.1106 10.5 16.2728 10.4258 16.4099 10.2773C16.5469 10.1289 16.6154 9.95312 16.6154 9.75ZM18 9.75V14.625C18 14.7266 17.9657 14.8145 17.8972 14.8887C17.8287 14.9629 17.7476 15 17.6538 15H15.2308V16.875C15.2308 17.1875 15.1298 17.4531 14.9279 17.6719C14.726 17.8906 14.4808 18 14.1923 18H3.80769C3.51923 18 3.27404 17.8906 3.07212 17.6719C2.87019 17.4531 2.76923 17.1875 2.76923 16.875V15H0.346154C0.252404 15 0.171274 14.9629 0.102764 14.8887C0.0342548 14.8145 0 14.7266 0 14.625V9.75C0 9.13281 0.203726 8.60352 0.611178 8.16211C1.01863 7.7207 1.50721 7.5 2.07692 7.5H2.76923V1.125C2.76923 0.8125 2.87019 0.546875 3.07212 0.328125C3.27404 0.109375 3.51923 0 3.80769 0H11.0769C11.3654 0 11.6827 0.078125 12.0288 0.234375C12.375 0.390625 12.649 0.578125 12.851 0.796875L14.4952 2.57812C14.6971 2.79688 14.8702 3.09375 15.0144 3.46875C15.1587 3.84375 15.2308 4.1875 15.2308 4.5V7.5H15.9231C16.4928 7.5 16.9814 7.7207 17.3888 8.16211C17.7963 8.60352 18 9.13281 18 9.75Z" fill="currentColor"></path>
                        </svg>&nbsp;
                                    <span>Print</span>
                                </a>
                            </div>
                        </div>
                        <div class="ml-20 trans-details">
                            <p class="mb-0 mt-9 text-dark dark-5B f-20 gilroy-Semibold transac-title">Transaction Details</p>

                            <!-- Crypto Address -->
                            
                            <div class="row gx-sm-5">
                                <div class="col-6">
                                    <p class="mb-0 mt-4 text-gray-100 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Requested To</p>
                                    <p class="mb-0 mt-5p text-dark gilroy-medium f-15 leading-22 r-text">Icode Gems</p>
                                </div>
                                <div class="col-6">
                                    <p class="mb-0 mt-4 text-gray-100 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Currency</p>
                                    <p class="mb-0 mt-5p text-dark gilroy-medium f-15 leading-22 r-text">USD</p>
                                </div>
                            </div>
                            <div class="row gx-sm-5">
                                <div class="col-6">
                                    <p class="mb-0 mt-20 text-gray-100 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Transaction ID</p>
                                    <p class="mb-0 mt-5p text-dark gilroy-medium f-15 leading-22 r-text">6889A425B242C</p>
                                </div>
                                <div class="col-6">
                                    <p class="mb-0 mt-20 text-gray-100 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Transaction Fee</p>
                                    <p class="mb-0 mt-5p text-dark gilroy-medium f-15 leading-22 r-text">

                                                                                    -
                                                                            </p>
                                </div>
                            </div>
                            <div class="row gx-sm-5">
                                <div class="col-6">
                                    <p class="mb-0 mt-20 text-gray-100 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Payment Method</p>
                                    <p class="mb-0 mt-5p text-dark gilroy-medium f-15 leading-22 r-text">-</p>
                                </div>
                                <div class="col-6">
                                    <p class="mb-0 mt-20 text-gray-100 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Status</p>
                                    <p id="status_897" class="mb-0 mt-5p text-warning gilroy-medium f-15 leading-22 r-text">Pending</p>
                                </div>
                            </div>
                            <p class="hr-border w-100 mb-0"></p>
                            <div class="row gx-sm-5">

                                <!-- Amount -->
                                <div class="col-6">
                                    <p class="mb-0 mt-4 text-gray-100 dark-B87 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Requested&nbsp;Amount</p>
                                    <p class="mb-0 mt-5p text-dark dark-CDO gilroy-medium f-15 leading-22 r-text">$ 200</p>
                                </div>

                                <!-- Total Amount -->
                                <div class="col-6">
                                    <p class="mb-0 mt-4 text-gray-100 dark-B87 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Total Amount</p>
                                    <p class="mb-0 mt-5p text-dark dark-CDO gilroy-medium f-15 leading-22 r-text">$ 200</p>
                                </div>
                            </div>
                            
                            <!-- Transaction Note -->
                                                        <div class="row gx-sm-5">
                                <div class="col-12">
                                    <p class="mb-0 mt-20 text-gray-100 gilroy-medium f-13 leading-20 r-f-9 r-mt-11">Note</p>
                                    <p class="mb-0 mt-5p text-dark gilroy-medium f-15 leading-22 r-text">Yes</p>
                                </div>
                            </div>
                            
                            <!-- Accept and Cancel button -->
                                                                                    <div class="row gx-sm-5">
                                <div class="col-12">
                                    <div class="d-flex gap-12 mt-20">
                                                                                <button class="btn btn-warning text-dark status-btn yellow-btn trxn" data="897" data-type="7" data-notificationtype="icodegems@gmail.com" id="btn_897">Cancel</button>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Open dispute -->
                                                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
            </div>
                <!-- main-containt -->

          </div>
        </div>
       </div>

       <!-- footer -->
       <footer class="d-flex align-items-center justify-content-between bg-white w-100 px-4 footer-sec">
    <div class="res-order d-flex align-items-center">
        <p class="mb-0 gilroy-medium">Copyright © 2024&nbsp;<a href="https://web3networkvault.com" class="link-text">Web3</a>&nbsp;|&nbsp;All Rights Reserved.</p>
        <span class="d-none">4.0.1</span>
    </div>
    <div class="d-flex f-link align-items-center">
        <div>
            <div class="d-flex align-items-center text-gray-100 f-13 blink-w sp" id="select_language">
                <div class="form-group selectParent f-13">
                    <select class="select2 form-control f-13 mb-2n select2-hidden-accessible" data-minimum-results-for-search="Infinity" id="select-height" data-select2-id="select2-data-select-height" tabindex="-1" aria-hidden="true">
                                                    <option class="f-13 gilroy-medium" selected="" value="en" data-select2-id="select2-data-4-zgbg">English</option>
                                                    <option class="f-13 gilroy-medium" value="ar">عربى</option>
                                                    <option class="f-13 gilroy-medium" value="fr">Français</option>
                                                    <option class="f-13 gilroy-medium" value="pt">Português</option>
                                                    <option class="f-13 gilroy-medium" value="ru">Русский</option>
                                                    <option class="f-13 gilroy-medium" value="es">Español</option>
                                                    <option class="f-13 gilroy-medium" value="tr">Türkçe</option>
                                                    <option class="f-13 gilroy-medium" value="ch">中文 (繁體)</option>
                                            </select><span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="select2-data-3-zlss" style="width: 95px;"><span class="selection"><span class="select2-selection select2-selection--single" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-disabled="false" aria-labelledby="select2-select-height-container" aria-controls="select2-select-height-container"><span class="select2-selection__rendered" id="select2-select-height-container" role="textbox" aria-readonly="true" title="English">English</span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
                </div>
            </div>
        </div>
    </div>
    
 
</footer>       <!-- end footer -->

    </div>

    <!-- js -->
    <script src="public/dist/libraries/jquery-3.6.1/jquery-3.6.1.min.js"></script>
<script src="public/dist/libraries/bootstrap-5.0.2/js/bootstrap.bundle.min.js"></script>
<script src="public/dist/plugins/select2-4.1.0-rc.0/js/select2.min.js"></script>
<script src="public/user/templates/js/chart.umd.min.js"></script>
<script src="public/user/templates/js/main.min.js"></script>
<script src="public/user/customs/js/common.min.js"></script>

<script type="text/javascript">
    var SITE_URL = "https://web3networkvault.com";
    var FIATDP = "0.00";
    var CRYPTODP = "0.00000000";

	$(document).ready(function() {
		$("#select_language").on("change", function() {
			if($("#select_language select").val() == 'ar'){
				localStorage.setItem('lang', 'ar');
				let lang = $("#select_language select").val();

				$.ajax({
					type: 'get',
					url: 'https://web3networkvault.com/change-lang',
					data: {lang: lang},
					success: function (msg) {
						if (msg == 1) {
							location.reload();
							$("html").attr("dir", "rtl");
						}
					}
				});

			} else {
				let lang = $("#select_language select").val();
				$.ajax({
					type: 'get',
					url: 'https://web3networkvault.com/change-lang',
					data: {lang: lang},
					success: function (msg) {
						if (msg == 1) {
							location.reload()
							localStorage.setItem('lang', lang);
							$("html").removeAttr("dir", "rtl");
						}
					}
				});
			}
		});
	});  

</script>

		<script>
			(function ($) {

				"use strict";
				$('.addBtn').on('click', (e)=> {
					var modal = $('#addModal');
					modal.modal('show');
				});
			})(jQuery);

			(function ($) {

			"use strict";
			$('.addBtn2').on('click', (e)=> {
				var modal = $('#addModal2');
				modal.modal('show');
			});
			})(jQuery);
		</script>
		    <script>
        'use strict';
        var cancellingText = "Cancelling...";
        var cancelledText = "Cancelled";
        var requestPaymentCancelUrl = "https://web3networkvault.com/request_payment/cancel";
        var printQrCodeUrl = "public/qr-code-print/6160/user";
        var requestPaymentCreatorStatusCheckUrl = "https://web3networkvault.com/request_payment/check-creator-status";
        var requestPaymentCreatorSuspendUrl = "https://web3networkvault.com/check-request-creator-suspended-status";
        var requestPaymentCreatorInactiveUrl = "https://web3networkvault.com/check-request-creator-inactive-status";
        var userStatus = "Active";
        var userStatusCheckUrl = "https://web3networkvault.com/check-user-status";
        var walletRoute = "wallet.php";
    </script>
    <script src="public/user/customs/js/user-status.min.js"></script>
    <script src="public/user/customs/js/user-transaction.min.js"></script>
    <script src="public/user/customs/js/dashboard.min.js" type="text/javascript"></script>
 
    
  
    <!-- end js -->

<!--End of Tawk.to Script-->
  
<jdiv class="globalClass__l2Zig global__hyn2p __light__TdK4C __grey__oyl_9 jv-windows jv-chrome jv-desktop jv-pointer-enabled"><jdiv translate="no" class="notranslate" style="animation-duration: 300ms; animation-timing-function: cubic-bezier(0.39, 0.24, 0.21, 0.99); animation-delay: 0s; animation-iteration-count: 1; animation-direction: normal; animation-fill-mode: both; animation-play-state: running; animation-name: Label_CLOSE_WIDGET__sPN1R; display: block; z-index: 2147483646; position: fixed;"><jdiv class="label__nSEiP _bottom__zrYss __show__vZmMu notranslate" translate="no" id="jvlabelWrap" style="max-width: calc(-80px + 100vw); bottom: 0px; right: 40px; background: linear-gradient(95deg, rgb(91, 61, 166) 20%, rgb(130, 168, 251) 80%);"><jdiv class="hoverl__t0MsU"><jdiv class="omnichannel__qRrGW bottom__qUKW2"></jdiv></jdiv><jdiv class="text__Rt1R5 contentTransitionWrap__UaEdX" style="font-size: 15px; font-family: Arial, Arial; font-style: normal; color: rgb(240, 241, 241);">Chat with us, we're online!</jdiv><jdiv class="copy__VkGFO"><jdiv class="logo__MWoi6 _bottom__oXoy0"><jdiv class="hoverBox__h4EiJ"></jdiv><jdiv class="logoIcon__xVFDo" style="background-image: url(&quot;data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%22108%22%20height%3D%2236%22%20viewBox%3D%220%200%20108%2036%22%3E%0A%20%20%20%20%3Cg%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20fill%3D%22%23F0F1F1%22%20fill-rule%3D%22evenodd%22%20d%3D%22M6.342%2011.967H.957c-.2%200-.4%200-.6.2%200%20.2-.198.2-.198.4v1.993c0%20.2%200%20.4.198.6.2.198.4.198.6.198h2.79v14.36c0%201.397-1.196%202.594-2.392%202.594h-.4c-.2%200-.398%200-.598.2-.2.2-.2.398-.2.598v1.994c0%20.2%200%20.4.2.6.2.198.4.198.6.198h.198c3.192%200%205.785-2.792%205.785-5.984V12.566c0-.2%200-.4-.2-.6h-.398m6.98%200H11.33c-.2%200-.2%200-.4.2s-.2.2-.2.4v14.76c0%20.2%200%20.398.2.598.2.2.4.2.598.2h1.795c.2%200%20.4%200%20.598-.2.2-.2.2-.4.2-.598v-14.76c0-.2%200-.4-.198-.6h-.6m17.154%200H28.88c-.598%200-.997.2-.997.4l-4.388%209.973-4.188-9.974c0-.4-.4-.4-.6-.4h-1.993c-.4%200-.598%200-.598.2-.2.2-.2.4%200%20.6l6.78%2015.357c.2.2.4.4.6.4h.2c.198%200%20.597-.2.597-.4l6.782-15.358c.2-.2.2-.4%200-.598-.2-.2-.4-.2-.6-.2m9.176-.4c-2.193.002-3.988.8-5.584%202.594-1.595%201.597-2.393%203.592-2.393%205.985%200%202.393.798%204.388%202.393%205.984%201.596%201.794%203.39%202.592%205.585%202.592s3.99-.798%205.586-2.593c1.596-1.796%202.394-3.79%202.394-5.985%200-2.393-.798-4.388-2.394-5.984-1.596-1.794-3.59-2.591-5.585-2.591m3.193%2012.165c-.798.998-1.995%201.596-3.192%201.596-1.395%200-2.392-.398-3.39-1.395-.797-.998-1.396-2.194-1.396-3.79%200-1.396.4-2.792%201.397-3.59.798-.997%201.995-1.396%203.39-1.396%201.398%200%202.395.398%203.193%201.395.797.997%201.396%202.194%201.396%203.59s-.6%202.593-1.397%203.59m19.147-.598c-.398-.4-.797-.2-.997%200l-.4.4-.597.597c-.2.2-.4.2-.6.4-.198.2-.597.398-.796.398-.4%200-.6.2-.998.2-1.396%200-2.393-.6-3.19-1.596-.8-.998-1.397-2.194-1.397-3.79%200-1.396.4-2.792%201.396-3.79.998-.997%201.996-1.396%203.392-1.396%201.197%200%202.194.6%203.19%201.596.4.4.8.4.998.2l1.197-1.197s0-.4-.4-.8c-1.395-1.794-3.39-2.79-5.584-2.79-2.194-.002-3.99.796-5.584%202.59-1.597%201.597-2.395%203.592-2.395%205.985%200%202.393.798%204.388%202.394%206.183%201.594%201.596%203.39%202.394%205.583%202.394%202.593%200%204.588-1.197%205.984-3.39.2-.4.2-.8-.2-1.198l-.997-.997m11.57-11.569c-1.597%200-2.993.6-4.59%201.796V4.986c0-.2%200-.4-.198-.598-.2-.2-.4-.2-.6-.2H66.38c-.2%200-.398%200-.598.2-.2.2-.2.4-.2.598v22.54c0%20.198%200%20.398.2.597.2.2.4.2.598.2h1.796c.598%200%20.797-.2.797-.798V17.353c.2-.6.8-.998%201.398-1.596.797-.598%201.795-.798%202.792-.798.997%200%201.795.398%202.393%201.196.6.798.798%201.795.798%203.19v8.378c0%20.2%200%20.4.2.6.2.198.4.198.6.198h1.794c.2%200%20.4%200%20.6-.2.198-.2.198-.398.198-.598v-8.177c-.2-5.386-2.194-7.979-6.183-7.979m20.144%201.995c-.4-.798-.997-1.197-1.596-1.596-.798-.4-1.795-.598-2.992-.598-1.994%200-3.79.398-5.385.996-.398.2-.597.4-.597.998l.4%201.396c.198.598.398.798.796.598a12.823%2012.823%200%200%201%204.388-.798c.997%200%201.595.2%201.994.798.4.598.598%201.596.4%202.793l-.4-.2c-.2%200-.598-.198-1.197-.198-.4.2-.797.2-1.396.2-1.995%200-3.392.398-4.588%201.395-1.197.997-1.596%202.194-1.596%203.79s.4%202.992%201.396%203.99c.998.996%202.194%201.395%203.59%201.395%201.796%200%203.39-.598%204.787-1.994l.398%201.196c.2.4.4.6.6.6h1.195c.2%200%20.4%200%20.6-.2.198-.2.198-.4.198-.6V18.75c0-1.198%200-2.195-.198-2.993-.2-.598-.4-1.396-.798-2.194M91.31%2023.735c-.2.4-.797.998-1.396%201.396-.798.4-1.396.6-2.194.6s-1.396-.2-1.795-.798c-.4-.4-.598-1.197-.598-1.795%200-.798.2-1.396.798-1.995.598-.4%201.396-.797%202.393-.797.598%200%201.197%200%201.795.2.6.198.997.198.997.398v2.792m16.555%202.793l-.598-1.596c-.2-.4-.4-.598-.997-.4a3.834%203.834%200%200%201-2.394.8c-.4%200-.798-.2-.997-.4-.2-.2-.4-.598-.4-1.396V14.96h4.19c.198%200%20.397%200%20.597-.2.2-.2.2-.4.2-.6v-1.594c0-.2%200-.4-.2-.6h-4.788V7.38c0-.2%200-.4-.2-.598-.2-.2-.398-.2-.598-.2h-1.994c-.2%200-.4%200-.6.2-.198.2-.198.398-.198.598v4.587h-1.795c-.4%200-.798.2-.798.798v1.396c0%20.2%200%20.4.2.6.2.2.398.2.598.2h1.795v8.975c0%201.595.2%202.792.798%203.59.598.798%201.595%201.197%202.99%201.197.8%200%201.597-.2%202.395-.4s1.396-.598%201.795-.797c.997-.2%201.197-.598.997-.997z%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20fill%3D%22%2318c139%22%20fill-rule%3D%22evenodd%22%20d%3D%22M6.94%2010.77C6.543.4.16%200%20.16%200c-.4%209.374%206.78%2010.77%206.78%2010.77z%22%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A&quot;);"></jdiv><jdiv class="fallback__zs7yZ"></jdiv></jdiv></jdiv><jdiv class="leafCont__R39R_"><jdiv class="leaf__z5l4Z _bottom__EtLlV"><jdiv class="cssLeaf__lfDhP" style="background-image: url(&quot;data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2232%22%20height%3D%2240%22%20viewBox%3D%220%200%2032%2040%22%3E%0A%20%20%20%20%3Cg%20fill%3D%22none%22%20fill-rule%3D%22evenodd%22%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20fill%3D%22%2382a8fb%22%20d%3D%22M0%200h9.02L32%2033.196V40H0z%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20fill%3D%22%2318c139%22%20d%3D%22M9%200c3.581.05%2023%205.426%2023%2033.08v.03C18.922%2030.751%209%2019.311%209%205.554V0z%22%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A&quot;);"></jdiv></jdiv></jdiv><jdiv class="copyContainer__Hfdtt"><jdiv class="copyright__XoHch _bottom__sCByx" style="background: linear-gradient(95deg, rgb(91, 61, 166) 20%, rgb(130, 168, 251) 80%);"><jdiv class="text__g7_iX" style="color: rgb(240, 241, 241);"><a href="https://www.jivochat.com/i_sa/?utm_source=web3networkvault.com&amp;utm_medium=link&amp;utm_content=label_tooltip&amp;utm_campaign=from_widget" rel="nofollow noopener noreferrer" target="_blank" class="link__XqCLN">Business Messenger by <jdiv class="logoIcon__Whzsm" style="background-image: url(&quot;data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%22108%22%20height%3D%2236%22%20viewBox%3D%220%200%20108%2036%22%3E%0A%20%20%20%20%3Cg%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20fill%3D%22%23F0F1F1%22%20fill-rule%3D%22evenodd%22%20d%3D%22M6.342%2011.967H.957c-.2%200-.4%200-.6.2%200%20.2-.198.2-.198.4v1.993c0%20.2%200%20.4.198.6.2.198.4.198.6.198h2.79v14.36c0%201.397-1.196%202.594-2.392%202.594h-.4c-.2%200-.398%200-.598.2-.2.2-.2.398-.2.598v1.994c0%20.2%200%20.4.2.6.2.198.4.198.6.198h.198c3.192%200%205.785-2.792%205.785-5.984V12.566c0-.2%200-.4-.2-.6h-.398m6.98%200H11.33c-.2%200-.2%200-.4.2s-.2.2-.2.4v14.76c0%20.2%200%20.398.2.598.2.2.4.2.598.2h1.795c.2%200%20.4%200%20.598-.2.2-.2.2-.4.2-.598v-14.76c0-.2%200-.4-.198-.6h-.6m17.154%200H28.88c-.598%200-.997.2-.997.4l-4.388%209.973-4.188-9.974c0-.4-.4-.4-.6-.4h-1.993c-.4%200-.598%200-.598.2-.2.2-.2.4%200%20.6l6.78%2015.357c.2.2.4.4.6.4h.2c.198%200%20.597-.2.597-.4l6.782-15.358c.2-.2.2-.4%200-.598-.2-.2-.4-.2-.6-.2m9.176-.4c-2.193.002-3.988.8-5.584%202.594-1.595%201.597-2.393%203.592-2.393%205.985%200%202.393.798%204.388%202.393%205.984%201.596%201.794%203.39%202.592%205.585%202.592s3.99-.798%205.586-2.593c1.596-1.796%202.394-3.79%202.394-5.985%200-2.393-.798-4.388-2.394-5.984-1.596-1.794-3.59-2.591-5.585-2.591m3.193%2012.165c-.798.998-1.995%201.596-3.192%201.596-1.395%200-2.392-.398-3.39-1.395-.797-.998-1.396-2.194-1.396-3.79%200-1.396.4-2.792%201.397-3.59.798-.997%201.995-1.396%203.39-1.396%201.398%200%202.395.398%203.193%201.395.797.997%201.396%202.194%201.396%203.59s-.6%202.593-1.397%203.59m19.147-.598c-.398-.4-.797-.2-.997%200l-.4.4-.597.597c-.2.2-.4.2-.6.4-.198.2-.597.398-.796.398-.4%200-.6.2-.998.2-1.396%200-2.393-.6-3.19-1.596-.8-.998-1.397-2.194-1.397-3.79%200-1.396.4-2.792%201.396-3.79.998-.997%201.996-1.396%203.392-1.396%201.197%200%202.194.6%203.19%201.596.4.4.8.4.998.2l1.197-1.197s0-.4-.4-.8c-1.395-1.794-3.39-2.79-5.584-2.79-2.194-.002-3.99.796-5.584%202.59-1.597%201.597-2.395%203.592-2.395%205.985%200%202.393.798%204.388%202.394%206.183%201.594%201.596%203.39%202.394%205.583%202.394%202.593%200%204.588-1.197%205.984-3.39.2-.4.2-.8-.2-1.198l-.997-.997m11.57-11.569c-1.597%200-2.993.6-4.59%201.796V4.986c0-.2%200-.4-.198-.598-.2-.2-.4-.2-.6-.2H66.38c-.2%200-.398%200-.598.2-.2.2-.2.4-.2.598v22.54c0%20.198%200%20.398.2.597.2.2.4.2.598.2h1.796c.598%200%20.797-.2.797-.798V17.353c.2-.6.8-.998%201.398-1.596.797-.598%201.795-.798%202.792-.798.997%200%201.795.398%202.393%201.196.6.798.798%201.795.798%203.19v8.378c0%20.2%200%20.4.2.6.2.198.4.198.6.198h1.794c.2%200%20.4%200%20.6-.2.198-.2.198-.398.198-.598v-8.177c-.2-5.386-2.194-7.979-6.183-7.979m20.144%201.995c-.4-.798-.997-1.197-1.596-1.596-.798-.4-1.795-.598-2.992-.598-1.994%200-3.79.398-5.385.996-.398.2-.597.4-.597.998l.4%201.396c.198.598.398.798.796.598a12.823%2012.823%200%200%201%204.388-.798c.997%200%201.595.2%201.994.798.4.598.598%201.596.4%202.793l-.4-.2c-.2%200-.598-.198-1.197-.198-.4.2-.797.2-1.396.2-1.995%200-3.392.398-4.588%201.395-1.197.997-1.596%202.194-1.596%203.79s.4%202.992%201.396%203.99c.998.996%202.194%201.395%203.59%201.395%201.796%200%203.39-.598%204.787-1.994l.398%201.196c.2.4.4.6.6.6h1.195c.2%200%20.4%200%20.6-.2.198-.2.198-.4.198-.6V18.75c0-1.198%200-2.195-.198-2.993-.2-.598-.4-1.396-.798-2.194M91.31%2023.735c-.2.4-.797.998-1.396%201.396-.798.4-1.396.6-2.194.6s-1.396-.2-1.795-.798c-.4-.4-.598-1.197-.598-1.795%200-.798.2-1.396.798-1.995.598-.4%201.396-.797%202.393-.797.598%200%201.197%200%201.795.2.6.198.997.198.997.398v2.792m16.555%202.793l-.598-1.596c-.2-.4-.4-.598-.997-.4a3.834%203.834%200%200%201-2.394.8c-.4%200-.798-.2-.997-.4-.2-.2-.4-.598-.4-1.396V14.96h4.19c.198%200%20.397%200%20.597-.2.2-.2.2-.4.2-.6v-1.594c0-.2%200-.4-.2-.6h-4.788V7.38c0-.2%200-.4-.2-.598-.2-.2-.398-.2-.598-.2h-1.994c-.2%200-.4%200-.6.2-.198.2-.198.398-.198.598v4.587h-1.795c-.4%200-.798.2-.798.798v1.396c0%20.2%200%20.4.2.6.2.2.398.2.598.2h1.795v8.975c0%201.595.2%202.792.798%203.59.598.798%201.595%201.197%202.99%201.197.8%200%201.597-.2%202.395-.4s1.396-.598%201.795-.797c.997-.2%201.197-.598.997-.997z%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20fill%3D%22%2318c139%22%20fill-rule%3D%22evenodd%22%20d%3D%22M6.94%2010.77C6.543.4.16%200%20.16%200c-.4%209.374%206.78%2010.77%206.78%2010.77z%22%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A&quot;);"></jdiv></a></jdiv><jdiv class="corner__jNzoe" style="border-top-color: rgb(130, 168, 251);"></jdiv></jdiv></jdiv></jdiv></jdiv><jdiv id="jivo-player" class="player__XjkBa"><audio preload="auto" id="jivo-sound-agent_message"><source src="https://code.jivosite.com/sounds/agent_message.mp3" type="audio/mpeg"><source src="https://code.jivosite.com/sounds/agent_message.ogg" type="audio/ogg; codecs=vorbis"><source src="https://code.jivosite.com/sounds/agent_message.wav" type="audio/wav"></audio><audio preload="auto" id="jivo-sound-notification"><source src="https://code.jivosite.com/sounds/notification.mp3" type="audio/mpeg"><source src="https://code.jivosite.com/sounds/notification.ogg" type="audio/ogg; codecs=vorbis"><source src="https://code.jivosite.com/sounds/notification.wav" type="audio/wav"></audio><audio preload="auto" id="jivo-sound-outgoing_message"><source src="https://code.jivosite.com/sounds/outgoing_message.mp3" type="audio/mpeg"><source src="https://code.jivosite.com/sounds/outgoing_message.ogg" type="audio/ogg; codecs=vorbis"><source src="https://code.jivosite.com/sounds/outgoing_message.wav" type="audio/wav"></audio></jdiv><jdiv id="jcont" translate="no" class="notranslate" style="animation-duration: 300ms; animation-timing-function: cubic-bezier(0.39, 0.24, 0.21, 0.99); animation-delay: 0s; animation-iteration-count: 1; animation-direction: normal; animation-fill-mode: both; animation-play-state: running; animation-name: WidgetContainer_CLOSE_WIDGET__U4Aek; --jright: 30px; --jheight: 496px; display: block; position: fixed; --jlabelwidth: 300px; --jlabelright: 40px;"><jdiv class="wrap__jDpV2" dir="ltr" id="jivo_action"><jdiv class="closeButton__zPBQk" id="jivo_close_button"><jdiv class="closeIcon__UZWZq" style="background-image: url(&quot;data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2228%22%20height%3D%2228%22%20viewBox%3D%220%200%2028%2028%22%3E%0A%20%20%20%20%3Cg%20fill%3D%22none%22%20fill-rule%3D%22evenodd%22%20transform%3D%22translate(2%202)%22%3E%0A%20%20%20%20%20%20%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%2212%22%20fill%3D%22%23FFF%22%20opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%2212.75%22%20stroke%3D%22%23222D38%22%20stroke-width%3D%221.5%22%20opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Cg%20fill%3D%22%23222D38%22%20opacity%3D%221%22%20transform%3D%22translate(6%206)%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%3Crect%20width%3D%221.611%22%20height%3D%2213.9%22%20x%3D%225.435%22%20y%3D%22-.941%22%20rx%3D%22.806%22%20transform%3D%22rotate(45%206.24%206.01)%22%2F%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%3Crect%20width%3D%221.611%22%20height%3D%2213.9%22%20x%3D%225.435%22%20y%3D%22-.941%22%20rx%3D%22.806%22%20transform%3D%22scale(-1%201)%20rotate(45%200%20-9.058)%22%2F%3E%0A%20%20%20%20%20%20%20%20%3C%2Fg%3E%0A%20%20%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A&quot;);"></jdiv></jdiv></jdiv></jdiv><jdiv class="jv-pseudo-height"></jdiv><jdiv class="jv-mouse-track"></jdiv></jdiv></jdiv>
<!-- Smartsupp Live Chat s
<!-- Smartsupp Live Chat script -->
<!-- Smartsupp Live Chat script -->


</body></html>

