<?php
session_start();
require "../secure/connect.php";

if (!isset($_SESSION['email'])) {
    header("Location: ../../index.php");
    exit();
}

// Fetch wallet addresses from DB
$sql = "SELECT * FROM wallet_add LIMIT 1";
$result = $conn->query($sql);
$row = $result->fetch_assoc();
if (!$row) {
    die("No wallet addresses found in database.");
}

// Map wallet names to DB columns
$walletMap = [
    'Bitcoin'   => 'BTC',
    'Ethereum'  => 'ETH',
    'Usdt'      => 'USDT',
    'Doge'      => 'DOGE',
    'XDC'       => 'XDC',
    'Xlm'       => 'XLM',
    'Matic'     => 'MATIC',
    'Xrp'       => 'XRP',
    'Ltc'       => 'LTC',
    'Algorand'  => 'ALGO'
];

// Handle wallet selection
if (isset($_POST['select_wallet'])) {
    $selectedWallet = $_POST['wallet'];
    $column = $walletMap[$selectedWallet] ?? '';
    $walletAddress = $row[$column] ?? '';

    $_SESSION['address'] = $selectedWallet;
    $_SESSION['wallet_address'] = $walletAddress;
}

// Load wallet from session if available
$selectedWallet = $_SESSION['address'] ?? '';
$walletAddress  = $_SESSION['wallet_address'] ?? '';

// Handle deposit submission
if (isset($_POST['submit'])) {
    $hash   = trim($_POST['hash']);
    $amount = $_POST['amount'];
    $wallet = $_SESSION['address'];          
    $walletAddress = $_SESSION['wallet_address']; 
    $email  = $_SESSION['email'];

    if (empty($hash) || empty($_FILES['proof']['name'])) {
        die("All fields are required.");
    }

    // Validate image
    $allowed = ['jpg','jpeg','png','gif'];
    $filename = $_FILES['proof']['name'];
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    if (!in_array($ext, $allowed)) die("Invalid image type.");

    // Save file
    $newName = "proof_" . time() . "." . $ext;
    $uploadPath = "uploads/" . $newName;
    move_uploaded_file($_FILES['proof']['tmp_name'], $uploadPath);

    $datereg = date("Y-m-d H:i:s");

    // Insert into database
    $stmt = $conn->prepare("
        INSERT INTO deposit (username, wallet, wallet_address, amount, trans_id, proof, status, datereg)
        VALUES (?, ?, ?, ?, ?, ?, 'pending', ?)
    ");
    $stmt->execute([$email, $wallet, $walletAddress, $amount, $hash, $newName, $datereg]);

    $_SESSION['success'] = "Deposit submitted successfully and is now under review.";
    header("Location: deposit_success.php");
    exit();
}
?>


<html lang="en"><head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="twoone.tech">
    <meta name="csrf-token" content="AWO37hEyyaFjyNu7gt4uBj6e66n0lDGYYU2YPoWc">

    <title>Money Transfer |  Web3</title>

    <!-- css -->
    <link rel="stylesheet" href="public/dist/libraries/bootstrap-5.0.2/css/bootstrap.min.css">
<link rel="stylesheet" href="public/dist/plugins/select2-4.1.0-rc.0/css/select2.min.css">
<link rel="stylesheet" href="public/user/templates/css/style.min.css">
    <!-- end css -->
    
    <!-- favicon -->
    <link rel="shortcut icon" href="public/uploads/logos/1698017319_favicon.PNG">

    <script>
      'use strict';
      var SITE_URL = "https://Quantumsecurenova.com";
      var FIATDP = "0.00";
      var CRYPTODP = "0.00000000";

      if (localStorage.getItem('dark') === '1') {
        document.documentElement.classList.add('dark');
      }

      if (localStorage.getItem('lang') == 'ar') {
        document.getElementsByTagName("html")[0].setAttribute("dir", "rtl");
        document.querySelector("html").setAttribute("dir", "rtl");
      } else {
        document.querySelector("html").removeAttribute("dir", "rtl");
      }
    </script>
  </head>
  <body cz-shortcut-listen="true">

    <!-- sidebar section -->
    <!-- Sidebar Start -->
<div class="side-navbar active-nav d-flex justify-content-between flex-wrap flex-column" id="sidebar">
    <div class="bg-secondary vh-100 position-fixed d-flex flex-column w-inherit drop-parent">
        <div>
            <a href="https://Quantumsecurenova.com"><img class="ml-40 mt-20 pay-logo img-fluid" src="public/uploads/logos/1698017319_logo.png" alt="Web3"></a>
        </div>
        <div class="flex-grow-1 px-4 px-res mt-43 bg-secondary position-relative overflow-auto hide-thin-scrollbar thin-scrollbar">
            <ul class="list-unstyled ps-0 accordion accordion-flush position-absolute w-268" id="accordion-menu">

                <!-- Dashboard -->
                <li>
                    <a href="index.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.8611 13.8016H4.98016C4.7202 13.8016 4.4709 13.9049 4.28708 14.0887C4.10327 14.2725 4 14.5218 4 14.7817V20.6627C4 20.9227 4.10327 21.172 4.28708 21.3558C4.4709 21.5396 4.7202 21.6429 4.98016 21.6429H10.8611C11.1211 21.6429 11.3704 21.5396 11.5542 21.3558C11.738 21.172 11.8413 20.9227 11.8413 20.6627V14.7817C11.8413 14.5218 11.738 14.2725 11.5542 14.0887C11.3704 13.9049 11.1211 13.8016 10.8611 13.8016ZM9.88095 19.6825H5.96032V15.7619H9.88095V19.6825ZM20.6627 4H14.7817C14.5218 4 14.2725 4.10327 14.0887 4.28708C13.9049 4.4709 13.8016 4.7202 13.8016 4.98016V10.8611C13.8016 11.1211 13.9049 11.3704 14.0887 11.5542C14.2725 11.738 14.5218 11.8413 14.7817 11.8413H20.6627C20.9227 11.8413 21.172 11.738 21.3558 11.5542C21.5396 11.3704 21.6429 11.1211 21.6429 10.8611V4.98016C21.6429 4.7202 21.5396 4.4709 21.3558 4.28708C21.172 4.10327 20.9227 4 20.6627 4ZM19.6825 9.88095H15.7619V5.96032H19.6825V9.88095ZM20.6627 16.7421H18.7024V14.7817C18.7024 14.5218 18.5991 14.2725 18.4153 14.0887C18.2315 13.9049 17.9822 13.8016 17.7222 13.8016C17.4623 13.8016 17.213 13.9049 17.0291 14.0887C16.8453 14.2725 16.7421 14.5218 16.7421 14.7817V16.7421H14.7817C14.5218 16.7421 14.2725 16.8453 14.0887 17.0291C13.9049 17.213 13.8016 17.4623 13.8016 17.7222C13.8016 17.9822 13.9049 18.2315 14.0887 18.4153C14.2725 18.5991 14.5218 18.7024 14.7817 18.7024H16.7421V20.6627C16.7421 20.9227 16.8453 21.172 17.0291 21.3558C17.213 21.5396 17.4623 21.6429 17.7222 21.6429C17.9822 21.6429 18.2315 21.5396 18.4153 21.3558C18.5991 21.172 18.7024 20.9227 18.7024 20.6627V18.7024H20.6627C20.9227 18.7024 21.172 18.5991 21.3558 18.4153C21.5396 18.2315 21.6429 17.9822 21.6429 17.7222C21.6429 17.4623 21.5396 17.213 21.3558 17.0291C21.172 16.8453 20.9227 16.7421 20.6627 16.7421ZM10.8611 4H4.98016C4.7202 4 4.4709 4.10327 4.28708 4.28708C4.10327 4.4709 4 4.7202 4 4.98016V10.8611C4 11.1211 4.10327 11.3704 4.28708 11.5542C4.4709 11.738 4.7202 11.8413 4.98016 11.8413H10.8611C11.1211 11.8413 11.3704 11.738 11.5542 11.5542C11.738 11.3704 11.8413 11.1211 11.8413 10.8611V4.98016C11.8413 4.7202 11.738 4.4709 11.5542 4.28708C11.3704 4.10327 11.1211 4 10.8611 4ZM9.88095 9.88095H5.96032V5.96032H9.88095V9.88095Z" fill="#C1BFDF"></path>
                            </svg></span>
                        <span>Dashboard</span>
                    </a>
                </li>

                <!-- Wallets -->
                <li>
                    <a href="wallet.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.44369 5.6875L16.9313 5.6875C17.3596 5.68749 17.7291 5.68748 18.0335 5.71234C18.3547 5.73859 18.6742 5.79653 18.9816 5.95317C19.4402 6.18687 19.8131 6.55976 20.0468 7.0184C20.2035 7.32583 20.2614 7.64532 20.2877 7.96654C20.3125 8.27088 20.3125 8.64037 20.3125 9.06867V10.2956C21.1151 10.5791 21.7213 11.2668 21.8907 12.1182C21.938 12.3562 21.9378 12.6225 21.9375 12.9319C21.9375 12.9543 21.9375 12.9771 21.9375 13C21.9375 13.023 21.9375 13.0457 21.9375 13.0682C21.9378 13.3775 21.938 13.6438 21.8907 13.8818C21.7213 14.7332 21.1151 15.4209 20.3125 15.7044V16.9313C20.3125 17.3596 20.3125 17.7291 20.2877 18.0335C20.2614 18.3547 20.2035 18.6742 20.0468 18.9816C19.8131 19.4402 19.4402 19.8131 18.9816 20.0468C18.6742 20.2035 18.3547 20.2614 18.0335 20.2877C17.7291 20.3125 17.3596 20.3125 16.9313 20.3125L7.44367 20.3125C7.01537 20.3125 6.64588 20.3125 6.34154 20.2877C6.02032 20.2614 5.70083 20.2035 5.3934 20.0468C4.93475 19.8131 4.56186 19.4402 4.32817 18.9816C4.17153 18.6742 4.11358 18.3547 4.08734 18.0335C4.06247 17.7291 4.06249 17.3596 4.0625 16.9313V9.06868C4.06249 8.64038 4.06247 8.27088 4.08734 7.96654C4.11358 7.64532 4.17153 7.32583 4.32817 7.0184C4.56186 6.55975 4.93475 6.18686 5.3934 5.95317C5.70083 5.79653 6.02032 5.73858 6.34154 5.71234C6.64588 5.68747 7.01538 5.68749 7.44369 5.6875ZM18.6875 15.8438H17.4688C17.4458 15.8438 17.4231 15.8438 17.4006 15.8438C17.0913 15.844 16.8249 15.8442 16.587 15.7969C15.62 15.6046 14.8642 14.8487 14.6718 13.8818C14.6245 13.6438 14.6247 13.3775 14.625 13.0682C14.625 13.0457 14.625 13.023 14.625 13C14.625 12.9771 14.625 12.9543 14.625 12.9318C14.6247 12.6225 14.6245 12.3562 14.6718 12.1182C14.8642 11.1513 15.62 10.3954 16.587 10.2031C16.8249 10.1558 17.0913 10.156 17.4006 10.1562C17.4231 10.1562 17.4458 10.1563 17.4688 10.1563H18.6875V9.1C18.6875 8.63155 18.6869 8.32908 18.6681 8.09887C18.65 7.87814 18.6194 7.79631 18.5989 7.75613C18.521 7.60325 18.3968 7.47896 18.2439 7.40106C18.2037 7.38059 18.1219 7.34998 17.9011 7.33194C17.6709 7.31313 17.3684 7.3125 16.9 7.3125H7.475C7.00655 7.3125 6.70408 7.31313 6.47387 7.33194C6.25314 7.34998 6.17131 7.38059 6.13113 7.40106C5.97825 7.47896 5.85396 7.60325 5.77606 7.75613C5.75559 7.79631 5.72498 7.87814 5.70694 8.09887C5.68813 8.32908 5.6875 8.63155 5.6875 9.1V16.9C5.6875 17.3685 5.68813 17.6709 5.70694 17.9011C5.72498 18.1219 5.75559 18.2037 5.77606 18.2439C5.85396 18.3967 5.97825 18.521 6.13113 18.5989C6.17131 18.6194 6.25314 18.65 6.47387 18.6681C6.70408 18.6869 7.00655 18.6875 7.475 18.6875L16.9 18.6875C17.3685 18.6875 17.6709 18.6869 17.9011 18.6681C18.1219 18.65 18.2037 18.6194 18.2439 18.5989C18.3968 18.521 18.521 18.3967 18.5989 18.2439C18.6194 18.2037 18.65 18.1219 18.6681 17.9011C18.6869 17.6709 18.6875 17.3685 18.6875 16.9V15.8438ZM17.4688 11.7813C17.0523 11.7813 16.9627 11.7852 16.904 11.7969C16.5817 11.861 16.3297 12.1129 16.2656 12.4352C16.2539 12.4939 16.25 12.5835 16.25 13C16.25 13.4165 16.2539 13.5061 16.2656 13.5648C16.3297 13.8871 16.5817 14.139 16.904 14.2031C16.9627 14.2148 17.0523 14.2188 17.4688 14.2188H19.0938C19.5102 14.2188 19.5998 14.2148 19.6585 14.2031C19.9808 14.139 20.2328 13.8871 20.2969 13.5648C20.3086 13.5061 20.3125 13.4165 20.3125 13C20.3125 12.5835 20.3086 12.4939 20.2969 12.4352C20.2328 12.1129 19.9808 11.861 19.6585 11.7969C19.5998 11.7852 19.5102 11.7813 19.0938 11.7813H17.4688Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Wallets</span>
                    </a>
                </li>
                <!-- Cards -->
                <li>
                    <a href="cards.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.44369 5.6875L16.9313 5.6875C17.3596 5.68749 17.7291 5.68748 18.0335 5.71234C18.3547 5.73859 18.6742 5.79653 18.9816 5.95317C19.4402 6.18687 19.8131 6.55976 20.0468 7.0184C20.2035 7.32583 20.2614 7.64532 20.2877 7.96654C20.3125 8.27088 20.3125 8.64037 20.3125 9.06867V10.2956C21.1151 10.5791 21.7213 11.2668 21.8907 12.1182C21.938 12.3562 21.9378 12.6225 21.9375 12.9319C21.9375 12.9543 21.9375 12.9771 21.9375 13C21.9375 13.023 21.9375 13.0457 21.9375 13.0682C21.9378 13.3775 21.938 13.6438 21.8907 13.8818C21.7213 14.7332 21.1151 15.4209 20.3125 15.7044V16.9313C20.3125 17.3596 20.3125 17.7291 20.2877 18.0335C20.2614 18.3547 20.2035 18.6742 20.0468 18.9816C19.8131 19.4402 19.4402 19.8131 18.9816 20.0468C18.6742 20.2035 18.3547 20.2614 18.0335 20.2877C17.7291 20.3125 17.3596 20.3125 16.9313 20.3125L7.44367 20.3125C7.01537 20.3125 6.64588 20.3125 6.34154 20.2877C6.02032 20.2614 5.70083 20.2035 5.3934 20.0468C4.93475 19.8131 4.56186 19.4402 4.32817 18.9816C4.17153 18.6742 4.11358 18.3547 4.08734 18.0335C4.06247 17.7291 4.06249 17.3596 4.0625 16.9313V9.06868C4.06249 8.64038 4.06247 8.27088 4.08734 7.96654C4.11358 7.64532 4.17153 7.32583 4.32817 7.0184C4.56186 6.55975 4.93475 6.18686 5.3934 5.95317C5.70083 5.79653 6.02032 5.73858 6.34154 5.71234C6.64588 5.68747 7.01538 5.68749 7.44369 5.6875ZM18.6875 15.8438H17.4688C17.4458 15.8438 17.4231 15.8438 17.4006 15.8438C17.0913 15.844 16.8249 15.8442 16.587 15.7969C15.62 15.6046 14.8642 14.8487 14.6718 13.8818C14.6245 13.6438 14.6247 13.3775 14.625 13.0682C14.625 13.0457 14.625 13.023 14.625 13C14.625 12.9771 14.625 12.9543 14.625 12.9318C14.6247 12.6225 14.6245 12.3562 14.6718 12.1182C14.8642 11.1513 15.62 10.3954 16.587 10.2031C16.8249 10.1558 17.0913 10.156 17.4006 10.1562C17.4231 10.1562 17.4458 10.1563 17.4688 10.1563H18.6875V9.1C18.6875 8.63155 18.6869 8.32908 18.6681 8.09887C18.65 7.87814 18.6194 7.79631 18.5989 7.75613C18.521 7.60325 18.3968 7.47896 18.2439 7.40106C18.2037 7.38059 18.1219 7.34998 17.9011 7.33194C17.6709 7.31313 17.3684 7.3125 16.9 7.3125H7.475C7.00655 7.3125 6.70408 7.31313 6.47387 7.33194C6.25314 7.34998 6.17131 7.38059 6.13113 7.40106C5.97825 7.47896 5.85396 7.60325 5.77606 7.75613C5.75559 7.79631 5.72498 7.87814 5.70694 8.09887C5.68813 8.32908 5.6875 8.63155 5.6875 9.1V16.9C5.6875 17.3685 5.68813 17.6709 5.70694 17.9011C5.72498 18.1219 5.75559 18.2037 5.77606 18.2439C5.85396 18.3967 5.97825 18.521 6.13113 18.5989C6.17131 18.6194 6.25314 18.65 6.47387 18.6681C6.70408 18.6869 7.00655 18.6875 7.475 18.6875L16.9 18.6875C17.3685 18.6875 17.6709 18.6869 17.9011 18.6681C18.1219 18.65 18.2037 18.6194 18.2439 18.5989C18.3968 18.521 18.521 18.3967 18.5989 18.2439C18.6194 18.2037 18.65 18.1219 18.6681 17.9011C18.6869 17.6709 18.6875 17.3685 18.6875 16.9V15.8438ZM17.4688 11.7813C17.0523 11.7813 16.9627 11.7852 16.904 11.7969C16.5817 11.861 16.3297 12.1129 16.2656 12.4352C16.2539 12.4939 16.25 12.5835 16.25 13C16.25 13.4165 16.2539 13.5061 16.2656 13.5648C16.3297 13.8871 16.5817 14.139 16.904 14.2031C16.9627 14.2148 17.0523 14.2188 17.4688 14.2188H19.0938C19.5102 14.2188 19.5998 14.2148 19.6585 14.2031C19.9808 14.139 20.2328 13.8871 20.2969 13.5648C20.3086 13.5061 20.3125 13.4165 20.3125 13C20.3125 12.5835 20.3086 12.4939 20.2969 12.4352C20.2328 12.1129 19.9808 11.861 19.6585 11.7969C19.5998 11.7852 19.5102 11.7813 19.0938 11.7813H17.4688Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Web3 Cards</span>
                    </a>
                </li>
               
                <li class="mb-21 d-flex align-items-center res-trans text-warning f-13 ml-20 mt-39 gilroy-Semibold text-uppercase">Transactions</li>

                <!-- Transactions -->
                <li>
                    <a href="transactions.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M19.5 4.875H11.375C10.7285 4.875 10.1085 5.13181 9.65143 5.58893C9.19431 6.04605 8.9375 6.66603 8.9375 7.3125V13C8.9375 13.6465 9.19431 14.2665 9.65143 14.7236C10.1085 15.1807 10.7285 15.4375 11.375 15.4375H19.5C20.1465 15.4375 20.7665 15.1807 21.2236 14.7236C21.6807 14.2665 21.9375 13.6465 21.9375 13V7.3125C21.9375 6.66603 21.6807 6.04605 21.2236 5.58893C20.7665 5.13181 20.1465 4.875 19.5 4.875ZM20.3125 13C20.3125 13.2155 20.2269 13.4222 20.0745 13.5745C19.9222 13.7269 19.7155 13.8125 19.5 13.8125H11.375C11.1595 13.8125 10.9528 13.7269 10.8005 13.5745C10.6481 13.4222 10.5625 13.2155 10.5625 13V7.3125C10.5625 7.09701 10.6481 6.89035 10.8005 6.73798C10.9528 6.5856 11.1595 6.5 11.375 6.5H19.5C19.7155 6.5 19.9222 6.5856 20.0745 6.73798C20.2269 6.89035 20.3125 7.09701 20.3125 7.3125V13ZM17.4688 9.75C17.168 9.75102 16.8783 9.86398 16.6562 10.0669C16.4815 9.90807 16.2645 9.80344 16.0314 9.76568C15.7983 9.72793 15.5593 9.75868 15.3434 9.85421C15.1275 9.94973 14.944 10.1059 14.8152 10.3038C14.6863 10.5016 14.6178 10.7327 14.6178 10.9688C14.6178 11.2048 14.6863 11.4359 14.8152 11.6337C14.944 11.8316 15.1275 11.9878 15.3434 12.0833C15.5593 12.1788 15.7983 12.2096 16.0314 12.1718C16.2645 12.1341 16.4815 12.0294 16.6562 11.8706C16.803 12.004 16.98 12.0995 17.172 12.149C17.364 12.1984 17.5652 12.2003 17.7581 12.1544C17.951 12.1085 18.1297 12.0162 18.2789 11.8856C18.4281 11.755 18.5431 11.5899 18.614 11.4048C18.685 11.2196 18.7097 11.02 18.686 10.8231C18.6623 10.6263 18.5909 10.4382 18.4781 10.2751C18.3653 10.1121 18.2144 9.97906 18.0385 9.88755C17.8626 9.79604 17.667 9.74883 17.4688 9.75ZM16.25 17.0625C16.0345 17.0625 15.8278 17.1481 15.6755 17.3005C15.5231 17.4528 15.4375 17.6595 15.4375 17.875V18.6875C15.4375 18.903 15.3519 19.1097 15.1995 19.262C15.0472 19.4144 14.8405 19.5 14.625 19.5H6.5C6.28451 19.5 6.07785 19.4144 5.92548 19.262C5.7731 19.1097 5.6875 18.903 5.6875 18.6875V15.4375H6.5C6.71549 15.4375 6.92215 15.3519 7.07452 15.1995C7.2269 15.0472 7.3125 14.8405 7.3125 14.625C7.3125 14.4095 7.2269 14.2028 7.07452 14.0505C6.92215 13.8981 6.71549 13.8125 6.5 13.8125H5.6875V13C5.6875 12.7845 5.7731 12.5778 5.92548 12.4255C6.07785 12.2731 6.28451 12.1875 6.5 12.1875C6.71549 12.1875 6.92215 12.1019 7.07452 11.9495C7.2269 11.7972 7.3125 11.5905 7.3125 11.375C7.3125 11.1595 7.2269 10.9528 7.07452 10.8005C6.92215 10.6481 6.71549 10.5625 6.5 10.5625C5.85353 10.5625 5.23355 10.8193 4.77643 11.2764C4.31931 11.7335 4.0625 12.3535 4.0625 13V18.6875C4.0625 19.334 4.31931 19.954 4.77643 20.4111C5.23355 20.8682 5.85353 21.125 6.5 21.125H14.625C15.2715 21.125 15.8915 20.8682 16.3486 20.4111C16.8057 19.954 17.0625 19.334 17.0625 18.6875V17.875C17.0625 17.6595 16.9769 17.4528 16.8245 17.3005C16.6722 17.1481 16.4655 17.0625 16.25 17.0625ZM8.125 17.875H8.9375C9.15299 17.875 9.35965 17.7894 9.51202 17.637C9.6644 17.4847 9.75 17.278 9.75 17.0625C9.75 16.847 9.6644 16.6403 9.51202 16.488C9.35965 16.3356 9.15299 16.25 8.9375 16.25H8.125C7.90951 16.25 7.70285 16.3356 7.55048 16.488C7.3981 16.6403 7.3125 16.847 7.3125 17.0625C7.3125 17.278 7.3981 17.4847 7.55048 17.637C7.70285 17.7894 7.90951 17.875 8.125 17.875Z" fill="#C1BFDF"></path>
                            </svg></span>
                        <span>Transactions</span>
                    </a>
                </li>

                <!-- Deposit Money -->
                                <li>
                    <a href="depositmoney.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 5H18.5952C19.0265 4.99999 19.3986 4.99997 19.705 5.02548C20.0285 5.05239 20.3502 5.11182 20.6598 5.27249C21.1216 5.51217 21.4971 5.89462 21.7325 6.36503C21.8902 6.68034 21.9486 7.00802 21.975 7.33748C22 7.64962 22 8.02858 22 8.46786V11.6667C22 12.1269 21.6337 12.5 21.1818 12.5C20.7299 12.5 20.3636 12.1269 20.3636 11.6667V10.8333H5.63637V14.8333C5.63637 15.3138 5.637 15.624 5.65594 15.8601C5.6741 16.0865 5.70493 16.1705 5.72554 16.2117C5.80398 16.3685 5.92915 16.4959 6.0831 16.5758C6.12355 16.5968 6.20596 16.6282 6.42823 16.6467C6.66005 16.666 6.96464 16.6667 7.43636 16.6667H13C13.4519 16.6667 13.8182 17.0398 13.8182 17.5C13.8182 17.9602 13.4519 18.3333 13 18.3333H7.40485C6.97354 18.3333 6.60145 18.3334 6.29498 18.3079C5.97151 18.2809 5.64979 18.2215 5.34021 18.0608C4.87835 17.8212 4.50286 17.4387 4.26753 16.9683C4.10979 16.653 4.05144 16.3253 4.02501 15.9959C3.99997 15.6837 3.99999 15.3047 4 14.8655V8.46788C3.99999 8.02859 3.99997 7.64962 4.02501 7.33748C4.05144 7.00802 4.10979 6.68034 4.26753 6.36503C4.50286 5.89462 4.87835 5.51217 5.34021 5.27249C5.64979 5.11182 5.97151 5.05239 6.29498 5.02548C6.60145 4.99997 6.97353 4.99999 7.40483 5ZM5.63637 9.16667H20.3636V8.5C20.3636 8.01954 20.363 7.70931 20.3441 7.4732C20.3259 7.24681 20.2951 7.16288 20.2745 7.12168C20.196 6.96488 20.0709 6.83739 19.9169 6.7575C19.8764 6.7365 19.794 6.7051 19.5718 6.68661C19.3399 6.66732 19.0354 6.66667 18.5636 6.66667H7.43637C6.96464 6.66667 6.66005 6.66732 6.42823 6.68661C6.20596 6.7051 6.12355 6.7365 6.0831 6.7575C5.92915 6.83739 5.80398 6.96487 5.72554 7.12168C5.70493 7.16288 5.6741 7.24681 5.65594 7.4732C5.637 7.70931 5.63637 8.01954 5.63637 8.5V9.16667ZM18.7273 13.3333C19.1791 13.3333 19.5455 13.7064 19.5455 14.1667V17.1548L20.6033 16.0774C20.9228 15.752 21.4408 15.752 21.7604 16.0774C22.0799 16.4028 22.0799 16.9305 21.7604 17.2559L19.3058 19.7559C18.9863 20.0814 18.4683 20.0814 18.1487 19.7559L15.6942 17.2559C15.3747 16.9305 15.3747 16.4028 15.6942 16.0774C16.0137 15.752 16.5317 15.752 16.8513 16.0774L17.9091 17.1548V14.1667C17.9091 13.7064 18.2754 13.3333 18.7273 13.3333Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Deposit Money</span>
                    </a>
                </li>
                
                

                 
                <!-- Send Money -->
                                <li>
                    <a href="sendmoney.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-white bg-info">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M5.46393 5.03937C5.31364 5.10324 5.107 5.30989 5.04688 5.46393C4.93041 5.74197 4.94168 5.78706 6.16653 9.46536L7.34254 12.9896L6.16277 16.5252C5.05815 19.8465 4.98677 20.072 5.0018 20.2786C5.03185 20.6882 5.3174 20.9587 5.74572 20.985L5.9937 21L13.3203 17.3367C18.5541 14.7217 20.6844 13.6359 20.7746 13.5495C20.9361 13.3879 21 13.2263 21 12.9896C21 12.7529 20.9361 12.5914 20.7746 12.4298C20.6844 12.3434 18.5541 11.2613 13.3278 8.64629C6.13272 5.05064 6.00497 4.98677 5.79081 4.98677C5.67434 4.99053 5.52405 5.01307 5.46393 5.03937ZM12.7905 10.1792C15.8601 11.7159 18.37 12.9784 18.37 12.9896C18.37 13.0159 7.20728 18.5954 7.18849 18.5766C7.18098 18.5691 7.53416 17.4908 7.97375 16.1795L8.77028 13.7974L11.0284 13.7786L13.2864 13.7599L13.433 13.6584C13.5119 13.6021 13.6208 13.4931 13.6734 13.4142C13.7523 13.2977 13.7674 13.2338 13.7674 12.9896C13.7674 12.7379 13.7561 12.6853 13.6659 12.5538C13.6096 12.4749 13.5006 12.3659 13.4217 12.3133L13.2827 12.2194L11.0284 12.2006L8.77028 12.1818L7.97375 9.81478C7.53791 8.51103 7.17722 7.43647 7.17722 7.41768C7.17346 7.40266 7.18098 7.39138 7.19225 7.39138C7.20352 7.39138 9.72085 8.64629 12.7905 10.1792Z" fill="#FFAF30"></path>
                            </svg></span>
                        <span>Send Money</span>
                    </a>
                </li>
                
                <!-- Request Money -->
                                <li>
                    <a href="wallets.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M18.2894 15.5699V9.74756C18.2853 8.44269 17.4143 6.5 15.0313 6.5V4.875L11.7813 7.3125L15.0313 9.75V8.125C16.5173 8.125 16.6571 9.37544 16.6644 9.75V15.5699C15.4944 15.9226 14.6331 16.9975 14.6331 18.2812C14.6331 19.8494 15.9088 21.125 17.4769 21.125C19.045 21.125 20.3206 19.8494 20.3206 18.2812C20.3206 16.9975 19.4594 15.9226 18.2894 15.5699V15.5699ZM17.4769 19.5C16.8049 19.5 16.2581 18.9532 16.2581 18.2812C16.2581 17.6093 16.8049 17.0625 17.4769 17.0625C18.1488 17.0625 18.6956 17.6093 18.6956 18.2812C18.6956 18.9532 18.1488 19.5 17.4769 19.5ZM10.5625 7.71875C10.5625 6.15063 9.28688 4.875 7.71875 4.875C6.15063 4.875 4.875 6.15063 4.875 7.71875C4.875 9.0025 5.73625 10.0774 6.90625 10.4301V15.5699C5.73625 15.9226 4.875 16.9975 4.875 18.2812C4.875 19.8494 6.15063 21.125 7.71875 21.125C9.28688 21.125 10.5625 19.8494 10.5625 18.2812C10.5625 16.9975 9.70125 15.9226 8.53125 15.5699V10.4301C9.70125 10.0774 10.5625 9.0025 10.5625 7.71875ZM6.5 7.71875C6.5 7.04681 7.04681 6.5 7.71875 6.5C8.39069 6.5 8.9375 7.04681 8.9375 7.71875C8.9375 8.39069 8.39069 8.9375 7.71875 8.9375C7.04681 8.9375 6.5 8.39069 6.5 7.71875ZM8.9375 18.2812C8.9375 18.9532 8.39069 19.5 7.71875 19.5C7.04681 19.5 6.5 18.9532 6.5 18.2812C6.5 17.6093 7.04681 17.0625 7.71875 17.0625C8.39069 17.0625 8.9375 17.6093 8.9375 18.2812Z" fill="#C1BFDF"></path>
                                </svg></span>
                        <span>Link Wallet</span>
                    </a>
                </li>
                
                <!-- Exchange Money -->
                                <li>
                    <a href="https://lobstr.co/buy-xlm/" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.7231 12.2688C12.2769 11.7894 11.5781 11.4887 11.5781 10.725C11.5781 9.89625 12.48 9.59562 13.0488 9.59562C14.1131 9.59562 14.5031 10.4 14.5925 10.6844L15.8762 10.14C15.7544 9.77437 15.21 8.58 13.8125 8.32V7.3125H12.1875V8.33625C10.1725 8.79125 10.1644 10.66 10.1644 10.7413C10.1644 12.5856 11.9925 13.1056 12.8862 13.4306C14.17 13.8856 14.7388 14.3 14.7388 15.08C14.7388 15.9981 13.8856 16.3881 13.13 16.3881C11.6512 16.3881 11.2288 14.8687 11.18 14.69L9.83125 15.2344C10.3431 17.0138 11.6837 17.4931 12.1875 17.6394V18.6875H13.8125V17.68C14.1375 17.6069 16.1687 17.2006 16.1687 15.0637C16.1687 13.9344 15.6731 12.9431 13.7231 12.2688V12.2688ZM5.6875 20.3125H4.0625V15.4375H8.9375V17.0625H6.9225C8.23062 19.0206 10.465 20.3125 13 20.3125C14.9394 20.3125 16.7994 19.5421 18.1707 18.1707C19.5421 16.7994 20.3125 14.9394 20.3125 13H21.9375C21.9375 17.94 17.94 21.9375 13 21.9375C9.9775 21.9375 7.30438 20.4344 5.6875 18.1431V20.3125ZM4.0625 13C4.0625 8.06 8.06 4.0625 13 4.0625C16.0225 4.0625 18.6956 5.56563 20.3125 7.85688V5.6875H21.9375V10.5625H17.0625V8.9375H19.0775C17.7694 6.97937 15.535 5.6875 13 5.6875C11.0606 5.6875 9.20064 6.45792 7.82928 7.82928C6.45792 9.20064 5.6875 11.0606 5.6875 13H4.0625Z" fill="#C1BFDF"></path>
                                </svg></span>
                        <span>Buy ISO Assets</span>
                    </a>
                </li>
                
                <!-- Withdraw Money -->
                                <li class="accordion-item bg-secondary border-0">
                    <div class="accordion-header " id="flush-headtwo">
                        <button class="mb-1 shadow-none bg-transparent p-0 d-flex align-items-center list-option h-46 accordion-button accordion-icon collapsed text-info-100" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.40483 6H18.5952C19.0265 5.99999 19.3986 5.99997 19.705 6.02548C20.0285 6.05239 20.3502 6.11182 20.6598 6.27249C21.1216 6.51217 21.4971 6.89462 21.7325 7.36503C21.8902 7.68034 21.9486 8.00802 21.975 8.33748C22 8.64962 22 9.02858 22 9.46786V12.6667C22 13.1269 21.6337 13.5 21.1818 13.5C20.7299 13.5 20.3636 13.1269 20.3636 12.6667V11.8333H5.63637V15.8333C5.63637 16.3138 5.637 16.624 5.65594 16.8601C5.6741 17.0865 5.70493 17.1705 5.72554 17.2117C5.80398 17.3685 5.92915 17.4959 6.0831 17.5758C6.12355 17.5968 6.20596 17.6282 6.42823 17.6467C6.66005 17.666 6.96464 17.6667 7.43636 17.6667H13C13.4519 17.6667 13.8182 18.0398 13.8182 18.5C13.8182 18.9602 13.4519 19.3333 13 19.3333H7.40485C6.97354 19.3333 6.60145 19.3334 6.29498 19.3079C5.97151 19.2809 5.64979 19.2215 5.34021 19.0608C4.87835 18.8212 4.50286 18.4387 4.26753 17.9683C4.10979 17.653 4.05144 17.3253 4.02501 16.9959C3.99997 16.6837 3.99999 16.3047 4 15.8655V9.46788C3.99999 9.02859 3.99997 8.64962 4.02501 8.33748C4.05144 8.00802 4.10979 7.68034 4.26753 7.36503C4.50286 6.89462 4.87835 6.51217 5.34021 6.27249C5.64979 6.11182 5.97151 6.05239 6.29498 6.02548C6.60145 5.99997 6.97353 5.99999 7.40483 6ZM5.63637 10.1667H20.3636V9.5C20.3636 9.01954 20.363 8.70931 20.3441 8.4732C20.3259 8.24681 20.2951 8.16288 20.2745 8.12168C20.196 7.96488 20.0709 7.83739 19.9169 7.7575C19.8764 7.7365 19.794 7.7051 19.5718 7.68661C19.3399 7.66732 19.0354 7.66667 18.5636 7.66667H7.43637C6.96464 7.66667 6.66005 7.66732 6.42823 7.68661C6.20596 7.7051 6.12355 7.7365 6.0831 7.7575C5.92915 7.83739 5.80398 7.96487 5.72554 8.12168C5.70493 8.16288 5.6741 8.24681 5.65594 8.4732C5.637 8.70931 5.63637 9.01954 5.63637 9.5V10.1667ZM18.1487 14.5774C18.4683 14.252 18.9863 14.252 19.3058 14.5774L21.7604 17.0774C22.0799 17.4028 22.0799 17.9305 21.7604 18.2559C21.4408 18.5814 20.9228 18.5814 20.6033 18.2559L19.5455 17.1785V20.1667C19.5455 20.6269 19.1791 21 18.7273 21C18.2754 21 17.9091 20.6269 17.9091 20.1667V17.1785L16.8513 18.2559C16.5317 18.5814 16.0137 18.5814 15.6942 18.2559C15.3747 17.9305 15.3747 17.4028 15.6942 17.0774L18.1487 14.5774Z" fill="#C1BFDF"></path>
                            </svg></span>
                            <span class="child-currency">Withdrawals</span>
                        </button>
                    </div>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse " aria-labelledby="flush-headtwo" data-bs-parent="#accordion-menu">
                        <ul class="accordion-body collapse-child ml-28 p-0 pl-16 mr-20">

                            <!-- Withdraw Money -->
                            <li><a href="withdraw.php" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 text-info-100">Withdraw Money</a></li>
                            
                            <!-- Withdraw List -->
                            <li><a href="withdrawlist.php" class="mb-2 ml-34 pl-14 f-14 d-flex align-items-center list-option h-46 text-info-100">Withdrawal List</a></li>

                            <!-- Withdraw Settings -->
                            <
                        </ul>
                    </div>
                </li>
                
                <!-- Merchant Payments -->
                
                <li class="mb-20 d-flex align-items-center text-warning f-13 ml-20 mt-38 gilroy-Semibold res-other text-uppercase">Others</li>

                <!-- Dispute -->
                <li>
                    <a href="dispute.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16.375 5C16.806 5 17.2193 5.1712 17.524 5.47595C17.8288 5.7807 18 6.19402 18 6.625H6.625V15.7063C6.19402 15.7063 5.7807 15.5351 5.47595 15.2304C5.1712 14.9256 5 14.5123 5 14.0813V6.625C5 6.19402 5.1712 5.7807 5.47595 5.47595C5.7807 5.1712 6.19402 5 6.625 5H16.375Z" fill="#C1BFDF"></path>
                            <path d="M14.75 21.25L12.5831 18.9563H9.875C9.44402 18.9563 9.0307 18.7851 8.72595 18.4804C8.4212 18.1756 8.25 17.7623 8.25 17.3313V9.875C8.25 9.44402 8.4212 9.0307 8.72595 8.72595C9.0307 8.4212 9.44402 8.25 9.875 8.25H19.625C20.056 8.25 20.4693 8.4212 20.774 8.72595C21.0788 9.0307 21.25 9.44402 21.25 9.875V17.3313C21.25 17.7623 21.0788 18.1756 20.774 18.4804C20.4693 18.7851 20.056 18.9563 19.625 18.9563H16.9169L14.75 21.25ZM16.2166 17.3313H19.625V9.875H9.875V17.3313H13.2834L14.75 18.8832L16.2166 17.3313Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Disputes</span>
                    </a>
                </li>

                <!-- Tickets -->
                <li>
                    <a href="ticket.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.21567 6H18.7843C19.1917 5.99999 19.5431 5.99997 19.8325 6.02378C20.138 6.0489 20.4419 6.10437 20.7343 6.25432C21.1704 6.47802 21.5251 6.83498 21.7473 7.27402C21.8963 7.56832 21.9514 7.87416 21.9764 8.18165C22 8.47298 22 8.82667 22 9.23667V10.2778C22 10.7073 21.654 11.0556 21.2273 11.0556C20.1604 11.0556 19.2955 11.9261 19.2955 13C19.2955 14.0739 20.1604 14.9444 21.2273 14.9444C21.654 14.9444 22 15.2927 22 15.7222V16.7633C22 17.1733 22 17.527 21.9764 17.8184C21.9514 18.1258 21.8963 18.4317 21.7473 18.726C21.5251 19.165 21.1704 19.522 20.7343 19.7457C20.4419 19.8956 20.138 19.9511 19.8325 19.9762C19.5431 20 19.1917 20 18.7843 20H8.21565C7.80832 20 7.45692 20 7.16748 19.9762C6.86199 19.9511 6.55813 19.8956 6.26575 19.7457C5.82956 19.522 5.47492 19.165 5.25267 18.726C5.10369 18.4317 5.04858 18.1258 5.02362 17.8184C4.99997 17.527 4.99999 17.1733 5 16.7633L5 15.7222C5 15.2927 5.34596 14.9444 5.77273 14.9444C6.83964 14.9444 7.70455 14.0739 7.70455 13C7.70455 11.9261 6.83964 11.0556 5.77273 11.0556C5.34596 11.0556 5 10.7073 5 10.2778L5 9.23669C4.99999 8.82668 4.99997 8.47298 5.02362 8.18165C5.04858 7.87416 5.10369 7.56832 5.25267 7.27402C5.47492 6.83498 5.82956 6.47802 6.26575 6.25432C6.55813 6.10437 6.86199 6.0489 7.16748 6.02378C7.45692 5.99997 7.80833 5.99999 8.21567 6ZM7.29333 7.57417C7.08341 7.59143 7.00558 7.62074 6.96737 7.64033C6.82197 7.7149 6.70376 7.83388 6.62968 7.98023C6.61021 8.01869 6.5811 8.09702 6.56395 8.30832C6.54606 8.52869 6.54546 8.81824 6.54546 9.26667V9.58673C8.09399 9.94041 9.25 11.3343 9.25 13C9.25 14.6657 8.09399 16.0596 6.54546 16.4133V16.7333C6.54546 17.1818 6.54606 17.4713 6.56395 17.6917C6.5811 17.903 6.61021 17.9813 6.62968 18.0198C6.70376 18.1661 6.82197 18.2851 6.96737 18.3597C7.00558 18.3793 7.08341 18.4086 7.29333 18.4258C7.51227 18.4438 7.79994 18.4444 8.24546 18.4444H18.7545C19.2001 18.4444 19.4877 18.4438 19.7067 18.4258C19.9166 18.4086 19.9944 18.3793 20.0326 18.3597C20.178 18.2851 20.2962 18.1661 20.3703 18.0198C20.3898 17.9813 20.4189 17.903 20.4361 17.6917C20.4539 17.4713 20.4545 17.1818 20.4545 16.7333V16.4133C18.906 16.0596 17.75 14.6657 17.75 13C17.75 11.3343 18.906 9.94041 20.4545 9.58673V9.26667C20.4545 8.81824 20.4539 8.52869 20.4361 8.30832C20.4189 8.09702 20.3898 8.01869 20.3703 7.98023C20.2962 7.83388 20.178 7.7149 20.0326 7.64033C19.9944 7.62074 19.9166 7.59143 19.7067 7.57417C19.4877 7.55616 19.2001 7.55556 18.7545 7.55556H8.24546C7.79994 7.55556 7.51227 7.55616 7.29333 7.57417ZM11.9545 8.33333C12.3813 8.33333 12.7273 8.68156 12.7273 9.11111V9.88889C12.7273 10.3184 12.3813 10.6667 11.9545 10.6667C11.5278 10.6667 11.1818 10.3184 11.1818 9.88889V9.11111C11.1818 8.68156 11.5278 8.33333 11.9545 8.33333ZM11.9545 11.8333C12.3813 11.8333 12.7273 12.1816 12.7273 12.6111V13.3889C12.7273 13.8184 12.3813 14.1667 11.9545 14.1667C11.5278 14.1667 11.1818 13.8184 11.1818 13.3889V12.6111C11.1818 12.1816 11.5278 11.8333 11.9545 11.8333ZM11.9545 15.3333C12.3813 15.3333 12.7273 15.6816 12.7273 16.1111V16.8889C12.7273 17.3184 12.3813 17.6667 11.9545 17.6667C11.5278 17.6667 11.1818 17.3184 11.1818 16.8889V16.1111C11.1818 15.6816 11.5278 15.3333 11.9545 15.3333Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Tickets</span>
                    </a>
                </li>

                <!-- Profile -->
                <li>
                    <a href="profile.php" class="mb-1 d-flex align-items-center list-option h-46 mt-7 text-info-100">
                        <span class="ms-3 mr-20"><svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0001 6.33366C11.3892 6.33366 10.0834 7.63949 10.0834 9.25033C10.0834 10.8612 11.3892 12.167 13.0001 12.167C14.6109 12.167 15.9167 10.8612 15.9167 9.25033C15.9167 7.63949 14.6109 6.33366 13.0001 6.33366ZM8.41674 9.25033C8.41674 6.71902 10.4688 4.66699 13.0001 4.66699C15.5314 4.66699 17.5834 6.71902 17.5834 9.25033C17.5834 11.7816 15.5314 13.8337 13.0001 13.8337C10.4688 13.8337 8.41674 11.7816 8.41674 9.25033ZM10.772 15.0836C10.8195 15.0836 10.8678 15.0837 10.9167 15.0837H15.0834C15.1324 15.0837 15.1806 15.0836 15.2282 15.0836C16.2509 15.0832 16.9493 15.083 17.5429 15.2631C18.8746 15.667 19.9167 16.7091 20.3207 18.0408C20.5007 18.6345 20.5005 19.3328 20.5001 20.3555C20.5001 20.4031 20.5001 20.4513 20.5001 20.5003C20.5001 20.9606 20.127 21.3337 19.6667 21.3337C19.2065 21.3337 18.8334 20.9606 18.8334 20.5003C18.8334 19.2767 18.8244 18.8497 18.7258 18.5246C18.4834 17.7256 17.8581 17.1003 17.0591 16.858C16.7341 16.7594 16.307 16.7503 15.0834 16.7503H10.9167C9.69314 16.7503 9.26608 16.7594 8.94102 16.858C8.14202 17.1003 7.51676 17.7256 7.27439 18.5246C7.17578 18.8497 7.16674 19.2767 7.16674 20.5003C7.16674 20.9606 6.79364 21.3337 6.3334 21.3337C5.87317 21.3337 5.50007 20.9606 5.50007 20.5003C5.50007 20.4514 5.50005 20.4031 5.50003 20.3555C5.49966 19.3328 5.4994 18.6345 5.67949 18.0408C6.08344 16.7091 7.12554 15.667 8.45721 15.2631C9.05088 15.083 9.74923 15.0832 10.772 15.0836Z" fill="#C1BFDF"></path>
                        </svg></span>
                        <span>Profile</span>
                    </a>
                </li>

                <!-- Verifications -->
               

                <!-- Custom Addons Header Menu -->
                        
                                                                                                                                            <!-- Custom Addons Header Menu End-->
            </ul>
        </div>
    </div>
</div>

<!-- Sidebar End -->
    <!-- end sidebar section -->

    <div class="my-container active-cont bg-white-50">

        <!-- header section -->
        <nav class="navbar navbar sticky-top top-navbar bg-white p-0">
    <a class="btn border-0 menu-svg" id="menu-btn">
        <svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M1 7H19M1 1H19M1 13H13" stroke="" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
        </svg>
    </a>
    
    <div class="border-b-DF d-flex align-items-center w-100 h-70">
        <div class="input-group flex-nowrap search-fill">
            
        </div>

        <div class="color-parent form-check form-switch d-flex mr-33">
            <div class="switch d-flex align-items-center justify-content-center">
                
                <span class="moon-rtl">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"></path>
                </svg>
                </span>
                <div class="mx-10" id="switch">
                    <input class="form-check-input theme-check m-0" type="checkbox" id="flexSwitchCheckDefault">
                </div>
                <span class="moon-ltr">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.48582 2.84091C8.67976 3.03564 8.73332 3.33061 8.62031 3.58153C8.26666 4.36671 8.06945 5.23872 8.06945 6.15876C8.06945 9.61707 10.8616 12.4206 14.306 12.4206C15.2223 12.4206 16.0908 12.2226 16.8728 11.8675C17.1227 11.754 17.4165 11.8078 17.6104 12.0025C17.8044 12.1973 17.8579 12.4922 17.7449 12.7432C16.5602 15.3735 13.923 17.2059 10.8582 17.2059C6.68582 17.2059 3.30347 13.8098 3.30347 9.62056C3.30347 6.5433 5.12845 3.89543 7.74819 2.70588C7.9981 2.5924 8.29187 2.64618 8.48582 2.84091ZM6.87136 4.80495C5.49618 5.954 4.62165 7.68514 4.62165 9.62056C4.62165 13.0789 7.41383 15.8824 10.8582 15.8824C12.7858 15.8824 14.5099 15.0043 15.6543 13.6235C15.2166 13.7028 14.7659 13.7441 14.306 13.7441C10.1336 13.7441 6.75127 10.348 6.75127 6.15876C6.75127 5.69694 6.79245 5.24447 6.87136 4.80495Z" fill="currentColor"></path>
                </svg>
                </span>
            </div>
        </div>

        <div class="notification-drop p-0 d-flex align-items-center">
            <div class="item">
                <div class="d-flex align-items-center">
                    <div class="d-flex align-items-center justify-content-center user-list">
                        <img src="public/dist/images/default-avatar.png" alt="Profile" class="img-fluid">
                    </div>
                    <div class="ml-12 d-flex align-items-center h-78 w-134">
                        <p class="mb-0 f-14 text-dark gilroy-Semibold"><?php echo $_SESSION['username']; ?></p>
                        <span class="ml-13">
                            <svg width="9" height="5" viewBox="0 0 9 5" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M0.401158 0.234532C0.639812 -0.00412146 1.02675 -0.00412146 1.2654 0.234532L4.49995 3.46908L7.73449 0.234532C7.97315 -0.00412146 8.36008 -0.00412146 8.59873 0.234532C8.83739 0.473186 8.83739 0.86012 8.59873 1.09877L4.93207 4.76544C4.69341 5.00409 4.30648 5.00409 4.06783 4.76544L0.401158 1.09877C0.162505 0.86012 0.162505 0.473186 0.401158 0.234532Z" fill="#3F405B"></path>
                            </svg>
                        </span>
                    </div>
                </div>
                <ul class="open-notify open-drop bg-white">
                    <li class="d-flex align-items-center bg-secondary h-78 px-3">
                        <div class="d-flex align-items-center justify-content-center user-dp">
                            <img src="public/dist/images/default-avatar.png" alt="Profile" class="img-fluid">
                        </div>
                        <div class="ms-3 text-white">
                            <p class="mb-0 f-15 gilroy-medium text-white"><?php echo $_SESSION['username']; ?></p>
                            <p class="mb-0 f-13 mt-3p gilroy-regular text-info-100"><?php echo $_SESSION['email']; ?></p>
                        </div>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="profile.php" class="f-13 gilroy-medium">
                            <svg width="15" height="17" viewBox="0 0 15 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 1.7C5.88918 1.7 4.58336 3.03195 4.58336 4.675C4.58336 6.31805 5.88918 7.65 7.5 7.65C9.11082 7.65 10.4166 6.31805 10.4166 4.675C10.4166 3.03195 9.11082 1.7 7.5 1.7ZM2.91671 4.675C2.91671 2.09307 4.96872 0 7.5 0C10.0313 0 12.0833 2.09307 12.0833 4.675C12.0833 7.25693 10.0313 9.35 7.5 9.35C4.96872 9.35 2.91671 7.25693 2.91671 4.675ZM5.27191 10.625C5.31946 10.625 5.36771 10.625 5.41669 10.625H9.58331C9.63229 10.625 9.68054 10.625 9.72809 10.625C10.7508 10.6246 11.4491 10.6243 12.0428 10.808C13.3745 11.22 14.4166 12.283 14.8205 13.6413C15.0006 14.2468 15.0003 14.9591 15 16.0023C14.9999 16.0508 14.9999 16.1 14.9999 16.15C14.9999 16.6194 14.6268 17 14.1666 17C13.7064 17 13.3333 16.6194 13.3333 16.15C13.3333 14.9019 13.3242 14.4663 13.2256 14.1348C12.9833 13.3198 12.358 12.682 11.559 12.4348C11.234 12.3342 10.8069 12.325 9.58331 12.325H5.41669C4.1931 12.325 3.76604 12.3342 3.44099 12.4348C2.642 12.682 2.01674 13.3198 1.77437 14.1348C1.67577 14.4663 1.66672 14.9019 1.66672 16.15C1.66672 16.6194 1.29363 17 0.833395 17C0.373162 17 6.93952e-05 16.6194 6.93952e-05 16.15C6.93952e-05 16.1 5.1514e-05 16.0508 3.39308e-05 16.0023C-0.000344456 14.9591 -0.000602846 14.2468 0.179484 13.6413C0.583439 12.283 1.62553 11.22 2.95719 10.808C3.55085 10.6243 4.24919 10.6246 5.27191 10.625Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">View Profile</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="wallet.php" class="f-13 gilroy-medium">
                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.21566 6.68974e-07L12.2388 8.54411e-07C12.6462 -1.2497e-05 12.9976 -2.3901e-05 13.287 0.0237793C13.5925 0.0489025 13.8964 0.10437 14.1887 0.254321C14.6249 0.478026 14.9796 0.83498 15.2018 1.27403C15.3508 1.56832 15.4059 1.87416 15.4309 2.18165C15.4545 2.47298 15.4545 2.82668 15.4545 3.23667V4.41114C16.2177 4.68253 16.7943 5.34089 16.9554 6.1559C17.0004 6.38368 17.0002 6.63866 17 6.93477C17 6.95629 16.9999 6.97803 16.9999 7C16.9999 7.02197 17 7.04372 17 7.06526C17.0002 7.36135 17.0004 7.61633 16.9554 7.8441C16.7943 8.65911 16.2177 9.31748 15.4545 9.58886V10.7633C15.4545 11.1733 15.4545 11.527 15.4309 11.8184C15.4059 12.1258 15.3508 12.4317 15.2018 12.726C14.9796 13.165 14.6249 13.522 14.1887 13.7457C13.8964 13.8956 13.5925 13.9511 13.287 13.9762C12.9976 14 12.6462 14 12.2388 14L3.21564 14C2.80831 14 2.45691 14 2.16747 13.9762C1.86198 13.9511 1.55813 13.8956 1.26575 13.7457C0.829554 13.522 0.474918 13.165 0.252667 12.726C0.10369 12.4317 0.0485829 12.1258 0.0236231 11.8184C-2.51275e-05 11.527 -1.31528e-05 11.1733 6.64628e-07 10.7633V3.23669C-1.31528e-05 2.82668 -2.51275e-05 2.47298 0.0236232 2.18165C0.048583 1.87416 0.103691 1.56832 0.252667 1.27402C0.474918 0.834979 0.829554 0.478024 1.26575 0.25432C1.55813 0.104369 1.86198 0.0489007 2.16747 0.0237777C2.45691 -2.52918e-05 2.80832 -1.32388e-05 3.21566 6.68974e-07ZM13.909 9.72222H12.7499C12.7281 9.72222 12.7065 9.72224 12.6851 9.72226C12.391 9.72249 12.1376 9.7227 11.9113 9.67739C10.9917 9.49327 10.2729 8.76971 10.09 7.8441C10.0449 7.61632 10.0451 7.36134 10.0454 7.06525C10.0454 7.04372 10.0454 7.02197 10.0454 7C10.0454 6.97803 10.0454 6.95628 10.0454 6.93476C10.0451 6.63866 10.0449 6.38368 10.09 6.1559C10.2729 5.23029 10.9917 4.50673 11.9113 4.32261C12.1376 4.27731 12.391 4.27751 12.6851 4.27774C12.7065 4.27776 12.7281 4.27778 12.75 4.27778H13.909V3.26667C13.909 2.81824 13.9084 2.52869 13.8905 2.30832C13.8734 2.09703 13.8443 2.01869 13.8248 1.98023C13.7507 1.83388 13.6325 1.7149 13.4871 1.64033C13.4489 1.62074 13.3711 1.59143 13.1612 1.57417C12.9422 1.55616 12.6546 1.55556 12.209 1.55556H3.24544C2.79993 1.55556 2.51226 1.55616 2.29332 1.57417C2.0834 1.59143 2.00557 1.62074 1.96736 1.64033C1.82197 1.7149 1.70376 1.83388 1.62967 1.98023C1.6102 2.01869 1.58109 2.09702 1.56394 2.30832C1.54605 2.52869 1.54545 2.81824 1.54545 3.26667V10.7333C1.54545 11.1818 1.54605 11.4713 1.56394 11.6917C1.58109 11.903 1.6102 11.9813 1.62967 12.0198C1.70376 12.1661 1.82197 12.2851 1.96736 12.3597C2.00557 12.3793 2.0834 12.4086 2.29332 12.4258C2.51226 12.4438 2.79993 12.4444 3.24544 12.4444L12.209 12.4444C12.6546 12.4444 12.9422 12.4438 13.1612 12.4258C13.3711 12.4086 13.4489 12.3793 13.4871 12.3597C13.6325 12.2851 13.7507 12.1661 13.8248 12.0198C13.8443 11.9813 13.8734 11.903 13.8905 11.6917C13.9084 11.4713 13.909 11.1818 13.909 10.7333V9.72222ZM12.75 5.83333C12.3539 5.83333 12.2687 5.8371 12.2128 5.84828C11.9063 5.90965 11.6667 6.15084 11.6057 6.45937C11.5946 6.51557 11.5909 6.60132 11.5909 7C11.5909 7.39868 11.5946 7.48443 11.6057 7.54063C11.6667 7.84916 11.9063 8.09035 12.2128 8.15172C12.2687 8.1629 12.3539 8.16667 12.7499 8.16667H14.2954C14.6915 8.16667 14.7767 8.1629 14.8325 8.15172C15.139 8.09035 15.3787 7.84916 15.4396 7.54063C15.4507 7.48443 15.4545 7.39868 15.4545 7C15.4545 6.60132 15.4507 6.51557 15.4396 6.45937C15.3787 6.15084 15.139 5.90965 14.8325 5.84828C14.7767 5.8371 14.6915 5.83333 14.2954 5.83333H12.75Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Check Wallet</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center">
                        <a href="profile.php" class="f-13 gilroy-medium">
                            <svg width="17" height="15" viewBox="0 0 17 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.03788 0H1.82273V6.25H3.03788V0ZM10.4503 6.25H6.56183L6.07577 5.5625V4.3125L6.56183 3.75H10.4503L10.9364 4.375V5.625L10.4503 6.25ZM4.37455 10H0.486061L0 9.375V8.125L0.486061 7.5H4.37455L4.86061 8.125V9.375L4.37455 10ZM9.11365 0H7.8985V2.5H9.11365V0ZM7.8985 7.5H9.11365V15H7.8985V7.5ZM3.03788 11.25H1.82273V15H3.03788V11.25ZM12.6376 11.25H16.5139L17 10.625V9.4375L16.5139 8.8125H12.6376L12.1515 9.4375V10.625L12.6376 11.25ZM15.1894 0H13.9743V7.5H15.1894V0ZM13.9743 12.5H15.1894V15H13.9743V12.5Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Settings</span>
                        </a>
                    </li>
                    <li class="d-flex align-items-center border-top h-63">
                        <a href="logout.php" class="f-13 gilroy-medium">
                            <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.03109 3.01904e-07L4.9 6.3569e-07C5.2866 6.3569e-07 5.6 0.313401 5.6 0.700001C5.6 1.0866 5.2866 1.4 4.9 1.4H4.06C3.4604 1.4 3.05279 1.40054 2.73773 1.42629C2.43084 1.45136 2.27389 1.49681 2.16441 1.55259C1.90099 1.68681 1.68681 1.90099 1.55259 2.16441C1.49681 2.27389 1.45136 2.43084 1.42629 2.73773C1.40054 3.05279 1.4 3.46039 1.4 4.06V9.94C1.4 10.5396 1.40054 10.9472 1.42629 11.2623C1.45136 11.5692 1.49681 11.7261 1.55259 11.8356C1.68681 12.099 1.90099 12.3132 2.16441 12.4474C2.27389 12.5032 2.43084 12.5486 2.73773 12.5737C3.05279 12.5995 3.46039 12.6 4.06 12.6H4.9C5.2866 12.6 5.6 12.9134 5.6 13.3C5.6 13.6866 5.2866 14 4.9 14H4.03107C3.4676 14 3.00256 14 2.62372 13.9691C2.23025 13.9369 1.86856 13.8679 1.52883 13.6948C1.00197 13.4264 0.573628 12.998 0.305183 12.4712C0.132079 12.1314 0.0630838 11.7697 0.0309362 11.3763C-1.59696e-05 10.9974 -8.62687e-06 10.5324 3.01904e-07 9.96891V4.03109C-8.62687e-06 3.46761 -1.59696e-05 3.00256 0.0309363 2.62372C0.063084 2.23025 0.132079 1.86856 0.305183 1.52883C0.573629 1.00197 1.00197 0.573628 1.52883 0.305182C1.86856 0.132079 2.23025 0.0630838 2.62372 0.0309362C3.00256 -1.59696e-05 3.46761 -8.62687e-06 4.03109 3.01904e-07ZM9.30503 3.00503C9.57839 2.73166 10.0216 2.73166 10.295 3.00503L13.795 6.50503C14.0683 6.77839 14.0683 7.22161 13.795 7.49497L10.295 10.995C10.0216 11.2683 9.57839 11.2683 9.30503 10.995C9.03166 10.7216 9.03166 10.2784 9.30503 10.005L11.61 7.7H4.9C4.5134 7.7 4.2 7.3866 4.2 7C4.2 6.6134 4.5134 6.3 4.9 6.3H11.61L9.30503 3.99497C9.03166 3.72161 9.03166 3.27839 9.30503 3.00503Z" fill="currentColor"></path>
                            </svg>
                            <span class="ms-3">Logout</span>
                        </a>
                    </li>
                </ul>
            </div> 
        </div>
    </div>  
</nav>        <!-- end header section -->
<div class="container mt-5">
    <h2 class="mb-4">Deposit Money - <?php echo htmlspecialchars($selectedWallet); ?></h2>

    <div class="row">

        <!-- QR + Wallet Address -->
        <div class="col-md-6 mb-4">
            <div class="card text-center">
                <div class="card-header">
                    <h4>Wallet Info</h4>
                </div>
                <div class="card-body">
                    <?php if(!empty($walletAddress)): ?>
                        <!-- Display QR Code if exists -->
                        <img src="qrcodes/<?php echo htmlspecialchars($walletMap[$selectedWallet] ?? ''); ?>.png" 
                             alt="QR Code" class="img-fluid mb-3" style="max-width:200px;">
                        <p class="mb-2"><?php echo htmlspecialchars($walletAddress); ?></p>
                        <button class="btn btn-secondary" onclick="copyAddress()">Copy Address</button>
                    <?php else: ?>
                        <p>No wallet address found.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Deposit Form -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4>Submit Deposit</h4>
                </div>
                <div class="card-body">
                    <form method="post" action="" enctype="multipart/form-data">
                        <div class="form-group">
                            <label>Wallet</label>
                            <input type="text" name="wallet" class="form-control" 
                                   value="<?php echo htmlspecialchars($selectedWallet); ?>" readonly>
                        </div>

                        <div class="form-group">
                            <label>Wallet Address</label>
                            <div class="input-group">
                                <input type="text" class="form-control" value="<?php echo htmlspecialchars($walletAddress); ?>" id="walletAddress" readonly>
                                <button type="button" class="btn btn-secondary" onclick="copyAddress()">Copy</button>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>Amount</label>
                            <input type="number" step="0.0001" name="amount" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label>Transaction Hash</label>
                            <input type="text" name="hash" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label>Proof of Payment</label>
                            <input type="file" name="proof" accept="image/*" class="form-control" required>
                        </div>

                        <button type="submit" name="submit" class="btn btn-primary btn-block">Submit Deposit</button>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
function copyAddress() {
    var copyText = document.getElementById("walletAddress");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    document.execCommand("copy");
    alert("Copied the address: " + copyText.value);
}
</script>


<script>
function copyAddress() {
    const copyText = document.getElementById("walletAddress");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    document.execCommand("copy");
    alert("Wallet address copied: " + copyText.value);
}

function copyWallet() {
    const text = "<?php echo htmlspecialchars($_SESSION['wallet_address']); ?>";
    navigator.clipboard.writeText(text).then(() => {
        alert("Wallet address copied: " + text);
    });
}
</script>


        </div>
       </div>

       <!-- footer -->
       <footer class="d-flex align-items-center justify-content-between bg-white w-100 px-4 footer-sec">
    <div class="res-order d-flex align-items-center">
        <p class="mb-0 gilroy-medium">Copyright © 2024&nbsp;<a href="https://W3ciphering.com" class="link-text">Web3</a>&nbsp;|&nbsp;All Rights Reserved.</p>
        <span class="d-none">4.0.1</span>
    </div>
    <div class="d-flex f-link align-items-center">
        <div>
            <div class="d-flex align-items-center text-gray-100 f-13 blink-w sp" id="select_language">
                <div class="form-group selectParent f-13">
                    <select class="select2 form-control f-13 mb-2n select2-hidden-accessible" data-minimum-results-for-search="Infinity" id="select-height" data-select2-id="select2-data-select-height" tabindex="-1" aria-hidden="true">
                                                    <option class="f-13 gilroy-medium" selected="" value="en" data-select2-id="select2-data-4-4bp9">English</option>
                                                    <option class="f-13 gilroy-medium" value="ar">عربى</option>
                                                    <option class="f-13 gilroy-medium" value="fr">Français</option>
                                                    <option class="f-13 gilroy-medium" value="pt">Português</option>
                                                    <option class="f-13 gilroy-medium" value="ru">Русский</option>
                                                    <option class="f-13 gilroy-medium" value="es">Español</option>
                                                    <option class="f-13 gilroy-medium" value="tr">Türkçe</option>
                                                    <option class="f-13 gilroy-medium" value="ch">中文 (繁體)</option>
                                            </select><span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="select2-data-3-8gwo" style="width: 95px;"><span class="selection"><span class="select2-selection select2-selection--single" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-disabled="false" aria-labelledby="select2-select-height-container" aria-controls="select2-select-height-container"><span class="select2-selection__rendered" id="select2-select-height-container" role="textbox" aria-readonly="true" title="English">English</span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
                </div>
            </div>
        </div>
    </div>
    
 
</footer>       <!-- end footer -->

    </div>

    <!-- js -->
    <script src="public/dist/libraries/jquery-3.6.1/jquery-3.6.1.min.js"></script>
<script src="public/dist/libraries/bootstrap-5.0.2/js/bootstrap.bundle.min.js"></script>
<script src="public/dist/plugins/select2-4.1.0-rc.0/js/select2.min.js"></script>
<script src="public/user/templates/js/chart.umd.min.js"></script>
<script src="public/user/templates/js/main.min.js"></script>
<script src="public/user/customs/js/common.min.js"></script>

<script type="text/javascript">
    var SITE_URL = "https://Quantumsecurenova.com";
    var FIATDP = "0.00";
    var CRYPTODP = "0.00000000";

	$(document).ready(function() {
		$("#select_language").on("change", function() {
			if($("#select_language select").val() == 'ar'){
				localStorage.setItem('lang', 'ar');
				let lang = $("#select_language select").val();

				$.ajax({
					type: 'get',
					url: 'https://Quantumsecurenova.com/change-lang',
					data: {lang: lang},
					success: function (msg) {
						if (msg == 1) {
							location.reload();
							$("html").attr("dir", "rtl");
						}
					}
				});

			} else {
				let lang = $("#select_language select").val();
				$.ajax({
					type: 'get',
					url: 'https://Quantumsecurenova.com/change-lang',
					data: {lang: lang},
					success: function (msg) {
						if (msg == 1) {
							location.reload()
							localStorage.setItem('lang', lang);
							$("html").removeAttr("dir", "rtl");
						}
					}
				});
			}
		});
	});  

</script>

    <script type="text/javascript">
    function restrictNumberToPrefdecimal(e, type) {
        let decimalFormat =
            type === "fiat" ?
            "2" :
            "8";

        let num = $.trim(e.value);
        if (num.length > 0 && !isNaN(num)) {
            e.value = digitCheck(num, 8, decimalFormat);
            return e.value;
        }
    }

    function digitCheck(num, beforeDecimal, afterDecimal) {
        return num
            .replace(/[^\d.]/g, "")
            .replace(new RegExp("(^[\\d]{" + beforeDecimal + "})[\\d]", "g"), "$1")
            .replace(/(\..*)\./g, "$1")
            .replace(new RegExp("(\\.[\\d]{" + afterDecimal + "}).", "g"), "$1");
    }

</script>    <script>
    var isNumberOrDecimalPointKey = function(value, e) {

        var charCode = (e.which) ? e.which : e.keyCode;

        if (charCode == 46) {
            if (value.value.indexOf('.') === -1) {
                return true;
            } else {
                return false;
            }
        } else {
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
        }
        return true;
    }
</script>
    
    <script src="public/dist/plugins/html5-validation-1.0.0/validation.min.js"></script>
    <script src="public/dist/plugins/debounce-1.1/jquery.ba-throttle-debounce.min.js"></script>

    <script type="text/javascript">
        'use strict';
        let token = $('[name="_token"]').val();
        let processedBy = "email";
        let transactionTypeId = "3";
        let placeHolder = "Please enter valid :x";
        let validEmailMessage = placeHolder.replace(':x', 'email (ex: user@gmail.com)'); 
        let validPhoneMessage = placeHolder.replace(':x', 'phone (ex: +12015550123)');
        let validEmailOrPhoneMessage = placeHolder.replace(':x', 'email (ex: user@gmail.com) or phone (ex: +12015550123)');
        let lowBalanceText = "Not have enough balance !";
        let receiverStatusUrl = "https://Quantumsecurenova.com/transfer-user-email-phone-receiver-status-validate";
        let checkAmountLimitUrl = "https://Quantumsecurenova.com/amount-limit";
        let submitBtnText = 'Processing...';
    </script>
    <script src="public/user/customs/js/send-money.min.js"></script>
    <!-- end js -->
 

  
</body></html>
