<?php
session_start();
include "../secure/connect.php";

header('Content-Type: text/plain'); // So the response is readable in the browser or JS fetch()

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Debugging: check if session and post data are received
    if (!isset($_SESSION['email'])) {
        echo "Session email is not set.";
        exit;
    }

    $email = $_SESSION['email'];
    $amount = isset($_POST['amount']) ? floatval($_POST['amount']) : 0;
    $invest_type = isset($_POST['invest_type']) ? $_POST['invest_type'] : '';

    if ($email && $amount > 0 && $invest_type) {
        $stmt = $conn->prepare("INSERT INTO deposits (email, deposit, invest_type) VALUES (?, ?, ?)");
        $stmt->bind_param("sds", $email, $amount, $invest_type);

        if ($stmt->execute()) {
            echo "Deposit recorded.";
        } else {
            echo "Insert failed: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo "Invalid or missing data: ";
        echo "Email: $email, Amount: $amount, Type: $invest_type";
    }
} else {
    echo "Invalid request method.";
}
