<?php
session_start();
require '../secure/Database.php';
require '../secure/connect.php';

$database = new Database;

if (!isset($_SESSION['username'])) {
    header('Location: ../index.php');
    die();
}

$message = "";

// Handle update submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["submit"])) {
    $id  = intval($_POST["id"]);   // withdrawal id
    $bal = $_POST["bal"];          // new status

    $stmt = $conn->prepare("UPDATE withdrawal SET status=? WHERE id=?");
    $stmt->bind_param("si", $bal, $id);
    $stmt->execute();

    $message = "Status updated successfully for withdrawal ID: " . $id;
}

// Fetch unique usernames
$usernames = $conn->query("SELECT DISTINCT username FROM withdrawal");

// If username selected, fetch their withdrawals
$selectedUser = $_GET['username'] ?? null;
$withdrawals = [];
if ($selectedUser) {
    $stmt = $conn->prepare("SELECT id, amount, wallet_address, status, datereg FROM withdrawal WHERE username=?");
    $stmt->bind_param("s", $selectedUser);
    $stmt->execute();
    $withdrawals = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="en">
<?php include 'head.php'; ?>
<body class="app sidebar-mini rtl">
<?php include 'topnav.php'; ?>
<div class="app-sidebar__overlay" data-toggle="sidebar"></div>
<?php include 'nav.php'; ?>
<main class="app-content">
  <div class="clearfix"></div>
  <div class="col-md-12">
    <div class="tile">
      <h3 class="tile-title">Withdrawal Status</h3>

      <?php if ($message): ?>
        <div class="alert alert-success text-center"><?php echo $message; ?></div>
      <?php endif; ?>

      <!-- Step 1: Select Username -->
      <form method="get" action="">
        <select class="form-control" name="username" onchange="this.form.submit()" required>
          <option disabled selected>-- Select Username --</option>
          <?php while($u = $usernames->fetch_assoc()): ?>
            <option value="<?php echo htmlspecialchars($u['username']); ?>"
              <?php if ($selectedUser == $u['username']) echo 'selected'; ?>>
              <?php echo htmlspecialchars($u['username']); ?>
            </option>
          <?php endwhile; ?>
        </select>
      </form>
      <br>

      <!-- Step 2: If username chosen, show withdrawals in table -->
      <?php if ($selectedUser && count($withdrawals) > 0): ?>
        <div class="table-responsive">
          <table class="table table-bordered">
            <thead>
              <tr>
                <th>ID</th>
                <th>Amount</th>
                <th>Wallet Address</th>
                <th>Date</th>
                <th>Status</th>
                <th>Update</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($withdrawals as $w): ?>
              <tr>
                <td><?php echo $w['id']; ?></td>
                <td>$<?php echo htmlspecialchars($w['amount']); ?></td>
                <td><?php echo htmlspecialchars($w['wallet_address']); ?></td>
                <td><?php echo htmlspecialchars($w['datereg']); ?></td>
                <td><?php echo htmlspecialchars($w['status']); ?></td>
                <td>
                  <form method="post" style="display:flex; gap:5px;">
                    <input type="hidden" name="id" value="<?php echo $w['id']; ?>">
                    <input type="text" name="bal" class="form-control" placeholder="Enter new status" required>
                    <button type="submit" name="submit" class="btn btn-primary btn-sm">Update</button>
                  </form>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>

    </div>
  </div>
</main>
</body>
</html>
