<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Include the Composer autoload (for Composer users)
//require 'vendor/autoload.php';
// Or, if you manually installed PHPMailer, use:
 require 'PHPMailer/src/PHPMailer.php';
 require 'PHPMailer/src/Exception.php';
 require 'PHPMailer/src/SMTP.php';

$etitle = $fullname = $emailtitle = $eheader = $amount = $wallet = $otp = "";
$errors = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize and validate form inputs
    $etitle = filter_var(trim($_POST['etitle']), FILTER_SANITIZE_EMAIL);
    $fullname = htmlspecialchars(trim($_POST['fullname']));
    $emailtitle = htmlspecialchars(trim($_POST['emailtitle']));
    $eheader = htmlspecialchars(trim($_POST['eheader']));
    $amount = floatval($_POST['amount']);
    $wallet = htmlspecialchars(trim($_POST['wallet']));

    // Generate OTP (One-time password)
    $otp = bin2hex(openssl_random_pseudo_bytes(16)); // Using 16 bytes for OTP

    // Basic validation
    if (empty($etitle) || !filter_var($etitle, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Please enter a valid email address.";
    }
    if (empty($fullname)) {
        $errors[] = "Full name is required.";
    }
    if (empty($amount) || $amount <= 0) {
        $errors[] = "Please enter a valid withdrawal amount.";
    }
    if (empty($wallet)) {
        $errors[] = "Wallet address is required.";
    }

    if (empty($errors)) {
        // Use PHPMailer to send the email
        $mail = new PHPMailer(true);
        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host = 'www.Quantumsecurenova.com';  // Replace with your SMTP server (e.g., Gmail, Mailgun, etc.)
            $mail->SMTPAuth = true;
            $mail->Username = 'support@Quantumsecurenova.com'; // Replace with your SMTP username
            $mail->Password = 'Rapid12@1'; // Replace with your SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;

            // Recipients
            $mail->setFrom('support@Quantumsecurenova.com', 'Quantum Economic Networks');
            $mail->addAddress($etitle); // Recipient email

            // Content
            $mail->isHTML(true);
            $mail->Subject = $emailtitle;
            $mail->Body    = "
            <html>
                <head>
                    <title>$emailtitle</title>
                </head>
                <body style='font-family: Arial, sans-serif;'>
                    <center>
                        <img src='https://Quantumsecurenova.com/logo.png' alt='Logo' style='width: 50%; height: auto;'/><br><br>
                        <h3>$eheader</h3>
                        <h4>Dear $fullname,</h4>
                        <p>Your Deposit has been successfully Received. Below are the details:</p>
                        <p><strong>Amount:</strong> $$amount</p>
                        <p><strong>Wallet Address:</strong> $wallet</p>
                        <p><strong>Transaction Batch:</strong> $otp</p><br>
                        <p>If you face any challenges, please contact us at <a href='mailto:support@Quantumsecurenova.com'>support@Quantumsecurenova.com</a></p>
                    </center>
                </body>
            </html>";

            // Send email
            $mail->send();
            echo "<p style='color: green; font-weight: bold;'>Email was sent successfully!</p>";
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
    } else {
        // Display errors
        foreach ($errors as $error) {
            echo "<p style='color: red;'>$error</p>";
        }
    }
}
?>
<html lang="en">
  <?php include'head.php'; ?>
  <body class="app sidebar-mini rtl">
    <!-- Navbar-->
    <?php include'topnav.php'; ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <?php include'nav.php'; ?>
    <main class="app-content">
      
        <div class="clearfix"></div>
        <div class="col-md-12">
          <div class="tile">
            <h3 class="tile-title">Deposit Email Portal</h3>
            <div class="table-responsive">

<!-- HTML Form for Sending Email -->
<form action="alert.php" method="POST">
    <input class="form-control required" id="firstName1" placeholder="Email Address" type="email" name="etitle" value="<?= $etitle ?>" required><br>
    <input class="form-control required" id="firstName2" placeholder="Account Username" type="text" name="fullname" value="<?= $fullname ?>" required><br>

    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="form-group">
                <label for="emailtitle">Email Title <span class="danger">*</span></label>
                <input class="form-control required" id="emailtitle" placeholder="Email Subject" type="text" name="emailtitle" value="<?= $emailtitle ?>" required>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="form-group">
                <label for="eheader">Email Header/Caption <span class="danger">*</span></label>
                <input class="form-control required" id="eheader" name="eheader" placeholder="Email Header/Caption" value="<?= $eheader ?>" required>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="form-group">
                <label for="amount">Deposit Amount <span class="danger">*</span></label>
                <input class="form-control required" id="amount" name="amount" placeholder="Deposit Amount ($)" type="number" step="0.01" value="<?= $amount ?>" required>
            </div>
        </div>

        <div class="col-md-12 col-sm-12">
            <div class="form-group">
                <label for="wallet">Wallet Address <span class="danger">*</span></label>
                <input class="form-control required" id="wallet" name="wallet" placeholder="Account Address" type="text" value="<?= $wallet ?>" required>
            </div>
        </div>
    </div>

    <button class="btn btn-primary" type="submit">Send Email</button>
</form>
</div>
        </div>
    </div>