<?php
session_start();
require 'database_connection.php'; // ✅ path to your DB file

$kycRequests = [];

try {
    $stmt = $database->query("SELECT k.*, u.fullname AS username FROM kyc_requests k JOIN user u ON k.user_id = u.id ORDER BY k.created_at DESC");
    $kycRequests = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
  <?php include'head.php'; ?>
  <body class="app sidebar-mini rtl">
    <!-- Navbar-->
    <?php include'topnav.php'; ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <?php include'nav.php'; ?>
 <main class="app-content">
  <div class="clearfix"></div>
  <div class="col-md-12">
    <div class="tile">
      <h3 class="tile-title">KYC Submissions</h3>
      <div class="table-responsive">
        <table class="table">
          <thead>
            <tr>
              <th>Username</th>
              <th>Full Name</th>
              <th>Document Type</th>
              <th>ID Front</th>
              <th>Selfie</th>
              <th>Status</th>
              <th>Submitted At</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($kycRequests as $kyc): ?>
            <tr>
              <td><?= htmlspecialchars($kyc['username']); ?></td>
              <td><?= htmlspecialchars($kyc['full_name']); ?></td>
              <td><?= ucfirst($kyc['document_type']); ?></td>
           <<td>
  <a href="/<?= ltrim(htmlspecialchars($kyc['id_front_path']), '/'); ?>" target="_blank">View</a> |
  <a href="/<?= ltrim(htmlspecialchars($kyc['id_front_path']), '/'); ?>" download>Download</a>
</td>
<td>
  <a href="/<?= ltrim(htmlspecialchars($kyc['selfie_path']), '/'); ?>" target="_blank">View</a> |
  <a href="/<?= ltrim(htmlspecialchars($kyc['selfie_path']), '/'); ?>" download>Download</a>
</td>


              <td><span class="badge bg-<?= $kyc['status'] === 'approved' ? 'success' : ($kyc['status'] === 'declined' ? 'danger' : 'secondary'); ?>">
                <?= ucfirst($kyc['status']); ?></span></td>
              <td><?= date('Y-m-d H:i', strtotime($kyc['created_at'])); ?></td>
              <td>
                <?php if ($kyc['status'] === 'pending'): ?>
                  <a href="kyc_action.php?action=approve&id=<?= $kyc['id']; ?>" class="btn btn-success btn-sm" onclick="return confirm('Approve this KYC?');">Approve</a>
                  <a href="kyc_action.php?action=decline&id=<?= $kyc['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Decline this KYC?');">Decline</a>
                <?php else: ?>
                  <em>No actions</em>
                <?php endif; ?>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</main>

    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.2.1.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- The javascript plugin to display page loading on top-->
    <script src="js/plugins/pace.min.js"></script>
    <!-- Page specific javascripts-->
    <!-- Google analytics script-->
    <script type="text/javascript">
      if(document.location.hostname == 'pratikborsadiya.in') {
      	(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
      	(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
      	m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
      	})(window,document,'script','//www.google-analytics.com/analytics.js','ga');
      	ga('create', 'UA-72504830-1', 'auto');
      	ga('send', 'pageview');
      }
    </script>
  </body>
</html>
<?php

?>