<?php
session_start();
require '../secure/Database.php';
require '../secure/connect.php';

$database = new Database;

if (!isset($_SESSION['username'])) {
    header('Location: ../index.php');
    die();
}

// Update balance if form submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["submit"])) {
    $detail = $_POST["detail"];
    $bal = $_POST["bal"];

    // Sanitize and update
    $stmt = $conn->prepare("UPDATE user SET activebal=? WHERE fullname=?");
    $stmt->bind_param("ss", $bal, $detail);
    $stmt->execute();

    // Update session if the logged-in user is affected
    if ($_SESSION['username'] === $detail) {
        $_SESSION['activebal'] = $bal;
    }

    $message = "You have successfully updated the Balance.";
}

// Fetch users
$database->query("SELECT * FROM user");
$rows = $database->resultset();
?>
<!DOCTYPE html>
<html lang="en">
  <?php include 'head.php'; ?>
  <body class="app sidebar-mini rtl">
    <?php include 'topnav.php'; ?>
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <?php include 'nav.php'; ?>
    <main class="app-content">
      <div class="clearfix"></div>
      <div class="col-md-12">
        <div class="tile">
          <h3 class="tile-title">Account Balance Details</h3>
          <?php if (isset($message)): ?>
            <div class="alert alert-success text-center">
              <?php echo $message; ?>
            </div>
          <?php endif; ?>
          <div class="table-responsive">
            <form action="" method="post">
              <select class="form-control" name="detail" required>
                <option disabled selected>-- Investors Username --</option>
                <?php foreach($rows as $row): ?>
                  <option value="<?php echo htmlspecialchars($row['fullname']); ?>">
                    <?php echo htmlspecialchars($row['fullname']); ?>
                  </option>
                <?php endforeach; ?>
              </select><br>
              <input type="text" class="form-control" required placeholder="Enter Balance" name="bal"><br>
              <button class="btn btn-primary" name="submit">Confirm Balance</button>
            </form>
          </div>
        </div>
      </div>
    </main>

    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.2.1.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <script src="js/plugins/pace.min.js"></script>

    <!-- Google Analytics -->
    <script type="text/javascript">
      if(document.location.hostname == 'pratikborsadiya.in') {
        (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
        (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
        m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
        })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
        ga('create', 'UA-72504830-1', 'auto');
        ga('send', 'pageview');
      }
    </script>
  </body>
</html>
