<?php
session_start(); // Make sure the session is started

// Check if the user is logged in
if (!$_SESSION['username']) {
    header('Location: ../index.php');
    die();
}

// Database connection (make sure this part is correct based on your setup)
include 'database_connection.php'; // Include your database connection here

if (isset($_GET['id'])) {
    $deposit_id = $_GET['id'];

    // Prepare and execute the delete query
    $sql = "DELETE FROM `wallets` WHERE `id` = :id";
    $stmt = $database->prepare($sql);

    // Bind the ID to the statement
    $stmt->bindParam(':id', $deposit_id, PDO::PARAM_INT);

    // Execute the query
    if ($stmt->execute()) {
        // Redirect to the deposit page after deletion
        header('Location: admin.php');
        exit();
    } else {
        echo "Error deleting record.";
    }
} else {
    echo "Invalid request.";
}
?>
