<?php
session_start();
require '../secure/Database.php';
$database = new Database;

if (!isset($_SESSION['username'])) {
    header('Location: ../../index.htm');
    exit();
} else {
    $database->query("SELECT email FROM user");
    $rows = $database->resultset();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include 'head.php'; ?>
<body class="app sidebar-mini rtl">
  <?php include 'topnav.php'; ?>
  <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
  <?php include 'nav.php'; ?>

  <main class="app-content">
    <div class="col-md-12">
      <div class="tile">
        <h3 class="tile-title text-center mb-4">💰 Add Profit / Update Balance</h3>

        <div class="table-responsive">
          <form action="" method="post" id="balanceForm" class="p-3">

            <!-- Select User -->
            <div class="form-group">
              <label><strong>Select Investor (Email)</strong></label>
              <select class="form-control" name="email" id="emailSelect" required>
                <option disabled selected>-- Choose User --</option>
                <?php foreach($rows as $row): ?>
                  <option value="<?php echo $row['email']; ?>"><?php echo $row['email']; ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <!-- Select Wallet -->
            <div class="form-group">
              <label><strong>Select Wallet</strong></label>
              <select name="wallet" id="walletSelect" class="form-control" required>
                <option value="">-- Select Wallet --</option>
                <option value="Bitcoin">Bitcoin</option>
                <option value="Ethereum">Ethereum</option>
                <option value="Usdt">USDT</option>
                <option value="Xrp">XRP</option>
                <option value="Xlm">XLM</option>
                <option value="BNB">BNB</option>
                <option value="ShibaInu">Shiba Inu</option>
                <option value="Safemoon">Safemoon</option>
                <option value="Quant">Quant</option>
                <option value="Algorand">Algorand</option>
                <option value="Stellar">Stellar</option>
                <option value="Hedera">Hedera</option>
                <option value="IOTA">IOTA</option>
                <option value="XDC">ADA</option>
                <option value="MATIC">PEPE</option>
                <option value="Doge">Doge</option>
              </select>
            </div>

            <!-- Existing Balance -->
            <div class="form-group" id="balanceBox" style="display:none;">
              <label><strong>Current Balance:</strong></label>
              <p id="currentBalance" style="font-weight:900; color:#28a745; font-size:1.5rem; transition: all 0.3s ease;"></p>
            </div>

            <!-- Amount -->
            <div class="form-group">
              <label><strong>Enter Amount</strong></label>
              <input type="number" class="form-control" name="amount" placeholder="Enter amount" step="0.01" required>
            </div>

            <!-- Action Buttons -->
            <div class="form-group text-center mt-4">
              <button type="submit" name="action" value="add" class="btn btn-success px-4 mr-2">➕ Add Balance</button>
              <button type="submit" name="action" value="subtract" class="btn btn-danger px-4">➖ Subtract Balance</button>
            </div>
          </form>
        </div>
      </div>

      <?php
      include "../secure/connect.php";

      if (isset($_POST["action"])) {
          $username = $_POST["email"];
          $wallet   = $_POST["wallet"];
          $amount   = floatval($_POST["amount"]);
          $action   = $_POST["action"];
          $datereg  = date("Y-m-d H:i:s");

          // Adjust sign based on action
          if ($action === "subtract") {
              $amount = -abs($amount);
          } else {
              $amount = abs($amount);
          }

          $check = $conn->prepare("SELECT amount FROM deposit WHERE username = ? AND wallet = ?");
          $check->bind_param("ss", $username, $wallet);
          $check->execute();
          $result = $check->get_result();

          if ($result->num_rows > 0) {
              $row = $result->fetch_assoc();
              $currentBalance = floatval($row['amount']);
              $newBalance = $currentBalance + $amount;

              $stmt = $conn->prepare("UPDATE deposit SET amount = ?, status = 'confirm', datereg = ? WHERE username = ? AND wallet = ?");
              $stmt->bind_param("dsss", $newBalance, $datereg, $username, $wallet);
              $stmt->execute();

              $color = ($action === 'subtract') ? 'danger' : 'success';
              $emoji = ($action === 'subtract') ? '🔻' : '✅';
              $actionText = ($action === 'subtract') ? 'Subtracted' : 'Added';

              echo "<div class='alert alert-$color text-center mt-4'>
                      $emoji <b>$actionText</b> <b>".abs($amount)."</b> from <b>$username</b> ($wallet).<br>
                      Previous Balance: <b>$currentBalance</b><br><br>
                      New Balance: <b>$newBalance</b>
                    </div>";
          } else {
              $stmt = $conn->prepare("INSERT INTO deposit (username, wallet, amount, status, datereg) VALUES (?, ?, ?, 'confirm', ?)");
              $stmt->bind_param("ssds", $username, $wallet, $amount, $datereg);
              $stmt->execute();

              echo "<div class='alert alert-info text-center mt-4'>
                      🆕 Created new $wallet wallet for <b>$username</b> with starting balance <b>$amount</b>.
                    </div>";
          }
      }
      ?>
    </div>
  </main>
   
  <!-- jQuery for AJAX -->
  <script src="js/jquery-3.2.1.min.js"></script>
  <script>
  // ✅ Fetch current balance dynamically and animate it
  $('#emailSelect, #walletSelect').on('change', function() {
      const email = $('#emailSelect').val();
      const wallet = $('#walletSelect').val();
      if (email && wallet) {
          $.ajax({
              url: 'get_balance.php',
              method: 'POST',
              data: { email: email, wallet: wallet },
              success: function(response) {
                  $('#balanceBox').show();
                  const balanceEl = $('#currentBalance');
                  balanceEl.fadeOut(150, function() {
                      balanceEl.text(response ? response : '0.00').fadeIn(200);
                      balanceEl.css('color', '#28a745'); // green by default
                  });
              }
          });
      }
  });
  </script>
   <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.2.1.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <script src="js/plugins/pace.min.js"></script>
</body>
</html>
