<?php
session_start();
require '../connect.php';

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $old = trim($_POST['old_password']);
    $new = trim($_POST['new_password']);

    // Get current admin details
    $stmt = $conn->prepare("SELECT * FROM admin_account WHERE id = 1");
    $stmt->execute();
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$admin || $old !== $admin['password']) {
        $msg = "<div class='alert alert-danger text-center'>❌ Old password is incorrect.</div>";
    } else {
        $update = $conn->prepare("UPDATE admin_account SET password = ? WHERE id = 1");
        $update->execute([$new]);
        $msg = "<div class='alert alert-success text-center'>✅ Password updated successfully.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Change Password</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(135deg, #1a73e8, #673ab7);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .cp-card {
            max-width: 450px;
            width: 100%;
            border-radius: 15px;
            padding: 25px;
            background: #fff;
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        }

        .cp-header {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .cp-header h3 {
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

<div class="cp-card">
    <div class="cp-header">
        <h3>🔐 Change Password</h3>
        <p class="text-muted">Update your admin password</p>
    </div>

    <?= $msg ?>

    <form method="POST">
        <div class="mb-3">
            <label class="form-label">Old Password</label>
            <input type="password" name="old_password" class="form-control" placeholder="Enter old password" required>
        </div>

        <div class="mb-3">
            <label class="form-label">New Password</label>
            <input type="password" name="new_password" class="form-control" placeholder="Enter new password" required>
        </div>

        <button type="submit" class="btn btn-primary w-100">Update Password</button>

        <a href="dashboard.php" class="btn btn-outline-secondary w-100 mt-3">⬅ Back to Dashboard</a>
    </form>
</div>

</body>
</html>
