<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class Newsletter extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $user;
    public $subject;
    public $content;
    public $template;

    /**
     * Create a new message instance.
     */
    public function __construct(User $user, string $subject, string $content, string $template = 'standard')
    {
        $this->user = $user;
        $this->subject = $subject;
        $this->content = $content;
        $this->template = $template;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: $this->subject,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        $view = 'emails.newsletter.' . $this->template;
        
        return new Content(
            view: $view,
            with: [
                'user' => $this->user,
                'content' => $this->content,
                'subject' => $this->subject,
                'companyName' => setting('company_name', config('app.name')),
                'companyEmail' => setting('company_email', 'support@example.com'),
                'companyLogo' => setting('company_logo', '')
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
} 